(define (tunnel-ball-shade imdr cx cy radius light start-color alpha)
  (let* ((width (* radius 2))
	 (height (* radius 2))
         (end-color-factor 0.5)
         (end-color (list (* end-color-factor (car start-color))
                          (* end-color-factor (cadr start-color))
                          (* end-color-factor (caddr start-color))))
         (radians (/ (* light *pi*) 180))
	 (light-x (+ cx (* radius (* 0.6 (cos radians)))))
	 (light-y (- cy (* radius (* 0.6 (sin radians)))))
	 (light-end-x (+ cx (* radius (cos (+ *pi* radians)))))
	 (light-end-y (- cy (* radius (sin (+ *pi* radians)))))
	 (offset (* radius 0.1))
	 (old-fg (car (gimp-palette-get-foreground)))
	 (old-bg (car (gimp-palette-get-background))))
    (gimp-palette-set-foreground start-color)
    (gimp-palette-set-background end-color)
    (gimp-blend (cadr imdr) FG-BG-RGB NORMAL-MODE RADIAL alpha offset
                REPEAT-NONE FALSE 0 0 light-x light-y light-end-x light-end-y)
    (gimp-palette-set-background old-bg)
    (gimp-palette-set-foreground old-fg)))

(define (tunnel-ball-shade-frac imdr cx cy radius frac light start-color alpha)
  (tunnel-ball-shade imdr cx cy (* radius frac) light start-color alpha))

(define (tunnel-ball-noise imdr noise)
  (plug-in-noisify 1 (car imdr) (cadr imdr) FALSE noise noise noise 0))

(define (tunnel-ball-ellipse image x y w h op aa)
  (gimp-ellipse-select image x y w h op aa FALSE 0))

(define (tunnel-ball-ellipse-frac image x y w h frac op aa)
  (let* ((xdia (* w frac))
         (ydia (* h frac))
         (xoffs (+ x (* w 0.5) (* xdia -0.5)))
         (yoffs (+ y (* h 0.5) (* ydia -0.5))))
    (gimp-ellipse-select image xoffs yoffs xdia ydia op aa FALSE 0)))

(define (listlength l)
  (if (null? l)
      0
      (+ 1 (listlength (cdr l)))))

(define build-array-helper
  (lambda (arr n l)
    (if (null? l)
        arr
        (begin
          (aset arr n (car l))
          (build-array-helper arr (+ n 1) (cdr l))))))

(define (list-to-array l)
  (let* ((ln (listlength l))
         (arr (cons-array ln 'double)))
    (build-array-helper arr 0 l)))

(define build-array
  (lambda l
    (let* ((ln (listlength l))
           (arr (cons-array ln 'double)))
      (build-array-helper arr 0 l))))

(define (tunnel-ball-fourofeight image x y w h op aa)
  (let* ((xc (+ x (/ w 2)))
         (yc (+ y (/ h 2)))
         (xofs (* 0.207107 w)) ; 0.5 / tan(67.5 degrees)
         (yofs (* 0.207107 h))
         (x1 (- xc xofs))
         (x2 (+ xc xofs))
         (y1 (- yc yofs))
         (y2 (+ yc yofs))
         (poly (build-array xc yc x1 0 x2 0 xc yc w y1 w y2 xc yc
                            x2 h x1 h xc yc 0 y2 0 y1 xc yc)))
    (gimp-free-select image 26 poly op aa FALSE 0)))

(define (tunnel-ball-plus image x y w h op aa)
  (let* ((xc (+ x (/ w 2)))
         (yc (+ y (/ h 2)))
         (xofs (* 0.05 w))
         (yofs (* 0.05 h))
         (x1 (- xc xofs))
         (x2 (+ xc xofs))
         (y1 (- yc yofs))
         (y2 (+ yc yofs))
         (poly (build-array x1 0 x2 0 x2 y1 w y1 w y2 x2 y2 x2 h
                            x1 h x1 y2 0 y2 0 y1 x1 y1 x1 0)))
    (gimp-free-select image 26 poly op aa FALSE 0)))

(define (tunnel-ball-cross image x y w h op aa)
  (let* ((xc (+ x (/ w 2)))
         (yc (+ y (/ h 2)))
         (xofsi (* 0.05 w))
         (xofso (* 0.15 w))
         (yofsi (* 0.05 h))
         (yofso (* 0.15 h))
         (x1 (- xc xofso))
         (x2 (- xc xofsi))
         (x3 (+ xc xofsi))
         (x4 (+ xc xofso))
         (y1 (- yc yofso))
         (y2 (- yc yofsi))
         (y3 (+ yc yofsi))
         (y4 (+ yc yofso))
         (poly (build-array x1 y2 x2 y2 x2 y1 x3 y1 x3 y2 x4 y2
                            x4 y3 x3 y3 x3 y4 x2 y4 x2 y3 x1 y3 x1 y2)))
    (gimp-free-select image 26 poly op aa FALSE 0)))

(define (tunnel-ball-shield image x y w h op aa)
  (let* ((xc (+ x (/ w 2)))
         (yc (+ y (/ h 2)))
         (xofs (* 0.1 w))
         (yofsi (* 0.1 h))
         (yofso (* 0.15 h))
         (x1 (- xc xofs))
         (x2 (+ xc xofs))
         (y1 (- yc yofsi))
         (y2 (+ yc yofsi))
         (y3 (+ yc yofso))
         (poly (build-array x1 y1 x2 y1 x2 y2 xc y3 x1 y2 x1 y1)))
    (gimp-free-select image 12 poly op aa FALSE 0)))

(define (tunnel-moving-balls prefix)
  (let* ((radius 30)
         (diameter (* radius 2))
         (fradius 20)
         (fdiameter (* fradius 2))
         (mradius 50)
         (mdiameter (* mradius 2))
         (light 45)
         (bg-color '(0 0 0))
         (appr (lambda (filename)
                 (string-append prefix filename))))
    ;ship and ship_frag
    (let ((imdr (tunnel-new diameter diameter)))
      (tunnel-ball-ellipse (car imdr) 0 0 diameter diameter REPLACE TRUE)
      (tunnel-ball-shade imdr radius radius radius light '(255 131 250) 40)
      (tunnel-ball-ellipse-frac (car imdr) 0 0 diameter diameter 0.2 REPLACE
                                TRUE)
      (tunnel-ball-shade-frac imdr radius radius radius 0.2 light
                              '(255 131 250) 100)
      (tunnel-ball-ellipse (car imdr) 0 0 diameter diameter REPLACE TRUE)
      (tunnel-ball-shade imdr radius radius radius light '(255 131 250) 40)
      (tunnel-save imdr (appr "ship") bg-color))
    (let ((imdr (tunnel-new fdiameter fdiameter)))
      (tunnel-ball-ellipse (car imdr) 0 0 fdiameter fdiameter REPLACE TRUE)
      (tunnel-ball-shade imdr fradius fradius fradius light '(255 131 250) 100)
      (tunnel-ball-fourofeight (car imdr) 0 0 fdiameter fdiameter INTERSECT
                               TRUE)
      (tunnel-ball-shade imdr fradius fradius fradius light '(192 99 188) 100)
      (tunnel-save imdr (appr "ship_frag") bg-color))
    ; tickler, tickler_frag and tickler_thrower
    (let ((imdr (tunnel-new diameter diameter)))
      (tunnel-ball-ellipse (car imdr) 0 0 diameter diameter REPLACE TRUE)
      (tunnel-ball-shade imdr radius radius radius light '(222 184 135) 100)
      (tunnel-save imdr (appr "tickler") bg-color))
    (let ((imdr (tunnel-new fdiameter fdiameter)))
      (tunnel-ball-ellipse (car imdr) 0 0 fdiameter fdiameter REPLACE TRUE)
      (tunnel-ball-shade imdr fradius fradius fradius light '(222 184 135) 100)
      (tunnel-ball-fourofeight (car imdr) 0 0 fdiameter fdiameter INTERSECT
                               TRUE)
      (tunnel-ball-shade imdr fradius fradius fradius light '(167 138 102) 100)
      (tunnel-save imdr (appr "tickler_frag") bg-color))
    (let ((imdr (tunnel-new mdiameter mdiameter)))
      (tunnel-ball-ellipse (car imdr) 0 0 mdiameter mdiameter REPLACE TRUE)
      (tunnel-ball-shade imdr mradius mradius mradius light '(222 184 135) 100)
      (tunnel-ball-plus (car imdr) 0 0 mdiameter mdiameter INTERSECT TRUE)
      (tunnel-ball-shade imdr mradius mradius mradius light '(167 138 102) 100)
      (tunnel-save imdr (appr "tickler_thrower") bg-color))
    ; punch, punch_frag and punch_thrower
    (let ((imdr (tunnel-new diameter diameter)))
      (tunnel-ball-ellipse (car imdr) 0 0 diameter diameter REPLACE TRUE)
      (tunnel-ball-shade imdr radius radius radius light '(99 184 255) 100)
      (tunnel-save imdr (appr "punch") bg-color))
    (let ((imdr (tunnel-new fdiameter fdiameter)))
      (tunnel-ball-ellipse (car imdr) 0 0 fdiameter fdiameter REPLACE TRUE)
      (tunnel-ball-shade imdr fradius fradius fradius light '(99 184 255) 100)
      (tunnel-ball-fourofeight (car imdr) 0 0 fdiameter fdiameter INTERSECT
                               TRUE)
      (tunnel-ball-shade imdr fradius fradius radius light '(75 138 192) 100)
      (tunnel-save imdr (appr "punch_frag") bg-color))
    (let ((imdr (tunnel-new mdiameter mdiameter)))
      (tunnel-ball-ellipse (car imdr) 0 0 mdiameter mdiameter REPLACE TRUE)
      (tunnel-ball-shade imdr mradius mradius mradius light '(99 184 255) 100)
      (tunnel-ball-plus (car imdr) 0 0 mdiameter mdiameter INTERSECT TRUE)
      (tunnel-ball-shade imdr mradius mradius mradius light '(75 138 192) 100)
      (tunnel-save imdr (appr "punch_thrower") bg-color))
    ; speedy, speedy_frag and speedy_thrower
    (let ((imdr (tunnel-new diameter diameter)))
      (tunnel-ball-ellipse (car imdr) 0 0 diameter diameter REPLACE TRUE)
      (tunnel-ball-shade imdr radius radius radius light '(255 215 0) 100)
      (tunnel-save imdr (appr "speedy") bg-color))
    (let ((imdr (tunnel-new fdiameter fdiameter)))
      (tunnel-ball-ellipse (car imdr) 0 0 fdiameter fdiameter REPLACE TRUE)
      (tunnel-ball-shade imdr fradius fradius fradius light '(255 215 0) 100)
      (tunnel-ball-fourofeight (car imdr) 0 0 fdiameter fdiameter INTERSECT
                               TRUE)
      (tunnel-ball-shade imdr fradius fradius fradius light '(192 162 0) 100)
      (tunnel-save imdr (appr "speedy_frag") bg-color))
    (let ((imdr (tunnel-new mdiameter mdiameter)))
      (tunnel-ball-ellipse (car imdr) 0 0 mdiameter mdiameter REPLACE TRUE)
      (tunnel-ball-shade imdr mradius mradius mradius light '(255 215 0) 100)
      (tunnel-ball-plus (car imdr) 0 0 mdiameter mdiameter INTERSECT TRUE)
      (tunnel-ball-shade imdr mradius mradius mradius light '(192 162 0) 100)
      (tunnel-save imdr (appr "speedy_thrower") bg-color))
    ; crazy, crazy_frag and crazy_thrower
    (let ((imdr (tunnel-new diameter diameter)))
      (tunnel-ball-ellipse (car imdr) 0 0 diameter diameter REPLACE TRUE)
      (tunnel-ball-shade imdr radius radius radius light '(205 92 92) 100)
      (tunnel-save imdr (appr "crazy") bg-color))
    (let ((imdr (tunnel-new diameter diameter)))
      (tunnel-ball-ellipse (car imdr) 0 0 diameter diameter REPLACE TRUE)
      (tunnel-ball-shade imdr radius radius radius light '(205 92 92) 100)
      (tunnel-ball-fourofeight (car imdr) 0 0 diameter diameter INTERSECT TRUE)
      (tunnel-ball-shade imdr radius radius radius light '(154 69 69) 100)
      (tunnel-save imdr (appr "crazy_frag") bg-color))
    (let ((imdr (tunnel-new mdiameter mdiameter)))
      (tunnel-ball-ellipse (car imdr) 0 0 mdiameter mdiameter REPLACE TRUE)
      (tunnel-ball-shade imdr mradius mradius mradius light '(205 92 92) 100)
      (tunnel-ball-plus (car imdr) 0 0 mdiameter mdiameter INTERSECT TRUE)
      (tunnel-ball-shade imdr mradius mradius mradius light '(154 69 69) 100)
      (tunnel-save imdr (appr "crazy_thrower") bg-color))
    ; crawler, crawler_frag and crawler_thrower
    (let ((imdr (tunnel-new diameter diameter)))
      (tunnel-ball-ellipse (car imdr) 0 0 diameter diameter REPLACE TRUE)
      (tunnel-ball-shade imdr radius radius radius light '(132 112 255) 100)
      (tunnel-save imdr (appr "crawler") bg-color))
    (let ((imdr (tunnel-new diameter diameter)))
      (tunnel-ball-ellipse (car imdr) 0 0 diameter diameter REPLACE TRUE)
      (tunnel-ball-shade imdr radius radius radius light '(132 112 255) 100)
      (tunnel-ball-fourofeight (car imdr) 0 0 diameter diameter INTERSECT TRUE)
      (tunnel-ball-shade imdr radius radius radius light '(99 84 192) 100)
      (tunnel-save imdr (appr "crawler_frag") bg-color))
    (let ((imdr (tunnel-new mdiameter mdiameter)))
      (tunnel-ball-ellipse (car imdr) 0 0 mdiameter mdiameter REPLACE TRUE)
      (tunnel-ball-shade imdr mradius mradius mradius light '(132 112 255) 100)
      (tunnel-ball-plus (car imdr) 0 0 mdiameter mdiameter INTERSECT TRUE)
      (tunnel-ball-shade imdr mradius mradius mradius light '(99 84 192) 100)
      (tunnel-save imdr (appr "crawler_thrower") bg-color))
    ; multics
    (let ((imdr (tunnel-new mdiameter mdiameter)))
      (tunnel-ball-ellipse (car imdr) 0 0 mdiameter mdiameter REPLACE TRUE)
      (gimp-rect-select (car imdr) 0 0 mradius mradius INTERSECT FALSE 0)
      ; punch color
      (tunnel-ball-shade imdr mradius mradius mradius light '(99 184 255) 100)
      (tunnel-ball-ellipse (car imdr) 0 0 mdiameter mdiameter REPLACE TRUE)
      (gimp-rect-select (car imdr) 0 mradius mradius mradius INTERSECT FALSE 0)
      ; speedy color
      (tunnel-ball-shade imdr mradius mradius mradius light '(255 215 0) 100)
      (tunnel-ball-ellipse (car imdr) 0 0 mdiameter mdiameter REPLACE TRUE)
      (gimp-rect-select (car imdr) mradius 0 mradius mradius INTERSECT FALSE 0)
      ; crazy color
      (tunnel-ball-shade imdr mradius mradius mradius light '(205 92 92) 100)
      (tunnel-ball-ellipse (car imdr) 0 0 mdiameter mdiameter REPLACE TRUE)
      (gimp-rect-select (car imdr) mradius mradius mradius mradius INTERSECT
			FALSE 0)
      ; crawler color
      (tunnel-ball-shade imdr mradius mradius mradius light '(132 112 255) 100)
      (tunnel-ball-ellipse (car imdr) 0 0 mdiameter mdiameter REPLACE TRUE)
      (tunnel-ball-plus (car imdr) 0 0 mdiameter mdiameter INTERSECT TRUE)
      ; tickler dark color
      (tunnel-ball-shade imdr mradius mradius mradius light '(167 138 102) 100)
      (tunnel-save imdr (appr "multics") bg-color))
    ;normal_bullet
    (let ((imdr (tunnel-new fdiameter fdiameter)))
      (tunnel-ball-ellipse (car imdr) 0 0 fdiameter fdiameter REPLACE TRUE)
      (tunnel-ball-shade imdr fradius fradius fradius light '(50 205 50) 100)
      (tunnel-save imdr (appr "normal_bullet") bg-color))
    ;strong_bullet
    (let ((imdr (tunnel-new fdiameter fdiameter)))
      (tunnel-ball-ellipse (car imdr) 0 0 fdiameter fdiameter REPLACE TRUE)
      (tunnel-ball-shade imdr fradius fradius fradius light '(102 205 170) 100)
      (tunnel-save imdr (appr "strong_bullet") bg-color))
    ; strength_pickup
    (let ((imdr (tunnel-new diameter diameter)))
      (tunnel-ball-ellipse (car imdr) 0 0 diameter diameter REPLACE TRUE)
      (tunnel-ball-shade imdr radius radius radius light '(255 99 71) 30)
      (tunnel-ball-cross (car imdr) 0 0 diameter diameter REPLACE TRUE)
      (tunnel-ball-shade imdr radius radius radius light '(255 99 71) 100)
      (tunnel-ball-ellipse (car imdr) 0 0 diameter diameter REPLACE TRUE)
      (tunnel-ball-shade imdr radius radius radius light '(255 99 71) 30)
      (tunnel-save imdr (appr "strength_pickup") bg-color))
    ; shield_pickup
    (let ((imdr (tunnel-new diameter diameter)))
      (tunnel-ball-ellipse (car imdr) 0 0 diameter diameter REPLACE TRUE)
      (tunnel-ball-shade imdr radius radius radius light '(100 149 237) 30)
      (tunnel-ball-shield (car imdr) 0 0 diameter diameter REPLACE TRUE)
      (tunnel-ball-shade imdr radius radius radius light '(100 149 237) 100)
      (tunnel-ball-ellipse (car imdr) 0 0 diameter diameter REPLACE TRUE)
      (tunnel-ball-shade imdr radius radius radius light '(100 149 237) 30)
      (tunnel-save imdr (appr "shield_pickup") bg-color))
    ; weap_pickup
    (let ((imdr (tunnel-new diameter diameter)))
      (tunnel-ball-ellipse (car imdr) 0 0 diameter diameter REPLACE TRUE)
      (tunnel-ball-shade imdr radius radius radius light '(50 205 50) 30)
      (tunnel-ball-ellipse-frac (car imdr) 0 0 diameter diameter 0.25 REPLACE
                                TRUE)
      (tunnel-ball-shade-frac imdr radius radius radius 0.25 light '(50 205 50)
                              100)
      (tunnel-ball-ellipse (car imdr) 0 0 diameter diameter REPLACE TRUE)
      (tunnel-ball-shade imdr radius radius radius light '(50 205 50) 30)
      (tunnel-save imdr (appr "weap_pickup") bg-color))
    ; fast_weap_pickup
    (let ((imdr (tunnel-new diameter diameter))
          (rs (* radius 0.25))
          (ds (* diameter 0.25)))
      (tunnel-ball-ellipse (car imdr) 0 0 diameter diameter REPLACE TRUE)
      (tunnel-ball-shade imdr radius radius radius light '(50 205 50) 30)
      
      ;     ->o
      ;      o o
      (tunnel-ball-ellipse (car imdr)
                           (+ radius (* ds -0.5))
                           (+ radius (* ds -1.0774))
                           ds ds REPLACE TRUE)
      (tunnel-ball-shade imdr
                         (+ radius (* ds 0))
                         (+ radius (* ds -0.5774))
                         rs light '(50 205 50) 100)

      ;       o
      ;    ->o o
      (tunnel-ball-ellipse (car imdr)
                           (+ radius (* ds -1))
                           (+ radius (* ds -0.2113))
                           ds ds REPLACE TRUE)
      (tunnel-ball-shade imdr
                         (+ radius (* ds -0.5))
                         (+ radius (* ds 0.2887))
                         rs light '(50 205 50) 100)

      ;       o
      ;      o o<-
      (tunnel-ball-ellipse (car imdr)
                           (+ radius (* ds 0))
                           (+ radius (* ds -0.2113))
                           ds ds REPLACE TRUE)
      (tunnel-ball-shade imdr
                         (+ radius (* ds 0.5))
                         (+ radius (* ds 0.2887))
                         rs light '(50 205 50) 100)

      (tunnel-ball-ellipse (car imdr) 0 0 diameter diameter REPLACE TRUE)
      (tunnel-ball-shade imdr radius radius radius light '(50 205 50) 30)
      (tunnel-save imdr (appr "fast_weap_pickup") bg-color))
    ; strong_weap_pickup
    (let ((imdr (tunnel-new diameter diameter)))
      (tunnel-ball-ellipse (car imdr) 0 0 diameter diameter REPLACE TRUE)
      (tunnel-ball-shade imdr radius radius radius light '(102 205 170) 30)
      (tunnel-ball-ellipse-frac (car imdr) 0 0 diameter diameter 0.25 REPLACE
                                TRUE)
      (tunnel-ball-shade-frac imdr radius radius radius 0.25 light
                              '(102 205 170) 100)
      (tunnel-ball-ellipse (car imdr) 0 0 diameter diameter REPLACE TRUE)
      (tunnel-ball-shade imdr radius radius radius light '(102 205 170) 30)
      (tunnel-save imdr (appr "strong_weap_pickup") bg-color))
    ; strong_fast_weap_pickup
    (let ((imdr (tunnel-new diameter diameter))
          (rs (* radius 0.25))
          (ds (* diameter 0.25)))
      (tunnel-ball-ellipse (car imdr) 0 0 diameter diameter REPLACE TRUE)
      (tunnel-ball-shade imdr radius radius radius light '(102 205 170) 30)
      
      ;     ->o
      ;      o o
      (tunnel-ball-ellipse (car imdr)
                           (+ radius (* ds -0.5))
                           (+ radius (* ds -1.0774))
                           ds ds REPLACE TRUE)
      (tunnel-ball-shade imdr
                         (+ radius (* ds 0))
                         (+ radius (* ds -0.5774))
                         rs light '(102 205 170) 100)

      ;       o
      ;    ->o o
      (tunnel-ball-ellipse (car imdr)
                           (+ radius (* ds -1))
                           (+ radius (* ds -0.2113))
                           ds ds REPLACE TRUE)
      (tunnel-ball-shade imdr
                         (+ radius (* ds -0.5))
                         (+ radius (* ds 0.2887))
                         rs light '(102 205 170) 100)

      ;       o
      ;      o o<-
      (tunnel-ball-ellipse (car imdr)
                           (+ radius (* ds 0))
                           (+ radius (* ds -0.2113))
                           ds ds REPLACE TRUE)
      (tunnel-ball-shade imdr
                         (+ radius (* ds 0.5))
                         (+ radius (* ds 0.2887))
                         rs light '(102 205 170) 100)

      (tunnel-ball-ellipse (car imdr) 0 0 diameter diameter REPLACE TRUE)
      (tunnel-ball-shade imdr radius radius radius light '(102 205 170) 30)
      (tunnel-save imdr (appr "strong_fast_weap_pickup") bg-color))
    (let ((imdr (tunnel-new diameter diameter)))
      (begin ))))

(define (tunnel-icons prefix)
  (let ((tunnel-icon-w (lambda (w)
                         (let* ((ship-rad (* w 0.33))
                                (ship-cx (* w 0.4))
                                (ship-cy (* w 0.5))
                                (bullet-rad (* w 0.2))
                                (bullet-cx (* w 0.72))
                                (bullet-cy (* w 0.7))
                                (ship-dia (* ship-rad 2))
                                (ship-x (- ship-cx ship-rad))
                                (ship-y (- ship-cy ship-rad))
                                (bullet-dia (* bullet-rad 2))
                                (bullet-x (- bullet-cx bullet-rad))
                                (bullet-y (- bullet-cy bullet-rad))
                                (light 45)
                                (bg-color '(0 0 0))
                                (appr (lambda (filename)
                                        (string-append prefix filename
                                                       (number->string w)))))
                           (let ((imdr (tunnel-new w w)))
                             (tunnel-ball-ellipse (car imdr) bullet-x bullet-y
                                                  bullet-dia bullet-dia REPLACE
                                                  FALSE)
                             (tunnel-ball-shade imdr bullet-cx bullet-cy
                                                bullet-rad light '(40 200 40)
                                                100)
                             (tunnel-ball-ellipse (car imdr) ship-x ship-y
                                                  ship-dia ship-dia REPLACE
                                                  FALSE)
                             (tunnel-ball-shade imdr ship-cx ship-cy ship-rad
                                                light '(255 131 250) 100)
                             (tunnel-save imdr (appr "icon") bg-color))))))
    (tunnel-icon-w 16)
    (tunnel-icon-w 32)
    (tunnel-icon-w 48)
    (tunnel-icon-w 64)))

(define (tunnel-weapons prefix)
  (let* ((w 96)
         (h w)
         (light 45)
         (bg-color '(0 0 0))
         (appr (lambda (filename)
                 (string-append prefix filename))))
    ;def_weapon
    (let* ((rad (* w 0.35))
           (dia (* rad 2))
           (cx (* w 0.5))
           (cy (* h 0.5))
           (x (- cx rad))
           (y (- cy rad))
           (imdr (tunnel-new w h)))
      (tunnel-ball-ellipse (car imdr) x y dia dia REPLACE TRUE)
      (tunnel-ball-shade imdr cx cy rad light '(50 250 50) 100)
      (tunnel-save imdr (appr "def_weapon") bg-color))
    ;fast_weapon
    (let* ((rad1 (* w 0.35))
           (rad2 (* w 0.2))
           (rad3 (* w 0.11))
           (cx1 (* w 0.4))
           (cx2 (* w 0.65))
           (cx3 (* w 0.8))
           (cy1 (* h 0.45))
           (cy2 (* h 0.60))
           (cy3 (* h 0.69))
           (dia1 (* rad1 2))
           (dia2 (* rad2 2))
           (dia3 (* rad3 2))
           (x1 (- cx1 rad1))
           (x2 (- cx2 rad2))
           (x3 (- cx3 rad3))
           (y1 (- cy1 rad1))
           (y2 (- cy2 rad2))
           (y3 (- cy3 rad3))
           (imdr (tunnel-new w h)))
      (tunnel-ball-ellipse (car imdr) x3 y3 dia3 dia3 REPLACE TRUE)
      (tunnel-ball-shade imdr cx3 cy3 rad3 light '(32 160 32) 100)
      (tunnel-ball-ellipse (car imdr) x2 y2 dia2 dia2 REPLACE TRUE)
      (tunnel-ball-shade imdr cx2 cy2 rad2 light '(40 200 40) 100)
      (tunnel-ball-ellipse (car imdr) x1 y1 dia1 dia1 REPLACE TRUE)
      (tunnel-ball-shade imdr cx1 cy1 rad1 light '(50 250 50) 100)
      (tunnel-save imdr (appr "fast_weapon") bg-color))
    ;strong_weapon
    (let* ((rad (* w 0.35))
           (dia (* rad 2))
           (cx (* w 0.5))
           (cy (* h 0.5))
           (x (- cx rad))
           (y (- cy rad))
           (imdr (tunnel-new w h)))
      (tunnel-ball-ellipse (car imdr) x y dia dia REPLACE TRUE)
      (tunnel-ball-shade imdr cx cy rad light '(102 205 170) 100)
      (tunnel-save imdr (appr "strong_weapon") bg-color))
    ;strong_fast_weapon
    (let* ((rad1 (* w 0.35))
           (rad2 (* w 0.2))
           (rad3 (* w 0.11))
           (cx1 (* w 0.4))
           (cx2 (* w 0.65))
           (cx3 (* w 0.8))
           (cy1 (* h 0.45))
           (cy2 (* h 0.60))
           (cy3 (* h 0.69))
           (dia1 (* rad1 2))
           (dia2 (* rad2 2))
           (dia3 (* rad3 2))
           (x1 (- cx1 rad1))
           (x2 (- cx2 rad2))
           (x3 (- cx3 rad3))
           (y1 (- cy1 rad1))
           (y2 (- cy2 rad2))
           (y3 (- cy3 rad3))
           (imdr (tunnel-new w h)))
      (tunnel-ball-ellipse (car imdr) x3 y3 dia3 dia3 REPLACE TRUE)
      (tunnel-ball-shade imdr cx3 cy3 rad3 light '(66 132 109) 100)
      (tunnel-ball-ellipse (car imdr) x2 y2 dia2 dia2 REPLACE TRUE)
      (tunnel-ball-shade imdr cx2 cy2 rad2 light '(82 164 136) 100)
      (tunnel-ball-ellipse (car imdr) x1 y1 dia1 dia1 REPLACE TRUE)
      (tunnel-ball-shade imdr cx1 cy1 rad1 light '(102 205 170) 100)
      (tunnel-save imdr (appr "strong_fast_weapon") bg-color))))

(define (tunnel-balls prefix)
  (tunnel-moving-balls prefix)
  (tunnel-icons prefix)
  (tunnel-weapons prefix))
