/*
  Copyright (C) 2006   Hans-Georg Breunig

  This file is part of TsumeGo.

  TsumeGo is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  TsumeGo is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with TsumeGo; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/


#include <stdio.h>

#include "board.h"


coord getmove_terminal() {
	coord c;
	char ch;
	unsigned int u;
read:
	while(!scanf("%1c%u", &ch, &u));
	c.x = ch - 'a';
	c.y = u - 1;
	if(c.x < 0 || c.y < 0 || c.x >= BOARDSIZE || c.y >= BOARDSIZE)
		goto read;
	return c;
}

/*
coord getmove_terminal() {
	coord c;
	unsigned int x,y;
	scanf("%u %u", &x, &y);
	c.x = x - 1; c.y = y - 1;
	return c;
}
*/


void printboard(int *board) {
	int i, j, line;
	char ch;

	printf("  ");
	for(i = 0, ch = 'A'; i < BOARDSIZE; i++, ch++)
		printf(" %c", ch);
	printf("\n");

	for(j = BOARDSIZE-1, line = BOARDSIZE; j >= 0; j--, line--) {
		printf(" %d", line);
		for(i = 0; i < BOARDSIZE; i++) {
			if(board[BPOS(i, j)] == 1) {
				printf(" X");
			}
			else if(board[BPOS(i, j)] == 2) {
				printf(" O");
			}
			else printf(" .");
		}
		printf(" %d\n", line);
	}

	printf("  ");
	for(i = 0, ch = 'A'; i < BOARDSIZE; i++, ch++)
		printf(" %c", ch);
	printf("\n\n");
}

/*
void interactive_terminal() {
	coord c;
	for(;;) {
		printboard();
get:
		c = getmove_terminal();
		if(!trymove(c.x, c.y)) {
			printf("  Not allowed.\n");
			goto get;
		}
	}
}
*/


// vim:tabstop=4:shiftwidth=4
