/*
  Copyright (C) 2006   Hans-Georg Breunig

  This file is part of TsumeGo.

  TsumeGo is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  TsumeGo is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with TsumeGo; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/


#include <stdio.h>
#include <string.h>

#include "board.h"


int temp[BOARDSIZE][BOARDSIZE];

int saved[BOARDSIZE*BOARDSIZE];
int history_black[BOARDSIZE*BOARDSIZE];
int history_white[BOARDSIZE*BOARDSIZE];
int history_valid;

int ac, rc;


void init_board() {
	col = BLACK;
	history_valid = 0;
	memset(board, 0, BOARDSIZE*BOARDSIZE*sizeof(int));
}


void debug_history() {
	int i, j;
	for(i = 0; i < BOARDSIZE; i++) {
		for(j = 0; j < BOARDSIZE; j++)
			printf(" %d", history_black[BPOS(i,j)]);
		printf("\n");
	}
	printf("\n");
}


int sub_alive(int x, int y) {

	// FIXME macro
	if(x < 0 || y < 0 || x >= BOARDSIZE || y >= BOARDSIZE ||
	   board[BPOS(x, y)] != ac || temp[x][y] == 5)
		return 0;  // invalid or already visited point

	temp[x][y] = 5;  // mark

	// FIXME macro
	if((x > 0 && board[BPOS(x-1, y)] <= 0) || 
	   (x < BOARDSIZE-1 && board[BPOS(x+1, y)] <= 0) ||
	   (y > 0 && board[BPOS(x, y-1)] <= 0) ||
	   (y < BOARDSIZE-1 && board[BPOS(x, y+1)] <= 0)) {
		return 1;
	}
	else
		return sub_alive(x-1, y) || sub_alive(x+1, y) || sub_alive(x, y-1) || sub_alive(x, y+1);
}

int alive(int x, int y) {
	int i, j;
	for(i = 0; i < BOARDSIZE; i++)
		for(j = 0; j < BOARDSIZE; j++)
			temp[i][j] = 0;

	ac = board[BPOS(x, y)];
	return sub_alive(x, y);
}


void clear_suicide() {
	int i, j;

	for(i = 0; i < BOARDSIZE; i++)
		for(j = 0; j < BOARDSIZE; j++)
			if(board[BPOS(i, j)] == SUICIDE) board[BPOS(i, j)] = 0;

}


void sub_remove(int x, int y) {

	// FIXME macro
	if(x < 0 || y < 0 || x >= BOARDSIZE || y >= BOARDSIZE || board[BPOS(x, y)] != rc)
		return;  // invalid point

	board[BPOS(x, y)] = 0;

	sub_remove(x-1, y);
	sub_remove(x+1, y);
	sub_remove(x, y-1);
	sub_remove(x, y+1);
}

void remove_worm(int x, int y) {
	captured = 1;
	rc = board[BPOS(x, y)];
	sub_remove(x, y);
	clear_suicide();  // suicide flags might be invalid now.
}


void save_board() {
	memcpy(saved, board, BOARDSIZE*BOARDSIZE*sizeof(int));
}

void restore_board() {
	memcpy(board, saved, BOARDSIZE*BOARDSIZE*sizeof(int));
}


int history_clash() {
	int i, j;
	if(!history_valid) {
		// printf("history not valid.\n");
		return 0;
	}


	if(col == BLACK) {
		for(i = 0; i < BOARDSIZE; i++)
			for(j = 0; j < BOARDSIZE; j++)
				if((board[BPOS(i, j)] > 0 || history_black[BPOS(i, j)] > 0)
						&& board[BPOS(i, j)] != history_black[BPOS(i, j)]) return 0;
	}
	else {
		for(i = 0; i < BOARDSIZE; i++)
			for(j = 0; j < BOARDSIZE; j++)
				if((board[BPOS(i, j)] > 0 || history_white[BPOS(i, j)] > 0)
						&& board[BPOS(i, j)] != history_white[BPOS(i, j)]) return 0;
	}

	return 1;
}


void update_history() {
	if(col == BLACK)
		memcpy(history_black, board, BOARDSIZE*BOARDSIZE*sizeof(int));
	else {
		memcpy(history_white, board, BOARDSIZE*BOARDSIZE*sizeof(int));
		history_valid = 1;
	}
}


int makemove(int x, int y) {

	save_board();
	board[BPOS(x, y)] = col;
	captured = 0;


	if(x > 0 && board[BPOS(x-1, y)] == OTHER_COLOR(col) && !alive(x-1, y))
		remove_worm(x-1, y);

	if(x < BOARDSIZE-1 && board[BPOS(x+1, y)] == OTHER_COLOR(col) && !alive(x+1, y))
		remove_worm(x+1, y);

	if(y > 0 && board[BPOS(x, y-1)] == OTHER_COLOR(col) && !alive(x, y-1))
		remove_worm(x, y-1);

	if(y < BOARDSIZE-1 && board[BPOS(x, y+1)] == OTHER_COLOR(col) && !alive(x, y+1))
		remove_worm(x, y+1);


	if(!alive(x, y)) {
		board[BPOS(x, y)] = SUICIDE;
		return 0;  // suicide not allowed.
	}

	/*
	if(history_clash()) {
		restore_board();
		board[BPOS(x, y)] = REPETION;
		return 0;
	}
	*/

	/* update_history(); */

	col = OTHER_COLOR(col);

	return 1;
}


int trymove(int x, int y) {
	if(x < 0 || y < 0 || x >= BOARDSIZE || y >= BOARDSIZE || board[BPOS(x, y)] != 0)
		return 0;
	return makemove(x, y);
}


void update_freelist() {
	int i, j;

	freelist_size = 0;
	for(i = 0; i < BOARDSIZE; i++)
		for(j = 0; j < BOARDSIZE; j++)
			if(board[BPOS(i, j)] == 0) {
				// printf("free: %d %d\n", i, j);
				freelist[freelist_size].x = i;
				freelist[freelist_size].y = j;
				freelist_size++;
			}
}


int numstones(int color) {
	int i;
	int num = 0;

	for(i = 0; i < BOARDSIZE*BOARDSIZE; i++) {
		if(board[i] == color) num++;
	}
	
	return num;
}



// vim:tabstop=4:shiftwidth=4
