/*
  Copyright (C) 2006   Hans-Georg Breunig

  This file is part of TsumeGo.

  TsumeGo is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  TsumeGo is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with TsumeGo; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/


#ifndef _BOARD_H
#define _BOARD_H


#define BLACK 1
#define WHITE 2
#define SUICIDE -1
#define REPETION -2

#define OTHER_COLOR(color)      (WHITE+BLACK-(color))


#define BOARDSIZE 4
int board[BOARDSIZE*BOARDSIZE];

#define BPOS(i, j)  (j) + ((i) * BOARDSIZE)


int col;

struct _coord {
	int x;
	int y;
};
typedef struct _coord coord;

coord freelist[BOARDSIZE*BOARDSIZE];
int freelist_size;

int captured;

extern int trymove(int, int);




extern coord getmove_rand();
extern coord getmove_evol();
extern coord getmove_terminal();

#endif
