# - This module looks for TSP installation
# TSP is an Open Source implementation of Transport Sample Protocol
# See https://savannah.nongnu.org/projects/tsp or http://www.ts2p.org/
# If you have a non-standard TSP installation
# You may help this script to find the appropriate
# TSP installation by setting TSP_CUSTOM_HOME
# before calling FIND_PACKAGE(TSP REQUIRED)
# If TSP_CUSTOM_HOME is not set then TSP is search 
# if TSP_HOME env var is set
# then use /usr 
#
# Once done this will define:
# try to find TSP components
#
# TSP_INCLUDE_DIRS         - Directories to include to use TSP
# TSP_LIBRARIES            - Files to link against to use TSP
# TSP_EXECUTABLE_DIRS      - Directories to include to use TSP
# TSP_FOUND                - If false, don't try to use TSP
# TSP_BB_INCLUDE_DIRS      - Directories to include to use TSP BlackBoard
# TSP_BB_LIBRARIES         - Files to link against to use TSP BlackBoard
# TSP_BB_EXECUTABLE_DIRS   - Directories to include to use TSP
# TSP_BB_FOUND             - If false, don't try to use TSP BlackBoard
#

MACRO(MESSAGE_QUIETLY QUIET TYPE MSG)
   IF(NOT ${QUIET})
       MESSAGE(${TYPE} "${MSG}")
   ENDIF(NOT ${QUIET})
ENDMACRO(MESSAGE_QUIETLY QUIET TYPE MSG)

IF (NOT TSP_FIND_QUIETLY)
  MESSAGE_QUIETLY(TSP_FIND_QUIETLY STATUS "Looking for TSP...")
ENDIF (NOT TSP_FIND_QUIETLY)

IF (TSP_CUSTOM_HOME)
  SET(TSP_FIND_HOME ${TSP_CUSTOM_HOME})
  MESSAGE_QUIETLY(TSP_FIND_QUIETLY STATUS "Using TSP_CUSTOM_HOME : ${TSP_FIND_HOME}")
ELSE (TSP_CUSTOM_HOME)
  IF ("$ENV{TSP_HOME}" STRGREATER "")
     SET(TSP_FIND_HOME "$ENV{TSP_HOME}")
     MESSAGE_QUIETLY(TSP_FIND_QUIETLY STATUS "Using environment defined TSP_HOME : ${TSP_FIND_HOME}")
  ENDIF ("$ENV{TSP_HOME}" STRGREATER "")
  IF (NOT TSP_FIND_HOME)
     SET(TSP_FIND_HOME "/usr")
  ENDIF (NOT TSP_FIND_HOME)
ENDIF (TSP_CUSTOM_HOME)

SET(TSP_INCLUDE_DIRS)
SET(TSP_LIBRARIES)
SET(TSP_EXECUTABLE_DIRS)

FIND_PATH(TSP_EXECUTABLE_PATH tsp_stub_server
  ${TSP_FIND_HOME}/bin
  /opt/tsp/bin)

IF (TSP_EXECUTABLE_PATH)
  SET(TSP_EXECUTABLE_DIRS ${TSP_EXECUTABLE_DIRS} ${TSP_EXECUTABLE_PATH})
ENDIF(TSP_EXECUTABLE_PATH)

FIND_PATH(TSP_SCRIPTS_PATH tsp.profile.sh
  ${TSP_FIND_HOME}/scripts
  /opt/tsp/scripts)

IF (TSP_SCRIPTS_PATH)
  SET(TSP_EXECUTABLE_DIRS ${TSP_EXECUTABLE_DIRS} ${TSP_SCRIPTS_PATH})
ENDIF(TSP_SCRIPTS_PATH)

FIND_PATH(TSP_INCLUDE_PATH tsp_consumer.h
  ${TSP_FIND_HOME}/include
  /opt/tsp/include)

IF (TSP_INCLUDE_PATH)
  SET(TSP_INCLUDE_DIRS ${TSP_INCLUDE_DIRS} ${TSP_INCLUDE_PATH})
ENDIF(TSP_INCLUDE_PATH)

FIND_LIBRARY(TSP_CONSUMER_LIBRARY
  NAMES
  tsp_consumer
  PATHS
  ${TSP_FIND_HOME}/lib
  /opt/tsp/lib)

IF (TSP_CONSUMER_LIBRARY) 
  SET(TSP_LIBRARIES ${TSP_LIBRARIES} ${TSP_CONSUMER_LIBRARY})
ENDIF(TSP_CONSUMER_LIBRARY)

IF (TSP_LIBRARIES AND TSP_INCLUDE_PATH)
  SET(TSP_FOUND TRUE)
ENDIF(TSP_LIBRARIES AND TSP_INCLUDE_PATH)

MARK_AS_ADVANCED(
  TSP_CONSUMER_LIBRARY
  TSP_INCLUDE_PATH
  TSP_EXECUTABLE_PATH
  TSP_SCRIPTS_PATH)

IF (NOT TSP_FIND_QUIETLY)
  IF (TSP_FOUND)
    MESSAGE_QUIETLY(TSP_FIND_QUIETLY STATUS "Looking for TSP... - found ${TSP_INCLUDE_DIRS}")
  ELSE (TSP_FOUND)
    MESSAGE_QUIETLY(TSP_FIND_QUIETLY STATUS "Looking for TSP... - NOT found")
  ENDIF (TSP_FOUND)
ENDIF (NOT TSP_FIND_QUIETLY)

SET(TSP_BB_INCLUDE_DIRS)
SET(TSP_BB_LIBRARIES)
SET(TSP_BB_EXECUTABLE_DIRS)

FIND_PATH(TSP_BB_EXECUTABLE_PATH bb_tools
  ${TSP_FIND_HOME}/bin
  /opt/tsp/bin
  )

IF (TSP_BB_EXECUTABLE_PATH)
  SET(TSP_BB_EXECUTABLE_DIRS ${TSP_BB_EXECUTABLE_DIRS} ${TSP_BB_EXECUTABLE_PATH})
ENDIF(TSP_BB_EXECUTABLE_PATH)

FIND_PATH(TSP_BB_SCRIPTS_PATH bb_read
  ${TSP_FIND_HOME}/scripts
  /opt/tsp/scripts
  )

IF (TSP_BB_SCRIPTS_PATH)
  SET(TSP_BB_EXECUTABLE_DIRS ${TSP_BB_EXECUTABLE_DIRS} ${TSP_BB_SCRIPTS_PATH})
ENDIF(TSP_BB_SCRIPTS_PATH)

FIND_PATH(TSP_BB_INCLUDE_PATH bb_core.h
  ${TSP_FIND_HOME}/include
  /opt/tsp/include
  )

IF (TSP_BB_INCLUDE_PATH)
  SET(TSP_BB_INCLUDE_DIRS ${TSP_BB_INCLUDE_DIRS} ${TSP_BB_INCLUDE_PATH})
ENDIF(TSP_BB_INCLUDE_PATH)

FIND_LIBRARY(TSP_BB_LIBRARY
  NAMES
  bb
  PATHS
  ${TSP_FIND_HOME}/lib
  /opt/tsp/lib
  )

IF (TSP_BB_LIBRARY) 
  SET(TSP_BB_LIBRARIES ${TSP_BB_LIBRARIES} ${TSP_BB_LIBRARY})
ENDIF(TSP_BB_LIBRARY)

IF (TSP_BB_LIBRARIES AND TSP_BB_INCLUDE_PATH)
  SET(TSP_BB_FOUND TRUE)
ENDIF(TSP_BB_LIBRARIES AND TSP_BB_INCLUDE_PATH)

MARK_AS_ADVANCED(
  TSP_BB_LIBRARY
  TSP_BB_INCLUDE_PATH
  TSP_BB_EXECUTABLE_PATH
  TSP_BB_SCRIPTS_PATH)