
MESSAGE(STATUS "Looking for xml2-config...")
FIND_PROGRAM(XML2_CONFIG_PROGRAM
  NAMES xml2-config 
  PATHS /usr/local/bin /usr/bin
  DOC "The libxml2 (www.xmlsoft.org) configuration tool")
IF (XML2_CONFIG_PROGRAM)
  MESSAGE(STATUS "Looking for xml2-config - found : ${XML2_CONFIG_PROGRAM}")
  SET(XML2_FOUND "YES")
  EXECUTE_PROCESS(COMMAND ${XML2_CONFIG_PROGRAM} --libs
		  OUTPUT_VARIABLE XML2_LIBRARY
		  OUTPUT_STRIP_TRAILING_WHITESPACE)
  EXECUTE_PROCESS(COMMAND ${XML2_CONFIG_PROGRAM} --cflags
		  OUTPUT_VARIABLE XML2_CFLAGS
		  OUTPUT_STRIP_TRAILING_WHITESPACE)

  EXEC_PROGRAM(${XML2_CONFIG_PROGRAM} 
    ARGS "--version"
    OUTPUT_VARIABLE XML2_VERSION)

  SET(XML2_MINIMAL_VERSION "2.6.0")

  IF (XML2_VERSION STRGREATER XML2_MINIMAL_VERSION)
    MESSAGE(STATUS "Checking libxml2 version ${XML2_VERSION} > ${XML2_MINIMAL_VERSION}, XML Writer API Supported")
    SET(XML2_XMLWRITER_SUPPORTED "YES")
  ELSE (XML2_VERSION STRGREATER XML2_MINIMAL_VERSION)
    MESSAGE(STATUS "Checking libxml2 version ${XML2_VERSION} < ${XML2_MINIMAL_VERSION}, XML Writer API NOT Supported")
    SET(XML2_XMLWRITER_SUPPORTED "NO")
  ENDIF (XML2_VERSION STRGREATER XML2_MINIMAL_VERSION)
  SET(XML2_DEVEL_PACKAGE libxml2-devel)
ELSE (XML2_CONFIG_PROGRAM)
  SET(XML2_FOUND "NO")
  MESSAGE(STATUS "Looking for xml2-config - NOT found") 
ENDIF (XML2_CONFIG_PROGRAM)
