#$Id: test_data_fetcher.rb,v 1.4 2007/04/24 21:32:12 sgalles Exp $
#-----------------------------------------------------------------------
#
#TSP Ruby consumer - component for a generic Transport Sampling Protocol.
#
#Copyright (c) 2006 Stephane GALLES
#
#This library is free software; you can redistribute it and/or
#modify it under the terms of the GNU Lesser General Public
#License as published by the Free Software Foundation; either
#version 2.1 of the License, or (at your option) any later version.
#
#This library is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#Lesser General Public License for more details.
#
#You should have received a copy of the GNU Lesser General Public
#License along with this library; if not, write to the Free Software
#Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
#-----------------------------------------------------------------------
#
#Project    : TSP
#Maintainer : stephane.galles@free.fr
#Component  : RubyTsp Consumer
#
#-----------------------------------------------------------------------


$:.unshift File.join(File.dirname(__FILE__),"..","lib")
require 'test/unit'

require 'stringio'
require 'data_fetcher'


class TestDataFetcher < Test::Unit::TestCase
     
  def setup  
    g1 = Group.new
    g1[0] = GroupItem.new("s1",111)
    g1[0].on_decode(&Datatype::DOUBLE.decoder)
    g1[1] = GroupItem.new("s2",222)
    g1[1].on_decode(&Datatype::DOUBLE.decoder)
    g2 = Group.new()
    g2[0] = GroupItem.new("s3",333)
    g2[0].on_decode(&Datatype::DOUBLE.decoder)
    groups = [g1,g2] 
    data = [1000,0] +
           [12.3] +
           [-14.1] +
           [1001,1] +
           [16.1]
    mock_io = StringIO.new(data.pack("NNGGNNG"))
    @data_fetcher = DataFetcher.new(mock_io, groups)
  end
  
  def test_that_when_a_group_is_fetched_data_are_put_in_the_queue
    assert_not_nil(@data_fetcher.fetch_next_group)
    assert_equal(Sample.new(12.3,111,0),@data_fetcher.deq_sample(true))
    assert_equal(Sample.new(-14.1,222,0),@data_fetcher.deq_sample(true))
    assert_not_nil(@data_fetcher.fetch_next_group)
    assert_equal(Sample.new(16.1,333,0),@data_fetcher.deq_sample(true))
    assert_raise(RuntimeError){
      (@data_fetcher.fetch_next_group)
    }
  end
  
  def test_that_when_end_of_work_is_called_an_exception_is_raised_for_next_deq_sample
    @data_fetcher.end_of_work
    assert_raise(RuntimeError){
      @data_fetcher.deq_sample
    }        
  end
  

end

