#$Id: test_consumer.rb,v 1.3 2007/04/24 21:32:12 sgalles Exp $
#-----------------------------------------------------------------------
#
#TSP Ruby consumer - component for a generic Transport Sampling Protocol.
#
#Copyright (c) 2006 Stephane GALLES
#
#This library is free software; you can redistribute it and/or
#modify it under the terms of the GNU Lesser General Public
#License as published by the Free Software Foundation; either
#version 2.1 of the License, or (at your option) any later version.
#
#This library is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#Lesser General Public License for more details.
#
#You should have received a copy of the GNU Lesser General Public
#License along with this library; if not, write to the Free Software
#Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
#-----------------------------------------------------------------------
#
#Project    : TSP
#Maintainer : stephane.galles@free.fr
#Component  : RubyTsp Consumer
#
#-----------------------------------------------------------------------


$:.unshift File.join(File.dirname(__FILE__),"..","lib")
require 'test/unit'
require 'schmock'


require 'consumer'
require 'group'


class TestConsumer < Test::Unit::TestCase
  
  def setup
    @mock_data_fetcher = SchMock.new
    @mock_data_fetcher_factory = SchMock.new
    @mock_command = SchMock.new
    @consumer = Consumer.new(@mock_command, @mock_data_fetcher_factory)
    @core_req_open = CoreRequestOpen.new
    @core_ans_open = CoreAnswerOpen.new
    @core_req_info = CoreRequestInformation.new(nil)
    @core_req_sample = CoreRequestSample.new(nil,[])
    @core_ans_sample = CoreAnswerSample.new([])   
    @core_req_sample_init = CoreRequestSampleInit.new(nil)
    @core_ans_sample_init = CoreAnswerSampleInit.new           
    @core_req_sample_destroy = CoreRequestSampleDestroy.new(nil)
    @core_ans_sample_destroy = CoreAnswerSampleDestroy.new      
    @core_req_close = CoreRequestClose.new(nil)     
  end
  
  
  def test_that_channel_id_is_used_after_request_open_for_other_calls
    @core_ans_open.channel_id = 1234        
    @mock_command.__expects(:request_open).with(@core_req_open).returns(@core_ans_open)
    @core_req_info.channel_id = 1234        
    @mock_command.__expects(:request_information).with(@core_req_info).returns(@core_ans_sample)
    @core_req_sample.channel_id = 1234
    @mock_command.__expects(:request_sample).with(@core_req_sample).returns(@core_ans_sample)
    @core_req_sample_init.channel_id = 1234    
    @mock_command.__expects(:request_sample_init).with(@core_req_sample_init).returns(@core_ans_sample_init)    
    @core_req_sample_destroy.channel_id = 1234    
    @mock_command.__expects(:request_sample_destroy).with(@core_req_sample_destroy).returns(@core_ans_sample_destroy)    
    @core_req_close.channel_id = 1234    
    @mock_command.__expects(:request_close).with(@core_req_close).returns(1)    
    @mock_data_fetcher_factory.__expects(:create).with(nil,nil,[]).returns(@mock_data_fetcher)
    @mock_data_fetcher.ignore_missing
    #Test       
    @consumer.request_open
    @consumer.request_information
    @consumer.request_sample([])
    @consumer.request_sample_init
    @consumer.request_sample_destroy
    @consumer.request_close
    #Verify
    @mock_command.__verify    
    @mock_data_fetcher.__verify    
    @mock_data_fetcher_factory.__verify    
  end
  
  def test_that_after_request_sample_fetcher_is_provided_with_groups
   #TODO (shame on me...)
  end
  
  
  def test_that_during_request_sample_init_fetcher_is_provided_with_data_adress      
    @core_ans_sample_init.data_address = "myhost:3000"    
    @mock_command.__expects(:request_sample_init).with(@core_req_sample_init).returns(@core_ans_sample_init)
    @mock_data_fetcher_factory.__expects(:create).with("myhost", 3000, nil).returns(@mock_data_fetcher)
    @mock_data_fetcher.ignore_missing
    #Test
    @consumer.request_sample_init
    #Verify
    @mock_command.__verify  
    @mock_data_fetcher.__verify    
    @mock_data_fetcher_factory.__verify  
  end
  
  def test_request_information
    #Symbols
    s0 = CoreSymbolInfo.new("symbol0")
    s0.global_index, s0.group_index, s0.group_rank = 444,0,0
    s1 = CoreSymbolInfo.new("symbol1")
    s1.global_index, s1.group_index, s1.group_rank = 555,0,1
    s2 = CoreSymbolInfo.new("symbol2")
    s2.global_index, s2.group_index, s2.group_rank = 666,1,0
    @core_ans_sample = CoreAnswerSample.new([s0,s1,s2]) 
    #Mock
    @mock_command.__expects(:request_information).with(@core_req_info).returns(@core_ans_sample)    
    #Test
    symbols = @consumer.request_information
    assert_equal(3,symbols.length)
    assert_equal(SymbolInfo.new("symbol0",1,0,444),symbols[0])
    assert_equal(SymbolInfo.new("symbol1",1,0,555),symbols[1])
    assert_equal(SymbolInfo.new("symbol2",1,0,666),symbols[2])
    #Verify
    @mock_command.__verify 
  end   
  
  def test_that_request_sample_destroy_destroys_the_fetcher
    @mock_command.__expects(:request_sample_init).with(@core_req_sample_init).returns(@core_ans_sample_init)    
    @mock_data_fetcher_factory.__expects(:create).with(nil,nil,nil).returns(@mock_data_fetcher)
    @mock_command.__expects(:request_sample_destroy).with(@core_req_sample_destroy).returns(@core_ans_sample_destroy)        
    @mock_data_fetcher.__expects(:start).with()
    @mock_data_fetcher.__expects(:stop).with()
    #Test
    @consumer.request_sample_init
    @consumer.request_sample_destroy
    #Verify
    @mock_command.__verify  
    @mock_data_fetcher.__verify    
    @mock_data_fetcher_factory.__verify  
  end
  
end
