#$Id: test_command_xmlrpc.rb,v 1.5 2007/04/24 21:32:12 sgalles Exp $
#-----------------------------------------------------------------------
#
#TSP Ruby consumer - component for a generic Transport Sampling Protocol.
#
#Copyright (c) 2006 Stephane GALLES
#
#This library is free software; you can redistribute it and/or
#modify it under the terms of the GNU Lesser General Public
#License as published by the Free Software Foundation; either
#version 2.1 of the License, or (at your option) any later version.
#
#This library is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#Lesser General Public License for more details.
#
#You should have received a copy of the GNU Lesser General Public
#License along with this library; if not, write to the Free Software
#Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
#-----------------------------------------------------------------------
#
#Project    : TSP
#Maintainer : stephane.galles@free.fr
#Component  : RubyTsp Consumer
#
#-----------------------------------------------------------------------


$:.unshift File.join(File.dirname(__FILE__),"..","lib")
require 'test/unit'

require 'command_xmlrpc'
require 'consumer_core_domain'

class TestRequestOpenXMLRPCAdaptor < Test::Unit::TestCase
  
  
  def test_adapt_to_xmlrpc_request_open
    rs = CoreRequestOpen.new()
    assert_not_nil(rs)
    adaptor = RequestOpenXMLRPCAdaptor.new(rs)
    xmlrpcdata = adaptor.to_xmlrpc
    assert_not_nil(xmlrpcdata)
    assert(xmlrpcdata.has_key?("TSP_argv_t_len"))
  end

  
  def test_adapt_to_xmlrpc_answer_open  
   h = RelaxedHash.new(0000)
    h["status_str"] = "mystatus"
    ao = AnswerOpenXMLRPCFactory.create(h)
    assert_not_nil(ao)
    assert_equal("mystatus",ao.status_str)
    assert_equal(0000,ao.channel_id)
  end
  
  def test_adapt_to_xmlrpc_request_information
    r = CoreRequestInformation.new(1234)
    adaptor = RequestInformationXMLRPCAdaptor.new(r)
    xmlrpcdata = adaptor.to_xmlrpc
    assert_not_nil(xmlrpcdata)
    assert(xmlrpcdata.has_key?("channel_id"))
    assert_equal(1234,xmlrpcdata["channel_id"])
  end
  
  def test_adapt_to_xmlrpc_request_sample
    symbolInfo1 = CoreSymbolInfo.new("MySym1")
    symbolInfo2 = CoreSymbolInfo.new("MySym2")
    rs = CoreRequestSample.new(1234,[symbolInfo1, symbolInfo2],0)
    adaptor = RequestSampleXMLRPCAdaptor.new(rs)
    xmlrpc_array = adaptor.to_xmlrpc
    assert_not_nil(xmlrpc_array)
    assert_equal(3,xmlrpc_array.length)    
    assert(xmlrpc_array[0].has_key?("version_id"))
    assert_equal(2,xmlrpc_array[0]["symbols.TSP_sample_symbol_info_list_t_len"])
    assert(xmlrpc_array[1].has_key?("period"))
    assert(xmlrpc_array[2].has_key?("period"))
  end
  
  
  def test_adapt_to_xmlrpc_symbol_info
    rs = CoreSymbolInfo.new("MySimb")
    adaptor = SymbolInfoXMLRPCAdaptor.new(rs)
    xmlrpcdata = adaptor.to_xmlrpc
    assert_not_nil(xmlrpcdata)
    assert(xmlrpcdata.has_key?("period"))
    assert(xmlrpcdata.has_key?("type"))
    assert(xmlrpcdata.has_key?("nelem"))
    assert(xmlrpcdata.has_key?("offset"))
    assert(xmlrpcdata.has_key?("dimension"))
  end
  
  def test_create_from_xmlrpc_symbol_info
    xmldata = RelaxedHash.new(1111)
    xmldata["provider_global_index"] = 1234    
    xmldata["type"] = 10
    xmldata["nelem"] = 11
    xmldata["offset"] = 14
    xmldata["dimension"] = 12
    symbol = SymbolInfoXMLRPCAdaptor.create(xmldata)
    assert_not_nil(symbol)
    assert_equal(1234,symbol.global_index)
    assert_equal(10,symbol.type)
    assert_equal(11,symbol.nelem)
    assert_equal(14,symbol.offset)
    assert_equal(12,symbol.dimension)
  end
  
  
  def test_adapt_to_xmlrpc_answer_sample
    h1 = RelaxedHash.new(1111)
    h1["channel_id"] = 11
    h1["symbols.TSP_sample_symbol_info_list_t_len"] = 2
    h2 = RelaxedHash.new(2222)
    h2["period"] = 22
    h3 = RelaxedHash.new(3333)
    h3["period"] = 33
    a = [h1,h2,h3]
    as = AnswerSampleXMLRPCFactory.create(a)
    assert_not_nil(as)
    assert_equal(2,as.nb_symbols)
    assert_equal(11,as.channel_id)
    assert_equal(1111,as.version_id)    
    symbols = []
    as.each_symbol {|symbol| symbols << symbol}
    assert_equal(2,symbols.length)
    assert_equal(22,symbols[0].period)
  end
  
  
  def test_adapt_to_xmlrpc_request_sample_init
    r = CoreRequestSampleInit.new(1234)
    adaptor = RequestSampleInitXMLRPCAdaptor.new(r)
    xmlrpcdata = adaptor.to_xmlrpc
    assert_not_nil(xmlrpcdata)
    assert(xmlrpcdata.has_key?("channel_id"))
    assert_equal(1234,xmlrpcdata["channel_id"])
  end
  
  
  def test_adapt_to_xmlrpc_answer_sample_init
    h = RelaxedHash.new("random_init")
    h["data_address"] = "myhost:65000"
    a = AnswerSampleInitXMLRPCFactory.create(h)
    assert_not_nil(a)
    assert_equal("myhost:65000",a.data_address)
    assert_equal("random_init",a.channel_id)
  end
  
  def test_adapt_to_xmlrpc_request_sample_destroy
    r = CoreRequestSampleDestroy.new(1234)
    adaptor = RequestSampleDestroyXMLRPCAdaptor.new(r)
    xmlrpcdata = adaptor.to_xmlrpc
    assert_not_nil(xmlrpcdata)
    assert(xmlrpcdata.has_key?("channel_id"))
    assert_equal(1234,xmlrpcdata["channel_id"])
  end
  
  def test_adapt_to_xmlrpc_request_close
    r = CoreRequestClose.new(1234)
    adaptor = RequestCloseXMLRPCAdaptor.new(r)
    xmlrpcdata = adaptor.to_xmlrpc
    assert_not_nil(xmlrpcdata)
    assert(xmlrpcdata.has_key?("channel_id"))
    assert_equal(1234,xmlrpcdata["channel_id"])
  end
  
  def test_adapt_to_xmlrpc_answer_sample_destroy
    h = RelaxedHash.new(0000)
    h["status"] = 3
    ao = AnswerSampleDestroyXMLRPCFactory.create(h)
    assert_not_nil(ao)
    assert_equal(3,ao.status)
    assert_equal(0000,ao.channel_id)
  end
  
end

class RelaxedHash < Hash
    def fetch(key)
       self[key]   
    end
end  