#$Id: value_object_identity.rb,v 1.3 2007/04/24 21:32:12 sgalles Exp $
#-----------------------------------------------------------------------
#
#TSP Ruby consumer - component for a generic Transport Sampling Protocol.
#
#Copyright (c) 2006 Stephane GALLES
#
#This library is free software; you can redistribute it and/or
#modify it under the terms of the GNU Lesser General Public
#License as published by the Free Software Foundation; either
#version 2.1 of the License, or (at your option) any later version.
#
#This library is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#Lesser General Public License for more details.
#
#You should have received a copy of the GNU Lesser General Public
#License along with this library; if not, write to the Free Software
#Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
#-----------------------------------------------------------------------
#
#Project    : TSP
#Maintainer : stephane.galles@free.fr
#Component  : RubyTsp Consumer
#
#-----------------------------------------------------------------------



module ValueObjectIdentity
  def ==(obj); test_equal(obj); end
  def eql?(obj); test_equal(obj); end

  def ===(obj); test_equal(obj); end

  def hash
    h = 0

    self.instance_variables.each do |var|
      v = self.instance_eval var
      h ^= v.hash unless v.nil?
    end

    h
  end

  private
  def test_equal(obj)
    return false unless self.class == obj.class

    (self.instance_variables + obj.instance_variables).uniq.each do |var|
      v1 = self.instance_eval var
      v2 = obj.instance_eval var
      return false unless v1 == v2
    end

    true
  end
end