#$Id: group.rb,v 1.5 2007/04/24 21:32:12 sgalles Exp $
#-----------------------------------------------------------------------
#
#TSP Ruby consumer - component for a generic Transport Sampling Protocol.
#
#Copyright (c) 2006 Stephane GALLES
#
#This library is free software; you can redistribute it and/or
#modify it under the terms of the GNU Lesser General Public
#License as published by the Free Software Foundation; either
#version 2.1 of the License, or (at your option) any later version.
#
#This library is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#Lesser General Public License for more details.
#
#You should have received a copy of the GNU Lesser General Public
#License along with this library; if not, write to the Free Software
#Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
#-----------------------------------------------------------------------
#
#Project    : TSP
#Maintainer : stephane.galles@free.fr
#Component  : RubyTsp Consumer
#
#-----------------------------------------------------------------------

require 'consumer_domain'

class Group < Array

  def decode(io)  
    self.each do |group_item|
        group_item.decode(io) { |sample| yield sample}      
    end
  end
  
end

class GroupItem
    
  def initialize(name, global_index, nelem=1, offset=0)
    @name = name
    @global_index = global_index
    @nelem = nelem
    @offset = offset
    @buf = String.new
    @on_decode = nil
  end

    attr_reader :name, :global_index	
  
  def on_decode(&on_decode)
    @on_decode = on_decode
  end
  
  
  def decode(io)
    @nelem.times do |i|
      decoded_value = @on_decode.call(io,@buf)  
      yield Sample.new(decoded_value,@global_index,i)
    end  
  end
    
  def eql?(object)
    self == (object)
  end
  
  def ==(object)
    object.equal?(self) ||
     (object.instance_of?(self.class) &&
    object.name == name &&
    object.global_index == global_index
    )
  end
  
end

