#$Id: command_xmlrpc.rb,v 1.5 2007/04/24 21:32:12 sgalles Exp $
#-----------------------------------------------------------------------
#
#TSP Ruby consumer - component for a generic Transport Sampling Protocol.
#
#Copyright (c) 2006 Stephane GALLES
#
#This library is free software; you can redistribute it and/or
#modify it under the terms of the GNU Lesser General Public
#License as published by the Free Software Foundation; either
#version 2.1 of the License, or (at your option) any later version.
#
#This library is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#Lesser General Public License for more details.
#
#You should have received a copy of the GNU Lesser General Public
#License along with this library; if not, write to the Free Software
#Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
#-----------------------------------------------------------------------
#
#Project    : TSP
#Maintainer : stephane.galles@free.fr
#Component  : RubyTsp Consumer
#
#-----------------------------------------------------------------------


require 'enumerator'
require 'xmlrpc/client'

require 'consumer_core_domain'

class CommandXMLRPC
    
  #TODO : inject the XMLRPC server directly. This can't be tested as is.  
  def initialize(host="localhost",port=8000)
    @server = XMLRPC::Client.new(host, "/RPC2", port)
  end  
    
  def request_open(req_open)
    adaptor = RequestOpenXMLRPCAdaptor.new(req_open)
    xml_ans_open = @server.call("tsp.tsp_request_open", adaptor.to_xmlrpc)
    AnswerOpenXMLRPCFactory.create(xml_ans_open)
  end
  
  def request_information(req_info)
    adaptor=RequestInformationXMLRPCAdaptor.new(req_info)
    xml_ans_sample = @server.call("tsp.tsp_request_information", adaptor.to_xmlrpc)
    AnswerSampleXMLRPCFactory.create(xml_ans_sample)
  end
  
  def request_sample(req_sample)
    adaptor=RequestSampleXMLRPCAdaptor.new(req_sample)
    xml_ans_sample = @server.call("tsp.tsp_request_sample", *adaptor.to_xmlrpc)
    AnswerSampleXMLRPCFactory.create(xml_ans_sample)
  end
  
  def request_sample_init(req_sample_init)
    adaptor=RequestSampleInitXMLRPCAdaptor.new(req_sample_init)
    xml_ans_sample_init = @server.call("tsp.tsp_request_sample_init", adaptor.to_xmlrpc)
    AnswerSampleInitXMLRPCFactory.create(xml_ans_sample_init)
  end
  
  def request_sample_destroy(req_sample_destroy)
    adaptor=RequestSampleDestroyXMLRPCAdaptor.new(req_sample_destroy)
    xml_ans_sample_destroy = @server.call("tsp.tsp_request_sample_destroy", adaptor.to_xmlrpc)
    AnswerSampleDestroyXMLRPCFactory.create(xml_ans_sample_destroy)
  end
  
  def request_close(req_close)
    adaptor=RequestCloseXMLRPCAdaptor.new(req_close)
    @server.call("tsp.tsp_request_close", adaptor.to_xmlrpc)    
  end
    
end

module XMLRPCStructMapper
  
  def XMLRPCStructMapper.hash_to_struct(hash,struct,datamap)
    datamap.each do |accessor,key|
      value = hash.fetch(key) { raise "Unable to find key : '#{key}'"}
      struct.send("#{accessor}=", value)
    end  
    return struct  
  end  
  
  def XMLRPCStructMapper.struct_to_hash(struct,datamap)
    h = Hash.new
    datamap.each do |accessor,key|
      h[key] = struct.send("#{accessor}")
    end  
    return h
  end  
  
end

class RequestOpenXMLRPCAdaptor
  
  def initialize(req_open)
    @r = req_open
  end
    
  def to_xmlrpc
    {
      "version_id" => @r.version_id,
      #FIXME : can't transmit the array as xmlrpc expect a string...            
      "TSP_argv_t_len" => 0,
      "TSP_argv_t_val" => ""
    }    
  end
    
end

class AnswerOpenXMLRPCFactory

 
  private_class_method :new
  
  DATAMAP = {
    :version_id => "version_id",
    :channel_id => "channel_id",
    :status => "status",
    :status_str => "status_str",
  }
  
  
  def AnswerOpenXMLRPCFactory.create(xml_ans_open)
            
    return XMLRPCStructMapper.hash_to_struct(xml_ans_open,
                                             CoreAnswerOpen.new,
                                             DATAMAP)      
  end
    
end


class RequestInformationXMLRPCAdaptor

  DATAMAP = {
    :version_id => "version_id",
    :channel_id => "channel_id",   
  }

  def initialize(req_info)
    @r = req_info
  end

   def to_xmlrpc
    return XMLRPCStructMapper.struct_to_hash(@r,DATAMAP)
  end
        
end


class RequestSampleXMLRPCAdaptor
  
  DATAMAP = {
    :version_id => "version_id",
    :channel_id => "channel_id",
    :feature0   => "feature_words[0]",
    :feature1   => "feature_words[1]",
    :feature2   => "feature_words[2]",
    :feature3   => "feature_words[3]",
    :consumer_timeout => "consumer_timeout",
    :nb_symbols => "symbols.TSP_sample_symbol_info_list_t_len"
  }
  
  def initialize(req_sample)
    @r = req_sample;
  end
  
  def each_symbol_adapter
    @r.each_symbol {|symbol| yield SymbolInfoXMLRPCAdaptor.new(symbol) }
  end
      
  def to_xmlrpc
    symbol_adapter_iter = enum_for(:each_symbol_adapter)
    xml_symbols = symbol_adapter_iter.collect {|symbol_adapter| symbol_adapter.to_xmlrpc}
    
    xml_req_sample = XMLRPCStructMapper.struct_to_hash(@r,DATAMAP)
    return [xml_req_sample] + xml_symbols
  end
    
end

class SymbolInfoXMLRPCAdaptor
    
  DATAMAP = {
    :name => "name",
    :global_index => "provider_global_index",
    :group_index => "provider_group_index",
    :group_rank => "provider_group_rank",
    :dimension => "dimension",
    :period => "period",
    :phase => "phase",
    :type => "type",
    :dimension => "dimension",
    :nelem => "nelem",
    :offset => "offset"
  }
  

  def initialize(req_sample)
    @r = req_sample
  end
  
  def SymbolInfoXMLRPCAdaptor.create(xml_symbol_info)
    return XMLRPCStructMapper.hash_to_struct(xml_symbol_info,
                                             CoreSymbolInfo.new,
                                             DATAMAP)  
  end  
    
  def to_xmlrpc
    return XMLRPCStructMapper.struct_to_hash(@r,DATAMAP)
  end
    
end


class AnswerSampleXMLRPCFactory

  private_class_method :new
  
  DATAMAP = {
    :version_id => "version_id",
    :channel_id => "channel_id",
    :provider_timeout => "provider_timeout",
    :group_number => "provider_group_number",
    :base_frequency => "base_frequency",
    :max_period => "max_period",
    :max_client_number => "max_client_number",
    :current_client_number => "current_client_number",
    :status => "status",
  }
  
  def AnswerSampleXMLRPCFactory.create(xml_ans_sample_bundle)
  
    xml_ans_sample = xml_ans_sample_bundle.shift
    xml_symbols = xml_ans_sample_bundle
    
    symbols = xml_symbols.collect {|xml_symbol| SymbolInfoXMLRPCAdaptor.create(xml_symbol)}
    
    return XMLRPCStructMapper.hash_to_struct(xml_ans_sample,
                                             CoreAnswerSample.new(symbols),
                                             DATAMAP)
  end
  
end


class RequestSampleInitXMLRPCAdaptor

  DATAMAP = {
    :version_id => "version_id",
    :channel_id => "channel_id",   
  }

  def initialize(req_sample_init)
    @r = req_sample_init
  end

   def to_xmlrpc
    return XMLRPCStructMapper.struct_to_hash(@r,DATAMAP)
  end
        
end

class AnswerSampleInitXMLRPCFactory
 
  private_class_method :new
  
  DATAMAP = {
    :version_id => "version_id",
    :channel_id => "channel_id",
    :data_address => "data_address",
    :status => "status",
  }
    
  def AnswerSampleInitXMLRPCFactory.create(xml_ans_sample_init)
              
    return XMLRPCStructMapper.hash_to_struct(xml_ans_sample_init,
                                             CoreAnswerSampleInit.new,
                                             DATAMAP)      
  end    
end


class RequestSampleDestroyXMLRPCAdaptor

  DATAMAP = {
    :version_id => "version_id",
    :channel_id => "channel_id",   
  }

  def initialize(req_sample_init)
    @r = req_sample_init
  end

   def to_xmlrpc
    return XMLRPCStructMapper.struct_to_hash(@r,DATAMAP)
  end
        
end

class AnswerSampleDestroyXMLRPCFactory

  private_class_method :new
  
  DATAMAP = {
    :version_id => "version_id",
    :channel_id => "channel_id",
    :status => "status"
  }
  
  
  def AnswerSampleDestroyXMLRPCFactory.create(xml_ans_open)
            
    return XMLRPCStructMapper.hash_to_struct(xml_ans_open,
                                             CoreAnswerSampleDestroy.new,
                                             DATAMAP)      
  end
    
end

class RequestCloseXMLRPCAdaptor

  DATAMAP = {
    :version_id => "version_id",
    :channel_id => "channel_id",   
  }

  def initialize(req_sample_close)
    @r = req_sample_close
  end

   def to_xmlrpc
    return XMLRPCStructMapper.struct_to_hash(@r,DATAMAP)
  end
        
end


