#$Id: tsp_controller.rb,v 1.27 2007/03/23 13:56:39 sgalles Exp $
#-----------------------------------------------------------------------
#
#TSP Ruby consumer - component for a generic Transport Sampling Protocol.
#
#Copyright (c) 2007 Stephane GALLES
#
#This library is free software; you can redistribute it and/or
#modify it under the terms of the GNU Lesser General Public
#License as published by the Free Software Foundation; either
#version 2.1 of the License, or (at your option) any later version.
#
#This library is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#Lesser General Public License for more details.
#
#You should have received a copy of the GNU Lesser General Public
#License along with this library; if not, write to the Free Software
#Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
#-----------------------------------------------------------------------
#
#Project    : TSP
#Maintainer : stephane.galles@free.fr
#Component  : RubyTsp Consumer
#
#-----------------------------------------------------------------------



class TspController < ApplicationController

    before_filter  :authorize, :init_data


    REFRESH_PERIOD=10
    CEIL = lambda { |val| BigDecimal(val.to_s).ceil(2).to_f }
    TRUNCATE = lambda { |val| val.abs<1000 ? val : val.truncate }

    def index

        if @connected
            render(:action => 'tsp')
        else
            render(:action => 'not_connected')
        end
    end


    # Send a graph to the browser
    def graph
        g = Plot.new(600)
        g.title = 'TSP Sampling'
        g.font = File.expand_path('artwork/fonts/Vera.ttf', RAILS_ROOT)

        # y values
        @symbols.each{|s| g.data(s, @bridge.get_array(s).map(&CEIL) )}

        #x value
        g.x_data = @bridge.get_array(@absys_symbol).map(&CEIL)
        g.x_name = @absys_symbol

        send_data(g.to_blob,
        :disposition => 'inline',
        :type => 'image/png',
        :filename => "bart_scores.png")
        GC.start
    end

    def graph_ajax
        if @ajax_enabled
            render :update do |page|
                page.update_graph
            end
        end
    end


    def add_y_symbol_non_ajax
        @bridge.choose_symbol(@username, params[:id])
        redirect_refresh_graph
    end

    def add_x_symbol_non_ajax
        @bridge.choose_absys(@username, params[:id])
        redirect_refresh_graph
    end

    def clear
        @bridge.unchoose_symbols(@username)
        @bridge.unchoose_absys(@username)
        redirect_refresh_graph
    end

    def add_y_symbol
        @bridge.choose_symbol(@username, params[:symbol])
        process_symbols_changed
    end

    def remove_y_symbol
        @bridge.unchoose_symbol(@username, params[:symbol])
        process_symbols_changed
    end

    def remove_x_symbol
        @bridge.unchoose_absys(@username)
        process_symbols_changed
    end

    def add_y_symbol_remove_x
        @bridge.unchoose_absys(@username)
        add_y_symbol
    end

    def add_x_symbol
        @bridge.choose_absys(@username, params[:symbol])
        @bridge.unchoose_symbol(@username, params[:symbol])
        process_symbols_changed
    end

    def process_symbols_changed
        @symbols = @bridge.choosen_symbols(@username)
        @absys_symbol = @bridge.choosen_absys(@username)
        render :update do |page|
            page.replace_html 'y_symbols', helper_partial_y_symbols
            page.replace_html 'x_symbols', helper_partial_x_symbols
            page.replace_html 'available_symbols', helper_partial_available_symbols
            page.update_graph
        end

    end


    private

    def init_data

        GC.start
        @username=session[:user_id]
        DRb.start_service
        begin
            @bridge=DRbObject.new(nil, "druby://localhost:9001")
            @names=@bridge.symbols_name
        rescue
            @connected=false
        else
            @connected=true
            @symbols = @bridge.choosen_symbols(@username)
            @absys_symbol = @bridge.choosen_absys(@username)
        end
        @refresh_period = REFRESH_PERIOD
        @ajax_enabled=session[:ajax]
        @consumer_name = @bridge.consumer_name

        return true
    end

    def redirect_refresh_graph
        redirect_to :action => :index
    end

end
