# Filters added to this controller apply to all controllers in the application.
# Likewise, all the methods added will be available for all controllers.

class ApplicationController < ActionController::Base
  # Pick a unique cookie name to distinguish our session data from others'
  session :session_key => '_tspror_session_id'

  before_filter :ensure_protocol

  private

  def authorize      
      unless session[:user_id]
          redirect_to(:controller => "login", :action => "login")
      end
  end


  def ensure_protocol
      return true if !APP_CONFIG[:ssl_required] || request.ssl?

      https_port = ":" + (request.port + APP_CONFIG[:https_offset]).to_s
      https_port = "" if https_port==":443"
      redirect_to "https://" + request.host + https_port + request.request_uri
      return false

  end  

end
