#$Id: data_fetcher.rb,v 1.3 2007/02/20 05:59:04 sgalles Exp $
#-----------------------------------------------------------------------
#
#TSP Ruby consumer - component for a generic Transport Sampling Protocol.
#
#Copyright (c) 2006 Stephane GALLES
#
#This library is free software; you can redistribute it and/or
#modify it under the terms of the GNU Lesser General Public
#License as published by the Free Software Foundation; either
#version 2.1 of the License, or (at your option) any later version.
#
#This library is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#Lesser General Public License for more details.
#
#You should have received a copy of the GNU Lesser General Public
#License along with this library; if not, write to the Free Software
#Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
#-----------------------------------------------------------------------
#
#Project    : TSP
#Maintainer : stephane.galles@free.fr
#Component  : RubyTsp Consumer
#
#-----------------------------------------------------------------------



require 'group'
require 'consumer_domain'
require 'thread'

class DataFetcher

  MAX_QUEUE_SIZE = 1000

  def initialize(io, groups)
    @io = io
    @groups = groups
    @queue = SizedQueue.new(MAX_QUEUE_SIZE)
    @buf = String.new
    @stopped = false
  end
  
  
  def fetch_next_group    
    if @io.read(8,@buf) == nil
      @queue.enq(:DATA_STREAM_BROKEN)
      raise "Data stream broken !"      
    end    
    # FIXME : NN unpack two unsigned integer, actually, there're signed
    time_stamp, group_index = @buf.unpack "NN"    
    # FIXME : if an exception is raised, add something to the queue
    @groups[group_index].decode(@io) do |sample|        
        return if @stopped   
        @queue.enq(sample)         
    end    
  end

  def deq_sample(non_block=false)
    raise "Data stream was stopped" if @stopped       
    item = @queue.deq(non_block)
    raise "Data stream broken !" if item == :DATA_STREAM_BROKEN
    return item
  end
  
  def end_of_work
    @stopped = true 
    # unblock fetch_next_group    
    until @queue.empty?
      @queue.deq
    end  
  end
  
end