#$Id: consumer.rb,v 1.6 2007/02/20 21:00:08 sgalles Exp $
#-----------------------------------------------------------------------
#
#TSP Ruby consumer - component for a generic Transport Sampling Protocol.
#
#Copyright (c) 2006 Stephane GALLES
#
#This library is free software; you can redistribute it and/or
#modify it under the terms of the GNU Lesser General Public
#License as published by the Free Software Foundation; either
#version 2.1 of the License, or (at your option) any later version.
#
#This library is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#Lesser General Public License for more details.
#
#You should have received a copy of the GNU Lesser General Public
#License along with this library; if not, write to the Free Software
#Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
#-----------------------------------------------------------------------
#
#Project    : TSP
#Maintainer : stephane.galles@free.fr
#Component  : RubyTsp Consumer
#
#-----------------------------------------------------------------------



require 'enumerator'

require 'consumer_core_domain' 
require 'consumer_domain' 
require 'group'  
require 'data_fetcher'
require 'active_data_fetcher'
require 'command_xmlrpc'

  
class Consumer

  def initialize(command, active_data_fetcher_factory)
    @active_data_fetcher_factory = active_data_fetcher_factory 
    @command = command 
    @channel_id = nil
    @groups = nil
    @active_data_fetcher = nil
  end
  
  def request_open()
    req_open = CoreRequestOpen.new
    ans_open = @command.request_open(req_open)
    ans_open.check_status
    @channel_id = ans_open.channel_id
  end
  
  def request_information()
    req_info = CoreRequestInformation.new(@channel_id)
    ans_sample = @command.request_information(req_info)
    ans_sample.check_status
    core_symbol_iter = ans_sample.enum_for(:each_symbol)
    symbols = core_symbol_iter.collect {|core_symbol| SymbolInfo.from_core_symbol(core_symbol)}
    # some providers seem to puts randomly 0 or 1 in nelem, let's clean that up
    symbols.each do |symbol|
         symbol.nelem = 0
    end
    return symbols
  end
  
  def request_sample(symbols)
    core_symbols = symbols.collect {|symbol| symbol.to_core_symbol}
    req_sample = CoreRequestSample.new(@channel_id,core_symbols)
    ans_sample = @command.request_sample(req_sample) 
    ans_sample.check_status
    @groups = []
    ans_sample.each_symbol do |s|
      @groups[s.group_index] ||= Group.new
      group_item = GroupItem.new(s.name, s.global_index, s.nelem, s.offset)
      decoder = Datatype.get_datatype_by_id(s.type).decoder
      group_item.on_decode(&decoder)
      @groups[s.group_index][s.group_rank] = group_item
    end
  end
  
  def request_sample_init()
    req_sample_init = CoreRequestSampleInit.new(@channel_id)
    ans_sample_init = @command.request_sample_init(req_sample_init)
    ans_sample_init.check_status
    #TODO : remove this ugly thing and do plain ioc
    @active_data_fetcher = @active_data_fetcher_factory.create(ans_sample_init.host,ans_sample_init.port,@groups)
    @active_data_fetcher.start
  end
  
  def request_sample_destroy()
    @active_data_fetcher.stop
    req_sample_destroy = CoreRequestSampleDestroy.new(@channel_id)
    ans_sample_destroy = @command.request_sample_destroy(req_sample_destroy)
    ans_sample_destroy.check_status
  end
  
  def request_close()
    req_close = CoreRequestClose.new(@channel_id)
    @command.request_close(req_close)    
  end
  
  def deq_sample
    # TODO : iterate if a block is provided
     @active_data_fetcher.deq_sample
  end
        
end

class ConsumerFactory
    
  private_class_method :new  
    
  def ConsumerFactory.create(host="localhost",port=8000)
    command = CommandXMLRPC.new(host, port)
    active_data_fetcher_factory = ActiveDataFetcherFactory.new
    Consumer.new(command, active_data_fetcher_factory)
  end

end

#TODO : remove this ugly thing and do plain ioc
class ActiveDataFetcherFactory
    
  def create(host,port,groups)
    socket = TCPSocket.new(host, port)
    data_fetcher = DataFetcher.new(socket, groups)
    ActiveDataFetcher.new(data_fetcher)
  end

end


