#$Id: active_data_fetcher.rb,v 1.2 2007/02/20 05:59:04 sgalles Exp $
#-----------------------------------------------------------------------
#
#TSP Ruby consumer - component for a generic Transport Sampling Protocol.
#
#Copyright (c) 2006 Stephane GALLES
#
#This library is free software; you can redistribute it and/or
#modify it under the terms of the GNU Lesser General Public
#License as published by the Free Software Foundation; either
#version 2.1 of the License, or (at your option) any later version.
#
#This library is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#Lesser General Public License for more details.
#
#You should have received a copy of the GNU Lesser General Public
#License along with this library; if not, write to the Free Software
#Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
#-----------------------------------------------------------------------
#
#Project    : TSP
#Maintainer : stephane.galles@free.fr
#Component  : RubyTsp Consumer
#
#-----------------------------------------------------------------------


class ActiveDataFetcher

  def initialize(data_fetcher)
    @df = data_fetcher
    @stopped = false
    @thread = nil
  end
  
  def start
    @thread = Thread.new do
      begin
        @df.fetch_next_group
      end until @stopped
    end  
  end
  
  def deq_sample(non_block=false)
    @df.deq_sample(non_block)
  end
  
  def stop
    @stopped = true
    @df.end_of_work    
    @thread.join
  end
  
end

