
MESSAGE(STATUS "Looking for xml2-config...")
FIND_PROGRAM(XML2_CONFIG_PROGRAM
  NAMES xml2-config 
  PATHS /usr/local/bin /usr/bin
  DOC "The libxml2 (www.xmlsoft.org) configuration tool")
IF (XML2_CONFIG_PROGRAM)
  MESSAGE(STATUS "Looking for xml2-config - found : ${XML2_CONFIG_PROGRAM}")
  SET(XML2_FOUND "YES")
  SET(XML2_LIBRARY "`${XML2_CONFIG_PROGRAM} --libs`")
  SET(XML2_CFLAGS "`${XML2_CONFIG_PROGRAM} --cflags`")

  EXEC_PROGRAM(${XML2_CONFIG_PROGRAM} 
    ARGS "--version"
    OUTPUT_VARIABLE XML2_VERSION)

  SET(XML2_MINIMAL_VERSION "2.6.0")

  IF (XML2_VERSION STRGREATER XML2_MINIMAL_VERSION)
    MESSAGE(STATUS "Checking libxml2 version ${XML2_VERSION} > ${XML2_MINIMAL_VERSION}, XML Writer API Supported")
    SET(XML2_XMLWRITER_SUPPORTED "YES")
  ELSE (XML2_VERSION STRGREATER XML2_MINIMAL_VERSION)
    MESSAGE(STATUS "Checking libxml2 version ${XML2_VERSION} < ${XML2_MINIMAL_VERSION}, XML Writer API NOT Supported")
    SET(XML2_XMLWRITER_SUPPORTED "NO")
  ENDIF (XML2_VERSION STRGREATER XML2_MINIMAL_VERSION)
ELSE (XML2_CONFIG_PROGRAM)
  SET(XML2_FOUND "NO")
  MESSAGE(STATUS "Looking for xml2-config - NOT found") 
ENDIF (XML2_CONFIG_PROGRAM)