# - sets directory-variables defined by the GNU coding standards
#
# Usage:
#   find_package(GNUPaths)
#
# This module sets some variables whose names and contents are defined
# by the GNU coding standards. These variables are:
#
#   prefix         ... defaults to ${CMAKE_INSTALL_PREFIX}
#   exec_prefix    ... defaults to ${prefix}
#   bindir         ... defaults to ${exec_prefix}/${_bin}
#   sbindir        ... defaults to ${exec_prefix}/s${_bin}
#   libexecdir     ... defaults to ${exec_prefix}/libexec
#   datadir        ... defaults to ${prefix}/share
#   sysconfdir     ... defaults to ${prefix}/etc
#   sharedstatedir ... defaults to ${prefix}/com
#   localstatedir  ... defaults to ${prefix}/var
#   libdir         ... defaults to ${prefix}/${_lib}
#   infodir        ... defaults to ${prefix}/info
#   lispdir        ... defaults to ${datadir}/emacs/site-lisp
#   includedir     ... defaults to ${prefix}/include
#   oldincludedir  ... defaults to ${includedir}
#   mandir         ... defaults to ${mandir}
#
# Details about these variables can be found at 'info standards -> g
# Directory Variables'
#
#
# When ${PACKAGE} variable exists, the following variables will be
# defined:
#
#   pkglibdir      ... defaults to ${libdir}/${PACKAGE}
#   pkgincludedir  ... defaults to ${includedir}/${PACKAGE}
#   pkgdatadir     ... defaults to ${datadir}/${PACKAGE}
#
#
# The following variables are interesting for multilib environments
# and influence value of some other variables listed above:
#
#   _lib           ... defaults to "lib"
#   _bin           ... defaults to "bin"
#
#
# They are used like
#
# install(TARGETS foolib fooexe
#   RUNTIME DESTINATION "${bindir}"
#   LIBRARY DESTINATION "${libdir}")
#
#
# This module exists to provide packagers an uniform way to set paths.
# E.g. RPM packages can contain
#
#   cmake -D_lib=%_lib -Dbindir=%_bindir -Dlibdir=%_libdir ...
#
# which sets correct paths for the current environment (e.g. libdir to
# /usr/lib64 on multilib platforms)


# Copyright (C) 2006 Enrico Scholz <enrico.scholz@informatik.tu-chemnitz.de>
#
# Redistribution and use, with or without modification, are permitted
# provided that the following conditions are met:
# 
#    1. Redistributions must retain the above copyright notice, this
#       list of conditions and the following disclaimer.
#    2. The name of the author may not be used to endorse or promote
#       products derived from this software without specific prior
#       written permission.
# 
# THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
# IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY
# DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
# GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
# INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
# IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
# OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN
# IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

set(GNUPaths_FOUND 1)

set(_lib		"lib"				CACHE STRING "Basename of the library-directory; usually 'lib' or 'lib64' (on multilib archs)")
set(_bin		"bin"				CACHE STRING "Basename of the bin-directory; usually 'bin'")

set(prefix		"${CMAKE_INSTALL_PREFIX}"	CACHE PATH "A prefix used in constructing the default values of the directory variables.")
set(exec_prefix		"${prefix}"			CACHE PATH "A prefix used in constructing the default values of some of the direcotory variables.")
set(bindir		"${exec_prefix}/${_bin}"	CACHE PATH "The directory for installing executable programs that users can run.")
set(sbindir		"${exec_prefix}/s${_bin}"	CACHE PATH "The directory for installing executable programs that can be run from the shell, but are only generally useful to system administrators.")
set(libexecdir		"${exec_prefix}/libexec"	CACHE PATH "The directory for installing executable programs to be run by other programs rather than by users.")
			
set(datadir		"${prefix}/share"		CACHE PATH "The directory for installing read-only architecture independent data files.")
set(sysconfdir		"${prefix}/etc"			CACHE PATH "The directory for installing read-only data files that pertain to a single machine-that is to say, files for configuring a host.")
set(sharedstatedir	"${prefix}/com"			CACHE PATH "The directory for installing architecture-independent data files which the programs modify while they run.")
set(localstatedir	"${prefix}/var"			CACHE PATH "The directory for installing data files which the programs modify while they run, and that pertain to one specific machine.")
set(libdir		"${prefix}/${_lib}"		CACHE PATH "The directory for object files and libraries of object code.")
set(infodir		"${prefix}/info"		CACHE PATH "The directory for installing the Info files for this package.")
set(lispdir		"${datadir}/emacs/site-lisp"	CACHE PATH "The directory for installing any Emacs Lisp files in this package.")
set(includedir		"${prefix}/include"		CACHE PATH "The directory for installing header files to be included by user programs with the C `#include' preprocessor directive.")
set(oldincludedir	"${includedir}"			CACHE PATH "The directory for installing `#include' header files for use with compilers other than GCC.")
set(mandir		"${prefix}/man"			CACHE PATH "The top-level directory for installing the man pages for this package.")

mark_as_advanced(_lib _bin)
mark_as_advanced(prefix exec_prefix bindir sbindir libexecdir
  datadir sysconfdir sharedstatedir localstatedir libdir infodir
  lispdir includedir oldincludedir mandir)

if(PACKAGE)
  set(pkglibdir		"${libdir}/${PACKAGE}"		CACHE PATH "pkglibdir path")
  set(pkgincludedir	"${includedir}/${PACKAGE}"	CACHE PATH "pkgincludedir path")
  set(pkgdatadir	"${datadir}/${PACKAGE}"		CACHE PATH "pkgdatadir path")

  mark_as_advanced(pkglibdir pkgincludedir pkgdatadir)
endif(PACKAGE)


### Local Variables:
### mode: cmake
### End:
