/* $Id: TspSimpleStdOut.java,v 1.4 2005/10/05 00:11:47 sgalles Exp $
 * -----------------------------------------------------------------------
 * 
 * TSP Library - core components for a generic Transport Sampling Protocol.
 * 
 * Copyright (c) 2002 Yves DUFRENNE, Stephane GALLES, Eric NOULARD and Robert PAGNOT 
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * -----------------------------------------------------------------------
 * 
 * Project    : TSP
 * SubProject : jTSP
 * Maintainer : tsp@astrium-space.com
 * Component  : Consumer
 * 
 * -----------------------------------------------------------------------
 * 
 * Purpose   : exemple for the simple consumer API
 * 
 * -----------------------------------------------------------------------
 */

package tsp.consumer.app.jstdout.simple;


import tsp.core.common.url.TspURL;
import tsp.core.common.url.TspURLException;
import tsp.core.common.url.TspURLFactory;
import tsp.core.config.TspConfig;
import tsp.core.consumer.TspConsumerException;
import tsp.core.consumer.simple.TspSimpleAnswerSample;
import tsp.core.consumer.simple.TspSimpleConsumer;
import tsp.core.consumer.simple.TspSimpleConsumerFactory;
import tsp.core.consumer.simple.TspSimpleRequestSample;
import tsp.core.consumer.simple.TspSimpleSample;
import tsp.core.consumer.simple.TspSimpleSampleSymbolInfo;
import tsp.core.consumer.simple.TspSimpleSession;


class TspSimpleStdOut {

	public static void main(String[] args) {

		try {

			TspSimpleConsumerFactory factory = new TspSimpleConsumerFactory(args);
			

			/* Set up Logging level */
			TspConfig.setLogLevel(TspConfig.LOG_FINER);
			
			String sURL = args.length == 0 ? "" : args[0];
			TspURL url = TspURLFactory.createWithDefaultSupport(sURL);
			int symbol_rank = 0;
			int nb_print = 100;			
			if (args.length > 1) {
				symbol_rank = Integer.decode(args[1]).intValue();
			}
			if (args.length > 2) {
				nb_print = Integer.decode(args[2]).intValue();
			}
			
			TspSimpleConsumer consumer = factory.createSimpleConsumer(url);
			TspSimpleSession session = consumer.openSession();
			
			/* request Infos */
			TspSimpleAnswerSample asi = session.requestInfos();

			/* build request sample with a subset of variables */
			TspSimpleSampleSymbolInfo[] sampleSymbols = new TspSimpleSampleSymbolInfo[symbol_rank+1];
			System.arraycopy(asi.getSymbolInfos(), 0, sampleSymbols, 0, symbol_rank+1);
												
			TspSimpleRequestSample rqs = new TspSimpleRequestSample(sampleSymbols);
			session.requestSample(rqs);

			/* begin sampling */
			session.requestSampleInit();

			/* print sample value */
			TspSimpleSample sample = new TspSimpleSample();
			System.out.println("Waiting first element in FIFO...");			
			session.waitForData();
			
			System.out.println("Got it go!!");
			for (int k = 0; k < nb_print; ++k) {
				session.waitForData();
				session.fetchSample(sample);

				System.out.println(
					"Sample <"
						+ k
						+ "> = { provider_global_index ="
						+ sample.getIndex()
						+ ", value="
						+ sample.getValue());
			}
			/* end sampling */
			session.requestSampleFinalize();
			/* close Session */
			session.close();

		}
		catch (TspConsumerException e) {
			e.printStackTrace();
		} catch (TspURLException e) {
			e.printStackTrace();
		} catch (Exception e) {
			e.printStackTrace();
		}		
		

	} /* end of main */

}
