/*
 * Decompiled with CFR 0.152.
 */
package simtools.data;

import java.io.File;
import java.util.Iterator;
import simtools.data.AsciiFileDataSourceCollection;
import simtools.data.DataSource;
import simtools.data.DataSourceCollection;
import simtools.data.DataSourcePool;
import simtools.data.DataSourceProvider;
import simtools.data.DuplicateIdException;

public class AsciiFileDataSourceProvider
implements DataSourceProvider {
    private boolean chooseAgain = false;
    protected String marker = "AsciiFile:";

    protected void setChooseFileAgain(boolean bl) {
        this.chooseAgain = bl;
    }

    protected boolean getChooseFileAgain() {
        return this.chooseAgain;
    }

    public File chooseFile(String string, String string2) {
        File file = new File(string);
        if (file.exists()) {
            return file;
        }
        return null;
    }

    public boolean chooseUseCollection(DataSourceCollection dataSourceCollection, String string, String string2) {
        return false;
    }

    public Object getOptionalInformation(DataSource dataSource, DataSourceCollection dataSourceCollection) {
        if (dataSourceCollection == null || !(dataSourceCollection instanceof AsciiFileDataSourceCollection)) {
            return null;
        }
        AsciiFileDataSourceCollection asciiFileDataSourceCollection = (AsciiFileDataSourceCollection)dataSourceCollection;
        return new int[]{asciiFileDataSourceCollection.getGranularity(), asciiFileDataSourceCollection.getSubsampling()};
    }

    public DataSource provide(String string, String string2, Object object, DataSourcePool dataSourcePool) {
        Object object2;
        DataSourceCollection dataSourceCollection;
        block14: {
            if (string == null || string2 == null || !string2.startsWith(this.marker)) {
                return null;
            }
            dataSourceCollection = null;
            if (dataSourcePool != null) {
                try {
                    dataSourceCollection = dataSourcePool.getCollectionForDataSourceId(string);
                }
                catch (DuplicateIdException duplicateIdException) {
                    Iterator iterator = duplicateIdException.conflicts.iterator();
                    while (iterator.hasNext()) {
                        object2 = (DataSourceCollection)iterator.next();
                        if (object2 instanceof AsciiFileDataSourceCollection) continue;
                        iterator.remove();
                    }
                    if (duplicateIdException.conflicts.size() == 0) {
                        dataSourceCollection = null;
                    }
                    if (duplicateIdException.conflicts.size() <= 0) break block14;
                    dataSourceCollection = (AsciiFileDataSourceCollection)duplicateIdException.conflicts.get(0);
                }
            }
        }
        if (dataSourceCollection instanceof AsciiFileDataSourceCollection && this.chooseUseCollection(dataSourceCollection, string2, string)) {
            return dataSourceCollection.get(string);
        }
        int n = ((int[])object)[0];
        int n2 = ((int[])object)[1];
        object2 = string2.substring(this.marker.length());
        DataSource dataSource = null;
        AsciiFileDataSourceCollection asciiFileDataSourceCollection = null;
        block5: do {
            File file;
            if ((file = this.chooseFile((String)object2, string)) == null) {
                return null;
            }
            try {
                asciiFileDataSourceCollection = new AsciiFileDataSourceCollection(file, n2, n);
                for (int i = 0; i < asciiFileDataSourceCollection.size(); ++i) {
                    if (!string.equals(asciiFileDataSourceCollection.getInformation((int)i).id)) continue;
                    dataSource = (DataSource)asciiFileDataSourceCollection.get(i);
                    continue block5;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        } while (this.chooseAgain && dataSource == null);
        if (dataSource == null) {
            return null;
        }
        if (dataSourcePool != null) {
            dataSourcePool.addDataSourceCollection(asciiFileDataSourceCollection);
        }
        return dataSource;
    }
}

