/*
 * Decompiled with CFR 0.152.
 */
package simtools.data;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;
import simtools.data.CollectiveDataSource;
import simtools.data.DataException;
import simtools.data.DataInfo;
import simtools.data.DataSourceCollection;
import simtools.data.NoSuchIndex;
import simtools.data.UnsupportedOperation;
import simtools.data.ValueProvider;
import simtools.data.buffer.Buffer;
import simtools.data.buffer.BufferedDataSource;
import simtools.util.NumberStringComparator;

public class AsciiFileDataSourceCollection
extends DataSourceCollection {
    protected DataInfo[] info;
    protected Object[] min;
    protected Object[] max;
    protected Object[] cachedEntry;
    protected long cachedIndex;
    protected String charsetName;
    protected int subsampling;
    public static final int DEFAULT_GRANULARITY = 100;
    protected int granularity;
    protected transient Vector indexOffset;
    protected transient RandomAccessFile file;
    protected transient String fileName;
    protected transient String absoluteFileName;
    protected transient long currentIndex;
    protected transient long maxReachedIndex;
    static final String ID_MARKER = "AsciiFile:";
    protected DataInfo ourInfo;
    protected long sliceEnd;
    static /* synthetic */ Class class$java$lang$Number;

    public String getCharsetName() {
        return this.charsetName;
    }

    public void setCharsetName(String string) {
        this.charsetName = string;
    }

    Buffer[] getBuffers() {
        return this.buffers;
    }

    String[] getIds() {
        String[] stringArray = new String[this.info.length];
        for (int i = 0; i < this.info.length; ++i) {
            stringArray[i] = this.info[i].label;
        }
        return stringArray;
    }

    void setBuffer(int n, Buffer buffer) {
        buffer.setProvider((ValueProvider)this.get(n));
        this.set(n, new BufferedDataSource(buffer));
    }

    public AsciiFileDataSourceCollection(File file) throws IOException, InvalidFormatException {
        this(file, 1);
    }

    public AsciiFileDataSourceCollection(File file, String string) throws IOException, InvalidFormatException {
        this(file, 1, string);
    }

    public AsciiFileDataSourceCollection(File file, int n) throws IOException, InvalidFormatException {
        this(file, n, 100);
    }

    public AsciiFileDataSourceCollection(File file, int n, String string) throws IOException, InvalidFormatException {
        this(file, n, 100, string);
    }

    public AsciiFileDataSourceCollection(File file, int n, int n2) throws IOException, InvalidFormatException {
        this(file, n, n2, null);
    }

    public AsciiFileDataSourceCollection(File file, int n, int n2, String string) throws IOException, InvalidFormatException {
        String string2;
        int n3;
        this.granularity = n2;
        this.charsetName = string;
        if (this.granularity <= 0) {
            this.granularity = 100;
        }
        this.fileName = file.getName();
        this.absoluteFileName = file.getAbsolutePath();
        this.file = new RandomAccessFile(file, "r");
        this.cachedEntry = null;
        this.cachedIndex = -5L;
        this.subsampling = n;
        long l = this.file.getFilePointer();
        String string3 = this.convertToCharset(this.file.readLine());
        if (string3 == null) {
            throw new InvalidFormatException();
        }
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        while (string3 != null && (string3.startsWith("#") || string3.trim().equals(""))) {
            int n4;
            if (!string3.trim().equals("") && (n4 = string3.indexOf(61)) != -1) {
                String string4 = string3.substring(1, n4).trim();
                String string5 = string3.substring(n4 + 1).trim();
                hashtable.put(string4, string5);
                l = this.file.getFilePointer();
            }
            string3 = this.convertToCharset(this.file.readLine());
        }
        if (string3 == null) {
            throw new InvalidFormatException();
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string3);
        int n5 = stringTokenizer.countTokens();
        if (n5 == 0) {
            throw new InvalidFormatException();
        }
        boolean bl = true;
        Vector<String> vector = new Vector<String>();
        for (n3 = 0; n3 < n5; ++n3) {
            String string6 = stringTokenizer.nextToken();
            vector.add(string6);
            if (NumberStringComparator.stringToNumber(string6) != null) continue;
            bl = false;
        }
        if (bl) {
            this.file.seek(l);
            vector.clear();
            for (n3 = 0; n3 < n5; ++n3) {
                vector.add("data" + (n3 + 1));
            }
        }
        if ((string2 = (String)hashtable.get("name")) == null) {
            string2 = this.fileName;
        }
        this.ourInfo = new DataInfo(string2, ID_MARKER + this.absoluteFileName);
        this.ourInfo.alias = (String)hashtable.get("alias");
        this.ourInfo.comment = (String)hashtable.get("comment");
        this.info = new DataInfo[n5];
        this.min = new Object[n5];
        this.max = new Object[n5];
        for (int i = 0; i < n5; ++i) {
            String string7 = (String)vector.get(i);
            String string8 = (String)hashtable.get(string7 + ".name");
            this.info[i] = new DataInfo(string8 == null ? string7 : string8);
            this.info[i].alias = (String)hashtable.get(string7 + ".alias");
            this.info[i].comment = (String)hashtable.get(string7 + ".comment");
            this.info[i].unit = (String)hashtable.get(string7 + ".unit");
            this.info[i].linkedId = (String)hashtable.get(string7 + ".link");
            this.add(new CollectiveDataSource(this, i));
            this.min[i] = new Double(Double.POSITIVE_INFINITY);
            this.max[i] = new Double(Double.NEGATIVE_INFINITY);
        }
        this.indexOffset = new Vector();
        this.indexOffset.add(new Long(this.file.getFilePointer()));
        this.currentIndex = 0L;
        this.startIndex = 0L;
        this.maxReachedIndex = -1L;
    }

    public DataInfo getInformation(int n) {
        return this.info[n];
    }

    public int getGranularity() {
        return this.granularity;
    }

    public int getSubsampling() {
        return this.subsampling;
    }

    public void setSubsampling(int n) {
        this.subsampling = n;
    }

    public DataInfo getInformation() {
        return this.ourInfo;
    }

    public Object getMin(int n) throws UnsupportedOperation {
        return this.min[n];
    }

    public Object getMax(int n) throws UnsupportedOperation {
        return this.max[n];
    }

    public void setSlice(long l, long l2) {
        super.setSlice(l, l2);
        this.sliceEnd = l2;
    }

    public Object getValue(int n, long l) throws DataException {
        if (this.cachedIndex != l) {
            this.cachedEntry = this.getValueArray(l);
            this.cachedIndex = l;
            if (this.buffers != null) {
                for (int i = 0; i < this.size(); ++i) {
                    if (this.buffers[i] == null) continue;
                    this.buffers[i].setValue(l, this.cachedEntry[i]);
                }
            }
        }
        return this.cachedEntry[n];
    }

    public Object computeMin(int n) throws UnsupportedOperation {
        try {
            long l = 0L;
            while (true) {
                this.getValue(n, l++);
            }
        }
        catch (NoSuchIndex noSuchIndex) {
        }
        catch (DataException dataException) {
            throw new UnsupportedOperation(dataException.toString());
        }
        return this.min[n];
    }

    public Object computeMax(int n) throws UnsupportedOperation {
        try {
            long l = 0L;
            while (true) {
                this.getValue(n, l++);
            }
        }
        catch (NoSuchIndex noSuchIndex) {
        }
        catch (DataException dataException) {
            throw new UnsupportedOperation(dataException.toString());
        }
        return this.max[n];
    }

    public long computeLastIndex() throws UnsupportedOperation {
        try {
            long l = this.maxReachedIndex;
            while (true) {
                this.getValue(0, l++);
            }
        }
        catch (NoSuchIndex noSuchIndex) {
        }
        catch (DataException dataException) {
            dataException.printStackTrace();
            throw new UnsupportedOperation(dataException.toString());
        }
        return this.lastIndex;
    }

    public String readLineIgnoreComment() throws IOException {
        String string;
        do {
            if ((string = this.file.readLine()) != null) continue;
            return null;
        } while ((string = string.trim()) == null || string.equals("") || string.startsWith("#"));
        return this.convertToCharset(string);
    }

    protected String convertToCharset(String string) throws IOException {
        if (this.charsetName == null) {
            return string;
        }
        char[] cArray = string.toCharArray();
        byte[] byArray = new byte[cArray.length];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = (byte)cArray[i];
        }
        return new String(byArray, this.charsetName);
    }

    public Object[] readFile(boolean bl) throws NoSuchIndex, DataException {
        Object[] objectArray = new Object[this.size()];
        long l = -1L;
        try {
            String string;
            l = this.file.getFilePointer();
            try {
                string = this.readLineIgnoreComment();
                for (int i = 0; i < this.subsampling - 1; ++i) {
                    this.readLineIgnoreComment();
                }
            }
            catch (IOException iOException) {
                this.file.close();
                this.file = new RandomAccessFile(this.absoluteFileName, "r");
                this.file.seek(l);
                throw new DataException(iOException.toString());
            }
            if (string == null) {
                this.file.close();
                this.file = new RandomAccessFile(this.absoluteFileName, "r");
                this.file.seek(l);
                this.lastIndex = this.currentIndex - 1L;
                if (this.lastIndex == -1L) {
                    this.startIndex = -1L;
                }
                throw new NoSuchIndex(this.currentIndex);
            }
            if (bl) {
                StringTokenizer stringTokenizer = new StringTokenizer(string);
                for (int i = 0; i < this.size(); ++i) {
                    String string2 = stringTokenizer.nextToken();
                    objectArray[i] = NumberStringComparator.stringToNumber(string2);
                    if (objectArray[i] == null) {
                        objectArray[i] = string2;
                    }
                    try {
                        this.min[i] = this.getMin(this.min[i], objectArray[i]);
                    }
                    catch (ClassCastException classCastException) {
                        // empty catch block
                    }
                    try {
                        this.max[i] = this.getMax(this.max[i], objectArray[i]);
                        continue;
                    }
                    catch (ClassCastException classCastException) {
                        // empty catch block
                    }
                }
            }
            if (this.maxReachedIndex < this.currentIndex) {
                this.maxReachedIndex = this.currentIndex;
            }
            ++this.currentIndex;
            if (this.currentIndex % (long)this.granularity == 0L && this.currentIndex / (long)this.granularity == (long)this.indexOffset.size()) {
                this.indexOffset.add(new Long(this.file.getFilePointer()));
            }
        }
        catch (IOException iOException) {
            throw new DataException(iOException.toString());
        }
        catch (NumberFormatException numberFormatException) {
            if (l != -1L) {
                try {
                    this.file.close();
                    this.file = new RandomAccessFile(this.absoluteFileName, "r");
                    this.file.seek(l);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            throw new InvalidFormatException();
        }
        catch (NoSuchElementException noSuchElementException) {
            if (l != -1L) {
                try {
                    this.file.close();
                    this.file = new RandomAccessFile(this.absoluteFileName, "r");
                    this.file.seek(l);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            throw new InvalidFormatException();
        }
        return objectArray;
    }

    protected Object getMax(Object object, Object object2) throws ClassCastException {
        int n = NumberStringComparator.numStringCompare(object, object2);
        return n < 0 ? object2 : object;
    }

    protected Object getMin(Object object, Object object2) {
        int n = NumberStringComparator.numStringCompare(object, object2);
        return n < 0 ? object : object2;
    }

    public Object[] readFile() throws NoSuchIndex, DataException {
        return this.readFile(true);
    }

    public Object[] getValueArray(long l) throws DataException {
        long l2;
        if (this.currentIndex == l) {
            return this.readFile();
        }
        int n = (int)(l / (long)this.granularity);
        if (n >= this.indexOffset.size()) {
            n = this.indexOffset.size() - 1;
        }
        if ((l2 = (long)(n * this.granularity)) > this.currentIndex || l < this.currentIndex) {
            try {
                this.file.seek((Long)this.indexOffset.get(n));
            }
            catch (IOException iOException) {
                throw new DataException(iOException.toString());
            }
            this.currentIndex = l2;
        }
        while (this.currentIndex != l) {
            Object[] objectArray = this.readFile();
            if (this.buffers == null) continue;
            for (int i = 0; i < this.size(); ++i) {
                if (this.buffers[i] == null) continue;
                this.buffers[i].setValue(this.currentIndex - 1L, objectArray[i]);
            }
        }
        return this.readFile();
    }

    public Class valueClass(int n) {
        return class$java$lang$Number == null ? (class$java$lang$Number = AsciiFileDataSourceCollection.class$("java.lang.Number")) : class$java$lang$Number;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class InvalidFormatException
    extends DataException {
        InvalidFormatException() {
        }
    }
}

