/*
 * Decompiled with CFR 0.152.
 */
package jsynoptic.builtin;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Date;
import java.util.ResourceBundle;
import java.util.Vector;
import jsynoptic.base.DataSourceConsumer;
import jsynoptic.builtin.Abstract2DShape;
import jsynoptic.builtin.ui.TextPropertiesPanel;
import jsynoptic.ui.JSynoptic;
import jsynoptic.ui.JSynopticBatch;
import simtools.data.DataException;
import simtools.data.DataInfo;
import simtools.data.DataSource;
import simtools.data.DataSourcePool;
import simtools.data.EndNotificationListener;
import simtools.data.UnsupportedOperation;
import simtools.shapes.AbstractShape;
import simtools.ui.ColorMapper;
import simtools.ui.CustomizedLocale;
import simtools.ui.GenericMapper;
import simtools.ui.JPropertiesPanel;
import simtools.ui.MapperListener;
import simtools.ui.ResourceFinder;
import simtools.ui.TextMapper;

public class TextShape
extends Abstract2DShape
implements MapperListener,
DataSourceConsumer {
    static final long serialVersionUID = -6782484932282488103L;
    public static ResourceBundle resources = ResourceFinder.get(class$jsynoptic$builtin$TextShape == null ? (class$jsynoptic$builtin$TextShape = TextShape.class$("jsynoptic.builtin.TextShape")) : class$jsynoptic$builtin$TextShape);
    public static final int FORMAT_STRING = 0;
    public static final int FORMAT_DECIMAL = 1;
    public static final int FORMAT_SCIENTIFIC = 2;
    public static final int FORMAT_HEXADECIMAL = 3;
    public static final int FORMAT_OCTAL = 4;
    public static final int FORMAT_BINARY = 5;
    public static final int FORMAT_MAPPER = 6;
    public static final int FORMAT_DATE = 7;
    public static final int FORMAT_TIME = 8;
    public static final int FORMAT_DATE_TIME = 9;
    public static final int MIN_WIDTH = 40;
    public static final int MIN_HEIGHT = 20;
    public static final int MARGIN = 5;
    protected int format;
    protected NumberFormat decimalFormatter;
    protected NumberFormat scientificFormatter;
    protected DateFormat dateFormatter;
    protected DateFormat timeFormatter;
    protected DateFormat dateTimeFormatter;
    protected TextMapper mapper;
    protected String displayPattern = "%v%_%u";
    protected String text;
    protected transient DataSource source;
    protected transient long sourceIndex;
    protected Color textColor = Color.black;
    protected transient Color textDynamicColor = null;
    protected ColorMapper textMapper;
    protected transient DataSource textMapperSource;
    protected transient long textMapperIndex;
    protected static int referenceHeight = -1;
    protected static int referenceWidth = -1;
    protected static int referenceBaseline = -1;
    protected static Font referenceFont = null;
    protected static Object referenceMutex = new Object();
    protected static Graphics referenceGraphics = null;
    protected transient int baseline;
    protected transient Font currentFont;
    protected transient boolean dirtyText = false;
    protected transient boolean dirtyColor = false;
    protected transient EndNotificationListener delegateEndNotificationListener;
    protected transient boolean dirtyState = false;
    protected boolean lockedFont;
    static /* synthetic */ Class class$jsynoptic$builtin$TextShape;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void computeReferences() {
        Object object = referenceMutex;
        synchronized (object) {
            if (referenceFont == null) {
                Graphics graphics;
                Component component = JSynoptic.gui != null ? JSynoptic.gui : (JSynopticBatch.batch != null ? (Component)((Object)JSynopticBatch.batch.getPrintable(0)) : null);
                referenceGraphics = graphics = component != null ? component.createImage(100, 100).getGraphics() : new BufferedImage(100, 100, 1).createGraphics();
                referenceFont = Font.decode("Monospaced");
                referenceFont = referenceFont.deriveFont(100.0f);
                FontMetrics fontMetrics = graphics.getFontMetrics(referenceFont);
                referenceBaseline = fontMetrics.getDescent();
                referenceHeight = fontMetrics.getAscent() + referenceBaseline;
                referenceWidth = fontMetrics.stringWidth("W");
            }
        }
    }

    public void setFormat(int n) {
        this.format = n;
        if (n < 0) {
            n = 0;
        }
        if (n == 6 && this.mapper == null) {
            n = 0;
        }
    }

    public String getText() {
        return this.text;
    }

    public void setText(Object object) {
        if (this.format == 6 && this.mapper != null) {
            this.text = this.mapper.getString(object);
            if (this.text == null || this.text.equals("")) {
                this.text = " ";
            }
            return;
        }
        if (object == null) {
            this.text = " ";
            return;
        }
        if (!(object instanceof Number)) {
            this.text = object.toString();
            return;
        }
        Number number = (Number)object;
        switch (this.format) {
            case 1: {
                this.text = this.decimalFormatter.format(number);
                break;
            }
            case 2: {
                this.text = this.scientificFormatter.format(number);
                break;
            }
            case 3: {
                this.text = "0x" + Long.toHexString(number.longValue()).toUpperCase();
                break;
            }
            case 4: {
                this.text = "0" + Long.toOctalString(number.longValue());
                break;
            }
            case 5: {
                this.text = Long.toBinaryString(number.longValue());
                break;
            }
            case 7: {
                this.text = this.dateFormatter.format(new Date(number.longValue()));
                break;
            }
            case 8: {
                this.text = this.timeFormatter.format(new Date(number.longValue()));
                break;
            }
            case 9: {
                this.text = this.dateTimeFormatter.format(new Date(number.longValue()));
                break;
            }
            default: {
                this.text = number.toString();
            }
        }
    }

    protected Shape getDelegateShape() {
        return new Rectangle(this._ox, this._oy - this._h, this._w, this._h);
    }

    protected void constructor() {
        this.format = 0;
        this.decimalFormatter = NumberFormat.getNumberInstance(CustomizedLocale.get());
        this.scientificFormatter = NumberFormat.getNumberInstance(CustomizedLocale.get());
        if (this.scientificFormatter instanceof DecimalFormat) {
            ((DecimalFormat)this.scientificFormatter).applyPattern("0.000E0");
        }
        this.dateFormatter = DateFormat.getDateInstance(2, CustomizedLocale.get());
        this.timeFormatter = DateFormat.getTimeInstance(2, CustomizedLocale.get());
        this.dateTimeFormatter = DateFormat.getDateTimeInstance(2, 2, CustomizedLocale.get());
        this.lockedFont = false;
    }

    public TextShape(String string, int n, int n2) {
        this(string, n, n2, true);
    }

    public TextShape(String string, int n, int n2, boolean bl) {
        this(string, 0, 0, n, n2, bl);
    }

    public TextShape(String string, int n, int n2, int n3, int n4) {
        this(string, n, n2, n3, n4, true);
    }

    public TextShape(String string, int n, int n2, int n3, int n4, boolean bl) {
        super(n, n2, n3, n4);
        this.drawColor = null;
        this.text = string;
        this.allowResize = bl;
        this.constructor();
        this.fitText();
        this.delegateEndNotificationListener = this;
    }

    public EndNotificationListener getDelegateEndNotificationListener() {
        return this.delegateEndNotificationListener;
    }

    public void setDelegateEndNotificationListener(EndNotificationListener endNotificationListener) {
        if (this.source != null) {
            this.source.removeEndNotificationListener(this.delegateEndNotificationListener);
        }
        if (this.textMapperSource != null) {
            this.textMapperSource.removeEndNotificationListener(this.delegateEndNotificationListener);
        }
        this.delegateEndNotificationListener = endNotificationListener;
        if (this.source != null) {
            this.source.addEndNotificationListener(this.delegateEndNotificationListener);
        }
        if (this.textMapperSource != null) {
            this.textMapperSource.addEndNotificationListener(this.delegateEndNotificationListener);
        }
    }

    protected void drawHook(Graphics2D graphics2D, boolean bl) {
        Color color;
        if (!bl) {
            return;
        }
        Object object = graphics2D.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, AbstractShape.ANTI_ALIASING ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
        Rectangle rectangle = graphics2D.getClipBounds();
        graphics2D.setClip(this._ox, this._oy - this._h, this._w, this._h);
        Color color2 = color = this.textDynamicColor != null ? this.textDynamicColor : this.textColor;
        if (color != null) {
            graphics2D.setColor(color);
        }
        Font font = graphics2D.getFont();
        graphics2D.setFont(this.currentFont);
        graphics2D.drawString(this.text, this._ox + 5, this._oy - this.baseline);
        graphics2D.setFont(font);
        graphics2D.setClip(rectangle);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, object);
    }

    public void setDimensions(int n, int n2) {
        this._w = n;
        this._h = n2;
        if (this._w < MIN_SIZE) {
            this._w = MIN_SIZE;
        }
        if (this._h < MIN_SIZE) {
            this._h = MIN_SIZE;
        }
        this.ratio = (double)this._w / (double)this._h;
        this.fitText();
    }

    public void overrideDimensions(int n, int n2) {
        this._w = n;
        this._h = n2;
    }

    public void resize(int n, int n2) {
        super.resize(n, n2);
        this.fitText();
    }

    public void fitText() {
        if (this.lockedFont && !this.allowResize) {
            return;
        }
        double d = this._w - 10;
        double d2 = this._h - 10;
        if (d <= 0.0 || d2 <= 0.0) {
            return;
        }
        double d3 = d / (double)(this.text.length() * referenceWidth);
        double d4 = d2 / (double)referenceHeight;
        this.currentFont = referenceFont.deriveFont(AffineTransform.getScaleInstance(d3, d4));
        this.baseline = (int)((double)referenceBaseline * d4);
    }

    public static Font getFontToFitText(String string, int n, int n2) {
        double d = n - 10;
        double d2 = n2 - 10;
        if (d <= 0.0 || d2 <= 0.0) {
            return null;
        }
        double d3 = d / (double)(string.length() * referenceWidth);
        double d4 = d2 / (double)referenceHeight;
        return referenceFont.deriveFont(AffineTransform.getScaleInstance(d3, d4));
    }

    public boolean updateText() {
        Object object;
        String string;
        block26: {
            if (this.source == null) {
                return false;
            }
            string = this.text;
            try {
                String string2;
                String string3;
                this.setText(this.source.getValue(this.sourceIndex));
                if (this.displayPattern.trim().equals("")) break block26;
                object = DataInfo.getUnit(this.source);
                if (object == null) {
                    object = "";
                }
                if ((string3 = DataInfo.getLabel(this.source)) == null) {
                    string3 = "";
                }
                if ((string2 = DataInfo.getComment(this.source)) == null) {
                    string2 = "";
                }
                if (this.text == null || this.text.equals(" ")) {
                    this.text = "";
                }
                StringBuffer stringBuffer = new StringBuffer(this.displayPattern);
                boolean bl = false;
                int n = stringBuffer.indexOf("%");
                while (n != -1 && n < stringBuffer.length() - 1) {
                    block27: {
                        switch (stringBuffer.charAt(n + 1)) {
                            case 'v': {
                                stringBuffer.replace(n, n + 2, this.text);
                                if (bl && !this.text.equals("")) {
                                    stringBuffer.insert(n++, " ");
                                }
                                n += this.text.length();
                                break;
                            }
                            case 'u': {
                                stringBuffer.replace(n, n + 2, (String)object);
                                if (bl && !((String)object).equals("")) {
                                    stringBuffer.insert(n++, " ");
                                }
                                n += ((String)object).length();
                                break;
                            }
                            case 'n': {
                                stringBuffer.replace(n, n + 2, string3);
                                if (bl && !string3.equals("")) {
                                    stringBuffer.insert(n++, " ");
                                }
                                n += string3.length();
                                break;
                            }
                            case 'c': {
                                stringBuffer.replace(n, n + 2, string2);
                                if (bl && !string2.equals("")) {
                                    stringBuffer.insert(n++, " ");
                                }
                                n += string2.length();
                                break;
                            }
                            case '%': {
                                stringBuffer.replace(n, n + 2, "%");
                                if (bl) {
                                    stringBuffer.insert(n++, " ");
                                }
                                ++n;
                                break;
                            }
                            case '_': {
                                bl = true;
                                stringBuffer.delete(n, n + 2);
                                break block27;
                            }
                            default: {
                                ++n;
                            }
                        }
                        bl = false;
                    }
                    n = stringBuffer.indexOf("%", n);
                }
                this.text = stringBuffer.toString();
                if (this.text == null || this.text.equals("")) {
                    this.text = " ";
                }
            }
            catch (DataException dataException) {
                return false;
            }
        }
        if (this.text.equals(string)) {
            return false;
        }
        if (this.allowResize) {
            object = this.getBounds();
            this._w = (this._w - 10) * this.text.length() / string.length() + 10;
            if (this._w < MIN_SIZE) {
                this._w = MIN_SIZE;
            }
            this.fitText();
            ((Rectangle2D)object).add(this.getBounds());
            this.dirtyRectangle = ((RectangularShape)object).getBounds();
        } else {
            this.fitText();
        }
        return true;
    }

    public void DataSourceValueChanged(DataSource dataSource, long l, long l2) {
        if (dataSource.equals(this.source) && this.sourceIndex >= l && this.sourceIndex <= l2) {
            this.dirtyText = true;
        }
        if (dataSource.equals(this.textMapperSource) && this.textMapperIndex >= l && this.textMapperIndex <= l2) {
            this.dirtyColor = true;
        }
        super.DataSourceValueChanged(dataSource, l, l2);
    }

    public void DataSourceIndexRangeChanged(DataSource dataSource, long l, long l2) {
        if (dataSource.equals(this.source)) {
            this.sourceIndex = l2;
            this.dirtyText = true;
        }
        if (dataSource.equals(this.textMapperSource)) {
            this.textMapperIndex = l2;
            this.dirtyColor = true;
        }
        super.DataSourceIndexRangeChanged(dataSource, l, l2);
    }

    public void notificationEnd(Object object) {
        if (this.dirtyText) {
            this.dirty |= this.updateText();
            this.dirtyText = false;
        }
        if (this.dirtyColor) {
            Color color = null;
            if (this.textMapper != null) {
                color = (Color)this.textMapper.getPaint(this.textMapperSource, this.textMapperIndex);
            }
            this.dirty = color == null ? (this.dirty |= this.textDynamicColor != null) : (this.dirty |= !color.equals(this.textDynamicColor));
            this.textDynamicColor = color;
            this.dirtyColor = false;
        }
        super.notificationEnd(object);
    }

    public String[] getActions(double d, double d2, Object object, int n) {
        if (n == 3) {
            return null;
        }
        if (n == 4) {
            return null;
        }
        if (n == 5) {
            return null;
        }
        Vector<String> vector = new Vector<String>();
        String[] stringArray = super.getActions(d, d2, object, n);
        for (int i = 0; i < stringArray.length; ++i) {
            vector.add(stringArray[i]);
        }
        if (n == 1 && object instanceof DataSource) {
            vector.add(resources.getString("SetSource"));
        }
        return vector.toArray(new String[vector.size()]);
    }

    public void setSource(DataSource dataSource) {
        if (this.source != null) {
            this.source.removeListener(this);
            this.source.removeEndNotificationListener(this.delegateEndNotificationListener);
        }
        this.source = dataSource;
        if (this.source == null) {
            return;
        }
        this.source.addListener(this);
        this.source.addEndNotificationListener(this.delegateEndNotificationListener);
        try {
            this.sourceIndex = this.source.computeLastIndex();
        }
        catch (UnsupportedOperation unsupportedOperation) {
            try {
                this.sourceIndex = this.source.getLastIndex();
            }
            catch (UnsupportedOperation unsupportedOperation2) {
                try {
                    this.sourceIndex = this.source.getStartIndex();
                }
                catch (UnsupportedOperation unsupportedOperation3) {
                    this.sourceIndex = 0L;
                }
            }
        }
        this.updateText();
    }

    public boolean doAction(double d, double d2, Object object, String string) {
        if (string.equals(resources.getString("SetSource"))) {
            this.setSource((DataSource)object);
            return true;
        }
        return super.doAction(d, d2, object, string);
    }

    public JPropertiesPanel createPanel(boolean bl) {
        return new TextPropertiesPanel(bl);
    }

    public JPropertiesPanel createPanel() {
        return this.createPanel(true);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        DataSourcePool.global.writeDataSource(objectOutputStream, this.textMapperSource);
        DataSourcePool.global.writeDataSource(objectOutputStream, this.source);
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        if (this.mapper != null) {
            this.mapper.addListener(this);
        }
        this.delegateEndNotificationListener = this;
        this.textMapperSource = DataSourcePool.global.readDataSource(objectInputStream);
        if (this.textMapperSource != null) {
            try {
                this.textMapperIndex = this.textMapperSource.getLastIndex();
                this.textMapperSource.addListener(this);
                this.textMapperSource.addEndNotificationListener(this.delegateEndNotificationListener);
            }
            catch (UnsupportedOperation unsupportedOperation) {
                this.textMapperIndex = 0L;
            }
        }
        this.textDynamicColor = this.textMapper != null ? (Color)this.textMapper.getPaint(this.textMapperSource, this.textMapperIndex) : null;
        this.source = DataSourcePool.global.readDataSource(objectInputStream);
        if (this.source != null) {
            try {
                this.sourceIndex = this.source.getLastIndex();
                this.source.addListener(this);
                this.source.addEndNotificationListener(this.delegateEndNotificationListener);
            }
            catch (UnsupportedOperation unsupportedOperation) {
                this.sourceIndex = 0L;
            }
        }
        this.fitText();
    }

    protected AbstractShape cloneShape() {
        TextShape textShape = (TextShape)super.cloneShape();
        textShape.delegateEndNotificationListener = textShape;
        if (textShape.source != null) {
            textShape.source.addEndNotificationListener(textShape.delegateEndNotificationListener);
            textShape.source.addListener(textShape);
        }
        if (textShape.textMapperSource != null) {
            textShape.textMapperSource.addEndNotificationListener(textShape.delegateEndNotificationListener);
            textShape.textMapperSource.addListener(textShape);
        }
        textShape.decimalFormatter = (NumberFormat)this.decimalFormatter.clone();
        textShape.scientificFormatter = (NumberFormat)this.scientificFormatter.clone();
        textShape.dateFormatter = (DateFormat)this.dateFormatter.clone();
        textShape.timeFormatter = (DateFormat)this.timeFormatter.clone();
        textShape.dateTimeFormatter = (DateFormat)this.dateTimeFormatter.clone();
        return textShape;
    }

    public void mappingChanged(GenericMapper genericMapper) {
        if (genericMapper.equals(this.mapper)) {
            this.updateText();
        }
        this.notifyChange();
    }

    protected synchronized void notifyChange(Rectangle rectangle) {
        this.dirtyState = true;
        super.notifyChange(rectangle);
    }

    public boolean isDirtyState() {
        return this.dirtyState;
    }

    public void setDirtyState(boolean bl) {
        this.dirtyState = bl;
    }

    public boolean addDataSource(DataSource dataSource) {
        this.setSource(dataSource);
        this.notifyChange();
        return true;
    }

    public boolean canAddDataSource(DataSource dataSource) {
        return true;
    }

    public Object getPropertyValue(String string) {
        Object object = super.getPropertyValue(string);
        if (string.equalsIgnoreCase("TEXT")) {
            object = this.getText();
        } else if (string.equalsIgnoreCase("TEXT_COLOR")) {
            object = this.textColor;
        } else if (string.equalsIgnoreCase("TEXT_SOURCE")) {
            object = this.source;
        } else if (string.equalsIgnoreCase("VALUE_FORMAT")) {
            object = new Integer(this.format);
        } else if (string.equalsIgnoreCase("FORMAT_MAPPER")) {
            object = this.mapper;
        } else if (string.equalsIgnoreCase("DECIMAL_DIGITS")) {
            long l = 0L;
            if (this.format == 1) {
                l = this.decimalFormatter.getMaximumFractionDigits();
            } else if (this.format == 2 && this.scientificFormatter instanceof DecimalFormat) {
                String string2 = ((DecimalFormat)this.scientificFormatter).toPattern();
                l = 0L;
                l = string2.indexOf(69) - string2.indexOf(46);
                if (l > 0L) {
                    --l;
                }
            }
            object = new Integer((int)l);
        } else if (string.equalsIgnoreCase("TEXT_MAPPER")) {
            object = this.textMapper;
        } else if (string.equalsIgnoreCase("TEXT_MAPPER_SOURCE")) {
            object = this.textMapperSource;
        } else if (string.equalsIgnoreCase("DISPLAY_PATTERN")) {
            object = this.displayPattern;
        }
        return object;
    }

    public void setPropertyValue(String string, Object object) {
        super.setPropertyValue(string, object);
        if (string.equalsIgnoreCase("TEXT")) {
            if (object instanceof String && object != null) {
                this.setText((String)object);
            }
        } else if (string.equalsIgnoreCase("TEXT_COLOR")) {
            this.textColor = object instanceof Color ? (Color)object : null;
        } else if (string.equalsIgnoreCase("VALUE_FORMAT")) {
            if (object instanceof Integer) {
                this.setFormat((Integer)object);
            }
        } else if (string.equalsIgnoreCase("FORMAT_MAPPER")) {
            if (this.mapper != null) {
                this.mapper.removeListener(this);
            }
            if (object instanceof TextMapper) {
                this.mapper = (TextMapper)object;
                this.mapper.addListener(this);
            } else {
                this.mapper = null;
            }
        } else if (string.equalsIgnoreCase("TEXT_SOURCE")) {
            this.setSource((DataSource)object);
        } else if (string.equalsIgnoreCase("DECIMAL_DIGITS")) {
            if (object instanceof Integer) {
                int n = (Integer)object;
                if (this.format == 1) {
                    this.decimalFormatter.setMaximumFractionDigits(n);
                } else if (this.format == 2 && this.scientificFormatter instanceof DecimalFormat) {
                    String string2 = "0.";
                    for (int i = 0; i < n; ++i) {
                        string2 = string2 + "0";
                    }
                    string2 = string2 + "E0";
                    ((DecimalFormat)this.scientificFormatter).applyPattern(string2);
                }
            }
        } else if (string.equalsIgnoreCase("TEXT_MAPPER")) {
            this.textMapper = object instanceof ColorMapper ? (ColorMapper)object : null;
        } else if (string.equalsIgnoreCase("TEXT_MAPPER_SOURCE")) {
            if (this.textMapperSource != null) {
                this.textMapperSource.removeListener(this);
                this.textMapperSource.removeEndNotificationListener(this.delegateEndNotificationListener);
            }
            if (object instanceof DataSource) {
                this.textMapperSource = (DataSource)object;
                try {
                    this.textMapperIndex = this.textMapperSource.getLastIndex();
                    this.textMapperIndex = this.textMapperSource.getLastIndex();
                }
                catch (UnsupportedOperation unsupportedOperation) {
                    this.textMapperIndex = 0L;
                }
                this.textMapperSource.addListener(this);
                this.textMapperSource.addEndNotificationListener(this.delegateEndNotificationListener);
            } else {
                this.textMapperSource = null;
            }
        } else if (string.equalsIgnoreCase("DISPLAY_PATTERN") && object instanceof String) {
            this.displayPattern = (String)object;
        }
        this.fitText();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        TextShape.computeReferences();
    }
}

