/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.compiler;

import com.izforge.izpack.CustomData;
import com.izforge.izpack.GUIPrefs;
import com.izforge.izpack.Info;
import com.izforge.izpack.Pack;
import com.izforge.izpack.PackFile;
import com.izforge.izpack.Panel;
import com.izforge.izpack.compiler.ByteCountingOutputStream;
import com.izforge.izpack.compiler.Compiler;
import com.izforge.izpack.compiler.PackInfo;
import com.izforge.izpack.compiler.PackagerListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class Packager {
    public static final String SKELETON_SUBPATH = "lib/installer.jar";
    private File baseFile = null;
    private JarOutputStream primaryJarStream;
    private Info info = null;
    private GUIPrefs guiPrefs = null;
    private Properties variables = new Properties();
    private List panelList = new ArrayList();
    private List packsList = new ArrayList();
    private List langpackNameList = new ArrayList();
    private List customDataList = new ArrayList();
    private Map installerResourceURLMap = new HashMap();
    private Set includedJarURLs = new HashSet();
    private boolean packJarsSeparate = false;
    private PackagerListener listener;

    public void createInstaller(File primaryFile) throws IOException {
        String baseName = primaryFile.getName();
        if (baseName.endsWith(".jar")) {
            baseName = baseName.substring(0, baseName.length() - 4);
            this.baseFile = new File(primaryFile.getParentFile(), baseName);
        } else {
            this.baseFile = primaryFile;
        }
        this.info.setInstallerBase(this.baseFile.getName());
        this.packJarsSeparate = this.info.getWebDirURL() != null;
        this.primaryJarStream = this.getJarOutputStream(this.baseFile.getName() + ".jar");
        this.sendStart();
        this.writeSkeletonInstaller();
        this.writeInstallerObject("info", this.info);
        this.writeInstallerObject("vars", this.variables);
        this.writeInstallerObject("GUIPrefs", this.guiPrefs);
        this.writeInstallerObject("panelsOrder", this.panelList);
        this.writeInstallerObject("customData", this.customDataList);
        this.writeInstallerObject("langpacks.info", this.langpackNameList);
        this.writeInstallerResources();
        this.writeIncludedJars();
        this.writePacks();
        this.primaryJarStream.close();
        this.sendStop();
    }

    public void setPackagerListener(PackagerListener listener) {
        this.listener = listener;
    }

    private void sendMsg(String job) {
        if (this.listener != null) {
            this.listener.packagerMsg(job);
        }
    }

    private void sendStart() {
        if (this.listener != null) {
            this.listener.packagerStart();
        }
    }

    private void sendStop() {
        if (this.listener != null) {
            this.listener.packagerStop();
        }
    }

    public void setInfo(Info info) throws Exception {
        this.sendMsg("Setting the installer informations ...");
        this.info = info;
    }

    public void setGUIPrefs(GUIPrefs prefs) {
        this.sendMsg("Setting the GUI preferences ...");
        this.guiPrefs = prefs;
    }

    public Properties getVariables() {
        return this.variables;
    }

    public void addPanelJar(Panel panel, URL jarURL) {
        this.panelList.add(panel);
        this.addJarContent(jarURL);
    }

    public void addCustomJar(CustomData ca, URL url) {
        this.customDataList.add(ca);
        this.addJarContent(url);
    }

    public void addPack(PackInfo pack) {
        this.packsList.add(pack);
    }

    public List getPacksList() {
        return this.packsList;
    }

    public void addLangPack(String iso3, URL xmlURL, URL flagURL) {
        this.sendMsg("Adding langpack : " + iso3 + " ...");
        this.langpackNameList.add(iso3);
        this.addResource("flag." + iso3, flagURL);
        this.installerResourceURLMap.put("langpacks/" + iso3 + ".xml", xmlURL);
    }

    public void addResource(String resId, URL url) {
        this.sendMsg("Adding resource : " + resId + " ...");
        this.installerResourceURLMap.put("res/" + resId, url);
    }

    public void addNativeLibrary(String name, URL url) throws Exception {
        this.sendMsg("Adding native library : " + name + " ...");
        this.installerResourceURLMap.put("native/" + name, url);
    }

    public void addJarContent(URL jarURL) {
        this.sendMsg("Adding content of jar : " + jarURL.getFile() + " ...");
        this.includedJarURLs.add(jarURL);
    }

    public void addNativeUninstallerLibrary(CustomData data) {
        this.customDataList.add(data);
    }

    private void writeSkeletonInstaller() throws IOException {
        this.sendMsg("Copying the skeleton installer ...");
        InputStream is = Packager.class.getResourceAsStream("/lib/installer.jar");
        if (is == null) {
            File skeleton = new File(Compiler.IZPACK_HOME, SKELETON_SUBPATH);
            is = new FileInputStream(skeleton);
        }
        ZipInputStream inJarStream = new ZipInputStream(is);
        this.copyZip(inJarStream, this.primaryJarStream);
    }

    private void writeInstallerObject(String entryName, Object object) throws IOException {
        this.primaryJarStream.putNextEntry(new ZipEntry(entryName));
        ObjectOutputStream out = new ObjectOutputStream(this.primaryJarStream);
        out.writeObject(object);
        out.flush();
        this.primaryJarStream.closeEntry();
    }

    private void writeInstallerResources() throws IOException {
        this.sendMsg("Copying " + this.installerResourceURLMap.size() + " files into installer ...");
        Iterator i = this.installerResourceURLMap.keySet().iterator();
        while (i.hasNext()) {
            String name = (String)i.next();
            InputStream in = ((URL)this.installerResourceURLMap.get(name)).openStream();
            this.primaryJarStream.putNextEntry(new ZipEntry(name));
            this.copyStream(in, this.primaryJarStream);
            this.primaryJarStream.closeEntry();
            in.close();
        }
    }

    private void writeIncludedJars() throws IOException {
        this.sendMsg("Copying contents of " + this.includedJarURLs.size() + " jars into installer ...");
        Iterator i = this.includedJarURLs.iterator();
        while (i.hasNext()) {
            InputStream is = ((URL)i.next()).openStream();
            ZipInputStream inJarStream = new ZipInputStream(is);
            this.copyZip(inJarStream, this.primaryJarStream);
        }
    }

    private void writePacks() throws IOException {
        this.sendMsg("Writing Packs ...");
        HashMap<File, long[]> storedFiles = new HashMap<File, long[]>();
        int packNumber = 0;
        Iterator packIter = this.packsList.iterator();
        while (packIter.hasNext()) {
            PackInfo packInfo = (PackInfo)packIter.next();
            Pack pack = packInfo.getPack();
            pack.nbytes = 0L;
            JarOutputStream packStream = this.primaryJarStream;
            if (this.packJarsSeparate) {
                String name = this.baseFile.getName() + ".pack" + packNumber + ".jar";
                packStream = this.getJarOutputStream(name);
            }
            this.sendMsg("Writing Pack #" + packNumber + " : " + pack.name);
            ZipEntry entry = new ZipEntry("packs/pack" + packNumber);
            packStream.putNextEntry(entry);
            packStream.flush();
            ByteCountingOutputStream dos = new ByteCountingOutputStream(packStream);
            ObjectOutputStream objOut = new ObjectOutputStream(dos);
            long packageBytes = 0L;
            objOut.writeInt(packInfo.getPackFiles().size());
            Iterator iter = packInfo.getPackFiles().iterator();
            while (iter.hasNext()) {
                boolean addFile = !pack.loose;
                PackFile pf = (PackFile)iter.next();
                File file = packInfo.getFile(pf);
                long[] info = (long[])storedFiles.get(file);
                if (info != null && !this.packJarsSeparate) {
                    pf.setPreviousPackFileRef((int)info[0], info[1]);
                    addFile = false;
                }
                objOut.writeObject(pf);
                objOut.flush();
                if (addFile && !pf.isDirectory()) {
                    long pos = dos.getByteCount();
                    FileInputStream inStream = new FileInputStream(file);
                    long bytesWritten = this.copyStream(inStream, objOut);
                    if (bytesWritten != pf.length()) {
                        throw new IOException("File size mismatch when reading " + file);
                    }
                    inStream.close();
                    storedFiles.put(file, new long[]{packNumber, pos});
                }
                pack.nbytes += pf.length();
            }
            objOut.writeInt(packInfo.getParsables().size());
            iter = packInfo.getParsables().iterator();
            while (iter.hasNext()) {
                objOut.writeObject(iter.next());
            }
            objOut.writeInt(packInfo.getExecutables().size());
            iter = packInfo.getExecutables().iterator();
            while (iter.hasNext()) {
                objOut.writeObject(iter.next());
            }
            objOut.writeInt(packInfo.getUpdateChecks().size());
            iter = packInfo.getUpdateChecks().iterator();
            while (iter.hasNext()) {
                objOut.writeObject(iter.next());
            }
            objOut.flush();
            packStream.closeEntry();
            if (this.packJarsSeparate) {
                packStream.close();
            }
            ++packNumber;
        }
        this.primaryJarStream.putNextEntry(new ZipEntry("packs.info"));
        ObjectOutputStream out = new ObjectOutputStream(this.primaryJarStream);
        out.writeInt(this.packsList.size());
        Iterator i = this.packsList.iterator();
        while (i.hasNext()) {
            PackInfo pack = (PackInfo)i.next();
            out.writeObject(pack.getPack());
        }
        out.flush();
        this.primaryJarStream.closeEntry();
    }

    private JarOutputStream getJarOutputStream(String name) throws IOException {
        File file = new File(this.baseFile.getParentFile(), name);
        this.sendMsg("Building installer jar: " + file.getAbsolutePath());
        JarOutputStream jar = new JarOutputStream(new FileOutputStream(file));
        jar.setLevel(9);
        return jar;
    }

    private void copyZip(ZipInputStream zin, ZipOutputStream out) throws IOException {
        ZipEntry zentry;
        while ((zentry = zin.getNextEntry()) != null) {
            try {
                out.putNextEntry(new ZipEntry(zentry.getName()));
                this.copyStream(zin, out);
                out.closeEntry();
                zin.closeEntry();
            }
            catch (ZipException x) {}
        }
    }

    private long copyStream(InputStream in, OutputStream out) throws IOException {
        int bytesInBuffer;
        byte[] buffer = new byte[5120];
        long bytesCopied = 0L;
        while ((bytesInBuffer = in.read(buffer)) != -1) {
            out.write(buffer, 0, bytesInBuffer);
            bytesCopied += (long)bytesInBuffer;
        }
        return bytesCopied;
    }
}

