/*
 * Decompiled with CFR 0.152.
 */
package jsynoptic.plugins.jfreechart;

import java.util.Iterator;
import java.util.Vector;
import org.jfree.data.AbstractDataset;
import org.jfree.data.IntervalXYDataset;
import simtools.data.DataException;
import simtools.data.DataInfo;
import simtools.data.DataSource;
import simtools.data.DataSourceListener;
import simtools.data.EndNotificationListener;
import simtools.data.UnsupportedOperation;

public class SourceIntervalXYDataSet
extends AbstractDataset
implements IntervalXYDataset,
DataSourceListener,
EndNotificationListener {
    Vector series = new Vector();

    public static Number getNumberFromSource(DataSource dataSource, long l) {
        Object object = null;
        try {
            object = dataSource.getValue(l);
        }
        catch (DataException dataException) {
            return null;
        }
        if (object == null) {
            return null;
        }
        if (object instanceof Double) {
            double d = ((Number)object).doubleValue();
            if (Double.isNaN(d)) {
                return null;
            }
            if (Double.isInfinite(d)) {
                return null;
            }
            return (Double)object;
        }
        if (object instanceof Float) {
            float f = ((Number)object).floatValue();
            if (Float.isNaN(f)) {
                return null;
            }
            if (Float.isInfinite(f)) {
                return null;
            }
            return (Float)object;
        }
        if (object instanceof Number) {
            return (Number)object;
        }
        return null;
    }

    public Number getStartXValue(int n, int n2) {
        SourceIntervalMaker sourceIntervalMaker = (SourceIntervalMaker)this.series.get(n);
        if (sourceIntervalMaker.intervals == null) {
            return null;
        }
        return ((Interval)sourceIntervalMaker.intervals.get((int)n2)).low;
    }

    public Number getEndXValue(int n, int n2) {
        SourceIntervalMaker sourceIntervalMaker = (SourceIntervalMaker)this.series.get(n);
        if (sourceIntervalMaker.intervals == null) {
            return null;
        }
        return ((Interval)sourceIntervalMaker.intervals.get((int)n2)).high;
    }

    public Number getStartYValue(int n, int n2) {
        return this.getYValue(n, n2);
    }

    public Number getEndYValue(int n, int n2) {
        return this.getYValue(n, n2);
    }

    public int getItemCount(int n) {
        SourceIntervalMaker sourceIntervalMaker = (SourceIntervalMaker)this.series.get(n);
        return sourceIntervalMaker.intervals == null ? 0 : sourceIntervalMaker.intervals.size();
    }

    public Number getXValue(int n, int n2) {
        SourceIntervalMaker sourceIntervalMaker = (SourceIntervalMaker)this.series.get(n);
        if (sourceIntervalMaker.intervals == null) {
            return null;
        }
        Interval interval = (Interval)sourceIntervalMaker.intervals.get(n2);
        if (interval.uselong) {
            return new Long(interval.llow + (interval.lhigh - interval.llow) / 2L);
        }
        return new Double(interval.dlow + (interval.dhigh - interval.dlow) / 2.0);
    }

    public Number getYValue(int n, int n2) {
        SourceIntervalMaker sourceIntervalMaker = (SourceIntervalMaker)this.series.get(n);
        if (sourceIntervalMaker.intervals == null) {
            return null;
        }
        return new Long(((Interval)sourceIntervalMaker.intervals.get((int)n2)).count);
    }

    public int getSeriesCount() {
        return this.series.size();
    }

    public String getSeriesName(int n) {
        SourceIntervalMaker sourceIntervalMaker = (SourceIntervalMaker)this.series.get(n);
        return sourceIntervalMaker.getName();
    }

    public void DataSourceValueChanged(DataSource dataSource, long l, long l2) {
    }

    public void DataSourceIndexRangeChanged(DataSource dataSource, long l, long l2) {
    }

    public void DataSourceInfoChanged(DataSource dataSource, DataInfo dataInfo) {
    }

    public void DataSourceValueRangeChanged(DataSource dataSource) {
    }

    public void DataSourceOrderChanged(DataSource dataSource, int n) {
    }

    public void notificationEnd(Object object) {
    }

    public static class SourceIntervalMaker {
        public DataSource x;
        public DataSource y;
        Vector intervals;
        public String name;

        public SourceIntervalMaker(DataSource dataSource, DataSource dataSource2) {
            this(dataSource, dataSource2, null);
        }

        public SourceIntervalMaker(DataSource dataSource, DataSource dataSource2, String string) {
            this.x = dataSource;
            this.y = dataSource2;
            this.name = string;
            this.intervals = null;
            if (dataSource2 == null) {
                return;
            }
            this.computeValues();
        }

        public String getName() {
            if (this.name == null) {
                this.name = DataInfo.getLabel((Object)this.y);
            }
            return this.name;
        }

        protected void computeValues() {
            long l;
            long l2;
            this.intervals = null;
            if (this.x == null) {
                return;
            }
            try {
                l2 = this.x.getStartIndex();
            }
            catch (UnsupportedOperation unsupportedOperation) {
                try {
                    l2 = this.x.computeStartIndex();
                }
                catch (UnsupportedOperation unsupportedOperation2) {
                    return;
                }
            }
            try {
                l = this.x.getStartIndex();
            }
            catch (UnsupportedOperation unsupportedOperation) {
                try {
                    l = this.x.computeStartIndex();
                }
                catch (UnsupportedOperation unsupportedOperation3) {
                    return;
                }
            }
            if (l2 >= l) {
                return;
            }
            this.intervals = new Vector();
            Number number = null;
            Number number2 = null;
            for (long i = l2 + 1L; i <= l; ++i) {
                number = number2 != null ? (Number)number2 : (Number)SourceIntervalXYDataSet.getNumberFromSource(this.x, i - 1L);
                number2 = SourceIntervalXYDataSet.getNumberFromSource(this.x, i);
                if (number == null || number2 == null) continue;
                this.intervals.add(new Interval(number, number2));
            }
            if (this.intervals.size() == 0) {
                this.intervals = null;
                return;
            }
            try {
                l2 = this.y.getStartIndex();
            }
            catch (UnsupportedOperation unsupportedOperation) {
                try {
                    l2 = this.y.computeStartIndex();
                }
                catch (UnsupportedOperation unsupportedOperation4) {
                    return;
                }
            }
            try {
                l = this.y.getStartIndex();
            }
            catch (UnsupportedOperation unsupportedOperation) {
                try {
                    l = this.y.computeStartIndex();
                }
                catch (UnsupportedOperation unsupportedOperation5) {
                    return;
                }
            }
            if (l2 > l) {
                return;
            }
            for (long i = l2; i <= l; ++i) {
                Number number3 = SourceIntervalXYDataSet.getNumberFromSource(this.y, i);
                Iterator iterator = this.intervals.iterator();
                while (iterator.hasNext()) {
                    Interval interval = (Interval)iterator.next();
                    if (!interval.contains(number3)) continue;
                    ++interval.count;
                }
            }
        }
    }

    public static class Interval {
        public Number low;
        public Number high;
        public long count;
        public boolean uselong;
        public double dlow;
        public double dhigh;
        public long llow;
        public long lhigh;

        public Interval(Number number, Number number2) {
            this.low = number;
            this.high = number2;
            this.count = 0L;
            this.uselong = true;
            if (number instanceof Byte) {
                number = new Long(number.longValue());
            } else if (number instanceof Short) {
                number = new Long(number.longValue());
            } else if (number instanceof Integer) {
                number = new Long(number.longValue());
            }
            this.uselong &= number instanceof Long;
            if (number2 instanceof Byte) {
                number2 = new Long(number2.longValue());
            } else if (number2 instanceof Short) {
                number2 = new Long(number2.longValue());
            } else if (number2 instanceof Integer) {
                number2 = new Long(number2.longValue());
            }
            this.uselong &= number2 instanceof Long;
            this.dlow = number.doubleValue();
            this.dhigh = number2.doubleValue();
            if (this.uselong) {
                this.llow = number.longValue();
                this.lhigh = number2.longValue();
                if (this.llow >= this.lhigh) {
                    long l = this.llow;
                    this.llow = this.lhigh;
                    this.lhigh = l;
                    double d = this.dlow;
                    this.dlow = this.dhigh;
                    this.dhigh = d;
                    Number number3 = number;
                    number = number2;
                    number2 = number3;
                }
            } else if (this.dlow >= this.dhigh) {
                double d = this.dlow;
                this.dlow = this.dhigh;
                this.dhigh = d;
                Number number4 = number;
                number = number2;
                number2 = number4;
            }
        }

        public boolean contains(Number number) {
            if (number == null) {
                return false;
            }
            if (number instanceof Long && this.uselong) {
                long l = number.longValue();
                return l >= this.llow && l <= this.lhigh;
            }
            double d = number.doubleValue();
            return d >= this.dlow && d <= this.dhigh;
        }
    }
}

