/*
 * Decompiled with CFR 0.152.
 */
package org.doxygen.tools;

import java.io.File;
import java.util.Map;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.doxygen.tools.DoxygenConfig;
import org.doxygen.tools.DoxygenProcess;

public class DoxygenTask
extends Task {
    public static final String CONFIG_FILE = System.getProperty("user.home") + File.separator + ".doxytmp";
    private DoxygenConfig conf;
    private DoxygenProcess proc = new DoxygenProcess();
    private boolean verbose = false;
    private String versionCompatible = null;
    private String configFilename = null;

    public DoxygenTask() {
        this.conf = new DoxygenConfig();
    }

    public final void execute() throws BuildException {
        this.proc.checkVersion(this.versionCompatible);
        System.out.println("Version check complete");
        if (this.configFilename == null) {
            this.configFilename = CONFIG_FILE;
            this.proc.createConfig(this.configFilename);
        }
        this.conf.writeDoxygenConfig(this.configFilename);
        System.out.println("Created Config file");
        this.proc.executeDoxygenConfig(this.configFilename);
    }

    public final void setVersionCompatible(String string) {
        this.versionCompatible = string;
    }

    public final String getVersionCompatible() {
        return this.versionCompatible;
    }

    public final void setVerbose(boolean bl) {
        this.verbose = bl;
    }

    public final void setConfigFilename(String string) {
        this.configFilename = string;
    }

    public final void setDoxygenPath(String string) {
        this.proc.setDoxygenPath(string);
    }

    public final Property createProperty() {
        Property property = new Property();
        this.conf.addNestedAttribute(property);
        return property;
    }

    public final void setConfig(String string, String string2) {
        Property property = new Property();
        property.setName(string);
        property.setValue(string2);
        this.conf.addNestedAttribute(property);
    }

    public Map getTaskAttributes() {
        return this.conf.getTaskAttributes();
    }

    public final void activityLog(boolean bl, String string) {
        if (string != null && (bl || this.verbose)) {
            System.out.println(string);
        }
    }

    public static class Property {
        private String key;
        private String val;

        public final String getName() {
            return this.key;
        }

        public final String getValue() {
            return this.val;
        }

        public final void setName(String string) {
            this.key = string;
        }

        public final void setValue(String string) {
            this.val = string.toLowerCase().equals("true") ? "YES" : (string.toLowerCase().equals("false") ? "NO" : string);
        }

        public final String toString() {
            return "Property=[key={" + this.key + "}," + "value={" + this.val + "}," + "]";
        }
    }
}

