/*!  \file 

$Header: /cvsroot/tsp/tsp/src/providers/bb_provider/bb_tsp_provider.h,v 1.6 2004/10/26 23:46:54 erk Exp $

-----------------------------------------------------------------------

TSP Library - core components for a generic Transport Sampling Protocol.

Copyright (c) 2002 Yves DUFRENNE, Stephane GALLES, Eric NOULARD and Robert PAGNOT 

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

-----------------------------------------------------------------------

Project   : TSP
Maintainer : tsp@astrium-space.com
Component : Consumer

-----------------------------------------------------------------------

Purpose   : Blackboard TSP Provider

-----------------------------------------------------------------------
 */
#ifndef _BB_TSP_PROVIDER_H_
#define _BB_TSP_PROVIDER_H_

#include "tsp_abs_types.h"

#include <pthread.h>

#ifdef BB_TSP_PROVIDER_C
pthread_t glu_thread_id=0;
#else
extern pthread_t glu_thread_id;
#endif

/**
 * Indique la frequence de base du provider TSP
 * @param d_frequence_provider la frequence de base en Hz
 * @return toujours 0, cette fonction n'choue jamais.
 * @ingroup BlackBoard
 */
int 
GLU_set_base_frequency(double d_frequence_provider);

/**
 * Initialisation du fournisseur de donne TSP pour un BlackBoard TSP.
 * On doit passer  cette fonction d'initialisation les 
 * argument en provenance d'un main car la lib TSP peut
 * de cette manire grer des paramtres spcifiques  TSP.
 * Les paramtres qui ne concernent pas TSP seront inchangs.
 * 
 * @param argc Le parametre argc d'un main avant que le main
 *             ne l'utilise.
 * @param argv Le parametre argc d'un main avant que le main
 *             ne l'utilise.
 * @param TSPRunMode mode de dmarrage 0 = non bloquant, 1 = bloquant.
 * @param bbname le nom du blackboard auquel s'attacher
 * @return E_OK si initialisation ralise E_NOK sinon.
 * @ingroup BlackBoard
 */
int32_t
bb_tsp_provider_initialise(int* argc, char** argv[],int TSPRunMode, const char* bbname);

/**
 *
 */
int32_t 
bb_tsp_provider_finalize();
#endif /* _BB_TSP_PROVIDER_H_ */
