#$Id: Makefile.PL,v 1.1 2005/07/15 23:13:26 erk Exp $
#
#-----------------------------------------------------------------------
#
#TSP Library - core components for a generic Transport Sampling Protocol.
#
#Copyright (c) 2005 Pierre Mallard
#
#This library is free software; you can redistribute it and/or
#modify it under the terms of the GNU Lesser General Public
#License as published by the Free Software Foundation; either
#version 2.1 of the License, or (at your option) any later version.
#
#This library is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#Lesser General Public License for more details.
#
#You should have received a copy of the GNU Lesser General Public
#License along with this library; if not, write to the Free Software
#Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
#-----------------------------------------------------------------------
#
#Project    : TSP
#Maintainer : pmallard@silicom.fr
#Component  : Perl Wrapper for tsp_consumer
#
#-----------------------------------------------------------------------
#
#Purpose   :
# Configuration File for ExtUtils::MakeMaker Makefile construction
# In addition to the normal set of option that can be passed to MakeMaker (man ExtUtils::MakeMaker)
# We have added extra args with no name to set path to static lib libtsp_consumer.a 
# libtsp_services.a needed to run tsp_consumer.pm and tsp_consumer.h
# make;make install
#
# author : Pierre Mallard <pmallard@silicom.fr>

use ExtUtils::MakeMaker;
$VERSION = 0.0001;
$swig_typemap = "tsp_consumer.i";
$perl_from_swig = "tsp_consumer.pm";
$c_from_swig = "tsp_consumer_wrap.c";

########################################################################
# from Gavin SHERLOCK, GO-TermFinder-0.7/Makefile.PL (available on CPAN)

sub runSwigAutogeneration{

  print "Autogenerating wrappers from SWIG interface " . $swig_typemap . "\n";

  my $command = "swig -perl5 -shadow -I$TSP_INC_PATH " . $swig_typemap;

  system($command);
  if ($?){
      print "An error occurred when generating the wrappers from the SWIG interface : \n$!\n";
      print "The command that was run was:\n$command\n";
      print "Are you shure TSP_INC_PATH is correct ??\n";
      exit;
  }

}

sub existsAndUpToDate{
  my ($sourceFile, $destFile) = @_;

  if (!(-e $destFile)) { return 0; }
  my $sourceMtime = (stat $sourceFile)[9];
  my $destMtime = (stat $destFile)[9];

  return $destMtime >= $sourceMtime;
}

########################################################################


runSwigAutogeneration() unless
  existsAndUpToDate($swig_typemap,$perl_from_swig)
    and existsAndUpToDate($swig_typemap,$c_from_swig);

$o_from_swig = $c_from_swig;
$o_from_swig =~ s/\.c/\.o/;

WriteMakefile(
	      'NAME'              => "TSP::tsp_consumer",
	      'VERSION_FROM'      => "Makefile.PL",
	      'INC'               => "-I$TSP_INC_PATH",
	      'OBJECT'            => "$o_from_swig $TSP_LIB_PATH/libtsp_consumer.a $TSP_LIB_PATH/libtsp_services.a",
	      'clean'             => {FILES=>"$c_from_swig $o_from_swig"},
	      'AUTHOR'            => "Pierre Mallard <pmallard@silicom.fr>"
);
