/* $Id: VarTypeEnum.java,v 1.1 2005/03/31 05:40:03 sgalles Exp $
 * -----------------------------------------------------------------------
 * 
 * TSP Library - core components for a generic Transport Sampling Protocol.
 * 
 * Copyright (c) 2002 Yves DUFRENNE, Stephane GALLES, Eric NOULARD and Robert PAGNOT 
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * -----------------------------------------------------------------------
 * 
 * Project    : TSP
 * SubProject : jTSP
 * Maintainer : tsp@astrium-space.com
 * Component  : 
 * 
 * -----------------------------------------------------------------------
 * 
 * Purpose   : Consumer
 * 
 * -----------------------------------------------------------------------
 */

package tsp.consumer.util.configuration;



/**
 * Do NOT make this class serialisable, not for now at least...
 */
public final class VarTypeEnum {

    private final String name;

    private VarTypeEnum(String name) {
        this.name = name;
    }

    public final static VarTypeEnum UINT8_T = new VarTypeEnum("uint8_t");
    public final static VarTypeEnum UINT16_T = new VarTypeEnum("uint16_t");
    public final static VarTypeEnum UINT32_T = new VarTypeEnum("uint32_t");
    public final static VarTypeEnum UINT64_T = new VarTypeEnum("uint64_t");
    public final static VarTypeEnum INT8_T = new VarTypeEnum("int8_t");
    public final static VarTypeEnum INT16_T = new VarTypeEnum("int16_t");
    public final static VarTypeEnum INT32_T = new VarTypeEnum("int32_t");
    public final static VarTypeEnum INT64_T = new VarTypeEnum("int64_t");
    public final static VarTypeEnum FLOAT = new VarTypeEnum("float");
    public final static VarTypeEnum DOUBLE = new VarTypeEnum("double");
    public final static VarTypeEnum CHAR = new VarTypeEnum("char");
    public final static VarTypeEnum STRING = new VarTypeEnum("string");
    public final static VarTypeEnum TSPTYPE = new VarTypeEnum("TSPtype");

    private final static VarTypeEnum[] types = {UINT8_T, UINT16_T, UINT32_T, UINT64_T,
                                                INT8_T, INT16_T, INT32_T, INT64_T,
                                                FLOAT, DOUBLE, CHAR, STRING, TSPTYPE};

    public static VarTypeEnum getByName(String name) throws SpecException {
        for(int i = 0 ; i < types.length ; i++){
             VarTypeEnum currentType = types[i];
              if(0 == name.compareToIgnoreCase(currentType.name)){
                  return currentType;
              }
        }
        throw new SpecException("Unable to find Enum : " + name);
    }

    public String toString(){
        return name;
    }
}
