/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jfree.chart.renderer.Outlier;

public class OutlierList {
    private List outliers = new ArrayList();
    private Outlier averagedOutlier;
    private boolean multiple = false;

    public OutlierList(Outlier outlier) {
        this.setAveragedOutlier(outlier);
    }

    public boolean add(Outlier outlier) {
        return this.outliers.add(outlier);
    }

    public int getItemCount() {
        return this.outliers.size();
    }

    public Outlier getAveragedOutlier() {
        return this.averagedOutlier;
    }

    public void setAveragedOutlier(Outlier outlier) {
        this.averagedOutlier = outlier;
    }

    public boolean isMultiple() {
        return this.multiple;
    }

    public void setMultiple(boolean bl) {
        this.multiple = bl;
    }

    public boolean isOverlapped(Outlier outlier) {
        if (outlier == null) {
            return false;
        }
        boolean bl = outlier.overlaps(this.getAveragedOutlier());
        return bl;
    }

    public void updateAveragedOutlier() {
        double d = 0.0;
        double d2 = 0.0;
        int n = this.getItemCount();
        Iterator iterator = this.outliers.iterator();
        while (iterator.hasNext()) {
            Outlier outlier = (Outlier)iterator.next();
            d += outlier.getX();
            d2 += outlier.getY();
        }
        this.getAveragedOutlier().getPoint().setLocation(new Point2D.Double(d / (double)n, d2 / (double)n));
    }
}

