/*
 * Decompiled with CFR 0.152.
 */
package simtools.data;

import java.util.Timer;
import java.util.TimerTask;
import simtools.data.DataException;
import simtools.data.DataInfo;
import simtools.data.DataSource;
import simtools.data.DataSourceListener;
import simtools.data.DynamicDataSource;
import simtools.data.NoSuchIndex;

public class DataSourceAnimator
extends DynamicDataSource
implements DataSourceListener {
    public static final String MARKER = "AnimatedSource:";
    protected DataSource target;
    protected long period = 1000L;
    protected Timer timer;
    protected boolean finished;
    protected boolean autoStop;

    public boolean isFinished() {
        return this.finished;
    }

    public DataSourceAnimator(DataSource dataSource) {
        this(dataSource, 0);
    }

    public DataSourceAnimator(DataSource dataSource, int n) {
        this(dataSource, n, 1000L);
    }

    public DataSourceAnimator(DataSource dataSource, int n, long l) {
        super(dataSource.getInformation(), dataSource.getKind(), n);
        this.period = l;
        if (dataSource instanceof DataSourceAnimator) {
            this.target = ((DataSourceAnimator)dataSource).target;
        }
        this.target = dataSource;
        this.info.id = MARKER + this.info.id;
        this.autoRegister = false;
        this.target.addListener(this);
    }

    public void step() throws DataException {
        try {
            switch (this.kind) {
                case 1: {
                    super.setByteValue(this.target.getByteValue(this.lastIndex + 1L));
                }
                case 2: {
                    super.setShortValue(this.target.getShortValue(this.lastIndex + 1L));
                }
                case 3: {
                    super.setIntegerValue(this.target.getIntegerValue(this.lastIndex + 1L));
                }
                case 4: {
                    super.setLongValue(this.target.getLongValue(this.lastIndex + 1L));
                }
                case 5: {
                    super.setFloatValue(this.target.getFloatValue(this.lastIndex + 1L));
                }
                case 6: {
                    super.setDoubleValue(this.target.getDoubleValue(this.lastIndex + 1L));
                }
                case 7: {
                    super.setObjectValue(this.target.getValue(this.lastIndex + 1L));
                }
            }
            this.finished = false;
        }
        catch (DataException dataException) {
            if (this.autoStop && dataException instanceof NoSuchIndex) {
                this.finished = true;
            }
            throw dataException;
        }
        super.registerNewValue();
    }

    public long getPeriod() {
        return this.period;
    }

    public void setPeriod(long l) {
        if (this.isRunning()) {
            this.stop();
            this.period = l;
            this.start();
        } else {
            this.period = l;
        }
    }

    public boolean isRunning() {
        return this.timer != null;
    }

    public void start(long l) {
        if (this.isRunning()) {
            return;
        }
        this.period = l;
        this.start();
    }

    public void start() {
        if (this.isRunning()) {
            return;
        }
        this.timer = new Timer(true);
        this.timer.scheduleAtFixedRate(new TimerTask(){

            public void run() {
                block2: {
                    try {
                        DataSourceAnimator.this.step();
                    }
                    catch (DataException dataException) {
                        if (!DataSourceAnimator.this.autoStop || !(dataException instanceof NoSuchIndex)) break block2;
                        DataSourceAnimator.this.stop();
                    }
                }
            }
        }, 0L, this.period);
    }

    public void stop() {
        if (!this.isRunning()) {
            return;
        }
        this.timer.cancel();
        this.timer = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        DataSourceAnimator dataSourceAnimator = this;
        synchronized (dataSourceAnimator) {
            if (this.buffer != null) {
                this.buffer.clear();
            }
            this.lastIndex = -1L;
            this.finished = false;
        }
        this.notifyListenersForIndexRangeChange(this.getStartIndex(), this.getLastIndex());
    }

    public boolean isAutoStop() {
        return this.autoStop;
    }

    public void setAutoStop(boolean bl) {
        this.autoStop = bl;
    }

    public void DataSourceValueChanged(DataSource dataSource, long l, long l2) {
        if (this.buffer == null) {
            if (this.lastIndex >= l && this.lastIndex <= l2) {
                this.notifyListenersForValueChange(this.lastIndex, this.lastIndex);
            }
        } else {
            long l3;
            long l4 = Math.max(l, this.buffer.getStartIndex());
            if (l4 <= (l3 = Math.min(l2, this.buffer.getEndIndex()))) {
                this.notifyListenersForValueChange(l4, l3);
            }
        }
    }

    public void DataSourceIndexRangeChanged(DataSource dataSource, long l, long l2) {
        if (this.buffer == null) {
            if (this.lastIndex >= l && this.lastIndex <= l2) {
                this.notifyListenersForIndexRangeChange(this.lastIndex, this.lastIndex);
            }
        } else {
            long l3;
            long l4 = Math.max(l, this.buffer.getStartIndex());
            if (l4 <= (l3 = Math.min(l2, this.buffer.getEndIndex()))) {
                this.notifyListenersForIndexRangeChange(l4, l3);
            }
        }
    }

    public void DataSourceInfoChanged(DataSource dataSource, DataInfo dataInfo) {
        this.info = dataInfo;
        this.notifyListenersForInfoChange(dataInfo);
    }

    public void DataSourceValueRangeChanged(DataSource dataSource) {
        this.notifyListenersForValueRangeChange();
    }

    public void DataSourceOrderChanged(DataSource dataSource, int n) {
        this.notifyListenersForOrderChange(n);
    }

    public int sortedOrder() {
        return this.target.sortedOrder();
    }

    public Class valueClass() {
        return this.target.valueClass();
    }
}

