/*
 * Decompiled with CFR 0.152.
 */
package jsynoptic.data;

import java.util.Iterator;
import java.util.Set;
import jsynoptic.data.VariableAssociation;
import jsynoptic.parser.ExpressionNode;
import simtools.data.DataException;
import simtools.data.DataInfo;
import simtools.data.DataSource;
import simtools.data.DataSourceListener;
import simtools.data.UnsupportedOperation;

public class ExpressionDataSource
extends DataSource
implements DataSourceListener {
    protected ExpressionNode rootNode;
    protected Set variables;
    protected DataInfo info;
    protected long minIndex = 0L;
    protected long maxIndex = 0L;
    protected static String EXPRESSION_DATA_SOURCE_MARKER = "ExpressionDataSource:";

    public Set getVariables() {
        return this.variables;
    }

    public DataInfo getInformation() {
        return this.info;
    }

    public ExpressionDataSource(DataInfo dataInfo, ExpressionNode expressionNode) {
        this.info = dataInfo;
        this.info.id = EXPRESSION_DATA_SOURCE_MARKER + this.info.id;
        this.rootNode = expressionNode;
        this.variables = expressionNode.getVariables();
        this.minIndex = Long.MIN_VALUE;
        this.maxIndex = Long.MAX_VALUE;
        Iterator iterator = this.variables.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof VariableAssociation)) {
                iterator.remove();
                continue;
            }
            DataSource dataSource = ((VariableAssociation)e).ds;
            try {
                this.minIndex = Math.max(this.minIndex, dataSource.getStartIndex());
                this.maxIndex = Math.min(this.maxIndex, dataSource.getLastIndex());
            }
            catch (UnsupportedOperation unsupportedOperation) {
                // empty catch block
            }
            dataSource.addListener(this);
        }
        if (this.minIndex == Long.MIN_VALUE) {
            this.minIndex = 0L;
        }
        this.maxIndex = Long.MAX_VALUE;
    }

    public synchronized void changeExpression(String string, ExpressionNode expressionNode) {
        this.cleanup();
        this.rootNode = expressionNode;
        this.variables = this.rootNode.getVariables();
        this.info.comment = string;
        this.minIndex = Long.MIN_VALUE;
        this.maxIndex = Long.MAX_VALUE;
        Iterator iterator = this.variables.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof VariableAssociation)) {
                iterator.remove();
                continue;
            }
            DataSource dataSource = ((VariableAssociation)e).ds;
            try {
                this.minIndex = Math.max(this.minIndex, dataSource.getStartIndex());
                this.maxIndex = Math.min(this.maxIndex, dataSource.getLastIndex());
            }
            catch (UnsupportedOperation unsupportedOperation) {
                // empty catch block
            }
            dataSource.addListener(this);
            if (this.minIndex != Long.MIN_VALUE) continue;
            this.minIndex = 0L;
        }
        this.notifyListenersForValueChange(this.minIndex, this.maxIndex);
    }

    public synchronized void cleanup() {
        Iterator iterator = this.variables.iterator();
        while (iterator.hasNext()) {
            DataSource dataSource = ((VariableAssociation)iterator.next()).ds;
            dataSource.removeListener(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getValue(long l) throws DataException {
        ExpressionDataSource expressionDataSource = this;
        synchronized (expressionDataSource) {
            Iterator iterator;
            Object object = this.variables.iterator();
            while (object.hasNext()) {
                ((VariableAssociation)object.next()).lockIndex(l);
            }
            object = null;
            try {
                object = this.rootNode.evaluate();
                Object var6_4 = null;
                iterator = this.variables.iterator();
            }
            catch (Throwable throwable) {
                Object var6_5 = null;
                Iterator iterator2 = this.variables.iterator();
                while (iterator2.hasNext()) {
                    ((VariableAssociation)iterator2.next()).releaseIndex();
                }
                throw throwable;
            }
            while (iterator.hasNext()) {
                ((VariableAssociation)iterator.next()).releaseIndex();
            }
            return object;
        }
    }

    public void DataSourceValueChanged(DataSource dataSource, long l, long l2) {
        if (l >= this.minIndex && l2 <= this.maxIndex) {
            this.notifyListenersForValueChange(l, l2);
        }
    }

    public void DataSourceIndexRangeChanged(DataSource dataSource, long l, long l2) {
        long l3 = l;
        long l4 = l2;
        Iterator iterator = this.variables.iterator();
        while (iterator.hasNext()) {
            DataSource dataSource2 = ((VariableAssociation)iterator.next()).ds;
            if (dataSource2 == dataSource) continue;
            try {
                l3 = Math.max(l3, dataSource2.getStartIndex());
                l4 = Math.min(l4, dataSource2.getLastIndex());
            }
            catch (UnsupportedOperation unsupportedOperation) {}
        }
        this.minIndex = l3;
        this.maxIndex = l4;
        this.notifyListenersForIndexRangeChange(this.minIndex, this.maxIndex);
    }

    public void DataSourceInfoChanged(DataSource dataSource, DataInfo dataInfo) {
    }

    public void DataSourceValueRangeChanged(DataSource dataSource) {
    }

    public void DataSourceOrderChanged(DataSource dataSource, int n) {
    }

    public long computeLastIndex() throws UnsupportedOperation {
        long l = Long.MAX_VALUE;
        Iterator iterator = this.variables.iterator();
        while (iterator.hasNext()) {
            DataSource dataSource = ((VariableAssociation)iterator.next()).ds;
            l = Math.min(l, dataSource.computeLastIndex());
        }
        this.maxIndex = l;
        return this.maxIndex;
    }

    public long computeStartIndex() throws UnsupportedOperation {
        long l = Long.MIN_VALUE;
        Iterator iterator = this.variables.iterator();
        while (iterator.hasNext()) {
            DataSource dataSource = ((VariableAssociation)iterator.next()).ds;
            l = Math.max(l, dataSource.computeStartIndex());
        }
        this.minIndex = l;
        if (this.minIndex == Long.MIN_VALUE) {
            this.minIndex = 0L;
        }
        return this.minIndex;
    }

    public long getLastIndex() throws UnsupportedOperation {
        return this.maxIndex;
    }

    public long getStartIndex() throws UnsupportedOperation {
        return this.minIndex;
    }

    public boolean isComparable() {
        return true;
    }

    public String toString() {
        return this.info.label + " = " + this.info.comment;
    }

    public DataSource[] getSourceDependencies() {
        int n = this.variables.size();
        if (n <= 0) {
            return null;
        }
        DataSource[] dataSourceArray = new DataSource[n];
        int n2 = 0;
        Iterator iterator = this.variables.iterator();
        while (iterator.hasNext()) {
            dataSourceArray[n2++] = ((VariableAssociation)iterator.next()).ds;
        }
        return dataSourceArray;
    }
}

