/*
 * Decompiled with CFR 0.152.
 */
package jsynoptic.plugins.jfreechart;

import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.Rectangle2D;
import jsynoptic.plugins.jfreechart.JSynopticXYItemRenderer;
import jsynoptic.plugins.jfreechart.JSynopticXYItemRendererHelper;
import org.jfree.chart.CrosshairInfo;
import org.jfree.chart.LegendItem;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.DrawingSupplier;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.AreaXYRenderer;
import org.jfree.chart.renderer.XYItemRendererState;
import org.jfree.chart.urls.XYURLGenerator;
import org.jfree.data.DatasetChangeListener;
import org.jfree.data.DatasetGroup;
import org.jfree.data.XYDataset;
import simtools.data.DataSource;
import simtools.ui.ColorMapper;

public class JSynopticAreaXYItemRenderer
extends AreaXYRenderer
implements JSynopticXYItemRenderer {
    static final long serialVersionUID = 5638611076468432559L;
    protected JSynopticXYItemRendererHelper helper = new JSynopticXYItemRendererHelper(1);
    protected transient int indexShift = 0;

    public JSynopticAreaXYItemRenderer() {
    }

    public JSynopticAreaXYItemRenderer(int n) {
        super(n);
    }

    public JSynopticAreaXYItemRenderer(int n, XYToolTipGenerator xYToolTipGenerator, XYURLGenerator xYURLGenerator) {
        super(n, xYToolTipGenerator, xYURLGenerator);
    }

    public LegendItem getLegendItem(int n, int n2) {
        return this.helper.getLegendItem(this, n, n2);
    }

    public Paint getItemPaint(int n, int n2) {
        return this.helper.getItemPaint(this, n, n2 + this.indexShift);
    }

    public Paint getSeriesPaint(int n) {
        return this.helper.getSeriesPaint(this, n);
    }

    public LegendItem getDefaultLegendItem(int n, int n2) {
        return super.getLegendItem(n, n2);
    }

    public Paint getDefaultItemPaint(int n, int n2) {
        return super.getItemPaint(n, n2);
    }

    public Paint getDefaultSeriesPaint(int n) {
        return super.getSeriesPaint(n);
    }

    public DrawingSupplier getDrawingSupplier() {
        return this.helper.getDrawingSupplier();
    }

    public ColorMapper getColorMapper(int n) {
        return this.helper.getColorMapper(n);
    }

    public DataSource getDataSource(int n) {
        return this.helper.getDataSource(n);
    }

    public ColorMapper removeColorMapper(int n) {
        return this.helper.removeColorMapper(n);
    }

    public DataSource removeDataSource(int n) {
        return this.helper.removeDataSource(n);
    }

    public void setColorMapper(int n, ColorMapper colorMapper) {
        this.helper.setColorMapper(n, colorMapper);
    }

    public void setDataSource(int n, DataSource dataSource) {
        this.helper.setDataSource(n, dataSource);
    }

    public void drawItem(Graphics2D graphics2D, XYItemRendererState xYItemRendererState, Rectangle2D rectangle2D, PlotRenderingInfo plotRenderingInfo, XYPlot xYPlot, ValueAxis valueAxis, ValueAxis valueAxis2, XYDataset xYDataset, int n, int n2, CrosshairInfo crosshairInfo, int n3) {
        if (n2 == 0) {
            return;
        }
        if (xYDataset.getYValue(n, n2) == null) {
            return;
        }
        if (xYDataset.getYValue(n, n2 - 1) == null) {
            return;
        }
        if (xYDataset.getXValue(n, n2) == null) {
            return;
        }
        if (xYDataset.getXValue(n, n2 - 1) == null) {
            return;
        }
        DelegateDataset delegateDataset = new DelegateDataset(xYDataset, n, n2 - 1, 2);
        this.indexShift = n2 - 1;
        super.drawItem(graphics2D, xYItemRendererState, rectangle2D, plotRenderingInfo, xYPlot, valueAxis, valueAxis2, (XYDataset)delegateDataset, n, 0, crosshairInfo, n3);
        super.drawItem(graphics2D, xYItemRendererState, rectangle2D, plotRenderingInfo, xYPlot, valueAxis, valueAxis2, (XYDataset)delegateDataset, n, 1, crosshairInfo, n3);
        this.indexShift = 0;
    }

    public class DelegateDataset
    implements XYDataset {
        XYDataset dataset;
        int refItem;
        int refSerie;
        int nItem;

        public DelegateDataset(XYDataset xYDataset, int n, int n2, int n3) {
            this.dataset = xYDataset;
            this.refItem = n2;
            this.refSerie = n;
            this.nItem = n3;
        }

        public void addChangeListener(DatasetChangeListener datasetChangeListener) {
            this.dataset.addChangeListener(datasetChangeListener);
        }

        public boolean equals(Object object) {
            return this.dataset.equals(object);
        }

        public DatasetGroup getGroup() {
            return this.dataset.getGroup();
        }

        public int getItemCount(int n) {
            if (n == this.refSerie) {
                return this.nItem;
            }
            return this.dataset.getItemCount(n);
        }

        public int getSeriesCount() {
            return this.dataset.getSeriesCount();
        }

        public String getSeriesName(int n) {
            return this.dataset.getSeriesName(n);
        }

        public Number getXValue(int n, int n2) {
            if (n == this.refSerie) {
                return this.dataset.getXValue(n, this.refItem + n2);
            }
            return this.dataset.getXValue(n, n2);
        }

        public Number getYValue(int n, int n2) {
            if (n == this.refSerie) {
                return this.dataset.getYValue(n, this.refItem + n2);
            }
            return this.dataset.getYValue(n, n2);
        }

        public int hashCode() {
            return this.dataset.hashCode();
        }

        public void removeChangeListener(DatasetChangeListener datasetChangeListener) {
            this.dataset.removeChangeListener(datasetChangeListener);
        }

        public void setGroup(DatasetGroup datasetGroup) {
            this.dataset.setGroup(datasetGroup);
        }

        public String toString() {
            return this.dataset.toString();
        }
    }
}

