/*
 * Decompiled with CFR 0.152.
 */
package org.acplt.oncrpc;

import java.io.IOException;
import java.net.InetAddress;
import org.acplt.oncrpc.OncRpcException;

public abstract class XdrDecodingStream {
    public abstract InetAddress getSenderAddress();

    public abstract int getSenderPort();

    public abstract void beginDecoding() throws IOException, OncRpcException;

    public void endDecoding() throws IOException, OncRpcException {
    }

    public void close() throws IOException, OncRpcException {
    }

    public abstract int xdrDecodeInt() throws IOException, OncRpcException;

    public abstract byte[] xdrDecodeOpaque(int var1) throws IOException, OncRpcException;

    public abstract void xdrDecodeOpaque(byte[] var1, int var2, int var3) throws IOException, OncRpcException;

    public final void xdrDecodeOpaque(byte[] opaque) throws IOException, OncRpcException {
        this.xdrDecodeOpaque(opaque, 0, opaque.length);
    }

    public final byte[] xdrDecodeDynamicOpaque() throws IOException, OncRpcException {
        int length = this.xdrDecodeInt();
        byte[] opaque = new byte[length];
        if (length != 0) {
            this.xdrDecodeOpaque(opaque);
        }
        return opaque;
    }

    public final byte[] xdrDecodeByteVector() throws IOException, OncRpcException {
        int length = this.xdrDecodeInt();
        if (length > 0) {
            byte[] bytes = new byte[length];
            for (int i = 0; i < length; ++i) {
                bytes[i] = (byte)this.xdrDecodeInt();
            }
            return bytes;
        }
        return new byte[0];
    }

    public final byte[] xdrDecodeByteFixedVector(int length) throws IOException, OncRpcException {
        if (length > 0) {
            byte[] bytes = new byte[length];
            for (int i = 0; i < length; ++i) {
                bytes[i] = (byte)this.xdrDecodeInt();
            }
            return bytes;
        }
        return new byte[0];
    }

    public final byte xdrDecodeByte() throws IOException, OncRpcException {
        return (byte)this.xdrDecodeInt();
    }

    public final short xdrDecodeShort() throws IOException, OncRpcException {
        return (short)this.xdrDecodeInt();
    }

    public final long xdrDecodeLong() throws IOException, OncRpcException {
        return ((long)this.xdrDecodeInt() << 32) + ((long)this.xdrDecodeInt() & 0xFFFFFFFFL);
    }

    public final float xdrDecodeFloat() throws IOException, OncRpcException {
        return Float.intBitsToFloat(this.xdrDecodeInt());
    }

    public final double xdrDecodeDouble() throws IOException, OncRpcException {
        return Double.longBitsToDouble(this.xdrDecodeLong());
    }

    public final boolean xdrDecodeBoolean() throws IOException, OncRpcException {
        return this.xdrDecodeInt() != 0;
    }

    public final String xdrDecodeString() throws IOException, OncRpcException {
        int length = this.xdrDecodeInt();
        if (length > 0) {
            byte[] bytes = new byte[length];
            this.xdrDecodeOpaque(bytes, 0, length);
            return new String(bytes);
        }
        return new String();
    }

    public final short[] xdrDecodeShortVector() throws IOException, OncRpcException {
        int length = this.xdrDecodeInt();
        short[] value = new short[length];
        for (int i = 0; i < length; ++i) {
            value[i] = this.xdrDecodeShort();
        }
        return value;
    }

    public final short[] xdrDecodeShortFixedVector(int length) throws IOException, OncRpcException {
        short[] value = new short[length];
        for (int i = 0; i < length; ++i) {
            value[i] = this.xdrDecodeShort();
        }
        return value;
    }

    public final int[] xdrDecodeIntVector() throws IOException, OncRpcException {
        int length = this.xdrDecodeInt();
        int[] value = new int[length];
        for (int i = 0; i < length; ++i) {
            value[i] = this.xdrDecodeInt();
        }
        return value;
    }

    public final int[] xdrDecodeIntFixedVector(int length) throws IOException, OncRpcException {
        int[] value = new int[length];
        for (int i = 0; i < length; ++i) {
            value[i] = this.xdrDecodeInt();
        }
        return value;
    }

    public final long[] xdrDecodeLongVector() throws IOException, OncRpcException {
        int length = this.xdrDecodeInt();
        long[] value = new long[length];
        for (int i = 0; i < length; ++i) {
            value[i] = this.xdrDecodeLong();
        }
        return value;
    }

    public final long[] xdrDecodeLongFixedVector(int length) throws IOException, OncRpcException {
        long[] value = new long[length];
        for (int i = 0; i < length; ++i) {
            value[i] = this.xdrDecodeLong();
        }
        return value;
    }

    public final float[] xdrDecodeFloatVector() throws IOException, OncRpcException {
        int length = this.xdrDecodeInt();
        float[] value = new float[length];
        for (int i = 0; i < length; ++i) {
            value[i] = this.xdrDecodeFloat();
        }
        return value;
    }

    public final float[] xdrDecodeFloatFixedVector(int length) throws IOException, OncRpcException {
        float[] value = new float[length];
        for (int i = 0; i < length; ++i) {
            value[i] = this.xdrDecodeFloat();
        }
        return value;
    }

    public final double[] xdrDecodeDoubleVector() throws IOException, OncRpcException {
        int length = this.xdrDecodeInt();
        double[] value = new double[length];
        for (int i = 0; i < length; ++i) {
            value[i] = this.xdrDecodeDouble();
        }
        return value;
    }

    public final double[] xdrDecodeDoubleFixedVector(int length) throws IOException, OncRpcException {
        double[] value = new double[length];
        for (int i = 0; i < length; ++i) {
            value[i] = this.xdrDecodeDouble();
        }
        return value;
    }

    public final boolean[] xdrDecodeBooleanVector() throws IOException, OncRpcException {
        int length = this.xdrDecodeInt();
        boolean[] value = new boolean[length];
        for (int i = 0; i < length; ++i) {
            value[i] = this.xdrDecodeBoolean();
        }
        return value;
    }

    public final boolean[] xdrDecodeBooleanFixedVector(int length) throws IOException, OncRpcException {
        boolean[] value = new boolean[length];
        for (int i = 0; i < length; ++i) {
            value[i] = this.xdrDecodeBoolean();
        }
        return value;
    }

    public final String[] xdrDecodeStringVector() throws IOException, OncRpcException {
        int length = this.xdrDecodeInt();
        String[] value = new String[length];
        for (int i = 0; i < length; ++i) {
            value[i] = this.xdrDecodeString();
        }
        return value;
    }

    public final String[] xdrDecodeStringFixedVector(int length) throws IOException, OncRpcException {
        String[] value = new String[length];
        for (int i = 0; i < length; ++i) {
            value[i] = this.xdrDecodeString();
        }
        return value;
    }
}

