/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer;

import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import org.jfree.chart.CrosshairInfo;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.entity.XYItemEntity;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.AbstractRenderer;
import org.jfree.chart.renderer.AbstractXYItemRenderer;
import org.jfree.chart.renderer.AreaXYItemRendererState;
import org.jfree.chart.renderer.XYItemRenderer;
import org.jfree.chart.renderer.XYItemRendererState;
import org.jfree.chart.urls.XYURLGenerator;
import org.jfree.data.XYDataset;
import org.jfree.util.PublicCloneable;

public class AreaXYRenderer
extends AbstractXYItemRenderer
implements XYItemRenderer,
Cloneable,
PublicCloneable,
Serializable {
    public static final int SHAPES = 1;
    public static final int LINES = 2;
    public static final int SHAPES_AND_LINES = 3;
    public static final int AREA = 4;
    public static final int AREA_AND_SHAPES = 5;
    private boolean plotShapes;
    private boolean plotLines;
    private boolean plotArea;
    private boolean showOutline;

    public AreaXYRenderer() {
        this(4);
    }

    public AreaXYRenderer(int n) {
        this(n, null, null);
    }

    public AreaXYRenderer(int n, XYToolTipGenerator xYToolTipGenerator, XYURLGenerator xYURLGenerator) {
        this.setToolTipGenerator(xYToolTipGenerator);
        this.setURLGenerator(xYURLGenerator);
        if (n == 1) {
            this.plotShapes = true;
        }
        if (n == 2) {
            this.plotLines = true;
        }
        if (n == 3) {
            this.plotShapes = true;
            this.plotLines = true;
        }
        if (n == 4) {
            this.plotArea = true;
        }
        if (n == 5) {
            this.plotArea = true;
            this.plotShapes = true;
        }
        this.showOutline = false;
    }

    public boolean isOutline() {
        return this.showOutline;
    }

    public void setOutline(boolean bl) {
        this.showOutline = bl;
    }

    public boolean getPlotShapes() {
        return this.plotShapes;
    }

    public boolean getPlotLines() {
        return this.plotLines;
    }

    public boolean getPlotArea() {
        return this.plotArea;
    }

    public XYItemRendererState initialise(Graphics2D graphics2D, Rectangle2D rectangle2D, XYPlot xYPlot, XYDataset xYDataset, PlotRenderingInfo plotRenderingInfo) {
        AreaXYItemRendererState areaXYItemRendererState = new AreaXYItemRendererState(plotRenderingInfo);
        return areaXYItemRendererState;
    }

    public void drawItem(Graphics2D graphics2D, XYItemRendererState xYItemRendererState, Rectangle2D rectangle2D, PlotRenderingInfo plotRenderingInfo, XYPlot xYPlot, ValueAxis valueAxis, ValueAxis valueAxis2, XYDataset xYDataset, int n, int n2, CrosshairInfo crosshairInfo, int n3) {
        EntityCollection entityCollection;
        AreaXYItemRendererState areaXYItemRendererState = (AreaXYItemRendererState)xYItemRendererState;
        Number number = xYDataset.getXValue(n, n2);
        Number number2 = xYDataset.getYValue(n, n2);
        if (number2 == null) {
            number2 = AbstractRenderer.ZERO;
        }
        double d = valueAxis.translateValueToJava2D(number.doubleValue(), rectangle2D, xYPlot.getDomainAxisEdge());
        double d2 = valueAxis2.translateValueToJava2D(number2.doubleValue(), rectangle2D, xYPlot.getRangeAxisEdge());
        int n4 = xYDataset.getItemCount(n);
        Number number3 = xYDataset.getXValue(n, Math.max(n2 - 1, 0));
        Number number4 = xYDataset.getYValue(n, Math.max(n2 - 1, 0));
        if (number4 == null) {
            number4 = AbstractRenderer.ZERO;
        }
        double d3 = valueAxis.translateValueToJava2D(number3.doubleValue(), rectangle2D, xYPlot.getDomainAxisEdge());
        double d4 = valueAxis2.translateValueToJava2D(number4.doubleValue(), rectangle2D, xYPlot.getRangeAxisEdge());
        Number number5 = xYDataset.getXValue(n, Math.min(n2 + 1, n4 - 1));
        Number number6 = xYDataset.getYValue(n, Math.min(n2 + 1, n4 - 1));
        if (number6 == null) {
            number6 = AbstractRenderer.ZERO;
        }
        double d5 = valueAxis.translateValueToJava2D(number5.doubleValue(), rectangle2D, xYPlot.getDomainAxisEdge());
        double d6 = valueAxis2.translateValueToJava2D(number6.doubleValue(), rectangle2D, xYPlot.getRangeAxisEdge());
        double d7 = valueAxis2.translateValueToJava2D(0.0, rectangle2D, xYPlot.getRangeAxisEdge());
        Polygon polygon = null;
        if (xYPlot.getOrientation() == PlotOrientation.HORIZONTAL) {
            polygon = new Polygon();
            polygon.addPoint((int)d7, (int)((d3 + d) / 2.0));
            polygon.addPoint((int)((d4 + d2) / 2.0), (int)((d3 + d) / 2.0));
            polygon.addPoint((int)d2, (int)d);
            polygon.addPoint((int)((d2 + d6) / 2.0), (int)((d + d5) / 2.0));
            polygon.addPoint((int)d7, (int)((d + d5) / 2.0));
        } else {
            polygon = new Polygon();
            polygon.addPoint((int)((d3 + d) / 2.0), (int)d7);
            polygon.addPoint((int)((d3 + d) / 2.0), (int)((d4 + d2) / 2.0));
            polygon.addPoint((int)d, (int)d2);
            polygon.addPoint((int)((d + d5) / 2.0), (int)((d2 + d6) / 2.0));
            polygon.addPoint((int)((d + d5) / 2.0), (int)d7);
        }
        if (n2 == 0) {
            areaXYItemRendererState.area = new Polygon();
            double d8 = valueAxis2.translateValueToJava2D(0.0, rectangle2D, xYPlot.getRangeAxisEdge());
            if (xYPlot.getOrientation() == PlotOrientation.VERTICAL) {
                areaXYItemRendererState.area.addPoint((int)d, (int)d8);
            } else if (xYPlot.getOrientation() == PlotOrientation.HORIZONTAL) {
                areaXYItemRendererState.area.addPoint((int)d8, (int)d);
            }
        }
        if (xYPlot.getOrientation() == PlotOrientation.VERTICAL) {
            areaXYItemRendererState.area.addPoint((int)d, (int)d2);
        } else if (xYPlot.getOrientation() == PlotOrientation.HORIZONTAL) {
            areaXYItemRendererState.area.addPoint((int)d2, (int)d);
        }
        Paint paint = this.getItemPaint(n, n2);
        Stroke stroke = this.getItemStroke(n, n2);
        graphics2D.setPaint(paint);
        graphics2D.setStroke(stroke);
        Shape shape = null;
        if (this.plotShapes) {
            shape = this.getItemShape(n, n2);
            if (xYPlot.getOrientation() == PlotOrientation.VERTICAL) {
                shape = this.createTransformedShape(shape, d, d2);
            } else if (xYPlot.getOrientation() == PlotOrientation.HORIZONTAL) {
                shape = this.createTransformedShape(shape, d2, d);
            }
            graphics2D.draw(shape);
        }
        if (this.plotLines && n2 > 0) {
            if (xYPlot.getOrientation() == PlotOrientation.VERTICAL) {
                areaXYItemRendererState.line.setLine(d3, d4, d, d2);
            } else if (xYPlot.getOrientation() == PlotOrientation.HORIZONTAL) {
                areaXYItemRendererState.line.setLine(d4, d3, d2, d);
            }
            graphics2D.draw(areaXYItemRendererState.line);
        }
        if (this.plotArea && n2 > 0 && n2 == n4 - 1) {
            if (xYPlot.getOrientation() == PlotOrientation.VERTICAL) {
                areaXYItemRendererState.area.addPoint((int)d, (int)d7);
            } else if (xYPlot.getOrientation() == PlotOrientation.HORIZONTAL) {
                areaXYItemRendererState.area.addPoint((int)d7, (int)d);
            }
            graphics2D.fill(areaXYItemRendererState.area);
            if (this.showOutline) {
                graphics2D.setStroke(xYPlot.getOutlineStroke());
                graphics2D.setPaint(xYPlot.getOutlinePaint());
                graphics2D.draw(areaXYItemRendererState.area);
            }
        }
        if (xYPlot.isDomainCrosshairLockedOnData()) {
            if (xYPlot.isRangeCrosshairLockedOnData()) {
                crosshairInfo.updateCrosshairPoint(number.doubleValue(), number2.doubleValue(), d, d2);
            } else {
                crosshairInfo.updateCrosshairX(number.doubleValue());
            }
        } else if (xYPlot.isRangeCrosshairLockedOnData()) {
            crosshairInfo.updateCrosshairY(number2.doubleValue());
        }
        if (xYItemRendererState.getInfo() != null && (entityCollection = xYItemRendererState.getInfo().getOwner().getEntityCollection()) != null && polygon != null) {
            String string = null;
            if (this.getToolTipGenerator() != null) {
                string = this.getToolTipGenerator().generateToolTip(xYDataset, n, n2);
            }
            String string2 = null;
            if (this.getURLGenerator() != null) {
                string2 = this.getURLGenerator().generateURL(xYDataset, n, n2);
            }
            XYItemEntity xYItemEntity = new XYItemEntity(polygon, xYDataset, n, n2, string, string2);
            entityCollection.addEntity(xYItemEntity);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

