/*
 * Decompiled with CFR 0.152.
 */
package simtools.data;

import java.io.Serializable;
import java.util.Vector;
import simtools.data.DataException;
import simtools.data.DataInfo;
import simtools.data.DataSource;
import simtools.data.UnsupportedOperation;

public class LinearSource
extends DataSource
implements Serializable {
    protected double _org;
    protected double _coef;
    protected long _start;
    protected long _end;
    private static DataInfo info = new DataInfo(null, "LinearSource");
    static /* synthetic */ Class class$java$lang$Double;

    public LinearSource(double d, double d2, long l, long l2) {
        this._org = d;
        this._coef = d2;
        this._start = l;
        this._end = l2;
    }

    public LinearSource(double d, double d2, double d3) {
        int n = 0;
        if (d3 != 0.0) {
            n = (int)Math.floor((d2 - d) / d3);
        }
        if (n < 1) {
            this._end = 0L;
            this._start = 0L;
            this._coef = 0.0;
            this._org = 0.0;
            return;
        }
        this._start = 0L;
        this._end = n - 1;
        this._org = d;
        this._coef = d3;
    }

    public DataInfo getInformation() {
        return info;
    }

    public Object getMin() throws UnsupportedOperation {
        try {
            if (this._coef > 0.0) {
                return this.getValue(this._start);
            }
            return this.getValue(this._end);
        }
        catch (DataException dataException) {
            throw new UnsupportedOperation();
        }
    }

    public Object getMax() throws UnsupportedOperation {
        try {
            if (this._coef < 0.0) {
                return this.getValue(this._start);
            }
            return this.getValue(this._end);
        }
        catch (DataException dataException) {
            throw new UnsupportedOperation();
        }
    }

    public long getStartIndex() throws UnsupportedOperation {
        return this._start;
    }

    public long getLastIndex() throws UnsupportedOperation {
        return this._end;
    }

    public Object computeMin() throws UnsupportedOperation {
        return this.getMin();
    }

    public Object computeMax() throws UnsupportedOperation {
        return this.getMax();
    }

    public long computeStartIndex() throws UnsupportedOperation {
        return this.getStartIndex();
    }

    public long computeLastIndex() throws UnsupportedOperation {
        return this.getLastIndex();
    }

    public void setSlice(long l, long l2) {
    }

    public double getDoubleValue(long l) {
        if (l < this._start) {
            l = 0L;
        }
        return (double)(l - this._start) * this._coef + this._org;
    }

    public Object getValue(long l) throws DataException {
        return new Double(this.getDoubleValue(l));
    }

    public Class valueClass() {
        return class$java$lang$Double == null ? (class$java$lang$Double = LinearSource.class$("java.lang.Double")) : class$java$lang$Double;
    }

    public int sortedOrder() {
        return this._coef < 0.0 ? -1 : 1;
    }

    public void update() throws UnsupportedOperation {
    }

    Object getInternalParameters() {
        Vector<Number> vector = new Vector<Number>(4);
        vector.add(new Double(this._org));
        vector.add(new Double(this._coef));
        vector.add(new Long(this._start));
        vector.add(new Long(this._end));
        return vector;
    }

    LinearSource(Vector vector) {
        this((Double)vector.get(0), (Double)vector.get(1), (Long)vector.get(2), (Long)vector.get(3));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

