/*
 * Decompiled with CFR 0.152.
 */
package simtools.data;

import simtools.data.CollectiveDataSource;
import simtools.data.DataException;
import simtools.data.DataInfo;
import simtools.data.DataSource;
import simtools.data.DataSourceCollection;
import simtools.data.NoSuchIndex;
import simtools.data.UnsupportedOperation;
import simtools.data.buffer.Buffer;
import simtools.data.buffer.BufferedDataSource;
import simtools.data.buffer.DelayedBuffer;
import simtools.util.NumberStringComparator;

public class DynamicDataSourceCollection
extends DataSourceCollection {
    protected SourceInfo[] sourceInfo;
    protected DataInfo ourInfo;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Object;

    public void bufferize(Buffer buffer) throws UnsupportedOperation {
        if (!(buffer instanceof DelayedBuffer)) {
            throw new UnsupportedOperation();
        }
        super.bufferize(buffer);
    }

    public void bufferize(int n, Buffer buffer) throws UnsupportedOperation {
        if (!(buffer instanceof DelayedBuffer)) {
            throw new UnsupportedOperation();
        }
        super.bufferize(n, buffer);
    }

    public void bufferize(int n) throws UnsupportedOperation {
        this.bufferize(n, new DelayedBuffer());
    }

    public DataInfo getInformation(int n) {
        return this.sourceInfo[n].info;
    }

    public Object getMin(int n) throws UnsupportedOperation {
        if (!this.sourceInfo[n].hasValue) {
            throw new UnsupportedOperation();
        }
        switch (this.sourceInfo[n].kind) {
            case 1: {
                return new Byte(this.sourceInfo[n].minByte);
            }
            case 2: {
                return new Short(this.sourceInfo[n].minShort);
            }
            case 3: {
                return new Integer(this.sourceInfo[n].minInteger);
            }
            case 4: {
                return new Long(this.sourceInfo[n].minLong);
            }
            case 5: {
                return new Float(this.sourceInfo[n].minFloat);
            }
            case 6: {
                return new Double(this.sourceInfo[n].minDouble);
            }
            case 7: {
                return this.sourceInfo[n].minObject;
            }
        }
        return null;
    }

    public Object getMax(int n) throws UnsupportedOperation {
        if (!this.sourceInfo[n].hasValue) {
            throw new UnsupportedOperation();
        }
        switch (this.sourceInfo[n].kind) {
            case 1: {
                return new Byte(this.sourceInfo[n].maxByte);
            }
            case 2: {
                return new Short(this.sourceInfo[n].maxShort);
            }
            case 3: {
                return new Integer(this.sourceInfo[n].maxInteger);
            }
            case 4: {
                return new Long(this.sourceInfo[n].maxLong);
            }
            case 5: {
                return new Float(this.sourceInfo[n].maxFloat);
            }
            case 6: {
                return new Double(this.sourceInfo[n].maxDouble);
            }
            case 7: {
                return this.sourceInfo[n].maxObject;
            }
        }
        return null;
    }

    public byte getByteMin(int n) throws DataException {
        if (this.sourceInfo[n].kind == 1) {
            return this.sourceInfo[n].minByte;
        }
        return super.getByteMin(n);
    }

    public byte getByteMax(int n) throws DataException {
        if (this.sourceInfo[n].kind == 1) {
            return this.sourceInfo[n].maxByte;
        }
        return super.getByteMax(n);
    }

    public short getShortMin(int n) throws DataException {
        if (this.sourceInfo[n].kind == 2) {
            return this.sourceInfo[n].minShort;
        }
        return super.getShortMin(n);
    }

    public short getShortMax(int n) throws DataException {
        if (this.sourceInfo[n].kind == 2) {
            return this.sourceInfo[n].maxShort;
        }
        return super.getShortMax(n);
    }

    public int getIntegerMin(int n) throws DataException {
        if (this.sourceInfo[n].kind == 3) {
            return this.sourceInfo[n].minInteger;
        }
        return super.getIntegerMin(n);
    }

    public int getIntegerMax(int n) throws DataException {
        if (this.sourceInfo[n].kind == 3) {
            return this.sourceInfo[n].maxInteger;
        }
        return super.getIntegerMax(n);
    }

    public long getLongMin(int n) throws DataException {
        if (this.sourceInfo[n].kind == 4) {
            return this.sourceInfo[n].minLong;
        }
        return super.getLongMin(n);
    }

    public long getLongMax(int n) throws DataException {
        if (this.sourceInfo[n].kind == 4) {
            return this.sourceInfo[n].maxLong;
        }
        return super.getLongMax(n);
    }

    public float getFloatMin(int n) throws DataException {
        if (this.sourceInfo[n].kind == 5) {
            return this.sourceInfo[n].minFloat;
        }
        return super.getFloatMin(n);
    }

    public float getFloatMax(int n) throws DataException {
        if (this.sourceInfo[n].kind == 5) {
            return this.sourceInfo[n].maxFloat;
        }
        return super.getFloatMax(n);
    }

    public double getDoubleMin(int n) throws DataException {
        if (this.sourceInfo[n].kind == 6) {
            return this.sourceInfo[n].minDouble;
        }
        return super.getDoubleMin(n);
    }

    public double getDoubleMax(int n) throws DataException {
        if (this.sourceInfo[n].kind == 6) {
            return this.sourceInfo[n].maxDouble;
        }
        return super.getDoubleMax(n);
    }

    public Object computeMin(int n) throws UnsupportedOperation {
        if (!this.sourceInfo[n].hasValue) {
            throw new UnsupportedOperation();
        }
        if (this.buffers == null || this.buffers[n] == null) {
            switch (this.sourceInfo[n].kind) {
                case 1: {
                    this.sourceInfo[n].minByte = this.sourceInfo[n].cachedByte;
                    return new Byte(this.sourceInfo[n].minByte);
                }
                case 2: {
                    this.sourceInfo[n].minShort = this.sourceInfo[n].cachedShort;
                    return new Short(this.sourceInfo[n].minShort);
                }
                case 3: {
                    this.sourceInfo[n].minInteger = this.sourceInfo[n].cachedInteger;
                    return new Integer(this.sourceInfo[n].minInteger);
                }
                case 4: {
                    this.sourceInfo[n].minLong = this.sourceInfo[n].cachedLong;
                    return new Long(this.sourceInfo[n].minLong);
                }
                case 5: {
                    this.sourceInfo[n].minFloat = this.sourceInfo[n].cachedFloat;
                    return new Float(this.sourceInfo[n].minFloat);
                }
                case 6: {
                    this.sourceInfo[n].minDouble = this.sourceInfo[n].cachedDouble;
                    return new Double(this.sourceInfo[n].minDouble);
                }
                case 7: {
                    this.sourceInfo[n].minObject = this.sourceInfo[n].cachedObject;
                    return this.sourceInfo[n].minObject;
                }
            }
            return null;
        }
        int n2 = this.sortedOrder(n);
        switch (this.sourceInfo[n].kind) {
            case 1: {
                try {
                    this.sourceInfo[n].minByte = n2 == 1 ? this.buffers[n].getByteValue(this.buffers[n].getStartIndex()) : (n2 == -1 ? this.buffers[n].getByteValue(this.buffers[n].getEndIndex()) : this.sourceInfo[n].cachedByte);
                    return new Byte(this.sourceInfo[n].minByte);
                }
                catch (DataException dataException) {
                    this.sourceInfo[n].minByte = this.sourceInfo[n].cachedByte;
                    return new Byte(this.sourceInfo[n].minByte);
                }
            }
            case 2: {
                try {
                    this.sourceInfo[n].minShort = n2 == 1 ? this.buffers[n].getShortValue(this.buffers[n].getStartIndex()) : (n2 == -1 ? this.buffers[n].getShortValue(this.buffers[n].getEndIndex()) : this.sourceInfo[n].cachedShort);
                    return new Short(this.sourceInfo[n].minShort);
                }
                catch (DataException dataException) {
                    this.sourceInfo[n].minShort = this.sourceInfo[n].cachedShort;
                    return new Short(this.sourceInfo[n].minShort);
                }
            }
            case 3: {
                try {
                    this.sourceInfo[n].minInteger = n2 == 1 ? this.buffers[n].getIntegerValue(this.buffers[n].getStartIndex()) : (n2 == -1 ? this.buffers[n].getIntegerValue(this.buffers[n].getEndIndex()) : this.sourceInfo[n].cachedInteger);
                    return new Integer(this.sourceInfo[n].minInteger);
                }
                catch (DataException dataException) {
                    this.sourceInfo[n].minInteger = this.sourceInfo[n].cachedInteger;
                    return new Integer(this.sourceInfo[n].minInteger);
                }
            }
            case 4: {
                try {
                    this.sourceInfo[n].minLong = n2 == 1 ? this.buffers[n].getLongValue(this.buffers[n].getStartIndex()) : (n2 == -1 ? this.buffers[n].getLongValue(this.buffers[n].getEndIndex()) : this.sourceInfo[n].cachedLong);
                    return new Long(this.sourceInfo[n].minLong);
                }
                catch (DataException dataException) {
                    this.sourceInfo[n].minLong = this.sourceInfo[n].cachedLong;
                    return new Long(this.sourceInfo[n].minLong);
                }
            }
            case 5: {
                try {
                    this.sourceInfo[n].minFloat = n2 == 1 ? this.buffers[n].getFloatValue(this.buffers[n].getStartIndex()) : (n2 == -1 ? this.buffers[n].getFloatValue(this.buffers[n].getEndIndex()) : this.sourceInfo[n].cachedFloat);
                    return new Float(this.sourceInfo[n].minFloat);
                }
                catch (DataException dataException) {
                    this.sourceInfo[n].minFloat = this.sourceInfo[n].cachedFloat;
                    return new Float(this.sourceInfo[n].minFloat);
                }
            }
            case 6: {
                try {
                    this.sourceInfo[n].minDouble = n2 == 1 ? this.buffers[n].getDoubleValue(this.buffers[n].getStartIndex()) : (n2 == -1 ? this.buffers[n].getDoubleValue(this.buffers[n].getEndIndex()) : this.sourceInfo[n].cachedDouble);
                    return new Double(this.sourceInfo[n].minDouble);
                }
                catch (DataException dataException) {
                    this.sourceInfo[n].minDouble = this.sourceInfo[n].cachedDouble;
                    return new Double(this.sourceInfo[n].minDouble);
                }
            }
            case 7: {
                try {
                    this.sourceInfo[n].minObject = n2 == 1 ? this.buffers[n].getObjectValue(this.buffers[n].getStartIndex()) : (n2 == -1 ? this.buffers[n].getObjectValue(this.buffers[n].getEndIndex()) : this.sourceInfo[n].cachedObject);
                    return this.sourceInfo[n].minObject;
                }
                catch (DataException dataException) {
                    this.sourceInfo[n].minObject = this.sourceInfo[n].cachedObject;
                    return this.sourceInfo[n].minObject;
                }
            }
        }
        return null;
    }

    public Object computeMax(int n) throws UnsupportedOperation {
        if (!this.sourceInfo[n].hasValue) {
            throw new UnsupportedOperation();
        }
        if (this.buffers == null || this.buffers[n] == null) {
            switch (this.sourceInfo[n].kind) {
                case 1: {
                    this.sourceInfo[n].maxByte = this.sourceInfo[n].cachedByte;
                    return new Byte(this.sourceInfo[n].maxByte);
                }
                case 2: {
                    this.sourceInfo[n].maxShort = this.sourceInfo[n].cachedShort;
                    return new Short(this.sourceInfo[n].maxShort);
                }
                case 3: {
                    this.sourceInfo[n].maxInteger = this.sourceInfo[n].cachedInteger;
                    return new Integer(this.sourceInfo[n].maxInteger);
                }
                case 4: {
                    this.sourceInfo[n].maxLong = this.sourceInfo[n].cachedLong;
                    return new Long(this.sourceInfo[n].maxLong);
                }
                case 5: {
                    this.sourceInfo[n].maxFloat = this.sourceInfo[n].cachedFloat;
                    return new Float(this.sourceInfo[n].maxFloat);
                }
                case 6: {
                    this.sourceInfo[n].maxDouble = this.sourceInfo[n].cachedDouble;
                    return new Double(this.sourceInfo[n].maxDouble);
                }
                case 7: {
                    this.sourceInfo[n].maxObject = this.sourceInfo[n].cachedObject;
                    return this.sourceInfo[n].maxObject;
                }
            }
            return null;
        }
        int n2 = this.sortedOrder(n);
        switch (this.sourceInfo[n].kind) {
            case 1: {
                try {
                    this.sourceInfo[n].maxByte = n2 == -1 ? this.buffers[n].getByteValue(this.buffers[n].getStartIndex()) : (n2 == 1 ? this.buffers[n].getByteValue(this.buffers[n].getEndIndex()) : this.sourceInfo[n].cachedByte);
                    return new Byte(this.sourceInfo[n].maxByte);
                }
                catch (DataException dataException) {
                    this.sourceInfo[n].maxByte = this.sourceInfo[n].cachedByte;
                    return new Byte(this.sourceInfo[n].maxByte);
                }
            }
            case 2: {
                try {
                    this.sourceInfo[n].maxShort = n2 == -1 ? this.buffers[n].getShortValue(this.buffers[n].getStartIndex()) : (n2 == 1 ? this.buffers[n].getShortValue(this.buffers[n].getEndIndex()) : this.sourceInfo[n].cachedShort);
                    return new Short(this.sourceInfo[n].maxShort);
                }
                catch (DataException dataException) {
                    this.sourceInfo[n].maxShort = this.sourceInfo[n].cachedShort;
                    return new Short(this.sourceInfo[n].maxShort);
                }
            }
            case 3: {
                try {
                    this.sourceInfo[n].maxInteger = n2 == -1 ? this.buffers[n].getIntegerValue(this.buffers[n].getStartIndex()) : (n2 == 1 ? this.buffers[n].getIntegerValue(this.buffers[n].getEndIndex()) : this.sourceInfo[n].cachedInteger);
                    return new Integer(this.sourceInfo[n].maxInteger);
                }
                catch (DataException dataException) {
                    this.sourceInfo[n].maxInteger = this.sourceInfo[n].cachedInteger;
                    return new Integer(this.sourceInfo[n].maxInteger);
                }
            }
            case 4: {
                try {
                    this.sourceInfo[n].maxLong = n2 == -1 ? this.buffers[n].getLongValue(this.buffers[n].getStartIndex()) : (n2 == 1 ? this.buffers[n].getLongValue(this.buffers[n].getEndIndex()) : this.sourceInfo[n].cachedLong);
                    return new Long(this.sourceInfo[n].maxLong);
                }
                catch (DataException dataException) {
                    this.sourceInfo[n].maxLong = this.sourceInfo[n].cachedLong;
                    return new Long(this.sourceInfo[n].maxLong);
                }
            }
            case 5: {
                try {
                    this.sourceInfo[n].maxFloat = n2 == -1 ? this.buffers[n].getFloatValue(this.buffers[n].getStartIndex()) : (n2 == 1 ? this.buffers[n].getFloatValue(this.buffers[n].getEndIndex()) : this.sourceInfo[n].cachedFloat);
                    return new Float(this.sourceInfo[n].maxFloat);
                }
                catch (DataException dataException) {
                    this.sourceInfo[n].maxFloat = this.sourceInfo[n].cachedFloat;
                    return new Float(this.sourceInfo[n].maxFloat);
                }
            }
            case 6: {
                try {
                    this.sourceInfo[n].maxDouble = n2 == -1 ? this.buffers[n].getDoubleValue(this.buffers[n].getStartIndex()) : (n2 == 1 ? this.buffers[n].getDoubleValue(this.buffers[n].getEndIndex()) : this.sourceInfo[n].cachedDouble);
                    return new Double(this.sourceInfo[n].maxDouble);
                }
                catch (DataException dataException) {
                    this.sourceInfo[n].maxDouble = this.sourceInfo[n].cachedDouble;
                    return new Double(this.sourceInfo[n].maxDouble);
                }
            }
            case 7: {
                try {
                    this.sourceInfo[n].maxObject = n2 == -1 ? this.buffers[n].getObjectValue(this.buffers[n].getStartIndex()) : (n2 == 1 ? this.buffers[n].getObjectValue(this.buffers[n].getEndIndex()) : this.sourceInfo[n].cachedObject);
                    return this.sourceInfo[n].maxObject;
                }
                catch (DataException dataException) {
                    this.sourceInfo[n].maxObject = this.sourceInfo[n].cachedObject;
                    return this.sourceInfo[n].maxObject;
                }
            }
        }
        return null;
    }

    public int sortedOrder(int n) {
        return 0;
    }

    public boolean isComparable(int n) {
        return false;
    }

    public long getStartIndex(int n) {
        if (this.buffers == null) {
            return this.lastIndex;
        }
        if (n < this.buffers.length && this.buffers[n] != null) {
            return this.buffers[n].getStartIndex();
        }
        return this.lastIndex;
    }

    public long getLastIndex(int n) {
        if (this.buffers == null) {
            return this.lastIndex;
        }
        if (n < this.buffers.length && this.buffers[n] != null) {
            return this.buffers[n].getEndIndex();
        }
        return this.lastIndex;
    }

    public long computeStartIndex(int n) {
        return this.getStartIndex(n);
    }

    public long computeLastIndex(int n) {
        return this.getLastIndex(n);
    }

    protected DataSource createDataSource(DataInfo dataInfo) {
        return this.createDataSource(dataInfo, 7);
    }

    protected DataSource createDataSource(DataInfo dataInfo, int n) {
        Object[] objectArray;
        int n2 = this.size();
        CollectiveDataSource collectiveDataSource = new CollectiveDataSource(this, n2);
        this.add(collectiveDataSource);
        if (this.sourceInfo == null) {
            this.sourceInfo = new SourceInfo[n2 + 1];
        } else {
            objectArray = new SourceInfo[n2 + 1];
            System.arraycopy(this.sourceInfo, 0, objectArray, 0, n2);
            this.sourceInfo = objectArray;
        }
        this.sourceInfo[n2] = new SourceInfo();
        this.sourceInfo[n2].info = dataInfo;
        this.sourceInfo[n2].kind = n;
        if (this.buffers != null) {
            objectArray = new Buffer[n2 + 1];
            System.arraycopy(this.buffers, 0, objectArray, 0, n2);
            this.buffers = objectArray;
            this.buffers[n2] = null;
        }
        this.notifyListenersForDataSourceAdded(collectiveDataSource);
        return collectiveDataSource;
    }

    protected void removeDataSource(int n) {
        int n2;
        Object object;
        DataSource dataSource = (DataSource)this.get(n);
        if (this.sourceInfo != null) {
            object = new SourceInfo[this.sourceInfo.length - 1];
            for (n2 = 0; n2 < n; ++n2) {
                object[n2] = this.sourceInfo[n2];
            }
            for (n2 = n; n2 < ((Object[])object).length; ++n2) {
                object[n2] = this.sourceInfo[n2 + 1];
            }
            this.sourceInfo = object;
        }
        if (this.buffers != null) {
            object = new Buffer[this.buffers.length - 1];
            for (n2 = 0; n2 < n; ++n2) {
                object[n2] = this.buffers[n2];
            }
            for (n2 = n; n2 < ((Object[])object).length; ++n2) {
                object[n2] = this.buffers[n2 + 1];
            }
            this.buffers = object;
        }
        this.remove(n);
        while (n < this.size()) {
            object = this.get(n);
            if (object instanceof BufferedDataSource) {
                object = ((BufferedDataSource)object).dataSource;
            }
            if (object instanceof CollectiveDataSource) {
                ((CollectiveDataSource)object).myIndex = n;
            }
            ++n;
        }
        if (dataSource instanceof BufferedDataSource) {
            dataSource = ((BufferedDataSource)dataSource).dataSource;
        }
        if (dataSource instanceof CollectiveDataSource) {
            ((CollectiveDataSource)dataSource).myIndex = -1;
        }
        this.notifyListenersForDataSourceRemoved(dataSource);
    }

    protected void removeDataSource(DataSource dataSource) {
        int n = this.indexOf(dataSource);
        if (n == -1) {
            return;
        }
        this.removeDataSource(n);
    }

    protected void changeDataSourceInfo(DataSource dataSource, DataInfo dataInfo) {
        int n = this.indexOf(dataSource);
        this.sourceInfo[n].info = dataInfo;
        dataSource.notifyListenersForInfoChange(dataInfo);
    }

    protected void changeInfo(DataInfo dataInfo) {
        this.ourInfo = dataInfo;
        this.notifyListenersForInfoChange(dataInfo);
    }

    protected void setByteValue(int n, byte by) {
        this.sourceInfo[n].currentByte = by;
    }

    protected void setShortValue(int n, short s) {
        this.sourceInfo[n].currentShort = s;
    }

    protected void setIntegerValue(int n, int n2) {
        this.sourceInfo[n].currentInteger = n2;
    }

    protected void setLongValue(int n, long l) {
        this.sourceInfo[n].currentLong = l;
    }

    protected void setFloatValue(int n, float f) {
        this.sourceInfo[n].currentFloat = f;
    }

    protected void setDoubleValue(int n, double d) {
        this.sourceInfo[n].currentDouble = d;
    }

    protected void setObjectValue(int n, Object object) {
        this.sourceInfo[n].currentObject = object;
    }

    protected void registerNewValues() {
        ++this.lastIndex;
        for (int i = 0; i < this.size(); ++i) {
            boolean bl = false;
            switch (this.sourceInfo[i].kind) {
                case 1: {
                    this.sourceInfo[i].cachedByte = this.sourceInfo[i].currentByte;
                    if (this.buffers != null && this.buffers[i] != null) {
                        try {
                            this.buffers[i].setByteValue(this.lastIndex, this.sourceInfo[i].cachedByte);
                        }
                        catch (DataException dataException) {
                            // empty catch block
                        }
                    }
                    if (!this.sourceInfo[i].hasValue) {
                        this.sourceInfo[i].hasValue = true;
                        this.sourceInfo[i].minByte = this.sourceInfo[i].maxByte = this.sourceInfo[i].cachedByte;
                        bl = true;
                        break;
                    }
                    if (this.sortedOrder(i) != 0) {
                        try {
                            this.computeMin(i);
                            this.computeMax(i);
                        }
                        catch (UnsupportedOperation unsupportedOperation) {
                            // empty catch block
                        }
                        bl = true;
                        break;
                    }
                    if (this.sourceInfo[i].cachedByte < this.sourceInfo[i].minByte) {
                        this.sourceInfo[i].minByte = this.sourceInfo[i].cachedByte;
                        bl = true;
                    }
                    if (this.sourceInfo[i].cachedByte <= this.sourceInfo[i].maxByte) break;
                    this.sourceInfo[i].maxByte = this.sourceInfo[i].cachedByte;
                    bl = true;
                    break;
                }
                case 2: {
                    this.sourceInfo[i].cachedShort = this.sourceInfo[i].currentShort;
                    if (this.buffers != null && this.buffers[i] != null) {
                        try {
                            this.buffers[i].setShortValue(this.lastIndex, this.sourceInfo[i].cachedShort);
                        }
                        catch (DataException dataException) {
                            // empty catch block
                        }
                    }
                    if (!this.sourceInfo[i].hasValue) {
                        this.sourceInfo[i].hasValue = true;
                        this.sourceInfo[i].minShort = this.sourceInfo[i].maxShort = this.sourceInfo[i].cachedShort;
                        bl = true;
                        break;
                    }
                    if (this.sortedOrder(i) != 0) {
                        try {
                            this.computeMin(i);
                            this.computeMax(i);
                        }
                        catch (UnsupportedOperation unsupportedOperation) {
                            // empty catch block
                        }
                        bl = true;
                        break;
                    }
                    if (this.sourceInfo[i].cachedShort < this.sourceInfo[i].minShort) {
                        this.sourceInfo[i].minShort = this.sourceInfo[i].cachedShort;
                        bl = true;
                    }
                    if (this.sourceInfo[i].cachedShort <= this.sourceInfo[i].maxShort) break;
                    this.sourceInfo[i].maxShort = this.sourceInfo[i].cachedShort;
                    bl = true;
                    break;
                }
                case 3: {
                    this.sourceInfo[i].cachedInteger = this.sourceInfo[i].currentInteger;
                    if (this.buffers != null && this.buffers[i] != null) {
                        try {
                            this.buffers[i].setIntegerValue(this.lastIndex, this.sourceInfo[i].cachedInteger);
                        }
                        catch (DataException dataException) {
                            // empty catch block
                        }
                    }
                    if (!this.sourceInfo[i].hasValue) {
                        this.sourceInfo[i].hasValue = true;
                        this.sourceInfo[i].minInteger = this.sourceInfo[i].maxInteger = this.sourceInfo[i].cachedInteger;
                        bl = true;
                        break;
                    }
                    if (this.sortedOrder(i) != 0) {
                        try {
                            this.computeMin(i);
                            this.computeMax(i);
                        }
                        catch (UnsupportedOperation unsupportedOperation) {
                            // empty catch block
                        }
                        bl = true;
                        break;
                    }
                    if (this.sourceInfo[i].cachedInteger < this.sourceInfo[i].minInteger) {
                        this.sourceInfo[i].minInteger = this.sourceInfo[i].cachedInteger;
                        bl = true;
                    }
                    if (this.sourceInfo[i].cachedInteger <= this.sourceInfo[i].maxInteger) break;
                    this.sourceInfo[i].maxInteger = this.sourceInfo[i].cachedInteger;
                    bl = true;
                    break;
                }
                case 4: {
                    this.sourceInfo[i].cachedLong = this.sourceInfo[i].currentLong;
                    if (this.buffers != null && this.buffers[i] != null) {
                        try {
                            this.buffers[i].setLongValue(this.lastIndex, this.sourceInfo[i].cachedLong);
                        }
                        catch (DataException dataException) {
                            // empty catch block
                        }
                    }
                    if (!this.sourceInfo[i].hasValue) {
                        this.sourceInfo[i].hasValue = true;
                        this.sourceInfo[i].minLong = this.sourceInfo[i].maxLong = this.sourceInfo[i].cachedLong;
                        bl = true;
                        break;
                    }
                    if (this.sortedOrder(i) != 0) {
                        try {
                            this.computeMin(i);
                            this.computeMax(i);
                        }
                        catch (UnsupportedOperation unsupportedOperation) {
                            // empty catch block
                        }
                        bl = true;
                        break;
                    }
                    if (this.sourceInfo[i].cachedLong < this.sourceInfo[i].minLong) {
                        this.sourceInfo[i].minLong = this.sourceInfo[i].cachedLong;
                        bl = true;
                    }
                    if (this.sourceInfo[i].cachedLong <= this.sourceInfo[i].maxLong) break;
                    this.sourceInfo[i].maxLong = this.sourceInfo[i].cachedLong;
                    bl = true;
                    break;
                }
                case 5: {
                    this.sourceInfo[i].cachedFloat = this.sourceInfo[i].currentFloat;
                    if (this.buffers != null && this.buffers[i] != null) {
                        try {
                            this.buffers[i].setFloatValue(this.lastIndex, this.sourceInfo[i].cachedFloat);
                        }
                        catch (DataException dataException) {
                            // empty catch block
                        }
                    }
                    if (!this.sourceInfo[i].hasValue) {
                        this.sourceInfo[i].hasValue = true;
                        this.sourceInfo[i].minFloat = this.sourceInfo[i].maxFloat = this.sourceInfo[i].cachedFloat;
                        bl = true;
                        break;
                    }
                    if (this.sortedOrder(i) != 0) {
                        try {
                            this.computeMin(i);
                            this.computeMax(i);
                        }
                        catch (UnsupportedOperation unsupportedOperation) {
                            // empty catch block
                        }
                        bl = true;
                        break;
                    }
                    if (this.sourceInfo[i].cachedFloat < this.sourceInfo[i].minFloat) {
                        this.sourceInfo[i].minFloat = this.sourceInfo[i].cachedFloat;
                        bl = true;
                    }
                    if (!(this.sourceInfo[i].cachedFloat > this.sourceInfo[i].maxFloat)) break;
                    this.sourceInfo[i].maxFloat = this.sourceInfo[i].cachedFloat;
                    bl = true;
                    break;
                }
                case 6: {
                    this.sourceInfo[i].cachedDouble = this.sourceInfo[i].currentDouble;
                    if (this.buffers != null && this.buffers[i] != null) {
                        try {
                            this.buffers[i].setDoubleValue(this.lastIndex, this.sourceInfo[i].cachedDouble);
                        }
                        catch (DataException dataException) {
                            // empty catch block
                        }
                    }
                    if (!this.sourceInfo[i].hasValue) {
                        this.sourceInfo[i].hasValue = true;
                        this.sourceInfo[i].minDouble = this.sourceInfo[i].maxDouble = this.sourceInfo[i].cachedDouble;
                        bl = true;
                        break;
                    }
                    if (this.sortedOrder(i) != 0) {
                        try {
                            this.computeMin(i);
                            this.computeMax(i);
                        }
                        catch (UnsupportedOperation unsupportedOperation) {
                            // empty catch block
                        }
                        bl = true;
                        break;
                    }
                    if (this.sourceInfo[i].cachedDouble < this.sourceInfo[i].minDouble) {
                        this.sourceInfo[i].minDouble = this.sourceInfo[i].cachedDouble;
                        bl = true;
                    }
                    if (!(this.sourceInfo[i].cachedDouble > this.sourceInfo[i].maxDouble)) break;
                    this.sourceInfo[i].maxDouble = this.sourceInfo[i].cachedDouble;
                    bl = true;
                    break;
                }
                case 7: {
                    this.sourceInfo[i].cachedObject = this.sourceInfo[i].currentObject;
                    if (this.buffers != null && this.buffers[i] != null) {
                        try {
                            this.buffers[i].setValue(this.lastIndex, this.sourceInfo[i].cachedObject);
                        }
                        catch (DataException dataException) {
                            // empty catch block
                        }
                    }
                    if (!this.sourceInfo[i].hasValue) {
                        this.sourceInfo[i].hasValue = true;
                        this.sourceInfo[i].minObject = this.sourceInfo[i].maxObject = this.sourceInfo[i].cachedObject;
                        bl = true;
                        break;
                    }
                    if (this.sortedOrder(i) != 0) {
                        try {
                            this.computeMin(i);
                            this.computeMax(i);
                        }
                        catch (UnsupportedOperation unsupportedOperation) {
                            // empty catch block
                        }
                        bl = true;
                        break;
                    }
                    try {
                        if (NumberStringComparator.numStringCompare(this.sourceInfo[i].cachedObject, this.sourceInfo[i].minObject) < 0) {
                            this.sourceInfo[i].minObject = this.sourceInfo[i].cachedObject;
                            bl = true;
                        }
                    }
                    catch (ClassCastException classCastException) {
                        // empty catch block
                    }
                    try {
                        if (NumberStringComparator.numStringCompare(this.sourceInfo[i].cachedObject, this.sourceInfo[i].maxObject) <= 0) break;
                        this.sourceInfo[i].maxObject = this.sourceInfo[i].cachedObject;
                        bl = true;
                        break;
                    }
                    catch (ClassCastException classCastException) {
                        // empty catch block
                    }
                }
            }
            DataSource dataSource = (DataSource)this.get(i);
            if (bl) {
                dataSource.notifyListenersForValueRangeChange();
            }
            dataSource.notifyListenersForIndexRangeChange(this.getStartIndex(i), this.getLastIndex(i));
        }
        this.notifyEndNotificationListeners();
    }

    public DataInfo getInformation() {
        return this.ourInfo;
    }

    public Object getValue(int n, long l) throws DataException {
        if (l == this.lastIndex) {
            switch (this.sourceInfo[n].kind) {
                case 1: {
                    return new Byte(this.sourceInfo[n].cachedByte);
                }
                case 2: {
                    return new Short(this.sourceInfo[n].cachedShort);
                }
                case 3: {
                    return new Integer(this.sourceInfo[n].cachedInteger);
                }
                case 4: {
                    return new Long(this.sourceInfo[n].cachedLong);
                }
                case 5: {
                    return new Float(this.sourceInfo[n].cachedFloat);
                }
                case 6: {
                    return new Double(this.sourceInfo[n].cachedDouble);
                }
            }
            return this.sourceInfo[n].cachedObject;
        }
        if (this.buffers == null || n >= this.buffers.length || this.buffers[n] == null) {
            throw new NoSuchIndex(l);
        }
        long l2 = this.buffers[n].getStartIndex();
        long l3 = this.buffers[n].getEndIndex();
        if (l < l2 || l > l3) {
            throw new NoSuchIndex(l);
        }
        return this.buffers[n].getValue(l);
    }

    public int getKind(int n) {
        return this.sourceInfo[n].kind;
    }

    public Class valueClass(int n) {
        switch (this.sourceInfo[n].kind) {
            case 1: {
                return class$java$lang$Byte == null ? (class$java$lang$Byte = DynamicDataSourceCollection.class$("java.lang.Byte")) : class$java$lang$Byte;
            }
            case 2: {
                return class$java$lang$Short == null ? (class$java$lang$Short = DynamicDataSourceCollection.class$("java.lang.Short")) : class$java$lang$Short;
            }
            case 3: {
                return class$java$lang$Integer == null ? (class$java$lang$Integer = DynamicDataSourceCollection.class$("java.lang.Integer")) : class$java$lang$Integer;
            }
            case 4: {
                return class$java$lang$Long == null ? (class$java$lang$Long = DynamicDataSourceCollection.class$("java.lang.Long")) : class$java$lang$Long;
            }
            case 5: {
                return class$java$lang$Float == null ? (class$java$lang$Float = DynamicDataSourceCollection.class$("java.lang.Float")) : class$java$lang$Float;
            }
            case 6: {
                return class$java$lang$Double == null ? (class$java$lang$Double = DynamicDataSourceCollection.class$("java.lang.Double")) : class$java$lang$Double;
            }
        }
        return class$java$lang$Object == null ? (class$java$lang$Object = DynamicDataSourceCollection.class$("java.lang.Object")) : class$java$lang$Object;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected class SourceInfo {
        public DataInfo info;
        int kind;
        boolean hasValue;
        public byte currentByte;
        public byte cachedByte;
        public byte minByte;
        public byte maxByte;
        public short currentShort;
        public short cachedShort;
        public short minShort;
        public short maxShort;
        public int currentInteger;
        public int cachedInteger;
        public int minInteger;
        public int maxInteger;
        public long currentLong;
        public long cachedLong;
        public long minLong;
        public long maxLong;
        public float currentFloat;
        public float cachedFloat;
        public float minFloat;
        public float maxFloat;
        public double currentDouble;
        public double cachedDouble;
        public double minDouble;
        public double maxDouble;
        public Object currentObject;
        public Object cachedObject;
        public Object minObject;
        public Object maxObject;

        protected SourceInfo() {
        }
    }
}

