/*
 * Decompiled with CFR 0.152.
 */
package jsynoptic.builtin;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import jsynoptic.builtin.Abstract1DShape;
import jsynoptic.builtin.TextArrayShape;
import jsynoptic.builtin.TextShape;
import jsynoptic.ui.LongAction;
import simtools.data.DataSource;
import simtools.shapes.AbstractShape;
import simtools.ui.ActionCheckBox;
import simtools.ui.NumberField;
import simtools.ui.ResourceFinder;

public class HistoryShape
extends TextArrayShape {
    static final long serialVersionUID = 5471834643284146991L;
    public static ResourceBundle resources = ResourceFinder.get(class$jsynoptic$builtin$HistoryShape == null ? (class$jsynoptic$builtin$HistoryShape = HistoryShape.class$("jsynoptic.builtin.HistoryShape")) : class$jsynoptic$builtin$HistoryShape, TextArrayShape.resources);
    static /* synthetic */ Class class$jsynoptic$builtin$HistoryShape;

    public HistoryShape() {
        this(5);
    }

    public HistoryShape(int n) {
        this(n, 100, 50);
    }

    public HistoryShape(int n, int n2, int n3) {
        this._w = n2;
        if (this._w < 40) {
            this._w = 40;
        }
        if (n3 < 20) {
            n3 = 20;
        }
        this._y = this._h = n3 * n;
        this.cells = new Vector();
        for (int i = 0; i < n; ++i) {
            HookedTextShape hookedTextShape = new HookedTextShape(resources.getString("Text"), n2, n3, false);
            hookedTextShape.setAnchor(this._ox, this._oy + (i + 1) * n3);
            this.cells.add(hookedTextShape);
        }
        if (n > 0) {
            ((HookedTextShape)this.cells.get(0)).setDelegateEndNotificationListener(this);
        }
    }

    public String[] getActions(double d, double d2, Object object, int n) {
        if (n == 3) {
            return null;
        }
        if (n == 4) {
            return null;
        }
        if (n == 5) {
            return null;
        }
        if (n == 1) {
            // empty if block
        }
        Vector<String> vector = new Vector<String>();
        vector.add(resources.getString("Properties..."));
        if (object instanceof DataSource) {
            vector.add(resources.getString("SetSource"));
        }
        return vector.toArray(new String[vector.size()]);
    }

    public boolean doAction(double d, double d2, Object object, String string) {
        if (string.equals(resources.getString("SetSource"))) {
            HookedTextShape hookedTextShape = (HookedTextShape)this.cells.get(0);
            hookedTextShape.propagate();
            hookedTextShape.setSource((DataSource)object);
            return true;
        }
        if (string.equals(resources.getString("Properties..."))) {
            new LongAction(16L, null, this){

                protected void doAction() {
                    PropertiesPanel propertiesPanel = new PropertiesPanel();
                    int n = JOptionPane.showConfirmDialog(null, propertiesPanel, resources.getString("TextProperties"), 2, -1);
                    if (n == 0) {
                        propertiesPanel.updateProperties();
                        HistoryShape.this.notifyChange();
                    }
                }
            }.start();
            return true;
        }
        return false;
    }

    public boolean canDoAction(double d, double d2, Object object, String string, int n) {
        return true;
    }

    public void notificationEnd(Object object) {
        if (this.cells.size() > 0) {
            ((HookedTextShape)this.cells.get(0)).notificationEnd(object);
        }
        Rectangle rectangle = null;
        if (this.forceSameFont) {
            rectangle = this.getBounds();
            if (this.autoresize) {
                this.adjustSize();
                rectangle.add(this.getBounds());
            } else {
                this.unifyFonts();
            }
        }
        this.notifyChange(rectangle);
    }

    protected AbstractShape cloneShape() {
        HistoryShape historyShape = (HistoryShape)super.cloneShape();
        Iterator iterator = historyShape.cells.iterator();
        while (iterator.hasNext()) {
            TextShape textShape = (TextShape)iterator.next();
            textShape.setDelegateEndNotificationListener(textShape);
        }
        if (historyShape.cells.size() > 0) {
            ((HookedTextShape)historyShape.cells.get(0)).setDelegateEndNotificationListener(historyShape);
        }
        return historyShape;
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        if (this.forceSameFont) {
            this.unifyFonts();
        }
        Iterator iterator = this.cells.iterator();
        while (iterator.hasNext()) {
            TextShape textShape = (TextShape)iterator.next();
            textShape.setDelegateEndNotificationListener(textShape);
        }
        if (this.cells.size() > 0) {
            ((HookedTextShape)this.cells.get(0)).setDelegateEndNotificationListener(this);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class PropertiesPanel
    extends JPanel {
        Abstract1DShape.PropertiesPanel textPanel;
        NumberField nfHistSize;
        ActionCheckBox cbSameFont;
        JCheckBox cbResize;

        public PropertiesPanel() {
            this.setLayout(new BorderLayout());
            Box box = Box.createVerticalBox();
            Box box2 = Box.createHorizontalBox();
            box2.add(new JLabel(resources.getString("HistorySize:")));
            this.nfHistSize = new NumberField(HistoryShape.this.cells.size(), 10);
            box2.add(this.nfHistSize);
            this.nfHistSize.setHorizontalAlignment(4);
            box.add(box2);
            Box box3 = Box.createHorizontalBox();
            this.cbSameFont = new ActionCheckBox(this, resources.getString("UseAUniqueFontForTheWholeArray"), HistoryShape.this.forceSameFont){
                private final /* synthetic */ PropertiesPanel this$1;
                {
                    this.this$1 = propertiesPanel;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$1.cbResize.setEnabled(this.this$1.cbSameFont.isSelected());
                }
            };
            box3.add(this.cbSameFont);
            box3.add(Box.createHorizontalGlue());
            box.add(box3);
            box3 = Box.createHorizontalBox();
            this.cbResize = new JCheckBox(resources.getString("AutoResize"), HistoryShape.this.autoresize);
            box3.add(this.cbResize);
            box3.add(Box.createHorizontalGlue());
            box.add(box3);
            this.cbSameFont.apply();
            this.textPanel = ((TextShape)HistoryShape.this.cells.get(0)).createPanel(false);
            box.add(this.textPanel);
            this.add((Component)box, "Center");
        }

        public void updateProperties() {
            TextShape textShape;
            int n;
            HistoryShape.this.forceSameFont = this.cbSameFont.isSelected();
            HistoryShape.this.autoresize = this.cbResize.isSelected();
            this.textPanel.updateProperties();
            int n2 = (int)this.nfHistSize.getLongValue();
            if (n2 < 1) {
                n2 = 1;
            }
            int n3 = HistoryShape.this._h / HistoryShape.this.cells.size();
            Rectangle rectangle = HistoryShape.this.getBounds();
            if (n2 > 0) {
                ((HookedTextShape)HistoryShape.this.cells.get(0)).setDelegateEndNotificationListener((HookedTextShape)HistoryShape.this.cells.get(0));
            }
            for (n = HistoryShape.this.cells.size() - 1; n >= n2; --n) {
                textShape = (TextShape)HistoryShape.this.cells.remove(n);
            }
            for (n = HistoryShape.this.cells.size(); n < n2; ++n) {
                textShape = new HookedTextShape(resources.getString("Text"), HistoryShape.this._w, n3, false);
                textShape.setAnchor(HistoryShape.this._ox, HistoryShape.this._oy + (n + 1) * n3);
                HistoryShape.this.cells.add(textShape);
            }
            if (n2 > 0) {
                ((HookedTextShape)HistoryShape.this.cells.get(0)).setDelegateEndNotificationListener(HistoryShape.this);
            }
            HistoryShape.this._h = n3 * HistoryShape.this.cells.size();
            HistoryShape.this._y = HistoryShape.this._h;
            rectangle.add(HistoryShape.this.getBounds());
            HistoryShape.this.notifyChange(rectangle);
        }
    }

    public class HookedTextShape
    extends TextShape {
        static final long serialVersionUID = 1319437895774180799L;

        public HookedTextShape(String string, int n, int n2, boolean bl) {
            super(string, n, n2, bl);
        }

        public void propagate() {
            TextShape textShape = (TextShape)HistoryShape.this.cells.lastElement();
            for (int i = HistoryShape.this.cells.size() - 1; i > 0; --i) {
                TextShape textShape2 = (TextShape)HistoryShape.this.cells.get(i - 1);
                textShape.text = textShape2.text;
                textShape.drawColor = textShape2.drawColor;
                textShape.drawDynamicColor = textShape2.drawDynamicColor;
                textShape.fillColor = textShape2.fillColor;
                textShape.fillDynamicColor = textShape2.fillDynamicColor;
                textShape.textColor = textShape2.textColor;
                textShape.textDynamicColor = textShape2.textDynamicColor;
                textShape.baseline = textShape2.baseline;
                textShape.currentFont = textShape2.currentFont;
                textShape = textShape2;
            }
        }

        public void notificationEnd(Object object) {
            this.propagate();
            super.notificationEnd(object);
        }
    }
}

