/*
 * Decompiled with CFR 0.152.
 */
package simtools.shapes;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.text.Format;
import java.util.Vector;
import simtools.data.EndNotificationListener;
import simtools.diagram.Resizable;
import simtools.shapes.AbstractShape;
import simtools.shapes.AxisShape;
import simtools.shapes.CurveShape;
import simtools.shapes.CurveShapeListener;
import simtools.shapes.LabelShape;

public class PlotShape
extends AbstractShape
implements Serializable,
Cloneable,
CurveShapeListener,
EndNotificationListener,
Resizable {
    static final long serialVersionUID = -7683803866479302545L;
    private static Font _defaultFont = new Font("TimesRoman", 0, 10);
    protected Font _font = null;
    protected Font titleFont;
    protected Color _color = null;
    protected AxisShape _asx1;
    protected AxisShape _asy1;
    protected AxisShape _asx2;
    protected AxisShape _asy2;
    protected boolean hasLegend;
    protected LabelShape title;
    protected Vector _curves;
    protected transient boolean autoUpdateX1;
    protected transient boolean autoUpdateX2;
    protected transient boolean autoUpdateY1;
    protected transient boolean autoUpdateY2;
    protected transient boolean optimize;
    protected transient int optimizeMode;
    protected transient BufferedImage image;
    protected transient Graphics2D imageGraphics;
    protected transient boolean dirty = false;

    public PlotShape(int n, int n2, int n3, int n4) {
        super(n, n2);
        this._asx1 = new AxisShape(false, true, this._ox, this._oy, n3, n4);
        this._asy1 = new AxisShape(true, true, this._ox, this._oy, n3, n4);
        this._asx2 = null;
        this._asy2 = null;
        this._curves = new Vector();
        this.hasLegend = false;
        this.title = null;
        this.setColor(Color.black);
        this.setFont(_defaultFont);
        this.titleFont = this._font.deriveFont(this._font.getSize2D() * 2.0f);
        this.autoUpdateY2 = false;
        this.autoUpdateY1 = false;
        this.autoUpdateX2 = false;
        this.autoUpdateX1 = false;
        this.optimizeMode = 0;
        this.optimize = false;
    }

    protected AbstractShape cloneShape() {
        PlotShape plotShape = null;
        try {
            plotShape = (PlotShape)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
        plotShape._asx1 = (AxisShape)plotShape._asx1.cloneShape();
        plotShape._asy1 = (AxisShape)plotShape._asy1.cloneShape();
        if (plotShape._asx2 != null) {
            plotShape._asx2 = (AxisShape)plotShape._asx2.cloneShape();
        }
        if (plotShape._asy2 != null) {
            plotShape._asy2 = (AxisShape)plotShape._asy2.cloneShape();
        }
        plotShape._curves = new Vector();
        for (int i = 0; i < this._curves.size(); ++i) {
            Object object = null;
            Curve curve = (Curve)this._curves.elementAt(i);
            object = curve.clone();
            plotShape._curves.addElement(object);
        }
        if (this.title != null) {
            plotShape.title = (LabelShape)this.title.cloneShape();
        }
        return plotShape;
    }

    public void setSecondaryAxis(boolean bl, boolean bl2) {
        if (bl) {
            if (bl2) {
                if (this._asx2 != null) {
                    return;
                }
                this._asx2 = new AxisShape(false, false, this._ox, this._oy, this._asx1._lineWidth, this._asx1._lineHeight);
            } else {
                if (this._asx2 == null) {
                    return;
                }
                this._asx2 = null;
            }
        } else if (bl2) {
            if (this._asy2 != null) {
                return;
            }
            this._asy2 = new AxisShape(true, false, this._ox, this._oy, this._asx1._lineWidth, this._asx1._lineHeight);
        } else {
            if (this._asy2 == null) {
                return;
            }
            this._asy2 = null;
        }
        this.computeBounds();
    }

    public boolean isSecondaryAxis(boolean bl) {
        if (bl) {
            return this._asx2 != null;
        }
        return this._asy2 != null;
    }

    public int getCurveNumber() {
        return this._curves.size();
    }

    public Curve getCurve(int n) {
        return (Curve)this._curves.elementAt(n);
    }

    public void insertCurve(CurveShape curveShape, boolean bl, boolean bl2, int n) {
        Curve curve = new Curve(curveShape, bl, bl2);
        if (this._curves.size() == 0) {
            this.optimizeMode = curveShape.getXSource().sortedOrder();
        } else if (this.optimizeMode != curveShape.getXSource().sortedOrder()) {
            this.optimizeMode = 0;
        }
        if (n < 0) {
            this._curves.addElement(curve);
        } else {
            this._curves.insertElementAt(curve, n);
        }
        curveShape.addListener(this);
        if (curveShape._xSource != null) {
            curveShape._xSource.addEndNotificationListener(this);
        }
        if (curveShape._ySource != null) {
            curveShape._ySource.addEndNotificationListener(this);
        }
        if (this.optimize && this.optimizeMode != 0) {
            curveShape.tryDrawNewOnly();
        }
    }

    public void insertCurve(CurveShape curveShape) {
        this.insertCurve(curveShape, false);
    }

    public void insertCurve(CurveShape curveShape, boolean bl) {
        this.insertCurve(curveShape, bl, false);
    }

    public void insertCurve(CurveShape curveShape, boolean bl, boolean bl2) {
        this.insertCurve(curveShape, bl, bl2, -1);
    }

    public void removeCurve(CurveShape curveShape) {
        int n = -2;
        for (int i = 0; i < this._curves.size(); ++i) {
            Curve curve = (Curve)this._curves.elementAt(i);
            if (curve.shape == curveShape) {
                curveShape.removeListener(this);
                if (curveShape._xSource != null) {
                    curveShape._xSource.removeEndNotificationListener(this);
                }
                if (curveShape._ySource != null) {
                    curveShape._ySource.removeEndNotificationListener(this);
                }
                this._curves.removeElementAt(i);
                continue;
            }
            if (n == -2) {
                n = curve.shape.getXSource().sortedOrder();
                continue;
            }
            if (n == curve.shape.getXSource().sortedOrder()) continue;
            n = 0;
        }
        this.optimizeMode = n;
    }

    public void setCurveColor(CurveShape curveShape, Color color) {
        for (int i = 0; i < this._curves.size(); ++i) {
            Curve curve = (Curve)this._curves.elementAt(i);
            if (curve.shape != curveShape) continue;
            curve.color = color;
        }
    }

    public void setCurveLabel(CurveShape curveShape, String string) {
        for (int i = 0; i < this._curves.size(); ++i) {
            Curve curve = (Curve)this._curves.elementAt(i);
            if (curve.shape != curveShape) continue;
            curve.setLabel(string);
        }
    }

    public void setFont(Font font) {
        if (font != this._font) {
            this._font = font;
            this._asx1.setFont(font);
            this._asy1.setFont(font);
            if (this._asx2 != null) {
                this._asx2.setFont(font);
            }
            if (this._asy2 != null) {
                this._asy2.setFont(font);
            }
            this.updateBounds();
        }
    }

    public void setTitleFont(Font font) {
        if (font != this.titleFont) {
            String string = this.getTitle();
            this.setTitle(null);
            this.titleFont = font;
            this.setTitle(string);
            this.updateBounds();
        }
    }

    public boolean isLegendVisible() {
        return this.hasLegend;
    }

    public void setLegendVisible(boolean bl) {
        this.hasLegend = bl;
    }

    public String getTitle() {
        return this.title == null ? null : this.title.getString();
    }

    public void setTitle(String string) {
        if (string == null || string.trim().equals("")) {
            if (this.title != null) {
                this.title = null;
                this.computeBounds();
            }
        } else if (this.title == null) {
            this.title = new LabelShape(string, this._ox, this._oy, 10, false);
            this.title.setBounds(this.titleFont);
            int n = this.title.getBounds().height;
            this.title.translate(this._x + this._w / 2, this._y - this._h - n);
            this.computeBounds();
        } else {
            this.title.setString(string);
            this.title.setBounds(this.titleFont);
            this.computeBounds();
        }
    }

    public void set(double d, double d2, double d3, boolean bl, boolean bl2) {
        if (bl) {
            if (bl2) {
                this.setSecondaryAxis(true, true);
                this._asx2.set(d, d2, d3);
            } else {
                this._asx1.set(d, d2, d3);
            }
        } else if (bl2) {
            this.setSecondaryAxis(false, true);
            this._asy2.set(d, d2, d3);
        } else {
            this._asy1.set(d, d2, d3);
        }
        this.updateBounds();
    }

    public void setX(double d, double d2, double d3) {
        this.set(d, d2, d3, true, false);
    }

    public void setSecondaryX(double d, double d2, double d3) {
        this.set(d, d2, d3, true, true);
    }

    public void setY(double d, double d2, double d3) {
        this.set(d, d2, d3, false, false);
    }

    public void setSecondaryY(double d, double d2, double d3) {
        this.set(d, d2, d3, false, true);
    }

    public void setLabel(String string, boolean bl, boolean bl2) {
        if (bl) {
            if (bl2) {
                if (this._asx2 != null) {
                    this._asx2.setLabel(string);
                }
            } else {
                this._asx1.setLabel(string);
            }
        } else if (bl2) {
            if (this._asy2 != null) {
                this._asy2.setLabel(string);
            }
        } else {
            this._asy1.setLabel(string);
        }
        this.updateBounds();
    }

    public void setXLabel(String string, boolean bl) {
        this.setLabel(string, true, bl);
    }

    public void setXLabel(String string) {
        this.setXLabel(string, false);
    }

    public void setYLabel(String string, boolean bl) {
        this.setLabel(string, false, bl);
    }

    public void setYLabel(String string) {
        this.setYLabel(string, false);
    }

    public void setFormat(Format format, boolean bl, boolean bl2) {
        if (bl) {
            if (bl2) {
                this._asx2.setFormat(format);
            } else {
                this._asx1.setFormat(format);
            }
        } else if (bl2) {
            this._asy2.setFormat(format);
        } else {
            this._asy1.setFormat(format);
        }
        this.updateBounds();
    }

    public void setColor(Color color) {
        if (this._color != color) {
            this._color = color;
            this._asx1.setColor(this._color);
            this._asy1.setColor(this._color);
            if (this._asx2 != null) {
                this._asx2.setColor(this._color);
            }
            if (this._asy2 != null) {
                this._asy2.setColor(this._color);
            }
        }
    }

    public void setAnchor(Point point) {
        int n = point.x - this._ox;
        int n2 = point.y - this._oy;
        this.translate(n, n2);
    }

    public void resize(int n, int n2) {
        String string = this.getTitle();
        this.setTitle(null);
        this._asx1.resize(n, n2);
        this._asy1.resize(n, n2);
        if (this._asx2 != null) {
            this._asx2.resize(n, n2);
        }
        if (this._asy2 != null) {
            this._asy2.resize(n, n2);
        }
        this.updateBounds();
        this.setTitle(string);
    }

    public void translate(int n, int n2) {
        super.translate(n, n2);
        this._asx1.translate(n, n2);
        this._asy1.translate(n, n2);
        if (this._asx2 != null) {
            this._asx2.translate(n, n2);
        }
        if (this._asy2 != null) {
            this._asy2.translate(n, n2);
        }
        if (this.title != null) {
            this.title.translate(n, n2);
        }
    }

    public void setAnchor(int n, int n2) {
        super.setAnchor(n, n2);
        this._asx1.setAnchor(n, n2);
        this._asy1.setAnchor(n, n2);
        if (this._asx2 != null) {
            this._asx2.setAnchor(n, n2);
        }
        if (this._asy2 != null) {
            this._asy2.setAnchor(n, n2);
        }
        if (this.title != null) {
            this.title.setAnchor(n, n2);
        }
    }

    public void draw(Graphics2D graphics2D) {
        Color color = graphics2D.getColor();
        if (this.optimize && this.optimizeMode != 0) {
            if (this.image == null) {
                this.image = graphics2D.getDeviceConfiguration().createCompatibleImage(this._asx1._lineWidth, this._asx1._lineHeight);
                this.imageGraphics = this.image.createGraphics();
                this.imageGraphics.setBackground(graphics2D.getBackground());
                this.imageGraphics.setColor(Color.white);
                this.imageGraphics.fillRect(0, 0, this._asx1._lineWidth, this._asx1._lineHeight);
                this.imageGraphics.translate(0, this._asx1._lineHeight);
                this.drawCurves(this.imageGraphics);
            }
            graphics2D.drawImage(this.image, null, this._ox, this._oy - this._asx1._lineHeight);
        }
        this._asx1.draw(graphics2D);
        this._asy1.draw(graphics2D);
        if (this._asx2 != null) {
            this._asx2.draw(graphics2D);
        }
        if (this._asy2 != null) {
            this._asy2.draw(graphics2D);
        }
        if (!this.optimize || this.optimizeMode == 0) {
            Stroke stroke = graphics2D.getStroke();
            Color color2 = graphics2D.getColor();
            AffineTransform affineTransform = graphics2D.getTransform();
            Shape shape = graphics2D.getClip();
            graphics2D.translate(this._ox, this._oy);
            graphics2D.setClip(0, -this._asx1._lineHeight, this._asx1._lineWidth, this._asx1._lineHeight);
            this.drawCurves(graphics2D);
            graphics2D.setTransform(affineTransform);
            graphics2D.setClip(shape);
            graphics2D.setStroke(stroke);
            graphics2D.setColor(color2);
        }
        if (this.title != null) {
            this.title.draw(graphics2D);
        }
        if (this.hasLegend) {
            this.drawLegend(graphics2D);
        }
        graphics2D.setColor(color);
    }

    public void drawLegend(Graphics2D graphics2D) {
        Point point = new Point(0, 0);
        int n = this._ox + this._asx1._lineWidth;
        int n2 = this._oy - this._asx1._lineHeight;
        for (int i = 0; i < this._curves.size(); ++i) {
            Curve curve = (Curve)this._curves.elementAt(i);
            if (curve.label == null) continue;
            graphics2D.setColor(curve.color);
            curve.label.setAnchor(point);
            curve.label.setBounds(this._font);
            Rectangle rectangle = curve.label.getBounds();
            curve.label.translate(n - rectangle.width, n2);
            curve.label.draw(graphics2D);
            n2 += rectangle.height;
        }
    }

    protected void drawCurves(Graphics2D graphics2D) {
        AxisShape axisShape = null;
        AxisShape axisShape2 = null;
        for (int i = 0; i < this._curves.size(); ++i) {
            Curve curve = (Curve)this._curves.elementAt(i);
            graphics2D.setColor(curve.color);
            axisShape = curve.secondaryXaxis ? this._asx2 : this._asx1;
            AxisShape axisShape3 = axisShape2 = curve.secondaryYaxis ? this._asy2 : this._asy1;
            if (axisShape == null) {
                axisShape = this._asx1;
            }
            if (axisShape2 == null) {
                axisShape2 = this._asy1;
            }
            curve.shape.draw(graphics2D, axisShape.getMin(), axisShape2.getMin(), axisShape.getMax(), axisShape2.getMax(), axisShape.getScale(), axisShape2.getScale());
        }
    }

    protected void computeBounds() {
        this._asx1.computeBounds();
        this._asy1.computeBounds();
        if (this._asx2 != null) {
            this._asx2.computeBounds();
        }
        if (this._asy2 != null) {
            this._asy2.computeBounds();
        }
        this.updateBounds();
    }

    protected void updateBounds() {
        Rectangle rectangle = this._asx1.getBounds();
        if (this.title != null) {
            rectangle.add(this.title.getBounds());
        }
        rectangle.add(this._asy1.getBounds());
        if (this._asx2 != null) {
            rectangle.add(this._asx2.getBounds());
        }
        if (this._asy2 != null) {
            rectangle.add(this._asy2.getBounds());
        }
        this._w = rectangle.width;
        this._h = rectangle.height;
        this._x = rectangle.x - this._ox;
        this._y = rectangle.y + this._h - this._oy;
    }

    public void shapeChanged(CurveShape curveShape) {
        this.dirty = true;
    }

    public boolean isAutoUpdateX1() {
        return this.autoUpdateX1;
    }

    public boolean isAutoUpdateX2() {
        return this.autoUpdateX2;
    }

    public boolean isAutoUpdateY1() {
        return this.autoUpdateY1;
    }

    public boolean isAutoUpdateY2() {
        return this.autoUpdateY2;
    }

    public void setAutoUpdateX1(boolean bl) {
        this.autoUpdateX1 = bl;
    }

    public void setAutoUpdateX2(boolean bl) {
        this.autoUpdateX2 = bl;
    }

    public void setAutoUpdateY1(boolean bl) {
        this.autoUpdateY1 = bl;
    }

    public void setAutoUpdateY2(boolean bl) {
        this.autoUpdateY2 = bl;
    }

    public void setAutoUpdate(boolean bl) {
        this.setAutoUpdateX1(bl);
        this.setAutoUpdateX2(bl);
        this.setAutoUpdateY1(bl);
        this.setAutoUpdateY2(bl);
    }

    public boolean isOptimize() {
        return this.optimize;
    }

    public void setOptimize(boolean bl) {
        this.optimize = bl;
    }

    public void notificationEnd(Object object) {
        if (!this.dirty) {
            return;
        }
        this.dirty = false;
        if (this.autoUpdateX1 && this._asx1 != null || this.autoUpdateX2 && this._asx2 != null || this.autoUpdateY1 && this._asy1 != null || this.autoUpdateY2 && this._asy2 != null) {
            double d = Double.MAX_VALUE;
            double d2 = -1.7976931348623157E308;
            double d3 = Double.MAX_VALUE;
            double d4 = -1.7976931348623157E308;
            double d5 = Double.MAX_VALUE;
            double d6 = -1.7976931348623157E308;
            double d7 = Double.MAX_VALUE;
            double d8 = -1.7976931348623157E308;
            for (int i = 0; i < this._curves.size(); ++i) {
                Curve curve = (Curve)this._curves.elementAt(i);
                Rectangle2D rectangle2D = curve.shape.getBounds2D();
                if (curve.secondaryXaxis) {
                    d5 = Math.min(d5, rectangle2D.getMinX());
                    d6 = Math.max(d6, rectangle2D.getMaxX());
                } else {
                    d = Math.min(d, rectangle2D.getMinX());
                    d2 = Math.max(d2, rectangle2D.getMaxX());
                }
                if (curve.secondaryYaxis) {
                    d7 = Math.min(d7, rectangle2D.getMinY());
                    d8 = Math.max(d8, rectangle2D.getMaxY());
                    continue;
                }
                d3 = Math.min(d3, rectangle2D.getMinY());
                d4 = Math.max(d4, rectangle2D.getMaxY());
            }
            if (this.autoUpdateX1 && this._asx1 != null) {
                this._asx1.set(d, d2);
            }
            if (this.autoUpdateX2 && this._asx2 != null) {
                this._asx2.set(d5, d6);
            }
            if (this.autoUpdateY1 && this._asy1 != null) {
                this._asy1.set(d3, d4);
            }
            if (this.autoUpdateY2 && this._asy2 != null) {
                this._asy1.set(d7, d8);
            }
        }
        if (this.image != null) {
            this.drawCurves(this.imageGraphics);
        }
        this.notifyChange();
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        for (int i = 0; i < this._curves.size(); ++i) {
            CurveShape curveShape = ((Curve)this._curves.elementAt((int)i)).shape;
            if (curveShape._xSource != null) {
                curveShape._xSource.addEndNotificationListener(this);
            }
            if (curveShape._ySource == null) continue;
            curveShape._ySource.addEndNotificationListener(this);
        }
    }

    public class Curve
    implements Cloneable,
    Serializable {
        public CurveShape shape;
        LabelShape label;
        public boolean secondaryXaxis;
        public boolean secondaryYaxis;
        public Color color;

        public Curve(CurveShape curveShape, boolean bl, boolean bl2) {
            this.shape = curveShape;
            this.label = null;
            this.secondaryXaxis = bl;
            this.secondaryYaxis = bl2;
            this.color = Color.black;
        }

        public Object clone() {
            Curve curve = null;
            try {
                curve = (Curve)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                return null;
            }
            if (curve.label != null) {
                curve.label = (LabelShape)curve.label.cloneShape();
            }
            try {
                curve.shape = (CurveShape)this.shape.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                curve.shape = this.shape;
            }
            if (curve.shape != null) {
                curve.shape.addListener(PlotShape.this);
                curve.shape._xSource.addEndNotificationListener(PlotShape.this);
                curve.shape._ySource.addEndNotificationListener(PlotShape.this);
            }
            return curve;
        }

        public void setLabel(String string) {
            if (string == null || string.trim().equals("")) {
                if (this.label != null) {
                    this.label = null;
                }
            } else if (this.label == null) {
                this.label = new LabelShape(string, 0, 0, 9, false);
            } else {
                this.label.setString(string);
            }
        }

        public String getLabel() {
            if (this.label == null) {
                return null;
            }
            return this.label.getString();
        }

        public String toString() {
            if (this.label == null) {
                return "";
            }
            return this.label.getString();
        }
    }
}

