/*
 * Decompiled with CFR 0.152.
 */
package simtools.shapes;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.NoSuchElementException;
import simtools.data.DataException;
import simtools.data.DataInfo;
import simtools.data.DataSource;
import simtools.data.DataSourceListener;
import simtools.data.DataSourcePool;
import simtools.data.NoSuchIndex;
import simtools.data.UnsupportedOperation;
import simtools.shapes.CurveShapeListener;
import simtools.util.ListenerManager;

public class CurveShape
implements Shape,
Cloneable,
Serializable,
DataSourceListener {
    static final long serialVersionUID = 3969204429218131993L;
    static final int MAXSTEPS = 4000;
    protected transient DataSource _xSource = null;
    protected transient DataSource _ySource = null;
    protected long _min = -1L;
    protected long _max = -1L;
    protected transient double _orgx;
    protected transient double _orgy;
    protected transient double _maxx;
    protected transient double _maxy;
    protected transient double _scalex;
    protected transient double _scaley;
    protected transient boolean useCache = false;
    protected transient double[] xCache;
    protected transient double[] yCache;
    protected transient ListenerManager listeners = new ListenerManager();
    protected boolean drawNewOnly = false;
    protected transient long iteratorMinIndex = -1L;
    protected transient long iteratorMaxIndex = -1L;
    protected transient boolean xSourceChanged = false;
    protected transient boolean ySourceChanged = false;
    protected transient long xSourceNewStartIndex = -1L;
    protected transient long xSourceNewLastIndex = -1L;
    protected transient long ySourceNewStartIndex = -1L;
    protected transient long ySourceNewLastIndex = -1L;
    protected transient long lastDrawnIndex;
    protected AffineTransform _aff;
    private static double[] drawOnlyCurrentValue = new double[4];

    public CurveShape() {
        this.xCache = new double[8000];
        this.yCache = new double[8000];
    }

    public CurveShape(DataSource dataSource, DataSource dataSource2) {
        this();
        this.setData(dataSource, dataSource2);
    }

    public void setData(DataSource dataSource, DataSource dataSource2) {
        if (this._xSource != null) {
            this._xSource.removeListener(this);
        }
        if (this._ySource != null) {
            this._ySource.removeListener(this);
        }
        this._xSource = dataSource;
        this._ySource = dataSource2;
        this._xSource.addListener(this);
        this._ySource.addListener(this);
        this.useCache = false;
    }

    public DataSource getXSource() {
        return this._xSource;
    }

    public DataSource getYSource() {
        return this._ySource;
    }

    public void setSlice(long l, long l2) {
        if (this._min != l || this._max != l2) {
            this.useCache = false;
        }
        this._min = l;
        this._max = l2;
        this._xSource.setSlice(l, l2);
        this._ySource.setSlice(l, l2);
    }

    public boolean contains(double d, double d2) {
        return this.getBounds2D().contains(d, d2);
    }

    public boolean contains(double d, double d2, double d3, double d4) {
        return this.getBounds2D().contains(d, d2, d3, d4);
    }

    public boolean contains(Point2D point2D) {
        return this.getBounds2D().contains(point2D);
    }

    public boolean contains(Rectangle2D rectangle2D) {
        return this.contains(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    public boolean intersects(double d, double d2, double d3, double d4) {
        return this.getBounds2D().intersects(d, d2, d3, d4);
    }

    public boolean intersects(Rectangle2D rectangle2D) {
        return this.getBounds2D().intersects(rectangle2D);
    }

    public Rectangle getBounds() {
        Rectangle rectangle = new Rectangle();
        rectangle.setRect(this.getBounds2D());
        return rectangle;
    }

    public Rectangle2D getBounds2D() {
        if (this._ySource == null || this._xSource == null) {
            return new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
        }
        try {
            return new Rectangle2D.Double(this._xSource.getDoubleMin(), this._ySource.getDoubleMin(), this._xSource.getDoubleMax() - this._xSource.getDoubleMin(), this._ySource.getDoubleMax() - this._ySource.getDoubleMin());
        }
        catch (UnsupportedOperation unsupportedOperation) {
        }
        catch (DataException dataException) {
            // empty catch block
        }
        return new Rectangle2D.Double(-8.988465674311579E307, -8.988465674311579E307, Double.MAX_VALUE, Double.MAX_VALUE);
    }

    public void draw(Graphics2D graphics2D, double d, double d2, double d3, double d4, double d5, double d6) {
        if (this._orgx != d || this._orgy != d2 || this._maxx != d3 || this._maxy != d4 || this._scalex != d5 || this._scaley != d6) {
            this.useCache = false;
        }
        this._orgx = d;
        this._orgy = d2;
        this._maxx = d3;
        this._maxy = d4;
        this._scalex = d5;
        this._scaley = d6;
        graphics2D.draw(this);
    }

    public PathIterator getPathIterator(AffineTransform affineTransform) {
        if (this._ySource == null || this._xSource == null) {
            return new NoDrawIterator();
        }
        return new CurveIterator(affineTransform, this._orgx, this._orgy, this._maxx, this._maxy, this._scalex, this._scaley);
    }

    public PathIterator getPathIterator(AffineTransform affineTransform, double d) {
        if (this._ySource == null || this._xSource == null) {
            return new NoDrawIterator();
        }
        return new CurveIterator(affineTransform, this._orgx, this._orgy, this._maxx, this._maxy, this._scalex, this._scaley);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        DataSourcePool.global.writeDataSource(objectOutputStream, this._xSource);
        DataSourcePool.global.writeDataSource(objectOutputStream, this._ySource);
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        this.xCache = new double[8000];
        this.yCache = new double[8000];
        this.useCache = false;
        this.iteratorMinIndex = -1L;
        this.iteratorMaxIndex = -1L;
        this._xSource = DataSourcePool.global.readDataSource(objectInputStream);
        this._ySource = DataSourcePool.global.readDataSource(objectInputStream);
        this._xSource.addListener(this);
        this._ySource.addListener(this);
        if (this._min != -1L) {
            try {
                long l = this._xSource.getStartIndex();
                if (l > this._min) {
                    this._min = l;
                }
                if ((l = this._ySource.getStartIndex()) > this._min) {
                    this._min = l;
                }
            }
            catch (UnsupportedOperation unsupportedOperation) {
                this._min = -1L;
            }
        }
        if (this._max != -1L) {
            try {
                long l = this._xSource.getLastIndex();
                if (l < this._max) {
                    this._max = l;
                }
                if ((l = this._ySource.getLastIndex()) < this._max) {
                    this._max = l;
                }
            }
            catch (UnsupportedOperation unsupportedOperation) {
                this._max = -1L;
            }
        }
        if (this._min != -1L && this._max != -1L) {
            this._xSource.setSlice(this._min, this._max);
            this._ySource.setSlice(this._min, this._max);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        CurveShape curveShape = (CurveShape)super.clone();
        curveShape.listeners = new ListenerManager();
        curveShape._xSource.addListener(curveShape);
        curveShape._ySource.addListener(curveShape);
        return curveShape;
    }

    public void DataSourceValueChanged(DataSource dataSource, long l, long l2) {
        if (this._min != -1L && this._min > l2) {
            return;
        }
        if (this._max != -1L && this._max < l) {
            return;
        }
        this.notifyChange();
    }

    public void DataSourceIndexRangeChanged(DataSource dataSource, long l, long l2) {
        if (dataSource.equals(this._xSource)) {
            this.xSourceChanged = true;
            this.xSourceNewStartIndex = l;
            this.xSourceNewLastIndex = l2;
        } else if (dataSource.equals(this._ySource)) {
            this.ySourceChanged = true;
            this.ySourceNewStartIndex = l;
            this.ySourceNewLastIndex = l2;
        } else {
            return;
        }
        if (!this.xSourceChanged || !this.ySourceChanged) {
            return;
        }
        long l3 = Math.max(this.xSourceNewStartIndex, this.ySourceNewStartIndex);
        long l4 = Math.min(this.xSourceNewLastIndex, this.ySourceNewLastIndex);
        if (l3 == this._min && l4 == this._max) {
            return;
        }
        if (this._min != -1L) {
            this._min = l3;
        }
        if (this._max != -1L) {
            this._max = l4;
        }
        if (this.drawNewOnly) {
            this.iteratorMinIndex = this.lastDrawnIndex;
            this.iteratorMaxIndex = l4;
        }
        this.notifyChange();
    }

    public void DataSourceInfoChanged(DataSource dataSource, DataInfo dataInfo) {
    }

    public void DataSourceValueRangeChanged(DataSource dataSource) {
        this.notifyChange();
    }

    public void DataSourceOrderChanged(DataSource dataSource, int n) {
        this.notifyChange();
    }

    public void addListener(CurveShapeListener curveShapeListener) {
        this.listeners.add(curveShapeListener);
    }

    public void removeListener(CurveShapeListener curveShapeListener) {
        this.listeners.remove(curveShapeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyChange() {
        ListenerManager listenerManager = this.listeners;
        synchronized (listenerManager) {
            int n = this.listeners.size();
            for (int i = 0; i < n; ++i) {
                CurveShapeListener curveShapeListener = (CurveShapeListener)this.listeners.get(i);
                if (curveShapeListener == null) continue;
                curveShapeListener.shapeChanged(this);
            }
        }
        this.useCache = false;
    }

    public boolean isDrawNewOnly() {
        return this.drawNewOnly;
    }

    public boolean tryDrawNewOnly() {
        this.drawNewOnly = this._xSource.sortedOrder() != 0;
        return this.drawNewOnly;
    }

    public Rectangle2D getDrawNewOnlyArea() {
        if (this._xSource.sortedOrder() == 0 || this.iteratorMinIndex == -1L || this.iteratorMinIndex == -1L) {
            return this.getBounds();
        }
        try {
            CurveShape.drawOnlyCurrentValue[0] = (this._xSource.getDoubleValue(this.iteratorMinIndex) - this._orgx) * this._scalex;
            CurveShape.drawOnlyCurrentValue[1] = (this._orgy - this._ySource.getDoubleValue(this.iteratorMinIndex)) * this._scaley;
            CurveShape.drawOnlyCurrentValue[2] = (this._xSource.getDoubleValue(this.iteratorMaxIndex) - this._orgx) * this._scalex;
            CurveShape.drawOnlyCurrentValue[3] = (this._orgy - this._ySource.getDoubleValue(this.iteratorMaxIndex)) * this._scaley;
        }
        catch (DataException dataException) {
            return null;
        }
        if (this._aff != null) {
            this._aff.transform(drawOnlyCurrentValue, 0, drawOnlyCurrentValue, 0, 2);
        }
        double d = Math.min(drawOnlyCurrentValue[0], drawOnlyCurrentValue[2]);
        double d2 = Math.min(drawOnlyCurrentValue[1], drawOnlyCurrentValue[3]);
        double d3 = Math.max(drawOnlyCurrentValue[0], drawOnlyCurrentValue[2]) - d;
        double d4 = Math.max(drawOnlyCurrentValue[1], drawOnlyCurrentValue[3]) - d2;
        return new Rectangle2D.Double(d, d2, d3, d4);
    }

    public class CurveIterator
    implements PathIterator {
        long _index;
        long _maxi;
        long _mini;
        long _indexStep;
        double _ox;
        double _oy;
        double _sx;
        double _sy;
        double _mx;
        double _my;
        double[] currentValue;
        boolean valuesAlreadyComputed;
        boolean odd;
        double optimizedValue;
        boolean firstPoint;
        int iCache;
        boolean _useCache;

        public CurveIterator(AffineTransform affineTransform, double d, double d2, double d3, double d4, double d5, double d6) {
            long l;
            long l2;
            CurveShape.this._aff = affineTransform;
            this._ox = d;
            this._oy = d2;
            this._mx = d3;
            this._my = d4;
            this._sx = d5;
            this._sy = d6;
            this.odd = true;
            this.iCache = 0;
            if (CurveShape.this.iteratorMinIndex != -1L) {
                this._mini = this._index = CurveShape.this.iteratorMinIndex;
            } else {
                try {
                    l2 = CurveShape.this._xSource.getStartIndex();
                    l = CurveShape.this._ySource.getStartIndex();
                    this._index = l2 > l ? l2 : l;
                    this._mini = this._index;
                    if (CurveShape.this._min > this._mini) {
                        this._mini = this._index = CurveShape.this._min;
                    }
                }
                catch (UnsupportedOperation unsupportedOperation) {
                    this._mini = 0L;
                    this._index = 0L;
                }
            }
            if (CurveShape.this.iteratorMaxIndex != -1L) {
                this._maxi = CurveShape.this.iteratorMaxIndex;
            } else {
                try {
                    l2 = CurveShape.this._xSource.getLastIndex();
                    l = CurveShape.this._ySource.getLastIndex();
                    long l3 = this._maxi = l2 < l ? l2 : l;
                    if (CurveShape.this._max >= 0L && CurveShape.this._max < this._maxi) {
                        this._maxi = CurveShape.this._max;
                    }
                }
                catch (UnsupportedOperation unsupportedOperation) {
                    this._maxi = -1L;
                }
            }
            if (CurveShape.this._xSource.sortedOrder() != 0 && this._maxi > this._mini) {
                try {
                    double d7 = CurveShape.this._xSource.getDoubleValue(this._mini);
                    double d8 = CurveShape.this._xSource.getDoubleValue(this._maxi);
                    double d9 = (d8 - d7) / (double)(this._maxi - this._mini);
                    if (d9 > 0.0) {
                        long l4;
                        if (d7 < this._ox && (l4 = (long)((this._ox - d7) / d9) + this._mini - 400L) > this._mini && l4 < this._maxi && CurveShape.this._xSource.getDoubleValue(l4) <= this._ox) {
                            this._mini = l4;
                        }
                        if (d8 > this._mx && (l4 = this._maxi - (long)((d8 - this._mx) / d9) + 400L) > this._mini && l4 < this._maxi && CurveShape.this._xSource.getDoubleValue(l4) >= this._mx) {
                            this._maxi = l4;
                        }
                    } else if (d9 < 0.0) {
                        long l5;
                        if (d8 < this._ox && (l5 = (long)((this._ox - d8) / d9) + this._mini - 400L) > this._mini && l5 < this._maxi && CurveShape.this._xSource.getDoubleValue(l5) <= this._ox) {
                            this._mini = l5;
                        }
                        if (d7 > this._mx && (l5 = this._maxi - (long)((d7 - this._mx) / d9) + 400L) > this._mini && l5 < this._maxi && CurveShape.this._xSource.getDoubleValue(l5) >= this._mx) {
                            this._maxi = l5;
                        }
                    }
                }
                catch (DataException dataException) {
                    // empty catch block
                }
            }
            this._indexStep = 1L;
            if (this._maxi != -1L && this._mini != -1L && this._maxi - this._mini > 4000L) {
                this._indexStep = (this._maxi - this._mini) / 4000L;
                if (this._indexStep < 4L) {
                    this._indexStep = 1L;
                }
            }
            this.currentValue = new double[2];
            this.valuesAlreadyComputed = false;
            this.firstPoint = true;
        }

        protected boolean updateValues() {
            if (!this.valuesAlreadyComputed) {
                try {
                    this.currentValue[0] = (CurveShape.this._xSource.getDoubleValue(this._index) - this._ox) * this._sx;
                    this.currentValue[1] = (this._oy - CurveShape.this._ySource.getDoubleValue(this._index)) * this._sy;
                    if (CurveShape.this._aff != null) {
                        CurveShape.this._aff.transform(this.currentValue, 0, this.currentValue, 0, 1);
                    }
                    this.valuesAlreadyComputed = true;
                }
                catch (NoSuchIndex noSuchIndex) {
                    this.valuesAlreadyComputed = false;
                }
                catch (DataException dataException) {
                    dataException.printStackTrace();
                    throw new NoSuchElementException(dataException.toString());
                }
            }
            return this.valuesAlreadyComputed;
        }

        public int currentSegment() {
            if (this._maxi != -1L && this._index > this._maxi) {
                this.firstPoint = true;
                return 0;
            }
            if (!this.updateValues()) {
                this.firstPoint = true;
                return 0;
            }
            if (this.currentValue[0] != this.currentValue[0] || this.currentValue[1] != this.currentValue[1]) {
                this.firstPoint = true;
                return 0;
            }
            if (this.firstPoint) {
                this.firstPoint = false;
                return 0;
            }
            return 1;
        }

        public int currentSegment(double[] dArray) {
            int n = this.currentSegment();
            dArray[0] = this.currentValue[0];
            dArray[1] = this.currentValue[1];
            return n;
        }

        public int currentSegment(float[] fArray) {
            int n = this.currentSegment();
            fArray[0] = (float)this.currentValue[0];
            fArray[1] = (float)this.currentValue[1];
            return n;
        }

        public int getWindingRule() {
            return 1;
        }

        public boolean isDone() {
            if (this._maxi != -1L) {
                return this._index > this._maxi;
            }
            return !this.updateValues();
        }

        /*
         * Unable to fully structure code
         */
        public void next() {
            CurveShape.this.lastDrawnIndex = this._index++;
            if (this._indexStep > 1L) {
                ++this.iCache;
                if (CurveShape.this.useCache) {
                    this.currentValue[0] = CurveShape.this.xCache[this.iCache];
                    this.currentValue[1] = CurveShape.this.yCache[this.iCache];
                    if (CurveShape.this._aff != null) {
                        CurveShape.this._aff.transform(this.currentValue, 0, this.currentValue, 0, 1);
                    }
                    this._index += this._indexStep;
                } else {
                    var1_1 = this._index + this._indexStep;
                    v0 = this.odd = this.odd == false;
                    if (var1_1 <= this._maxi) {
                        if (this.odd) {
                            try {
                                var5_7 = var3_2 = CurveShape.this._ySource.getDoubleValue(this._index);
                                for (var9_8 = this._index + 1L; var9_8 < var1_1; ++var9_8) {
                                    var7_9 = CurveShape.this._ySource.getDoubleValue(var9_8);
                                    if (var7_9 < var3_2) {
                                        var3_2 = var7_9;
                                    }
                                    if (!(var7_9 > var5_7)) continue;
                                    var5_7 = var7_9;
                                }
                                if (CurveShape.this._ySource.sortedOrder() >= 0) {
                                    var7_9 = var3_2;
                                    this.optimizedValue = var5_7;
                                } else {
                                    var7_9 = var5_7;
                                    this.optimizedValue = var3_2;
                                }
                                this.currentValue[0] = (CurveShape.this._xSource.getDoubleValue(this._index) - this._ox) * this._sx;
                                this.currentValue[1] = (this._oy - var7_9) * this._sy;
                                CurveShape.this.xCache[this.iCache] = this.currentValue[0];
                                CurveShape.this.yCache[this.iCache] = this.currentValue[1];
                                if (CurveShape.this._aff == null) ** GOTO lbl64
                                CurveShape.this._aff.transform(this.currentValue, 0, this.currentValue, 0, 1);
                            }
                            catch (NoSuchIndex var3_3) {
                            }
                            catch (DataException var3_4) {
                                var3_4.printStackTrace();
                                throw new NoSuchElementException(var3_4.toString());
                            }
                        } else {
                            try {
                                this.currentValue[0] = (CurveShape.this._xSource.getDoubleValue(this._index) - this._ox) * this._sx;
                            }
                            catch (DataException var3_5) {
                                var3_5.printStackTrace();
                                throw new NoSuchElementException(var3_5.toString());
                            }
                            this.currentValue[1] = (this._oy - this.optimizedValue) * this._sy;
                            CurveShape.this.xCache[this.iCache] = this.currentValue[0];
                            CurveShape.this.yCache[this.iCache] = this.currentValue[1];
                            if (CurveShape.this._aff != null) {
                                CurveShape.this._aff.transform(this.currentValue, 0, this.currentValue, 0, 1);
                            }
                        }
                    } else {
                        try {
                            this.currentValue[0] = (CurveShape.this._xSource.getDoubleValue(this._maxi) - this._ox) * this._sx;
                            this.currentValue[1] = (this._oy - CurveShape.this._ySource.getDoubleValue(this._maxi)) * this._sy;
                            CurveShape.this.xCache[this.iCache] = this.currentValue[0];
                            CurveShape.this.yCache[this.iCache] = this.currentValue[1];
                            CurveShape.this.useCache = true;
                        }
                        catch (DataException var3_6) {
                            var3_6.printStackTrace();
                            throw new NoSuchElementException(var3_6.toString());
                        }
                    }
lbl64:
                    // 5 sources

                    this._index = var1_1;
                }
                this.valuesAlreadyComputed = true;
            } else {
                this.valuesAlreadyComputed = false;
            }
        }
    }

    public class NoDrawIterator
    implements PathIterator {
        public int currentSegment(double[] dArray) {
            dArray[0] = 0.0;
            dArray[1] = 0.0;
            return 0;
        }

        public int currentSegment(float[] fArray) {
            fArray[0] = 0.0f;
            fArray[1] = 0.0f;
            return 0;
        }

        public int getWindingRule() {
            return 1;
        }

        public boolean isDone() {
            return true;
        }

        public void next() {
        }
    }
}

