/*
 * Decompiled with CFR 0.152.
 */
package simtools.data;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import simtools.data.DataInfo;
import simtools.data.DataSource;
import simtools.data.DataSourceCollection;
import simtools.data.DataSourceCollectionListener;
import simtools.data.DataSourcePoolEvent;
import simtools.data.DataSourcePoolListener;
import simtools.data.DataSourceProvider;
import simtools.data.DuplicateIdException;
import simtools.data.buffer.Buffer;
import simtools.data.buffer.BufferedDataSource;
import simtools.util.ListenerManager;

public class DataSourcePool
implements DataSourceCollectionListener {
    public static final DataSourcePool global = new DataSourcePool();
    protected ListenerManager listeners = new ListenerManager();
    protected Vector providers = new Vector();
    protected NotifySet sources = new NotifySet();
    protected NotifySet collections = new NotifySet();
    protected Hashtable translations = new Hashtable();
    protected boolean notification;
    static /* synthetic */ Class class$simtools$data$DataSourcePool$SourceDependenciesMarker;
    static /* synthetic */ Class class$simtools$data$DataSourcePool$BufferMarker;
    static /* synthetic */ Class class$simtools$data$DataSourcePool$DataSourceCollectionMarker;

    public DataSourcePool() {
        this.setNotify(true);
    }

    public void addListener(DataSourcePoolListener dataSourcePoolListener) {
        this.listeners.add(dataSourcePoolListener);
    }

    public void removeListener(DataSourcePoolListener dataSourcePoolListener) {
        this.listeners.remove(dataSourcePoolListener);
    }

    public void addProvider(DataSourceProvider dataSourceProvider) {
        this.providers.add(0, dataSourceProvider);
    }

    public DataSourceProvider getProviderFor(DataSource dataSource, DataSourceCollection dataSourceCollection) {
        Object object = null;
        Iterator iterator = this.providers.iterator();
        while (iterator.hasNext()) {
            DataSourceProvider dataSourceProvider = (DataSourceProvider)iterator.next();
            object = dataSourceProvider.getOptionalInformation(dataSource, dataSourceCollection);
            if (object == null) continue;
            return dataSourceProvider;
        }
        return null;
    }

    public boolean removeProvider(DataSourceProvider dataSourceProvider) {
        return this.providers.remove(dataSourceProvider);
    }

    public void addDataSource(DataSource dataSource) {
        this.sources.add(dataSource);
    }

    public void addDataSourceCollection(DataSourceCollection dataSourceCollection) {
        this.collections.add(dataSourceCollection);
        dataSourceCollection.addListener(this);
    }

    public boolean removeDataSource(DataSource dataSource) {
        return this.sources.remove(dataSource);
    }

    public boolean removeDataSourceCollection(DataSourceCollection dataSourceCollection) {
        dataSourceCollection.removeListener(this);
        return this.collections.remove(dataSourceCollection);
    }

    public Set dataSourceCollections() {
        return this.collections;
    }

    public Set dataSources() {
        return this.sources;
    }

    public DataSource bufferize(DataSource dataSource, Buffer buffer) {
        if (dataSource instanceof BufferedDataSource) {
            return dataSource;
        }
        buffer.setProvider(dataSource);
        this.setNotify(false);
        if (this.sources.remove(dataSource)) {
            BufferedDataSource bufferedDataSource = new BufferedDataSource(buffer);
            this.sources.add(bufferedDataSource);
            this.setNotify(true);
            this.notifyListeners(4, bufferedDataSource, dataSource);
            return bufferedDataSource;
        }
        this.setNotify(true);
        Iterator iterator = this.collections.iterator();
        while (iterator.hasNext()) {
            int n;
            DataSourceCollection dataSourceCollection = (DataSourceCollection)iterator.next();
            if (!dataSourceCollection.contains(dataSource) || (n = dataSourceCollection.indexOf(dataSource)) == -1) continue;
            try {
                dataSourceCollection.bufferize(n, buffer);
                this.notifyListeners(4, dataSourceCollection, dataSourceCollection);
                return (DataSource)dataSourceCollection.get(n);
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    public DataSourceCollection bufferize(DataSourceCollection dataSourceCollection, Buffer buffer) {
        buffer.setProvider(null);
        Iterator iterator = this.collections.iterator();
        while (iterator.hasNext()) {
            DataSourceCollection dataSourceCollection2 = (DataSourceCollection)iterator.next();
            if (dataSourceCollection2 != dataSourceCollection) continue;
            try {
                dataSourceCollection2.bufferize(buffer);
                this.notifyListeners(4, dataSourceCollection2, dataSourceCollection);
                return dataSourceCollection2;
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    public boolean contains(DataSource dataSource) {
        if (this.sources.contains(dataSource)) {
            return true;
        }
        Iterator iterator = this.collections.iterator();
        while (iterator.hasNext()) {
            if (!((DataSourceCollection)iterator.next()).contains(dataSource)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(DataSourceCollection dataSourceCollection) {
        return this.collections.contains(dataSourceCollection);
    }

    public DataSource getDataSourceWithId(String string) throws DuplicateIdException {
        Object object;
        if (string == null) {
            return null;
        }
        Vector<DataSource> vector = new Vector<DataSource>();
        try {
            object = this.lookForId(this.sources, string);
            if (object != null) {
                vector.add((DataSource)object);
            }
        }
        catch (DuplicateIdException duplicateIdException) {
            vector.addAll(duplicateIdException.conflicts);
        }
        object = this.collections.iterator();
        while (object.hasNext()) {
            DataSource dataSource = this.lookForId((DataSourceCollection)object.next(), string);
            if (dataSource == null) continue;
            vector.add(dataSource);
        }
        if (vector.size() == 0) {
            return null;
        }
        if (vector.size() == 1) {
            return (DataSource)vector.get(0);
        }
        throw new DuplicateIdException(string, vector);
    }

    private DataSource lookForId(Collection collection, String string) throws DuplicateIdException {
        if (string == null) {
            return null;
        }
        Vector<DataSource> vector = new Vector<DataSource>();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            DataSource dataSource = (DataSource)iterator.next();
            if (!string.equals(DataInfo.getId(dataSource))) continue;
            vector.add(dataSource);
        }
        if (vector.size() == 0) {
            return null;
        }
        if (vector.size() == 1) {
            return (DataSource)vector.get(0);
        }
        throw new DuplicateIdException(string, vector);
    }

    public DataSourceCollection getDataSourceCollectionWithId(String string) throws DuplicateIdException {
        if (string == null) {
            return null;
        }
        Vector<DataSourceCollection> vector = new Vector<DataSourceCollection>();
        Iterator iterator = this.collections.iterator();
        while (iterator.hasNext()) {
            DataSourceCollection dataSourceCollection = (DataSourceCollection)iterator.next();
            if (!string.equals(DataInfo.getId(dataSourceCollection))) continue;
            vector.add(dataSourceCollection);
        }
        if (vector.size() == 0) {
            return null;
        }
        if (vector.size() == 1) {
            return (DataSourceCollection)vector.get(0);
        }
        throw new DuplicateIdException(string, vector);
    }

    public DataSourceCollection getCollectionForDataSourceId(String string) throws DuplicateIdException {
        if (string == null) {
            return null;
        }
        Vector<DataSourceCollection> vector = new Vector<DataSourceCollection>();
        Iterator iterator = this.collections.iterator();
        while (iterator.hasNext()) {
            DataSourceCollection dataSourceCollection = (DataSourceCollection)iterator.next();
            try {
                if (this.lookForId(dataSourceCollection, string) == null) {
                    continue;
                }
            }
            catch (DuplicateIdException duplicateIdException) {
                // empty catch block
            }
            vector.add(dataSourceCollection);
        }
        if (vector.size() == 0) {
            return null;
        }
        if (vector.size() == 1) {
            return (DataSourceCollection)vector.get(0);
        }
        throw new DuplicateIdException(string, vector);
    }

    public DataSource provide(String string, String string2, Object object, boolean bl) {
        DataSourcePool dataSourcePool = bl ? this : null;
        Iterator iterator = this.providers.iterator();
        while (iterator.hasNext()) {
            DataSource dataSource = ((DataSourceProvider)iterator.next()).provide(string, string2, object, dataSourcePool);
            if (dataSource == null) continue;
            return dataSource;
        }
        return null;
    }

    public void writeDataSource(ObjectOutputStream objectOutputStream, DataSource dataSource) throws IOException {
        Object object;
        boolean bl = false;
        DataSourceCollection dataSourceCollection = null;
        if (dataSource == null) {
            objectOutputStream.writeObject(null);
            return;
        }
        if (this.sources.contains(dataSource)) {
            bl = true;
        } else {
            object = this.collections.iterator();
            while (object.hasNext()) {
                dataSourceCollection = (DataSourceCollection)object.next();
                if (!dataSourceCollection.contains(dataSource)) continue;
                bl = true;
                break;
            }
        }
        if (!bl) {
            objectOutputStream.writeObject(null);
            return;
        }
        object = DataInfo.getId(dataSource);
        objectOutputStream.writeObject(object);
        if (object == null) {
            return;
        }
        DataSource[] dataSourceArray = dataSource.getSourceDependencies();
        if (dataSourceArray != null) {
            objectOutputStream.writeObject(class$simtools$data$DataSourcePool$SourceDependenciesMarker == null ? (class$simtools$data$DataSourcePool$SourceDependenciesMarker = DataSourcePool.class$("simtools.data.DataSourcePool$SourceDependenciesMarker")) : class$simtools$data$DataSourcePool$SourceDependenciesMarker);
            objectOutputStream.writeInt(dataSourceArray.length);
            for (int i = 0; i < dataSourceArray.length; ++i) {
                this.writeDataSource(objectOutputStream, dataSourceArray[i]);
            }
        }
        if (dataSource instanceof BufferedDataSource) {
            objectOutputStream.writeObject(class$simtools$data$DataSourcePool$BufferMarker == null ? (class$simtools$data$DataSourcePool$BufferMarker = DataSourcePool.class$("simtools.data.DataSourcePool$BufferMarker")) : class$simtools$data$DataSourcePool$BufferMarker);
            objectOutputStream.writeObject(((BufferedDataSource)dataSource).getBuffer());
        }
        if (dataSourceCollection != null) {
            objectOutputStream.writeObject(class$simtools$data$DataSourcePool$DataSourceCollectionMarker == null ? (class$simtools$data$DataSourcePool$DataSourceCollectionMarker = DataSourcePool.class$("simtools.data.DataSourcePool$DataSourceCollectionMarker")) : class$simtools$data$DataSourcePool$DataSourceCollectionMarker);
            objectOutputStream.writeObject(DataInfo.getId(dataSourceCollection));
        }
        Object object2 = null;
        Iterator iterator = this.providers.iterator();
        while (iterator.hasNext() && (object2 = ((DataSourceProvider)iterator.next()).getOptionalInformation(dataSource, dataSourceCollection)) == null) {
        }
        objectOutputStream.writeObject(object2);
    }

    protected DataSourceCollection getTranslateCollection(String string) {
        DataSourceCollection dataSourceCollection = (DataSourceCollection)this.translations.get(string);
        if (dataSourceCollection != null) {
            return dataSourceCollection;
        }
        try {
            return this.getDataSourceCollectionWithId(string);
        }
        catch (DuplicateIdException duplicateIdException) {
            return null;
        }
    }

    protected void setTranslateCollection(String string, DataSource dataSource) {
        if (string == null || dataSource == null) {
            return;
        }
        DataSourceCollection dataSourceCollection = null;
        Iterator iterator = this.collections.iterator();
        while (iterator.hasNext()) {
            DataSourceCollection dataSourceCollection2 = (DataSourceCollection)iterator.next();
            if (!dataSourceCollection2.contains(dataSource)) continue;
            dataSourceCollection = dataSourceCollection2;
            break;
        }
        if (dataSourceCollection == null) {
            return;
        }
        this.translations.put(string, dataSourceCollection);
    }

    public DataSource readDataSource(ObjectInputStream objectInputStream) throws IOException {
        Object object = null;
        try {
            object = objectInputStream.readObject();
            if (object == null) {
                return null;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        String string = (String)object;
        Object object2 = null;
        try {
            object2 = objectInputStream.readObject();
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if ((class$simtools$data$DataSourcePool$SourceDependenciesMarker == null ? (class$simtools$data$DataSourcePool$SourceDependenciesMarker = DataSourcePool.class$("simtools.data.DataSourcePool$SourceDependenciesMarker")) : class$simtools$data$DataSourcePool$SourceDependenciesMarker).equals(object2)) {
            int n = objectInputStream.readInt();
            for (int i = 0; i < n; ++i) {
                this.readDataSource(objectInputStream);
            }
            try {
                object2 = objectInputStream.readObject();
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        Buffer buffer = null;
        if ((class$simtools$data$DataSourcePool$BufferMarker == null ? (class$simtools$data$DataSourcePool$BufferMarker = DataSourcePool.class$("simtools.data.DataSourcePool$BufferMarker")) : class$simtools$data$DataSourcePool$BufferMarker).equals(object2)) {
            try {
                buffer = (Buffer)objectInputStream.readObject();
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            try {
                object2 = objectInputStream.readObject();
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        String string2 = null;
        if ((class$simtools$data$DataSourcePool$DataSourceCollectionMarker == null ? (class$simtools$data$DataSourcePool$DataSourceCollectionMarker = DataSourcePool.class$("simtools.data.DataSourcePool$DataSourceCollectionMarker")) : class$simtools$data$DataSourcePool$DataSourceCollectionMarker).equals(object2)) {
            try {
                string2 = (String)objectInputStream.readObject();
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            try {
                object2 = objectInputStream.readObject();
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        DataSourceCollection dataSourceCollection = string2 != null ? this.getTranslateCollection(string2) : null;
        DataSource dataSource = null;
        if (dataSourceCollection != null) {
            try {
                dataSource = this.lookForId(dataSourceCollection, string);
            }
            catch (DuplicateIdException duplicateIdException) {}
        } else if (string2 == null) {
            try {
                dataSource = this.getDataSourceWithId(string);
            }
            catch (DuplicateIdException duplicateIdException) {
                // empty catch block
            }
        }
        if (dataSource != null) {
            if (buffer != null && !(dataSource instanceof BufferedDataSource)) {
                return this.bufferize(dataSource, buffer);
            }
            return dataSource;
        }
        DataSource dataSource2 = this.provide(string, string2, object2, true);
        if (dataSource2 == null) {
            return null;
        }
        this.setTranslateCollection(string2, dataSource2);
        if (buffer != null) {
            return this.bufferize(dataSource2, buffer);
        }
        return dataSource2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyListeners(int n, Object object, Object object2) {
        if (!this.notification) {
            return;
        }
        DataSourcePoolEvent dataSourcePoolEvent = object instanceof DataSource ? new DataSourcePoolEvent(this, n, (DataSource)object, (DataSource)object2) : new DataSourcePoolEvent(this, n, (DataSourceCollection)object, (DataSourceCollection)object2);
        ListenerManager listenerManager = this.listeners;
        synchronized (listenerManager) {
            int n2 = this.listeners.size();
            for (int i = 0; i < n2; ++i) {
                DataSourcePoolListener dataSourcePoolListener = (DataSourcePoolListener)this.listeners.get(i);
                if (dataSourcePoolListener == null) continue;
                dataSourcePoolListener.dataSourcePoolNotification(dataSourcePoolEvent);
            }
        }
    }

    protected void setNotify(boolean bl) {
        this.notification = bl;
    }

    public void DataSourceCollectionInfoChanged(DataSourceCollection dataSourceCollection, DataInfo dataInfo) {
        this.notifyListeners(20, dataSourceCollection, dataSourceCollection);
    }

    public void DataSourceCollectionDataSourceAdded(DataSourceCollection dataSourceCollection, DataSource dataSource) {
        this.notifyListeners(20, dataSourceCollection, dataSourceCollection);
    }

    public void DataSourceCollectionDataSourceRemoved(DataSourceCollection dataSourceCollection, DataSource dataSource) {
        this.notifyListeners(20, dataSourceCollection, dataSourceCollection);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected class NotifySet
    extends HashSet {
        protected NotifySet() {
        }

        public boolean add(Object object) {
            boolean bl = super.add(object);
            if (bl) {
                DataSourcePool.this.notifyListeners(1, object, null);
            }
            return bl;
        }

        public boolean remove(Object object) {
            boolean bl = super.remove(object);
            if (bl) {
                if (object instanceof DataSourceCollection) {
                    DataSourcePool.this.translations.remove(DataInfo.getId((DataSourceCollection)object));
                }
                DataSourcePool.this.notifyListeners(2, object, null);
            }
            return bl;
        }
    }

    protected static final class SourceDependenciesMarker
    implements Serializable {
        static final long serialVersionUID = 4581013092140237821L;

        protected SourceDependenciesMarker() {
        }
    }

    protected static final class DataSourceCollectionMarker
    implements Serializable {
        static final long serialVersionUID = 8302914329862128731L;

        protected DataSourceCollectionMarker() {
        }
    }

    protected static final class BufferMarker
    implements Serializable {
        static final long serialVersionUID = 6047866471365207251L;

        protected BufferMarker() {
        }
    }
}

