/*
 * Decompiled with CFR 0.152.
 */
package jsynoptic.builtin;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ResourceBundle;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jsynoptic.data.DataSourceAnimator;
import simtools.data.DataException;
import simtools.data.DataInfo;
import simtools.data.DataSource;
import simtools.data.NoSuchIndex;
import simtools.data.UnsupportedOperation;
import simtools.ui.ActionCheckBox;
import simtools.ui.BasicMessageWriter;
import simtools.ui.ResourceFinder;
import simtools.util.NumberStringComparator;

public class RangeSource
extends DataSource {
    public static final String ID_PREFIX = "RangeSource:";
    public static ResourceBundle resources = ResourceFinder.get(class$jsynoptic$builtin$RangeSource == null ? (class$jsynoptic$builtin$RangeSource = RangeSource.class$("jsynoptic.builtin.RangeSource")) : class$jsynoptic$builtin$RangeSource);
    public static BasicMessageWriter messages = ResourceFinder.getMessages(class$jsynoptic$builtin$RangeSource == null ? (class$jsynoptic$builtin$RangeSource = RangeSource.class$("jsynoptic.builtin.RangeSource")) : class$jsynoptic$builtin$RangeSource);
    protected double dminValue;
    protected double dmaxValue;
    protected double dstep;
    protected long lminValue;
    protected long lmaxValue;
    protected long lstep;
    int kind;
    protected DataInfo info;
    static /* synthetic */ Class class$jsynoptic$builtin$RangeSource;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Object;

    public int getKind() {
        return this.kind;
    }

    public DataInfo getInformation() {
        return this.info;
    }

    public RangeSource(String string, double d, double d2, double d3) {
        this.dminValue = d;
        this.dmaxValue = d2;
        this.dstep = d3;
        this.kind = 6;
        this.info = new DataInfo(string, ID_PREFIX + string);
        Object[] objectArray = new Object[]{new Double(d), new Double(d2), new Double(d3)};
        this.info.comment = messages.printNargs("commentDouble", objectArray);
    }

    public RangeSource(String string, long l, long l2, long l3) {
        this.lminValue = l;
        this.lmaxValue = l2;
        this.lstep = l3;
        this.kind = 4;
        this.info = new DataInfo(string, ID_PREFIX + string);
        Object[] objectArray = new Object[]{new Long(l), new Long(l2), new Long(l3)};
        this.info.comment = messages.printNargs("commentLong", objectArray);
    }

    public Object getValue(long l) throws DataException {
        if (this.kind == 6) {
            return new Double(this.getDoubleValue(l));
        }
        return new Double(this.getLongValue(l));
    }

    public double getDoubleValue(long l) throws DataException {
        if (this.kind == 4) {
            return this.getLongValue(l);
        }
        double d = this.dminValue + (double)l * this.dstep;
        if (this.dstep > 0.0 && d > this.dmaxValue) {
            throw new NoSuchIndex(l);
        }
        if (this.dstep < 0.0 && d < this.dmaxValue) {
            throw new NoSuchIndex(l);
        }
        return d;
    }

    public long getLongValue(long l) throws DataException {
        if (this.kind == 6) {
            return (long)this.getDoubleValue(l);
        }
        long l2 = this.lminValue + l * this.lstep;
        if (this.lstep > 0L && l2 > this.lmaxValue) {
            throw new NoSuchIndex(l);
        }
        if (this.lstep < 0L && l2 < this.lmaxValue) {
            throw new NoSuchIndex(l);
        }
        return l2;
    }

    public long computeLastIndex() throws UnsupportedOperation {
        return this.getLastIndex();
    }

    public long computeStartIndex() throws UnsupportedOperation {
        return 0L;
    }

    public long getLastIndex() throws UnsupportedOperation {
        if (this.kind == 6) {
            return this.dstep == 0.0 ? Long.MAX_VALUE : (long)((this.dmaxValue - this.dminValue) / this.dstep);
        }
        return this.lstep == 0L ? Long.MAX_VALUE : (this.lmaxValue - this.lminValue) / this.lstep;
    }

    public long getStartIndex() throws UnsupportedOperation {
        return 0L;
    }

    public Object computeMax() {
        return this.getMax();
    }

    public Object computeMin() {
        return this.getMin();
    }

    public double getDoubleMax() {
        if (this.kind == 4) {
            return this.lmaxValue;
        }
        return this.dmaxValue;
    }

    public double getDoubleMin() {
        if (this.kind == 4) {
            return this.lminValue;
        }
        return this.dminValue;
    }

    public long getLongMax() {
        if (this.kind == 6) {
            return (long)this.dmaxValue;
        }
        return this.lmaxValue;
    }

    public long getLongMin() {
        if (this.kind == 6) {
            return (long)this.dminValue;
        }
        return this.lminValue;
    }

    public Object getMax() {
        if (this.kind == 6) {
            return new Double(this.getDoubleMax());
        }
        return new Long(this.getLongMax());
    }

    public Object getMin() {
        if (this.kind == 6) {
            return new Double(this.getDoubleMin());
        }
        return new Long(this.getLongMin());
    }

    public Number getStep() {
        if (this.kind == 6) {
            return new Double(this.dstep);
        }
        return new Long(this.lstep);
    }

    public boolean isComparable() {
        return true;
    }

    public int sortedOrder() {
        if (this.kind == 4) {
            if (this.lminValue < this.lmaxValue) {
                return 1;
            }
            if (this.lmaxValue < this.lminValue) {
                return -1;
            }
        } else if (this.kind == 6) {
            if (this.dminValue < this.dmaxValue) {
                return 1;
            }
            if (this.dmaxValue < this.dminValue) {
                return -1;
            }
        }
        return 0;
    }

    public Class valueClass() {
        if (this.kind == 4) {
            return class$java$lang$Long == null ? (class$java$lang$Long = RangeSource.class$("java.lang.Long")) : class$java$lang$Long;
        }
        if (this.kind == 6) {
            return class$java$lang$Double == null ? (class$java$lang$Double = RangeSource.class$("java.lang.Double")) : class$java$lang$Double;
        }
        return class$java$lang$Object == null ? (class$java$lang$Object = RangeSource.class$("java.lang.Object")) : class$java$lang$Object;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class OptionPanel
    extends JPanel {
        protected JRadioButton rbStatic;
        protected JRadioButton rbDynamic;
        protected JTextField tfMin;
        protected JTextField tfMax;
        protected JTextField tfStep;
        protected JTextField tfSize;
        protected JTextField tfPeriod;
        protected JLabel bufferLabel;
        protected JTextField tfInit;
        protected JTextField tfDynaStep;
        protected ActionCheckBox cbDynaEnd;
        protected JTextField tfDynaStop;

        public OptionPanel() {
            this.setLayout(new BoxLayout(this, 1));
            Box box = Box.createHorizontalBox();
            this.rbStatic = new JRadioButton(resources.getString("static"), true);
            box.add(this.rbStatic);
            box.add(Box.createHorizontalGlue());
            this.add(box);
            box = Box.createHorizontalBox();
            this.rbDynamic = new JRadioButton(resources.getString("dynamic"), false);
            box.add(this.rbDynamic);
            box.add(Box.createHorizontalGlue());
            this.add(box);
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this.rbStatic);
            buttonGroup.add(this.rbDynamic);
            JPanel jPanel = new JPanel(new CardLayout());
            Box box2 = Box.createVerticalBox();
            box = Box.createHorizontalBox();
            box.add(new JLabel(" "));
            box2.add(box);
            box = Box.createHorizontalBox();
            box.add(new JLabel(resources.getString("min")));
            box.add(Box.createHorizontalGlue());
            this.tfMin = new JTextField();
            box.add(this.tfMin);
            box2.add(box);
            box = Box.createHorizontalBox();
            box.add(new JLabel(resources.getString("max")));
            box.add(Box.createHorizontalGlue());
            this.tfMax = new JTextField();
            box.add(this.tfMax);
            box2.add(box);
            box = Box.createHorizontalBox();
            box.add(new JLabel(resources.getString("step")));
            box.add(Box.createHorizontalGlue());
            this.tfStep = new JTextField();
            box.add(this.tfStep);
            box2.add(box);
            box = Box.createHorizontalBox();
            box.add(new JLabel(" "));
            box2.add(box);
            jPanel.add((Component)box2, "s");
            box2 = Box.createVerticalBox();
            box = Box.createHorizontalBox();
            box.add(new JLabel(resources.getString("initValue")));
            box.add(Box.createHorizontalGlue());
            this.tfInit = new JTextField();
            box.add(this.tfInit);
            box2.add(box);
            box = Box.createHorizontalBox();
            box.add(new JLabel(resources.getString("step")));
            box.add(Box.createHorizontalGlue());
            this.tfDynaStep = new JTextField();
            box.add(this.tfDynaStep);
            box2.add(box);
            box = Box.createHorizontalBox();
            this.cbDynaEnd = new ActionCheckBox(this, resources.getString("stopValue"), false){
                private final /* synthetic */ OptionPanel this$0;
                {
                    this.this$0 = optionPanel;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$0.tfDynaStop.setEnabled(this.this$0.cbDynaEnd.isSelected());
                    this.this$0.tfDynaStop.setEditable(this.this$0.cbDynaEnd.isSelected());
                }
            };
            box.add(this.cbDynaEnd);
            box.add(Box.createHorizontalGlue());
            this.tfDynaStop = new JTextField();
            box.add(this.tfDynaStop);
            box2.add(box);
            this.cbDynaEnd.apply();
            box = Box.createHorizontalBox();
            this.bufferLabel = new JLabel(resources.getString("dynamicBufferLabel"));
            box.add(this.bufferLabel);
            box.add(Box.createHorizontalGlue());
            this.tfSize = new JTextField();
            box.add(this.tfSize);
            this.tfSize.setText("100");
            box2.add(box);
            box = Box.createHorizontalBox();
            this.bufferLabel = new JLabel(resources.getString("period"));
            box.add(this.bufferLabel);
            box.add(Box.createHorizontalGlue());
            this.tfPeriod = new JTextField();
            box.add(this.tfPeriod);
            this.tfPeriod.setText("1000");
            box2.add(box);
            jPanel.add((Component)box2, "d");
            this.add(jPanel);
            this.rbDynamic.addChangeListener(new ChangeListener(this, jPanel){
                private final /* synthetic */ JPanel val$cardPane;
                private final /* synthetic */ OptionPanel this$0;
                {
                    this.this$0 = optionPanel;
                    this.val$cardPane = jPanel;
                }

                public void stateChanged(ChangeEvent changeEvent) {
                    ((CardLayout)this.val$cardPane.getLayout()).show(this.val$cardPane, this.this$0.rbDynamic.isSelected() ? "d" : "s");
                }
            });
        }

        public DataSource createSource(String string) {
            DataSource dataSource;
            if (this.rbDynamic.isSelected()) {
                Number number;
                Number number2 = NumberStringComparator.stringToNumber(this.tfInit.getText());
                if (number2 == null) {
                    number2 = new Long(0L);
                }
                if ((number = NumberStringComparator.stringToNumber(this.tfDynaStep.getText())) == null) {
                    number = new Long(1L);
                }
                Number number3 = this.cbDynaEnd.isSelected() ? (Number)NumberStringComparator.stringToNumber(this.tfDynaStop.getText()) : (Number)null;
                boolean bl = number2 instanceof Long && number instanceof Long && (number3 == null || number3 instanceof Long);
                Number number4 = NumberStringComparator.stringToNumber(this.tfSize.getText());
                Number number5 = NumberStringComparator.stringToNumber(this.tfPeriod.getText());
                if (number4 == null) {
                    number4 = new Long(0L);
                }
                if (bl) {
                    long l;
                    long l2 = number.longValue();
                    long l3 = number3 != null ? number3.longValue() : (l = l2 > 0L ? Long.MAX_VALUE : Long.MIN_VALUE);
                    dataSource = number5 == null ? new DataSourceAnimator(new RangeSource(string, number2.longValue(), l, l2), number4.intValue()) : new DataSourceAnimator(new RangeSource(string, number2.longValue(), l, l2), number4.intValue(), (long)number5.intValue());
                } else {
                    double d;
                    double d2 = number.doubleValue();
                    double d3 = number3 != null ? number3.doubleValue() : (d = d2 > 0.0 ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY);
                    dataSource = number5 == null ? new DataSourceAnimator(new RangeSource(string, number2.doubleValue(), d, d2), number4.intValue()) : new DataSourceAnimator(new RangeSource(string, number2.doubleValue(), d, d2), number4.intValue(), (long)number5.intValue());
                }
            } else {
                Number number;
                Number number6;
                Number number7 = NumberStringComparator.stringToNumber(this.tfMin.getText());
                if (number7 == null) {
                    number7 = new Long(0L);
                }
                if ((number6 = NumberStringComparator.stringToNumber(this.tfMax.getText())) == null) {
                    number6 = new Long(0L);
                }
                if ((number = NumberStringComparator.stringToNumber(this.tfStep.getText())) == null) {
                    number = new Long(1L);
                }
                boolean bl = number7 instanceof Long && number6 instanceof Long && number instanceof Long;
                dataSource = bl ? new RangeSource(string, number7.longValue(), number6.longValue(), number.longValue()) : new RangeSource(string, number7.doubleValue(), number6.doubleValue(), number.doubleValue());
            }
            return dataSource;
        }
    }
}

