/*
 * Decompiled with CFR 0.152.
 */
package jsynoptic.builtin;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jsynoptic.base.ContextualActionProvider;
import jsynoptic.base.Linkable;
import jsynoptic.ui.JSynoptic;
import jsynoptic.ui.LongAction;
import simtools.data.DataException;
import simtools.data.DataInfo;
import simtools.data.DataSource;
import simtools.data.DataSourceCollection;
import simtools.data.DataSourcePool;
import simtools.data.UnsupportedOperation;
import simtools.shapes.AbstractShape;
import simtools.shapes.AxisLabelFormatter;
import simtools.shapes.CurveShape;
import simtools.shapes.PlotShape;
import simtools.ui.CustomizedLocale;
import simtools.ui.MenuResourceBundle;

public class Plot
extends PlotShape
implements ContextualActionProvider,
Linkable {
    static final long serialVersionUID = 4941787241403275071L;
    protected String link;
    protected static MenuResourceBundle resources;
    static Color[] defaultPalette;
    protected int paletteIndex = 0;
    protected transient DataSource primaryX = null;
    protected transient DataSource secondaryX = null;
    protected Vector primaryCurves = null;
    protected Vector secondaryCurves = null;
    protected boolean isPrimaryBounded;
    protected long primaryStartIndex;
    protected long primaryEndIndex;
    protected boolean isSecondaryBounded;
    protected long secondaryStartIndex;
    protected long secondaryEndIndex;
    protected double pxmin;
    protected double pxmax;
    protected double pxstep;
    protected String pxlabel;
    protected double pymin;
    protected double pymax;
    protected double pystep;
    protected String pylabel;
    protected double sxmin;
    protected double sxmax;
    protected double sxstep;
    protected String sxlabel;
    protected double symin;
    protected double symax;
    protected double systep;
    protected String sylabel;
    protected boolean pxvaluesOK = false;
    protected boolean pyvaluesOK = false;
    protected boolean sxvaluesOK = false;
    protected boolean syvaluesOK = false;
    protected transient double zoomX;
    protected transient double zoomY;
    protected transient int zoomState = 0;
    protected transient Vector zoomHistory = new Vector();
    protected transient PlotPropertiesDialog propertiesDialog = null;
    protected transient boolean isNotifying = true;

    public String getLink() {
        return this.link;
    }

    public void setLink(String string) {
        this.link = string;
    }

    public Plot(int n, int n2, int n3, int n4) {
        super(n, n2, n3, n4);
        this.setAutoUpdate(true);
    }

    protected AbstractShape cloneShape() {
        Plot plot = (Plot)super.cloneShape();
        plot.propertiesDialog = null;
        if (this.primaryCurves != null) {
            plot.primaryCurves = (Vector)this.primaryCurves.clone();
        }
        if (this.secondaryCurves != null) {
            plot.secondaryCurves = (Vector)this.secondaryCurves.clone();
        }
        return plot;
    }

    public boolean setPrimaryX(DataSource dataSource, boolean bl) {
        return this.setX(dataSource, true, false, bl);
    }

    public boolean setPrimaryXRange(DataSource dataSource, boolean bl) {
        return this.setX(dataSource, true, true, bl);
    }

    public boolean addPrimaryY(DataSource dataSource, boolean bl) {
        return this.addY(dataSource, true, true, bl);
    }

    public boolean setSecondaryX(DataSource dataSource, boolean bl) {
        return this.setX(dataSource, false, false, bl);
    }

    public boolean setSecondaryXRange(DataSource dataSource, boolean bl) {
        return this.setX(dataSource, false, true, bl);
    }

    public boolean addSecondaryY(DataSource dataSource, boolean bl) {
        return this.addY(dataSource, false, true, bl);
    }

    public boolean addSecondaryYForSecondaryX(DataSource dataSource, boolean bl) {
        return this.addY(dataSource, false, false, bl);
    }

    public boolean addPrimaryYForSecondaryX(DataSource dataSource, boolean bl) {
        return this.addY(dataSource, true, false, bl);
    }

    protected boolean setX(DataSource dataSource, boolean bl, boolean bl2, boolean bl3) {
        if (dataSource == null) {
            return false;
        }
        new LongAction(24L, new Object[]{dataSource, new Boolean(bl), new Boolean(bl2), new Boolean(bl3)}, new Object[]{dataSource, this}){

            protected void doAction() {
                CurveShape curveShape;
                Object object;
                Object[] objectArray = (Object[])this.param;
                DataSource dataSource = (DataSource)objectArray[0];
                boolean bl = (Boolean)objectArray[1];
                boolean bl2 = (Boolean)objectArray[2];
                boolean bl3 = (Boolean)objectArray[3];
                Rectangle rectangle = Plot.this.getBounds();
                if (bl2) {
                    object = new SetRangeDialog(dataSource);
                    ((SetRangeDialog)object).getAnswer();
                    if (((SetRangeDialog)object).status <= 0) {
                        return;
                    }
                    if (((SetRangeDialog)object).status == 1) {
                        if (bl) {
                            Plot.this.isPrimaryBounded = true;
                            Plot.this.primaryStartIndex = ((SetRangeDialog)object).istart;
                            Plot.this.primaryEndIndex = ((SetRangeDialog)object).iend;
                        } else {
                            Plot.this.isSecondaryBounded = true;
                            Plot.this.secondaryStartIndex = ((SetRangeDialog)object).istart;
                            Plot.this.secondaryEndIndex = ((SetRangeDialog)object).iend;
                        }
                    } else if (bl) {
                        Plot.this.isPrimaryBounded = false;
                    } else {
                        Plot.this.isSecondaryBounded = false;
                    }
                } else {
                    try {
                        long l = dataSource.computeStartIndex();
                        long l2 = dataSource.computeLastIndex();
                        if (bl) {
                            Plot.this.isPrimaryBounded = true;
                            Plot.this.primaryStartIndex = l;
                            Plot.this.primaryEndIndex = l2;
                        } else {
                            Plot.this.isSecondaryBounded = true;
                            Plot.this.secondaryStartIndex = l;
                            Plot.this.secondaryEndIndex = l2;
                        }
                    }
                    catch (UnsupportedOperation unsupportedOperation) {
                        if (bl) {
                            Plot.this.isPrimaryBounded = false;
                        }
                        Plot.this.isSecondaryBounded = false;
                    }
                }
                String string = DataInfo.getLabel(dataSource);
                if (bl) {
                    object = Plot.this.primaryX;
                    Plot.this.primaryX = dataSource;
                    Plot.this.pxlabel = string;
                } else {
                    Plot.this.setSecondaryAxis(true, true);
                    object = Plot.this.secondaryX;
                    Plot.this.secondaryX = dataSource;
                    Plot.this.sxlabel = string;
                }
                if (Plot.this.primaryCurves != null) {
                    Iterator iterator = Plot.this.primaryCurves.iterator();
                    while (iterator.hasNext()) {
                        curveShape = (CurveShape)iterator.next();
                        if (curveShape.getXSource() != object) continue;
                        curveShape.setData(dataSource, curveShape.getYSource());
                        if (!Plot.this.isPrimaryBounded) continue;
                        curveShape.setSlice(Plot.this.primaryStartIndex, Plot.this.primaryEndIndex);
                    }
                }
                if (Plot.this.secondaryCurves != null) {
                    Iterator iterator = Plot.this.secondaryCurves.iterator();
                    while (iterator.hasNext()) {
                        curveShape = (CurveShape)iterator.next();
                        if (curveShape.getXSource() != object) continue;
                        curveShape.setData(dataSource, curveShape.getYSource());
                        if (!Plot.this.isSecondaryBounded) continue;
                        curveShape.setSlice(Plot.this.secondaryStartIndex, Plot.this.secondaryEndIndex);
                    }
                }
                Plot.this.repaintDiagram(rectangle);
            }
        }.start(bl3);
        return !bl3;
    }

    protected boolean addY(DataSource dataSource, boolean bl, boolean bl2, boolean bl3) {
        if (dataSource == null) {
            return false;
        }
        new LongAction(24L, new Object[]{dataSource, new Boolean(bl), new Boolean(bl2), new Boolean(bl3)}, new Object[]{dataSource, this}){

            protected void doAction() {
                CurveShape curveShape;
                Object[] objectArray = (Object[])this.param;
                DataSource dataSource = (DataSource)objectArray[0];
                boolean bl = (Boolean)objectArray[1];
                boolean bl2 = (Boolean)objectArray[2];
                boolean bl3 = (Boolean)objectArray[3];
                Rectangle rectangle = Plot.this.getBounds();
                if (bl2) {
                    curveShape = new CurveShape(Plot.this.primaryX, dataSource);
                    if (Plot.this.isPrimaryBounded) {
                        curveShape.setSlice(Plot.this.primaryStartIndex, Plot.this.primaryEndIndex);
                    }
                } else {
                    curveShape = new CurveShape(Plot.this.secondaryX, dataSource);
                    if (Plot.this.isSecondaryBounded) {
                        curveShape.setSlice(Plot.this.secondaryStartIndex, Plot.this.secondaryEndIndex);
                    }
                }
                String string = DataInfo.getLabel(dataSource);
                if (bl) {
                    if (Plot.this.primaryCurves == null) {
                        Plot.this.primaryCurves = new Vector();
                    }
                    Plot.this.primaryCurves.add(curveShape);
                    if (Plot.this.primaryCurves.size() == 1 && Plot.this.pylabel == null) {
                        Plot.this.pylabel = string;
                    }
                    if (Plot.this.primaryCurves.size() == 2 && Plot.this.pylabel != null && Plot.this.pylabel.equals(DataInfo.getLabel(((CurveShape)Plot.this.primaryCurves.get(0)).getYSource()))) {
                        Plot.this.pylabel = null;
                    }
                    Plot.this.insertCurve(curveShape, !bl2, false);
                } else {
                    Plot.this.setSecondaryAxis(false, true);
                    if (Plot.this.secondaryCurves == null) {
                        Plot.this.secondaryCurves = new Vector();
                    }
                    Plot.this.secondaryCurves.add(curveShape);
                    if (Plot.this.secondaryCurves.size() == 1 && Plot.this.sylabel == null) {
                        Plot.this.sylabel = string;
                    }
                    if (Plot.this.secondaryCurves.size() == 2 && Plot.this.sylabel != null && Plot.this.sylabel.equals(DataInfo.getLabel(((CurveShape)Plot.this.secondaryCurves.get(0)).getYSource()))) {
                        Plot.this.sylabel = null;
                    }
                    Plot.this.insertCurve(curveShape, !bl2, true);
                }
                if (Plot.this._curves.size() > 0) {
                    Plot.this.setLegendVisible(true);
                }
                Plot.this.setCurveLabel(curveShape, string);
                Plot.this.setCurveColor(curveShape, defaultPalette[Plot.this.paletteIndex++]);
                if (Plot.this.paletteIndex >= defaultPalette.length) {
                    Plot.this.paletteIndex = 0;
                }
                Plot.this.repaintDiagram(rectangle);
            }
        }.start(bl3);
        return !bl3;
    }

    protected double computeStep(double d, double d2) {
        double d3 = Math.abs(d2 - d);
        double d4 = d3 / 9.0;
        double d5 = Math.log(10.0);
        double d6 = Math.floor(Math.log(d4 / 0.75) / d5);
        double d7 = Math.exp(d6 * d5);
        double d8 = d4 / d7;
        int n = 2;
        if (d8 < 1.5) {
            n = 1;
        } else if (d8 >= 3.5) {
            n = 5;
        }
        double d9 = (double)n * d7;
        return Math.rint(d9 * 1000000.0) / 1000000.0;
    }

    protected void repaintDiagram(Rectangle rectangle) {
        double d;
        double d2;
        int n;
        int n2;
        if (!this.pxvaluesOK && this.primaryX != null) {
            try {
                if (this.isPrimaryBounded) {
                    n2 = this.primaryX.sortedOrder();
                    if (n2 == 1) {
                        this.pxmin = this.primaryX.getDoubleValue(this.primaryStartIndex);
                        this.pxmax = this.primaryX.getDoubleValue(this.primaryEndIndex);
                    } else if (n2 == -1) {
                        this.pxmin = this.primaryX.getDoubleValue(this.primaryEndIndex);
                        this.pxmax = this.primaryX.getDoubleValue(this.primaryStartIndex);
                    } else {
                        this.pxmin = this.primaryX.getDoubleMin();
                        this.pxmax = this.primaryX.getDoubleMax();
                    }
                } else {
                    this.pxmin = this.primaryX.getDoubleMin();
                    this.pxmax = this.primaryX.getDoubleMax();
                }
                this.pxstep = this.computeStep(this.pxmin, this.pxmax);
                this.pxmin = Math.floor(this.pxmin / this.pxstep) * this.pxstep;
                this.pxmax = Math.ceil(this.pxmax / this.pxstep) * this.pxstep;
                this.pxvaluesOK = true;
            }
            catch (UnsupportedOperation unsupportedOperation) {
            }
            catch (DataException dataException) {
                // empty catch block
            }
        }
        if (!this.sxvaluesOK && this.secondaryX != null) {
            try {
                if (this.isSecondaryBounded) {
                    n2 = this.secondaryX.sortedOrder();
                    if (n2 == 1) {
                        this.sxmin = this.secondaryX.getDoubleValue(this.secondaryStartIndex);
                        this.sxmax = this.secondaryX.getDoubleValue(this.secondaryEndIndex);
                    } else if (n2 == -1) {
                        this.sxmin = this.secondaryX.getDoubleValue(this.secondaryEndIndex);
                        this.sxmax = this.secondaryX.getDoubleValue(this.secondaryStartIndex);
                    } else {
                        this.sxmin = this.secondaryX.getDoubleMin();
                        this.sxmax = this.secondaryX.getDoubleMax();
                    }
                } else {
                    this.sxmin = this.secondaryX.getDoubleMin();
                    this.sxmax = this.secondaryX.getDoubleMax();
                }
                this.sxstep = this.computeStep(this.sxmin, this.sxmax);
                this.sxmin = Math.floor(this.sxmin / this.sxstep) * this.sxstep;
                this.sxmax = Math.ceil(this.sxmax / this.sxstep) * this.sxstep;
                this.sxvaluesOK = true;
            }
            catch (UnsupportedOperation unsupportedOperation) {
            }
            catch (DataException dataException) {
                // empty catch block
            }
        }
        if (!this.pyvaluesOK && this.primaryCurves != null && this.primaryCurves.size() > 0) {
            try {
                DataSource dataSource = ((CurveShape)this.primaryCurves.get(0)).getYSource();
                this.pymin = dataSource.getDoubleMin();
                this.pymax = dataSource.getDoubleMax();
                for (n = 1; n < this.primaryCurves.size(); ++n) {
                    dataSource = ((CurveShape)this.primaryCurves.get(n)).getYSource();
                    d2 = dataSource.getDoubleMin();
                    d = dataSource.getDoubleMax();
                    if (d2 < this.pymin) {
                        this.pymin = d2;
                    }
                    if (!(d > this.pymax)) continue;
                    this.pymax = d;
                }
                this.pystep = this.computeStep(this.pymin, this.pymax);
                this.pymin = Math.floor(this.pymin / this.pystep) * this.pystep;
                this.pymax = Math.ceil(this.pymax / this.pystep) * this.pystep;
                this.pyvaluesOK = true;
            }
            catch (UnsupportedOperation unsupportedOperation) {
            }
            catch (DataException dataException) {
                // empty catch block
            }
        }
        if (!this.syvaluesOK && this.secondaryCurves != null && this.secondaryCurves.size() > 0) {
            try {
                DataSource dataSource = ((CurveShape)this.secondaryCurves.get(0)).getYSource();
                this.symin = dataSource.getDoubleMin();
                this.symax = dataSource.getDoubleMax();
                for (n = 1; n < this.secondaryCurves.size(); ++n) {
                    dataSource = ((CurveShape)this.secondaryCurves.get(n)).getYSource();
                    d2 = dataSource.getDoubleMin();
                    d = dataSource.getDoubleMax();
                    if (d2 < this.symin) {
                        this.symin = d2;
                    }
                    if (!(d > this.symax)) continue;
                    this.symax = d;
                }
                this.systep = this.computeStep(this.symin, this.symax);
                this.symin = Math.floor(this.symin / this.systep) * this.systep;
                this.symax = Math.ceil(this.symax / this.systep) * this.systep;
                this.syvaluesOK = true;
            }
            catch (UnsupportedOperation unsupportedOperation) {
            }
            catch (DataException dataException) {
                // empty catch block
            }
        }
        if (this.pxvaluesOK) {
            this.setX(this.pxmin, this.pxmax, this.pxstep);
        }
        this.setLabel(this.pxlabel, true, false);
        if (this.pyvaluesOK) {
            this.setY(this.pymin, this.pymax, this.pystep);
        }
        this.setLabel(this.pylabel, false, false);
        if (this.sxvaluesOK) {
            this.setSecondaryX(this.sxmin, this.sxmax, this.sxstep);
        }
        this.setLabel(this.sxlabel, true, true);
        if (this.syvaluesOK) {
            this.setSecondaryY(this.symin, this.symax, this.systep);
        }
        this.setLabel(this.sylabel, false, true);
        if (rectangle != null) {
            rectangle.add(this.getBounds());
        }
        this.notifyChange(rectangle);
    }

    public String[] getActions(double d, double d2, Object object, int n) {
        if (n == 3) {
            return new String[]{"mouseOver"};
        }
        if (n == 4) {
            return new String[]{"mouseOut"};
        }
        if (n == 5) {
            MouseEvent mouseEvent = (MouseEvent)object;
            if ((mouseEvent.getModifiers() & 0x10) != 16) {
                return null;
            }
            if (this.zoomState == 1) {
                return new String[]{"zoomTopLeft"};
            }
            if (this.zoomState == 2) {
                return new String[]{"zoomBottomRight"};
            }
            return null;
        }
        Vector<String> vector = new Vector<String>();
        if (object instanceof DataSource) {
            vector.add(resources.getStringValue("setX"));
            vector.add(resources.getStringValue("setXRange"));
            if (this.primaryX != null) {
                vector.add(resources.getStringValue("addY"));
                vector.add(resources.getStringValue("addSecY"));
                vector.add(resources.getStringValue("setSecX"));
                vector.add(resources.getStringValue("setSecXRange"));
                if (this.secondaryX != null) {
                    vector.add(resources.getStringValue("addYSecX"));
                    vector.add(resources.getStringValue("addSecYSecX"));
                }
            }
        } else if (object instanceof DataSourceCollection) {
            vector.add(resources.getStringValue("setXY1Yn"));
            vector.add(resources.getStringValue("setXY1YnRange"));
            if (this.primaryX != null) {
                vector.add(resources.getStringValue("addY1Yn"));
                vector.add(resources.getStringValue("addSecY1Yn"));
                vector.add(resources.getStringValue("setSecXY1Yn"));
                vector.add(resources.getStringValue("setSecXY1YnRange"));
                if (this.secondaryX != null) {
                    vector.add(resources.getStringValue("addSecY1YnForSecX"));
                }
            }
        }
        if (vector.size() == 0) {
            JSynoptic.setStatus(resources.getStringValue("noSource"));
        }
        if (n == 1 && this.zoomState == 0) {
            vector.add(0, resources.getStringValue("properties"));
            if (this.primaryCurves != null && this.primaryCurves.size() != 0 || this.secondaryCurves != null && this.secondaryCurves.size() != 0) {
                vector.add(resources.getStringValue("autoscale"));
                vector.add(resources.getStringValue("zoomBox"));
                if (this.zoomHistory != null && this.zoomHistory.size() > 1) {
                    vector.add(resources.getStringValue("zoomOut"));
                }
            }
        }
        return vector.toArray(new String[vector.size()]);
    }

    public boolean canDoAction(double d, double d2, Object object, String string, int n) {
        if (string == null) {
            return false;
        }
        if (string.equals("mouseOver") || string.equals("mouseOut") || string.equals("zoomTopLeft") || string.equals("zoomBottomRight") || string.equals(resources.getStringValue("properties")) || string.equals(resources.getStringValue("zoomBox")) || string.equals(resources.getStringValue("zoomOut")) || string.equals(resources.getStringValue("autoscale"))) {
            return true;
        }
        if (object instanceof DataSource || object instanceof DataSourceCollection) {
            if (JSynoptic.gui == null) {
                return false;
            }
            if (JSynoptic.gui.getSourcePanel().getSourceTree().isLocked(object)) {
                return false;
            }
        }
        return true;
    }

    public boolean doAction(double d, double d2, Object object, String string) {
        Object object2;
        if (string == null) {
            return false;
        }
        if (string.equals("mouseOver")) {
            if (this.zoomState == 1) {
                JSynoptic.setStatus(resources.getStringValue("zoomTopLeftMessage"));
                return true;
            }
            if (this.zoomState == 2) {
                JSynoptic.setStatus(resources.getStringValue("zoomBottomRightMessage"));
                return true;
            }
            String string2 = "";
            if (this._asx1 != null) {
                string2 = this.pxlabel != null ? string2 + this.pxlabel : string2 + "x";
                string2 = string2 + "=" + AxisLabelFormatter.labelFormat(this._asx1.getMin() + (d - (double)this._ox) / this._asx1.getScale());
            }
            if (this._asy1 != null) {
                if (!string2.equals("")) {
                    string2 = string2 + "   ";
                }
                string2 = this.pylabel != null ? string2 + this.pylabel : string2 + "y";
                string2 = string2 + "=" + AxisLabelFormatter.labelFormat(this._asy1.getMin() + ((double)this._oy - d2) / this._asy1.getScale());
            }
            if (this._asx2 != null) {
                if (!string2.equals("")) {
                    string2 = string2 + "   ";
                }
                string2 = this.sxlabel != null ? string2 + this.sxlabel : string2 + "x'";
                string2 = string2 + "=" + AxisLabelFormatter.labelFormat(this._asx2.getMin() + (d - (double)this._ox) / this._asx2.getScale());
            }
            if (this._asy2 != null) {
                if (!string2.equals("")) {
                    string2 = string2 + "   ";
                }
                string2 = this.sylabel != null ? string2 + this.sylabel : string2 + "y'";
                string2 = string2 + "=" + AxisLabelFormatter.labelFormat(this._asy2.getMin() + ((double)this._oy - d2) / this._asy2.getScale());
            }
            if (!string2.equals("")) {
                JSynoptic.setStatus(string2);
            }
            return true;
        }
        if (string.equals("mouseOut")) {
            JSynoptic.setStatus("");
            return true;
        }
        if (string.equals(resources.getStringValue("properties"))) {
            new LongAction(16L, null, this){

                protected void doAction() {
                    Rectangle rectangle = Plot.this.getBounds();
                    if (Plot.this.propertiesDialog == null) {
                        Plot.this.propertiesDialog = new PlotPropertiesDialog();
                    }
                    Plot.this.propertiesDialog.activate();
                    Plot.this.repaintDiagram(rectangle);
                }
            }.start();
            return true;
        }
        if (string.equals("zoomTopLeft")) {
            if (this.zoomState != 1) {
                return false;
            }
            this.zoomX = d;
            this.zoomY = d2;
            this.zoomState = 2;
            JSynoptic.setStatus(resources.getStringValue("zoomBottomRightMessage"));
            return true;
        }
        if (string.equals("zoomBottomRight")) {
            if (this.zoomState != 2) {
                return false;
            }
            double[] dArray = new double[]{this.pxmin, this.pxmax, this.pxstep, this.pymin, this.pymax, this.pystep, this.sxmin, this.sxmax, this.sxstep, this.symin, this.symax, this.systep};
            boolean[] blArray = new boolean[]{this.pxvaluesOK, this.pyvaluesOK, this.sxvaluesOK, this.syvaluesOK};
            this.zoomHistory.add(dArray);
            this.zoomHistory.add(blArray);
            if (this._asx1 != null) {
                this.pxmin = this._asx1.getMin() + (this.zoomX - (double)this._ox) / this._asx1.getScale();
                this.pxmax = this._asx1.getMin() + (d - (double)this._ox) / this._asx1.getScale();
                this.pxstep = this.computeStep(this.pxmin, this.pxmax);
                this.pxmin = Math.floor(this.pxmin / this.pxstep) * this.pxstep;
                this.pxmax = Math.ceil(this.pxmax / this.pxstep) * this.pxstep;
                this.pxvaluesOK = true;
            } else {
                this.pxvaluesOK = false;
            }
            if (this._asy1 != null) {
                this.pymin = this._asy1.getMin() + ((double)this._oy - this.zoomY) / this._asy1.getScale();
                this.pymax = this._asy1.getMin() + ((double)this._oy - d2) / this._asy1.getScale();
                this.pystep = this.computeStep(this.pymin, this.pymax);
                this.pymin = Math.floor(this.pymin / this.pystep) * this.pystep;
                this.pymax = Math.ceil(this.pymax / this.pystep) * this.pystep;
                this.pyvaluesOK = true;
            } else {
                this.pyvaluesOK = false;
            }
            if (this._asx2 != null) {
                this.sxmin = this._asx2.getMin() + (this.zoomX - (double)this._ox) / this._asx2.getScale();
                this.sxmax = this._asx2.getMin() + (d - (double)this._ox) / this._asx2.getScale();
                this.sxstep = this.computeStep(this.sxmin, this.sxmax);
                this.sxmin = Math.floor(this.sxmin / this.sxstep) * this.sxstep;
                this.sxmax = Math.ceil(this.sxmax / this.sxstep) * this.sxstep;
                this.sxvaluesOK = true;
            } else {
                this.sxvaluesOK = false;
            }
            if (this._asy2 != null) {
                this.symin = this._asy2.getMin() + ((double)this._oy - this.zoomY) / this._asy2.getScale();
                this.symax = this._asy2.getMin() + ((double)this._oy - d2) / this._asy2.getScale();
                this.systep = this.computeStep(this.symin, this.symax);
                this.symin = Math.floor(this.symin / this.systep) * this.systep;
                this.symax = Math.ceil(this.symax / this.systep) * this.systep;
                this.syvaluesOK = true;
            } else {
                this.syvaluesOK = false;
            }
            this.zoomState = 0;
            JSynoptic.setStatus("");
            this.repaintDiagram(this.getBounds());
            return true;
        }
        if (string.equals(resources.getStringValue("zoomBox"))) {
            if (this.zoomState != 0) {
                return false;
            }
            this.zoomState = 1;
            JSynoptic.setStatus(resources.getStringValue("zoomTopLeftMessage"));
            return true;
        }
        if (string.equals(resources.getStringValue("zoomOut"))) {
            int n = this.zoomHistory.size();
            if (n < 2) {
                return false;
            }
            Object e = this.zoomHistory.remove(n - 1);
            Object e2 = this.zoomHistory.remove(n - 2);
            if (!(e instanceof boolean[])) {
                return false;
            }
            if (!(e2 instanceof double[])) {
                return false;
            }
            boolean[] blArray = (boolean[])e;
            double[] dArray = (double[])e2;
            this.pxmin = dArray[0];
            this.pxmax = dArray[1];
            this.pxstep = dArray[2];
            this.pxvaluesOK = blArray[0];
            this.pymin = dArray[3];
            this.pymax = dArray[4];
            this.pystep = dArray[5];
            this.pyvaluesOK = blArray[1];
            this.sxmin = dArray[6];
            this.sxmax = dArray[7];
            this.sxstep = dArray[8];
            this.sxvaluesOK = blArray[2];
            this.symin = dArray[9];
            this.symax = dArray[10];
            this.systep = dArray[11];
            this.syvaluesOK = blArray[3];
            this.zoomState = 0;
            JSynoptic.setStatus("");
            this.repaintDiagram(this.getBounds());
            return true;
        }
        if (string.equals(resources.getStringValue("autoscale"))) {
            this.pxvaluesOK = false;
            this.sxvaluesOK = false;
            this.pyvaluesOK = false;
            this.syvaluesOK = false;
            this.repaintDiagram(this.getBounds());
            return true;
        }
        if (object instanceof DataSource) {
            object2 = (DataSource)object;
            if (string.equals(resources.getStringValue("setX"))) {
                return this.setPrimaryX((DataSource)object2, true);
            }
            if (string.equals(resources.getStringValue("setXRange"))) {
                return this.setPrimaryXRange((DataSource)object2, true);
            }
            if (string.equals(resources.getStringValue("addY"))) {
                return this.addPrimaryY((DataSource)object2, true);
            }
            if (string.equals(resources.getStringValue("addYSecX"))) {
                return this.addPrimaryYForSecondaryX((DataSource)object2, true);
            }
            if (string.equals(resources.getStringValue("addSecY"))) {
                return this.addSecondaryY((DataSource)object2, true);
            }
            if (string.equals(resources.getStringValue("setSecX"))) {
                return this.setSecondaryX((DataSource)object2, true);
            }
            if (string.equals(resources.getStringValue("setSecXRange"))) {
                return this.setSecondaryXRange((DataSource)object2, true);
            }
            if (string.equals(resources.getStringValue("addSecYSecX"))) {
                return this.addSecondaryYForSecondaryX((DataSource)object2, true);
            }
        }
        if (object instanceof DataSourceCollection) {
            object2 = (DataSourceCollection)object;
            if (string.equals(resources.getStringValue("setXY1Yn")) || string.equals(resources.getStringValue("setXY1YnRange"))) {
                if (((Vector)object2).size() < 1) {
                    return false;
                }
                new LongAction(0L, (Object)new Object[]{object2, string}){

                    protected void doAction() {
                        DataSourceCollection dataSourceCollection = (DataSourceCollection)((Object[])this.param)[0];
                        String string = (String)((Object[])this.param)[1];
                        if (string.equals(resources.getStringValue("setXY1Yn"))) {
                            Plot.this.setPrimaryX((DataSource)dataSourceCollection.get(0), false);
                        } else {
                            Plot.this.setPrimaryXRange((DataSource)dataSourceCollection.get(0), false);
                        }
                        boolean bl = Plot.this.pyvaluesOK;
                        boolean bl2 = Plot.this.pylabel != null;
                        Plot.this.pyvaluesOK = true;
                        for (int i = 1; i < dataSourceCollection.size() - 1; ++i) {
                            Plot.this.addPrimaryY((DataSource)dataSourceCollection.get(i), false);
                        }
                        Plot.this.pyvaluesOK = bl;
                        if (dataSourceCollection.size() > 1) {
                            Plot.this.addPrimaryY((DataSource)dataSourceCollection.get(dataSourceCollection.size() - 1), false);
                        }
                        Rectangle rectangle = Plot.this.getBounds();
                        if (!bl2 && dataSourceCollection.size() > 2) {
                            Plot.this.pylabel = null;
                            Plot.this.setLegendVisible(true);
                        }
                        Plot.this.setTitle(DataInfo.getLabel(dataSourceCollection));
                        Plot.this.repaintDiagram(rectangle);
                    }
                }.start();
                return false;
            }
            if (string.equals(resources.getStringValue("addY1Yn"))) {
                if (((Vector)object2).size() < 1) {
                    return false;
                }
                new LongAction(0L, (Object)new Object[]{object2, string}){

                    protected void doAction() {
                        DataSourceCollection dataSourceCollection = (DataSourceCollection)((Object[])this.param)[0];
                        String string = (String)((Object[])this.param)[1];
                        boolean bl = Plot.this.pyvaluesOK;
                        boolean bl2 = Plot.this.pylabel != null;
                        Plot.this.pyvaluesOK = true;
                        for (int i = 0; i < dataSourceCollection.size() - 1; ++i) {
                            Plot.this.addPrimaryY((DataSource)dataSourceCollection.get(i), false);
                        }
                        Plot.this.pyvaluesOK = bl;
                        if (dataSourceCollection.size() > 0) {
                            Plot.this.addPrimaryY((DataSource)dataSourceCollection.get(dataSourceCollection.size() - 1), false);
                        }
                        Rectangle rectangle = Plot.this.getBounds();
                        if (!bl2 && dataSourceCollection.size() > 1) {
                            Plot.this.pylabel = null;
                            Plot.this.setLegendVisible(true);
                        }
                        Plot.this.repaintDiagram(rectangle);
                    }
                }.start();
                return false;
            }
            if (string.equals(resources.getStringValue("addSecY1Yn"))) {
                if (((Vector)object2).size() < 1) {
                    return false;
                }
                new LongAction(0L, (Object)new Object[]{object2, string}){

                    protected void doAction() {
                        DataSourceCollection dataSourceCollection = (DataSourceCollection)((Object[])this.param)[0];
                        String string = (String)((Object[])this.param)[1];
                        boolean bl = Plot.this.syvaluesOK;
                        boolean bl2 = Plot.this.sylabel != null;
                        Plot.this.syvaluesOK = true;
                        for (int i = 0; i < dataSourceCollection.size() - 1; ++i) {
                            Plot.this.addSecondaryY((DataSource)dataSourceCollection.get(i), false);
                        }
                        Plot.this.syvaluesOK = bl;
                        if (dataSourceCollection.size() > 0) {
                            Plot.this.addSecondaryY((DataSource)dataSourceCollection.get(dataSourceCollection.size() - 1), false);
                        }
                        Rectangle rectangle = Plot.this.getBounds();
                        if (!bl2 && dataSourceCollection.size() > 1) {
                            Plot.this.sylabel = null;
                            Plot.this.setLegendVisible(true);
                        }
                        Plot.this.repaintDiagram(rectangle);
                    }
                }.start();
                return false;
            }
            if (string.equals(resources.getStringValue("setSecXY1Yn")) || string.equals(resources.getStringValue("setSecXY1YnRange"))) {
                if (((Vector)object2).size() < 1) {
                    return false;
                }
                new LongAction(0L, (Object)new Object[]{object2, string}){

                    protected void doAction() {
                        DataSourceCollection dataSourceCollection = (DataSourceCollection)((Object[])this.param)[0];
                        String string = (String)((Object[])this.param)[1];
                        if (string.equals(resources.getStringValue("setSecXY1Yn"))) {
                            Plot.this.setSecondaryX((DataSource)dataSourceCollection.get(0), false);
                        } else {
                            Plot.this.setSecondaryXRange((DataSource)dataSourceCollection.get(0), false);
                        }
                        boolean bl = Plot.this.syvaluesOK;
                        boolean bl2 = Plot.this.sylabel != null;
                        Plot.this.syvaluesOK = true;
                        for (int i = 1; i < dataSourceCollection.size() - 1; ++i) {
                            Plot.this.addSecondaryY((DataSource)dataSourceCollection.get(i), false);
                        }
                        Plot.this.syvaluesOK = bl;
                        if (dataSourceCollection.size() > 1) {
                            Plot.this.addSecondaryY((DataSource)dataSourceCollection.get(dataSourceCollection.size() - 1), false);
                        }
                        Rectangle rectangle = Plot.this.getBounds();
                        if (!bl2 && dataSourceCollection.size() > 2) {
                            Plot.this.sylabel = null;
                            Plot.this.setLegendVisible(true);
                        }
                        Plot.this.repaintDiagram(rectangle);
                    }
                }.start();
                return false;
            }
            if (string.equals(resources.getStringValue("addSecY1YnForSecX"))) {
                if (((Vector)object2).size() < 1) {
                    return false;
                }
                new LongAction(0L, (Object)new Object[]{object2, string}){

                    protected void doAction() {
                        DataSourceCollection dataSourceCollection = (DataSourceCollection)((Object[])this.param)[0];
                        String string = (String)((Object[])this.param)[1];
                        boolean bl = Plot.this.syvaluesOK;
                        boolean bl2 = Plot.this.sylabel != null;
                        Plot.this.syvaluesOK = true;
                        for (int i = 0; i < dataSourceCollection.size() - 1; ++i) {
                            Plot.this.addSecondaryYForSecondaryX((DataSource)dataSourceCollection.get(i), false);
                        }
                        Plot.this.syvaluesOK = bl;
                        if (dataSourceCollection.size() > 0) {
                            Plot.this.addSecondaryYForSecondaryX((DataSource)dataSourceCollection.get(dataSourceCollection.size() - 1), false);
                        }
                        Rectangle rectangle = Plot.this.getBounds();
                        if (!bl2 && dataSourceCollection.size() > 1) {
                            Plot.this.sylabel = null;
                            Plot.this.setLegendVisible(true);
                        }
                        Plot.this.repaintDiagram(rectangle);
                    }
                }.start();
                return false;
            }
        }
        return false;
    }

    public void notificationEnd(Object object) {
        this.syvaluesOK = false;
        this.sxvaluesOK = false;
        this.pyvaluesOK = false;
        this.pxvaluesOK = false;
        if (this.primaryX != null) {
            try {
                this.primaryStartIndex = this.primaryX.getStartIndex();
            }
            catch (UnsupportedOperation unsupportedOperation) {
                // empty catch block
            }
            try {
                this.primaryEndIndex = this.primaryX.getLastIndex();
            }
            catch (UnsupportedOperation unsupportedOperation) {
                // empty catch block
            }
        }
        if (this.secondaryX != null) {
            try {
                this.secondaryStartIndex = this.secondaryX.getStartIndex();
            }
            catch (UnsupportedOperation unsupportedOperation) {
                // empty catch block
            }
            try {
                this.secondaryEndIndex = this.secondaryX.getLastIndex();
            }
            catch (UnsupportedOperation unsupportedOperation) {
                // empty catch block
            }
        }
        this.isNotifying = false;
        super.notificationEnd(object);
        this.isNotifying = true;
        this.repaintDiagram(this.getBounds());
    }

    protected synchronized void notifyChange() {
        if (this.isNotifying) {
            super.notifyChange();
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        DataSourcePool.global.writeDataSource(objectOutputStream, this.primaryX);
        DataSourcePool.global.writeDataSource(objectOutputStream, this.secondaryX);
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        long l;
        long l2;
        objectInputStream.defaultReadObject();
        this.primaryX = DataSourcePool.global.readDataSource(objectInputStream);
        this.secondaryX = DataSourcePool.global.readDataSource(objectInputStream);
        this.propertiesDialog = null;
        this.zoomState = 0;
        this.zoomHistory = new Vector();
        if (this.isPrimaryBounded && this.primaryX != null) {
            try {
                l2 = this.primaryX.getStartIndex();
                l = this.primaryX.getLastIndex();
                if (l2 > this.primaryStartIndex) {
                    this.primaryStartIndex = l2;
                }
                if (l < this.primaryEndIndex) {
                    this.primaryEndIndex = l;
                }
            }
            catch (UnsupportedOperation unsupportedOperation) {
                this.isPrimaryBounded = false;
            }
        }
        if (this.isSecondaryBounded && this.secondaryX != null) {
            try {
                l2 = this.secondaryX.getStartIndex();
                l = this.secondaryX.getLastIndex();
                if (l2 > this.secondaryStartIndex) {
                    this.secondaryStartIndex = l2;
                }
                if (l < this.secondaryEndIndex) {
                    this.secondaryEndIndex = l;
                }
            }
            catch (UnsupportedOperation unsupportedOperation) {
                this.isSecondaryBounded = false;
            }
        }
        this.isNotifying = true;
    }

    static {
        try {
            resources = (MenuResourceBundle)ResourceBundle.getBundle("jsynoptic.builtin.resources.PlotResources", CustomizedLocale.get());
        }
        catch (Exception exception) {
            System.err.println("Can't load SourcePanel resources");
            System.exit(0);
        }
        defaultPalette = new Color[]{Color.blue, Color.red, Color.green, Color.magenta, Color.cyan, Color.orange, Color.pink, Color.black, Color.yellow};
    }

    class NumberField
    extends JTextField {
        private Toolkit toolkit = Toolkit.getDefaultToolkit();

        public NumberField(int n) {
            super(n);
        }

        public NumberField(double d, int n) {
            this(n);
            this.setValue(d);
        }

        public NumberField(long l, int n) {
            this(n);
            this.setValue(l);
        }

        public boolean isEmpty() {
            return this.getText().trim().equals("");
        }

        public void setValue(double d) {
            this.setText(String.valueOf(d));
        }

        public void setValue(long l) {
            this.setText(String.valueOf(l));
        }

        public double getDoubleValue() throws NumberFormatException {
            double d = 0.0;
            try {
                d = Double.parseDouble(this.getText());
            }
            catch (NumberFormatException numberFormatException) {
                this.selectAll();
                this.requestFocus();
                this.toolkit.beep();
                throw numberFormatException;
            }
            return d;
        }

        public long getLongValue() throws NumberFormatException {
            long l = 0L;
            try {
                l = Long.decode(this.getText());
            }
            catch (NumberFormatException numberFormatException) {
                this.selectAll();
                this.requestFocus();
                this.toolkit.beep();
                throw numberFormatException;
            }
            return l;
        }
    }

    public class SetRangeDialog
    extends JDialog
    implements ActionListener {
        protected JLabel lindex;
        protected JLabel lvalue;
        protected JLabel limin;
        protected JLabel limax;
        protected JLabel lvmin;
        protected JLabel lvmax;
        protected JLabel lvstart;
        protected JLabel lvend;
        protected JLabel lmin;
        protected JLabel lmax;
        protected JLabel lstart;
        protected JLabel lend;
        protected JButton icompute;
        protected JButton vcompute;
        protected NumberField nfistart;
        protected NumberField nfiend;
        protected NumberField nfvstart;
        protected NumberField nfvend;
        protected DataSource datasource;
        protected JButton bnob;
        protected JButton bok;
        protected JButton bcancel;
        protected boolean hasimin;
        protected boolean hasimax;
        protected boolean hasvmin;
        protected boolean hasvmax;
        protected boolean hasistart;
        protected boolean hasiend;
        protected double vmin;
        protected double vmax;
        protected long imin;
        protected long imax;
        protected int sortedOrder;
        public long istart;
        public long iend;
        public int status = -1;
        protected boolean computing;

        public SetRangeDialog(DataSource dataSource) {
            super((Frame)null, resources.getStringValue("setRangeDialogTitle"), false);
            this.datasource = dataSource;
            this.sortedOrder = dataSource.sortedOrder();
            this.computing = false;
            this.nfistart = new NumberField(10);
            this.nfiend = new NumberField(10);
            this.limin = new JLabel();
            this.limax = new JLabel();
            this.lvmin = new JLabel();
            this.lvmax = new JLabel();
            this.lmin = new JLabel(resources.getStringValue("minLabel"));
            this.lmax = new JLabel(resources.getStringValue("maxLabel"));
            this.lstart = new JLabel(resources.getStringValue("startLabel"));
            this.lend = new JLabel(resources.getStringValue("endLabel"));
            this.bnob = resources.getButton("noBoundsButton", this);
            this.bok = resources.getButton("OKButton", this);
            this.bcancel = resources.getButton("cancelButton", this);
            this.lindex = new JLabel(resources.getStringValue("indexLabel"));
            this.lvalue = new JLabel(resources.getStringValue("valueLabel"));
            String string = resources.getStringValue("unknownValue");
            if (this.sortedOrder == 0) {
                this.lvstart = new JLabel();
                this.lvend = new JLabel();
            } else {
                this.nfvstart = new NumberField(10);
                this.nfvend = new NumberField(10);
                this.nfvstart.addActionListener(this);
                this.nfvend.addActionListener(this);
            }
            this.nfistart.addActionListener(this);
            this.nfiend.addActionListener(this);
            try {
                this.imin = this.datasource.getStartIndex();
                this.nfistart.setValue(this.imin);
                this.limin.setText(String.valueOf(this.imin));
                this.hasimin = true;
            }
            catch (UnsupportedOperation unsupportedOperation) {
                this.hasimin = false;
                this.limin.setText(string);
            }
            try {
                this.imax = this.datasource.getLastIndex();
                this.nfiend.setValue(this.imax);
                this.limax.setText(String.valueOf(this.imax));
                this.hasimax = true;
            }
            catch (UnsupportedOperation unsupportedOperation) {
                this.hasimax = false;
                this.limax.setText(string);
            }
            try {
                this.vmin = this.datasource.getDoubleMin();
                this.lvmin.setText(String.valueOf(this.vmin));
                if (this.sortedOrder == 0) {
                    this.lvstart.setText(String.valueOf(this.vmin));
                } else {
                    this.nfvstart.setValue(this.vmin);
                }
                this.hasvmin = true;
            }
            catch (UnsupportedOperation unsupportedOperation) {
                this.hasvmin = false;
                this.lvmin.setText(string);
            }
            catch (DataException dataException) {
                this.hasvmin = false;
                this.lvmin.setText(string);
            }
            try {
                this.vmax = this.datasource.getDoubleMax();
                this.lvmax.setText(String.valueOf(this.vmax));
                if (this.sortedOrder == 0) {
                    this.lvend.setText(String.valueOf(this.vmax));
                } else {
                    this.nfvend.setValue(this.vmax);
                }
                this.hasvmax = true;
            }
            catch (UnsupportedOperation unsupportedOperation) {
                this.hasvmax = false;
                this.lvmax.setText(string);
            }
            catch (DataException dataException) {
                this.hasvmin = false;
                this.lvmin.setText(string);
            }
            this.icompute = !this.hasimin || !this.hasimax ? resources.getButton("computeButton", this) : null;
            this.vcompute = !this.hasvmin || !this.hasvmax ? resources.getButton("computeButton", this) : null;
            Box box = new Box(1);
            this.getContentPane().add(box);
            JPanel jPanel = new JPanel();
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            jPanel.setLayout(gridBagLayout);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagLayout.setConstraints(this.lmin, gridBagConstraints);
            jPanel.add(this.lmin);
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = 0;
            gridBagLayout.setConstraints(this.lstart, gridBagConstraints);
            jPanel.add(this.lstart);
            gridBagConstraints.gridx = 3;
            gridBagConstraints.gridy = 0;
            gridBagLayout.setConstraints(this.lend, gridBagConstraints);
            jPanel.add(this.lend);
            gridBagConstraints.gridx = 4;
            gridBagConstraints.gridy = 0;
            gridBagLayout.setConstraints(this.lmax, gridBagConstraints);
            jPanel.add(this.lmax);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagLayout.setConstraints(this.lindex, gridBagConstraints);
            jPanel.add(this.lindex);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 1;
            gridBagLayout.setConstraints(this.limin, gridBagConstraints);
            jPanel.add(this.limin);
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = 1;
            gridBagLayout.setConstraints(this.nfistart, gridBagConstraints);
            jPanel.add(this.nfistart);
            gridBagConstraints.gridx = 3;
            gridBagConstraints.gridy = 1;
            gridBagLayout.setConstraints(this.nfiend, gridBagConstraints);
            jPanel.add(this.nfiend);
            gridBagConstraints.gridx = 4;
            gridBagConstraints.gridy = 1;
            gridBagLayout.setConstraints(this.limax, gridBagConstraints);
            jPanel.add(this.limax);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 2;
            gridBagLayout.setConstraints(this.lvalue, gridBagConstraints);
            jPanel.add(this.lvalue);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 2;
            gridBagLayout.setConstraints(this.lvmin, gridBagConstraints);
            jPanel.add(this.lvmin);
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = 2;
            switch (this.sortedOrder) {
                case -1: {
                    gridBagLayout.setConstraints(this.nfvend, gridBagConstraints);
                    jPanel.add(this.nfvend);
                    break;
                }
                case 1: {
                    gridBagLayout.setConstraints(this.nfvstart, gridBagConstraints);
                    jPanel.add(this.nfvstart);
                    break;
                }
                default: {
                    gridBagLayout.setConstraints(this.lvstart, gridBagConstraints);
                    jPanel.add(this.lvstart);
                }
            }
            gridBagConstraints.gridx = 3;
            gridBagConstraints.gridy = 2;
            switch (this.sortedOrder) {
                case -1: {
                    gridBagLayout.setConstraints(this.nfvstart, gridBagConstraints);
                    jPanel.add(this.nfvstart);
                    break;
                }
                case 1: {
                    gridBagLayout.setConstraints(this.nfvend, gridBagConstraints);
                    jPanel.add(this.nfvend);
                    break;
                }
                default: {
                    gridBagLayout.setConstraints(this.lvend, gridBagConstraints);
                    jPanel.add(this.lvend);
                }
            }
            gridBagConstraints.gridx = 4;
            gridBagConstraints.gridy = 2;
            gridBagLayout.setConstraints(this.lvmax, gridBagConstraints);
            jPanel.add(this.lvmax);
            if (this.icompute != null) {
                gridBagConstraints.gridx = 5;
                gridBagConstraints.gridy = 1;
                gridBagLayout.setConstraints(this.icompute, gridBagConstraints);
                jPanel.add(this.icompute);
            }
            if (this.vcompute != null) {
                gridBagConstraints.gridx = 5;
                gridBagConstraints.gridy = 2;
                gridBagLayout.setConstraints(this.vcompute, gridBagConstraints);
                jPanel.add(this.vcompute);
            }
            box.add(jPanel);
            jPanel = new JPanel();
            jPanel.setLayout(new FlowLayout(1));
            jPanel.add(this.bcancel);
            jPanel.add(this.bnob);
            jPanel.add(this.bok);
            box.add(jPanel);
            this.addWindowListener(new WindowAdapter(this){
                private final /* synthetic */ SetRangeDialog this$1;
                {
                    this.this$1 = setRangeDialog;
                }

                public void windowClosing(WindowEvent windowEvent) {
                    this.this$1.done(0);
                }
            });
            this.pack();
            this.doLayout();
        }

        protected long dichoGetIndexForValue(double d, long l, long l2, boolean bl) throws DataException {
            while (l < l2) {
                long l3 = l + l2 >> 1;
                double d2 = this.datasource.getDoubleValue(l3);
                if (d == d2) {
                    return l3;
                }
                if (d < d2) {
                    if (bl) {
                        l2 = l3 - 1L;
                        continue;
                    }
                    l = l3 + 1L;
                    continue;
                }
                if (bl) {
                    l = l3 + 1L;
                    continue;
                }
                l2 = l3 - 1L;
            }
            return l;
        }

        protected void computeIndexBounds() {
            if (!this.hasimin) {
                try {
                    this.imin = this.datasource.computeStartIndex();
                    if (this.nfistart.isEmpty()) {
                        this.nfistart.setValue(this.imin);
                    }
                    this.limin.setText(String.valueOf(this.imin));
                    this.hasimin = true;
                }
                catch (UnsupportedOperation unsupportedOperation) {
                    // empty catch block
                }
            }
            if (!this.hasimax) {
                try {
                    this.imax = this.datasource.computeLastIndex();
                    if (this.nfiend.isEmpty()) {
                        this.nfiend.setValue(this.imax);
                    }
                    this.limax.setText(String.valueOf(this.imax));
                    this.hasimax = true;
                }
                catch (UnsupportedOperation unsupportedOperation) {
                    // empty catch block
                }
            }
        }

        synchronized void getAnswer() {
            this.show();
            while (this.status == -1) {
                try {
                    this.wait();
                    break;
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }

        synchronized void done(int n) {
            this.status = n;
            this.dispose();
            this.notifyAll();
        }

        synchronized void setComputeMode(boolean bl) {
            this.computing = bl;
            if (this.computing) {
                this.setCursor(Cursor.getPredefinedCursor(3));
            } else {
                this.setCursor(Cursor.getDefaultCursor());
            }
            if (this.lindex != null) {
                this.lindex.setEnabled(!bl);
            }
            if (this.lvalue != null) {
                this.lvalue.setEnabled(!bl);
            }
            if (this.limin != null) {
                this.limin.setEnabled(!bl);
            }
            if (this.limax != null) {
                this.limax.setEnabled(!bl);
            }
            if (this.lvmin != null) {
                this.lvmin.setEnabled(!bl);
            }
            if (this.lvmax != null) {
                this.lvmax.setEnabled(!bl);
            }
            if (this.lvstart != null) {
                this.lvstart.setEnabled(!bl);
            }
            if (this.lvend != null) {
                this.lvend.setEnabled(!bl);
            }
            if (this.lmin != null) {
                this.lmin.setEnabled(!bl);
            }
            if (this.lmax != null) {
                this.lmax.setEnabled(!bl);
            }
            if (this.lstart != null) {
                this.lstart.setEnabled(!bl);
            }
            if (this.lend != null) {
                this.lend.setEnabled(!bl);
            }
            if (this.icompute != null) {
                this.icompute.setEnabled(!bl);
            }
            if (this.vcompute != null) {
                this.vcompute.setEnabled(!bl);
            }
            if (this.nfistart != null) {
                this.nfistart.setEnabled(!bl);
            }
            if (this.nfiend != null) {
                this.nfiend.setEnabled(!bl);
            }
            if (this.nfvstart != null) {
                this.nfvstart.setEnabled(!bl);
            }
            if (this.nfvend != null) {
                this.nfvend.setEnabled(!bl);
            }
            if (this.bnob != null) {
                this.bnob.setEnabled(!bl);
            }
            if (this.bok != null) {
                this.bok.setEnabled(!bl);
            }
            if (this.bcancel != null) {
                this.bcancel.setEnabled(!bl);
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.computing) {
                return;
            }
            if (actionEvent.getSource() == this.icompute) {
                new LongAction(this){
                    private final /* synthetic */ SetRangeDialog this$1;
                    {
                        this.this$1 = setRangeDialog;
                    }

                    protected void doAction() {
                        this.this$1.setComputeMode(true);
                        this.this$1.computeIndexBounds();
                        this.this$1.setComputeMode(false);
                    }
                }.start();
                return;
            }
            if (actionEvent.getSource() == this.vcompute) {
                new LongAction(this){
                    private final /* synthetic */ SetRangeDialog this$1;
                    {
                        this.this$1 = setRangeDialog;
                    }

                    protected void doAction() {
                        this.this$1.setComputeMode(true);
                        if (!this.this$1.hasvmin) {
                            try {
                                this.this$1.datasource.computeMin();
                                this.this$1.vmin = this.this$1.datasource.getDoubleMin();
                                this.this$1.lvmin.setText(String.valueOf(this.this$1.vmin));
                                this.this$1.hasvmin = true;
                            }
                            catch (UnsupportedOperation unsupportedOperation) {
                            }
                            catch (DataException dataException) {
                                // empty catch block
                            }
                        }
                        if (!this.this$1.hasvmax) {
                            try {
                                this.this$1.datasource.computeMax();
                                this.this$1.vmax = this.this$1.datasource.getDoubleMax();
                                this.this$1.lvmax.setText(String.valueOf(this.this$1.vmax));
                                this.this$1.hasvmax = true;
                            }
                            catch (UnsupportedOperation unsupportedOperation) {
                            }
                            catch (DataException dataException) {
                                // empty catch block
                            }
                        }
                        this.this$1.setComputeMode(false);
                    }
                }.start();
                return;
            }
            if (actionEvent.getSource() == this.nfistart) {
                try {
                    if (this.sortedOrder == 0) {
                        this.lvstart.setText(String.valueOf(this.datasource.getValue(this.nfistart.getLongValue())));
                    } else {
                        this.nfvstart.setValue(this.datasource.getDoubleValue(this.nfistart.getLongValue()));
                    }
                }
                catch (NumberFormatException numberFormatException) {
                }
                catch (DataException dataException) {
                    // empty catch block
                }
                return;
            }
            if (actionEvent.getSource() == this.nfiend) {
                try {
                    if (this.sortedOrder == 0) {
                        this.lvend.setText(String.valueOf(this.datasource.getValue(this.nfiend.getLongValue())));
                    } else {
                        this.nfvend.setValue(this.datasource.getDoubleValue(this.nfiend.getLongValue()));
                    }
                }
                catch (NumberFormatException numberFormatException) {
                }
                catch (DataException dataException) {
                    // empty catch block
                }
                return;
            }
            if (actionEvent.getSource() == this.nfvstart) {
                this.computeIndexBounds();
                if (!this.hasimin || !this.hasimax) {
                    return;
                }
                try {
                    this.nfistart.setValue(this.dichoGetIndexForValue(this.nfvstart.getDoubleValue(), this.imin, this.imax, this.sortedOrder > 0));
                }
                catch (NumberFormatException numberFormatException) {
                }
                catch (DataException dataException) {
                    // empty catch block
                }
                return;
            }
            if (actionEvent.getSource() == this.nfvend) {
                this.computeIndexBounds();
                if (!this.hasimin || !this.hasimax) {
                    return;
                }
                try {
                    this.nfiend.setValue(this.dichoGetIndexForValue(this.nfvend.getDoubleValue(), this.imin, this.imax, this.sortedOrder > 0));
                }
                catch (NumberFormatException numberFormatException) {
                }
                catch (DataException dataException) {
                    // empty catch block
                }
                return;
            }
            if (actionEvent.getSource() == this.bnob) {
                this.done(2);
                return;
            }
            if (actionEvent.getSource() == this.bcancel) {
                this.done(0);
                return;
            }
            if (actionEvent.getSource() == this.bok) {
                if (this.nfistart.isEmpty()) {
                    this.hasistart = false;
                } else {
                    try {
                        this.istart = this.nfistart.getLongValue();
                        this.hasistart = true;
                    }
                    catch (NumberFormatException numberFormatException) {
                        return;
                    }
                }
                if (this.nfiend.isEmpty()) {
                    this.hasiend = false;
                } else {
                    try {
                        this.iend = this.nfiend.getLongValue();
                        this.hasiend = true;
                    }
                    catch (NumberFormatException numberFormatException) {
                        return;
                    }
                }
                if (this.hasistart ^ this.hasiend) {
                    JOptionPane.showMessageDialog(this, resources.getStringValue("mustSetBothBounds"), resources.getStringValue("missingInformation"), 0);
                    if (this.hasistart) {
                        this.nfiend.requestFocus();
                    } else {
                        this.nfistart.requestFocus();
                    }
                    return;
                }
                this.done(1);
                return;
            }
        }
    }

    public class PlotPropertiesDialog
    extends JDialog
    implements ActionListener {
        protected NumberField tfpxmin;
        protected NumberField tfpxmax;
        protected NumberField tfpxstep;
        protected JTextField tfpxlabel;
        protected NumberField tfpymin;
        protected NumberField tfpymax;
        protected NumberField tfpystep;
        protected JTextField tfpylabel;
        protected NumberField tfsxmin;
        protected NumberField tfsxmax;
        protected NumberField tfsxstep;
        protected JTextField tfsxlabel;
        protected NumberField tfsymin;
        protected NumberField tfsymax;
        protected NumberField tfsystep;
        protected JTextField tfsylabel;
        protected JTextField tftitle;
        protected JCheckBox cbpx;
        protected JCheckBox cbpy;
        protected JCheckBox cbsx;
        protected JCheckBox cbsy;
        protected JCheckBox cblegend;
        protected JCheckBox cbgpx;
        protected JCheckBox cbgpy;
        protected JCheckBox cbgsx;
        protected JCheckBox cbgsy;
        protected JButton bcancel;
        protected JButton bok;
        protected JButton matchpx;
        protected JButton matchpy;
        protected JLabel lpxmin;
        protected JLabel lpxmax;
        protected JLabel lpxstep;
        protected JLabel lpxlabel;
        protected JLabel lpymin;
        protected JLabel lpymax;
        protected JLabel lpystep;
        protected JLabel lpylabel;
        protected JLabel lsxmin;
        protected JLabel lsxmax;
        protected JLabel lsxstep;
        protected JLabel lsxlabel;
        protected JLabel lsymin;
        protected JLabel lsymax;
        protected JLabel lsystep;
        protected JLabel lsylabel;
        protected JComboBox cbxcurves;
        protected JTextField tfcurverename;
        protected JTextField cbxeditortf;
        protected JButton bcurverename;
        protected JButton bcurvecolor;
        protected JButton bcurvedelete;
        protected PlotShape.Curve activeCurve;
        protected Color noCurveColor;
        protected Vector curvesCopy;
        protected Vector primaryCurvesCopy;
        protected Vector secondaryCurvesCopy;
        protected boolean firstTime;
        public int status = -1;

        public PlotPropertiesDialog() {
            super((Frame)null, resources.getStringValue("propertiesDialogTitle"), false);
            this.tfpxmin = new NumberField(Plot.this.pxmin, 10);
            this.tfpxmax = new NumberField(Plot.this.pxmax, 10);
            this.tfpxstep = new NumberField(Plot.this.pxstep, 10);
            this.tfpxlabel = new JTextField(15);
            this.tfpymin = new NumberField(Plot.this.pymin, 10);
            this.tfpymax = new NumberField(Plot.this.pymax, 10);
            this.tfpystep = new NumberField(Plot.this.pystep, 10);
            this.tfpylabel = new JTextField(15);
            this.tfsxmin = new NumberField(Plot.this.sxmin, 6);
            this.tfsxmax = new NumberField(Plot.this.sxmax, 6);
            this.tfsxstep = new NumberField(Plot.this.sxstep, 6);
            this.tfsxlabel = new JTextField(15);
            this.tfsymin = new NumberField(Plot.this.symin, 6);
            this.tfsymax = new NumberField(Plot.this.symax, 6);
            this.tfsystep = new NumberField(Plot.this.systep, 6);
            this.tfsylabel = new JTextField(15);
            this.tftitle = new JTextField(25);
            this.lpxmin = new JLabel(resources.getStringValue("minLabel"));
            this.lpxmax = new JLabel(resources.getStringValue("maxLabel"));
            this.lpxstep = new JLabel(resources.getStringValue("stepLabel"));
            this.lpxlabel = new JLabel(resources.getStringValue("labelLabel"));
            this.lpymin = new JLabel(resources.getStringValue("minLabel"));
            this.lpymax = new JLabel(resources.getStringValue("maxLabel"));
            this.lpystep = new JLabel(resources.getStringValue("stepLabel"));
            this.lpylabel = new JLabel(resources.getStringValue("labelLabel"));
            this.lsxmin = new JLabel(resources.getStringValue("minLabel"));
            this.lsxmax = new JLabel(resources.getStringValue("maxLabel"));
            this.lsxstep = new JLabel(resources.getStringValue("stepLabel"));
            this.lsxlabel = new JLabel(resources.getStringValue("labelLabel"));
            this.lsymin = new JLabel(resources.getStringValue("minLabel"));
            this.lsymax = new JLabel(resources.getStringValue("maxLabel"));
            this.lsystep = new JLabel(resources.getStringValue("stepLabel"));
            this.lsylabel = new JLabel(resources.getStringValue("labelLabel"));
            this.cbpx = resources.getCheckBox("primX", this);
            this.cbpy = resources.getCheckBox("primY", this);
            this.cbsx = resources.getCheckBox("secX", this);
            this.cbsy = resources.getCheckBox("secY", this);
            this.cbgpx = resources.getCheckBox("grid", this);
            this.cbgpy = resources.getCheckBox("grid", this);
            this.cbgsx = resources.getCheckBox("grid", this);
            this.cbgsy = resources.getCheckBox("grid", this);
            this.cblegend = resources.getCheckBox("legend", this);
            this.cbxcurves = new JComboBox();
            this.activeCurve = null;
            this.cbxcurves.setEditable(true);
            this.cbxcurves.addActionListener(this);
            this.bcurvecolor = new JButton();
            this.bcurvecolor.addActionListener(this);
            this.noCurveColor = this.bcurvecolor.getBackground();
            this.bcurvedelete = resources.getButton("deleteCurveButton", this);
            this.cbxeditortf = (JTextField)this.cbxcurves.getEditor().getEditorComponent();
            this.cbxeditortf.addActionListener(this);
            this.bcancel = resources.getButton("cancelButton", this);
            this.bok = resources.getButton("OKButton", this);
            this.matchpx = resources.getButton("matchpxButton", this);
            this.matchpy = resources.getButton("matchpyButton", this);
            Box box = new Box(1);
            this.getContentPane().add(box);
            Box box2 = new Box(1);
            box2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), resources.getStringValue("primXSection")));
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new FlowLayout(0));
            jPanel.add(this.cbpx);
            jPanel.add(this.cbgpx);
            jPanel.add(this.lpxlabel);
            jPanel.add(this.tfpxlabel);
            box2.add(jPanel);
            jPanel = new JPanel();
            jPanel.setLayout(new FlowLayout(0));
            jPanel.add(this.lpxmin);
            jPanel.add(this.tfpxmin);
            jPanel.add(this.lpxmax);
            jPanel.add(this.tfpxmax);
            jPanel.add(this.lpxstep);
            jPanel.add(this.tfpxstep);
            box2.add(jPanel);
            box.add(box2);
            box2 = new Box(1);
            box2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), resources.getStringValue("primYSection")));
            jPanel = new JPanel();
            jPanel.setLayout(new FlowLayout(0));
            jPanel.add(this.cbpy);
            jPanel.add(this.cbgpy);
            jPanel.add(this.lpylabel);
            jPanel.add(this.tfpylabel);
            box2.add(jPanel);
            jPanel = new JPanel();
            jPanel.setLayout(new FlowLayout(0));
            jPanel.add(this.lpymin);
            jPanel.add(this.tfpymin);
            jPanel.add(this.lpymax);
            jPanel.add(this.tfpymax);
            jPanel.add(this.lpystep);
            jPanel.add(this.tfpystep);
            box2.add(jPanel);
            box.add(box2);
            box2 = new Box(1);
            box2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), resources.getStringValue("secXSection")));
            jPanel = new JPanel();
            jPanel.setLayout(new FlowLayout(0));
            jPanel.add(this.cbsx);
            jPanel.add(this.cbgsx);
            jPanel.add(this.lsxlabel);
            jPanel.add(this.tfsxlabel);
            box2.add(jPanel);
            jPanel = new JPanel();
            jPanel.setLayout(new FlowLayout(0));
            jPanel.add(this.lsxmin);
            jPanel.add(this.tfsxmin);
            jPanel.add(this.lsxmax);
            jPanel.add(this.tfsxmax);
            jPanel.add(this.lsxstep);
            jPanel.add(this.tfsxstep);
            jPanel.add(this.matchpx);
            box2.add(jPanel);
            box.add(box2);
            box2 = new Box(1);
            box2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), resources.getStringValue("secYSection")));
            jPanel = new JPanel();
            jPanel.setLayout(new FlowLayout(0));
            jPanel.add(this.cbsy);
            jPanel.add(this.cbgsy);
            jPanel.add(this.lsylabel);
            jPanel.add(this.tfsylabel);
            box2.add(jPanel);
            jPanel = new JPanel();
            jPanel.setLayout(new FlowLayout(0));
            jPanel.add(this.lsymin);
            jPanel.add(this.tfsymin);
            jPanel.add(this.lsymax);
            jPanel.add(this.tfsymax);
            jPanel.add(this.lsystep);
            jPanel.add(this.tfsystep);
            jPanel.add(this.matchpy);
            box2.add(jPanel);
            box.add(box2);
            jPanel = new JPanel();
            jPanel.setLayout(new FlowLayout(0));
            jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), resources.getStringValue("curvesLabel")));
            jPanel.add(this.cbxcurves);
            jPanel.add(this.bcurvecolor);
            jPanel.add(this.bcurvedelete);
            box.add(jPanel);
            jPanel = new JPanel();
            jPanel.setLayout(new FlowLayout(0));
            jPanel.add(new JLabel(resources.getStringValue("titleLabel")));
            jPanel.add(this.tftitle);
            jPanel.add(this.cblegend);
            box.add(jPanel);
            jPanel = new JPanel();
            jPanel.setLayout(new FlowLayout(1));
            jPanel.add(this.bcancel);
            jPanel.add(this.bok);
            box.add(jPanel);
            this.addWindowListener(new WindowAdapter(this){
                private final /* synthetic */ PlotPropertiesDialog this$1;
                {
                    this.this$1 = plotPropertiesDialog;
                }

                public void windowClosing(WindowEvent windowEvent) {
                    this.this$1.done(0);
                }
            });
            this.firstTime = true;
        }

        public void show() {
            this.tfpxmin.setValue(Plot.this.pxmin);
            this.tfpxmax.setValue(Plot.this.pxmax);
            this.tfpxstep.setValue(Plot.this.pxstep);
            if (Plot.this.pxlabel != null) {
                this.tfpxlabel.setText(Plot.this.pxlabel);
            }
            this.tfpymin.setValue(Plot.this.pymin);
            this.tfpymax.setValue(Plot.this.pymax);
            this.tfpystep.setValue(Plot.this.pystep);
            if (Plot.this.pylabel != null) {
                this.tfpylabel.setText(Plot.this.pylabel);
            }
            this.tfsxmin.setValue(Plot.this.sxmin);
            this.tfsxmax.setValue(Plot.this.sxmax);
            this.tfsxstep.setValue(Plot.this.sxstep);
            if (Plot.this.sxlabel != null) {
                this.tfsxlabel.setText(Plot.this.sxlabel);
            }
            this.tfsymin.setValue(Plot.this.symin);
            this.tfsymax.setValue(Plot.this.symax);
            this.tfsystep.setValue(Plot.this.systep);
            if (Plot.this.sylabel != null) {
                this.tfsylabel.setText(Plot.this.sylabel);
            }
            this.cbgpx.setSelected(Plot.this._asx1 != null ? Plot.this._asx1.isWithGridlines() : false);
            this.cbgpy.setSelected(Plot.this._asy1 != null ? Plot.this._asy1.isWithGridlines() : false);
            this.cbgsx.setSelected(Plot.this._asx2 != null ? Plot.this._asx2.isWithGridlines() : false);
            this.cbgsy.setSelected(Plot.this._asy2 != null ? Plot.this._asy2.isWithGridlines() : false);
            this.cblegend.setSelected(Plot.this.isLegendVisible());
            this.tftitle.setText(Plot.this.getTitle());
            this.cbxcurves.removeAllItems();
            this.curvesCopy = new Vector(Plot.this._curves.size());
            this.primaryCurvesCopy = Plot.this.primaryCurves == null ? null : (Vector)Plot.this.primaryCurves.clone();
            this.secondaryCurvesCopy = Plot.this.secondaryCurves == null ? null : (Vector)Plot.this.secondaryCurves.clone();
            Object object = Plot.this._curves.iterator();
            while (object.hasNext()) {
                PlotShape.Curve curve = (PlotShape.Curve)((PlotShape.Curve)object.next()).clone();
                this.curvesCopy.add(curve);
                this.cbxcurves.addItem(curve);
            }
            if (this.curvesCopy.size() > 0) {
                this.activeCurve = (PlotShape.Curve)this.curvesCopy.get(0);
                this.cbxcurves.setSelectedIndex(0);
            } else {
                this.activeCurve = null;
            }
            if (this.activeCurve != null) {
                this.bcurvecolor.setBackground(this.activeCurve.color);
                this.cbxcurves.setEnabled(true);
                this.bcurvecolor.setEnabled(true);
                this.bcurvedelete.setEnabled(true);
            } else {
                this.bcurvecolor.setBackground(this.noCurveColor);
                this.cbxcurves.setEnabled(false);
                this.bcurvecolor.setEnabled(false);
                this.bcurvedelete.setEnabled(false);
            }
            if (Plot.this.pxvaluesOK) {
                this.tfpxmin.setEnabled(true);
                this.tfpxmax.setEnabled(true);
                this.tfpxstep.setEnabled(true);
                this.tfpxlabel.setEnabled(true);
                this.lpxmin.setEnabled(true);
                this.lpxmax.setEnabled(true);
                this.lpxstep.setEnabled(true);
                this.lpxlabel.setEnabled(true);
                this.cbpx.setSelected(true);
                this.cbpx.setEnabled(false);
                this.cbgpx.setEnabled(true);
            } else {
                this.tfpxmin.setEnabled(false);
                this.tfpxmax.setEnabled(false);
                this.tfpxstep.setEnabled(false);
                this.tfpxlabel.setEnabled(false);
                this.lpxmin.setEnabled(false);
                this.lpxmax.setEnabled(false);
                this.lpxstep.setEnabled(false);
                this.lpxlabel.setEnabled(false);
                this.cbpx.setSelected(false);
                this.cbgpx.setEnabled(false);
            }
            if (Plot.this.pyvaluesOK) {
                this.tfpymin.setEnabled(true);
                this.tfpymax.setEnabled(true);
                this.tfpystep.setEnabled(true);
                this.tfpylabel.setEnabled(true);
                this.lpymin.setEnabled(true);
                this.lpymax.setEnabled(true);
                this.lpystep.setEnabled(true);
                this.lpylabel.setEnabled(true);
                this.cbpy.setSelected(true);
                this.cbpy.setEnabled(false);
                this.cbgpy.setEnabled(true);
            } else {
                this.tfpymin.setEnabled(false);
                this.tfpymax.setEnabled(false);
                this.tfpystep.setEnabled(false);
                this.tfpylabel.setEnabled(false);
                this.lpymin.setEnabled(false);
                this.lpymax.setEnabled(false);
                this.lpystep.setEnabled(false);
                this.lpylabel.setEnabled(false);
                this.cbpy.setSelected(false);
                this.cbgpy.setEnabled(false);
            }
            if (Plot.this.sxvaluesOK) {
                this.tfsxmin.setEnabled(true);
                this.tfsxmax.setEnabled(true);
                this.tfsxstep.setEnabled(true);
                this.tfsxlabel.setEnabled(true);
                this.lsxmin.setEnabled(true);
                this.lsxmax.setEnabled(true);
                this.lsxstep.setEnabled(true);
                this.lsxlabel.setEnabled(true);
                this.cbsx.setSelected(true);
                this.cbgsx.setEnabled(true);
                if (Plot.this.pxvaluesOK) {
                    this.matchpx.setEnabled(true);
                } else {
                    this.matchpx.setEnabled(false);
                }
            } else {
                this.tfsxmin.setEnabled(false);
                this.tfsxmax.setEnabled(false);
                this.tfsxstep.setEnabled(false);
                this.tfsxlabel.setEnabled(false);
                this.lsxmin.setEnabled(false);
                this.lsxmax.setEnabled(false);
                this.lsxstep.setEnabled(false);
                this.lsxlabel.setEnabled(false);
                this.cbsx.setSelected(false);
                this.cbgsx.setEnabled(false);
                this.matchpx.setEnabled(false);
            }
            if (Plot.this.syvaluesOK) {
                this.tfsymin.setEnabled(true);
                this.tfsymax.setEnabled(true);
                this.tfsystep.setEnabled(true);
                this.tfsylabel.setEnabled(true);
                this.lsymin.setEnabled(true);
                this.lsymax.setEnabled(true);
                this.lsystep.setEnabled(true);
                this.lsylabel.setEnabled(true);
                this.cbsy.setSelected(true);
                this.cbgsy.setEnabled(true);
                if (Plot.this.pyvaluesOK) {
                    this.matchpy.setEnabled(true);
                } else {
                    this.matchpy.setEnabled(false);
                }
            } else {
                this.tfsymin.setEnabled(false);
                this.tfsymax.setEnabled(false);
                this.tfsystep.setEnabled(false);
                this.tfsylabel.setEnabled(false);
                this.lsymin.setEnabled(false);
                this.lsymax.setEnabled(false);
                this.lsystep.setEnabled(false);
                this.lsylabel.setEnabled(false);
                this.cbsy.setSelected(false);
                this.cbgsy.setEnabled(false);
                this.matchpy.setEnabled(false);
            }
            this.pack();
            this.doLayout();
            if (this.firstTime) {
                object = Toolkit.getDefaultToolkit().getScreenSize();
                this.setLocation((((Dimension)object).width - this.getWidth()) / 2, (((Dimension)object).height - this.getHeight()) / 2);
                this.firstTime = false;
            }
            this.status = -1;
            super.show();
        }

        synchronized void activate() {
            this.show();
            while (this.status == -1) {
                try {
                    this.wait();
                    break;
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }

        synchronized void done(int n) {
            this.status = n;
            this.dispose();
            this.notifyAll();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == this.cbxcurves) {
                if (this.activeCurve == null) {
                    return;
                }
                if (actionEvent.getActionCommand().equals("comboBoxChanged")) {
                    Object object = this.cbxcurves.getSelectedItem();
                    if (object instanceof PlotShape.Curve) {
                        this.activeCurve = (PlotShape.Curve)object;
                    } else {
                        this.activeCurve = (PlotShape.Curve)this.curvesCopy.get(0);
                        this.cbxcurves.setSelectedItem(this.activeCurve);
                    }
                    this.bcurvecolor.setBackground(this.activeCurve.color);
                }
                return;
            }
            if (actionEvent.getSource() == this.cbxeditortf) {
                if (this.activeCurve != null) {
                    this.activeCurve.setLabel(this.cbxeditortf.getText());
                }
                return;
            }
            if (actionEvent.getSource() == this.bcurvecolor) {
                if (this.activeCurve == null) {
                    return;
                }
                Color color = JColorChooser.showDialog(this, resources.getStringValue("curveColorChooserTitle"), this.activeCurve.color);
                if (color == null) {
                    return;
                }
                this.activeCurve.color = color;
                this.bcurvecolor.setBackground(color);
                return;
            }
            if (actionEvent.getSource() == this.bcurvedelete) {
                if (this.activeCurve == null) {
                    return;
                }
                if (this.primaryCurvesCopy != null) {
                    this.primaryCurvesCopy.remove(this.activeCurve.shape);
                    if (this.primaryCurvesCopy.size() == 1 && (this.tfpylabel.getText() == null || this.tfpylabel.getText().equals(""))) {
                        this.tfpylabel.setText(DataInfo.getLabel(((CurveShape)this.primaryCurvesCopy.get(0)).getYSource()));
                    }
                    if (this.primaryCurvesCopy.size() == 0) {
                        this.tfpylabel.setText("");
                    }
                }
                if (this.secondaryCurvesCopy != null) {
                    this.secondaryCurvesCopy.remove(this.activeCurve.shape);
                    if (this.secondaryCurvesCopy.size() == 1 && (this.tfsylabel.getText() == null || this.tfsylabel.getText().equals(""))) {
                        this.tfpylabel.setText(DataInfo.getLabel(((CurveShape)this.secondaryCurvesCopy.get(0)).getYSource()));
                    }
                    if (this.secondaryCurvesCopy.size() == 0) {
                        this.tfsylabel.setText("");
                    }
                }
                this.curvesCopy.remove(this.activeCurve);
                this.cbxcurves.removeItem(this.activeCurve);
                if (this.curvesCopy.size() < 1) {
                    this.activeCurve = null;
                    this.bcurvecolor.setBackground(this.noCurveColor);
                    this.cbxcurves.setEnabled(false);
                    this.bcurvecolor.setEnabled(false);
                    this.bcurvedelete.setEnabled(false);
                } else {
                    Object object = this.cbxcurves.getSelectedItem();
                    if (object instanceof PlotShape.Curve) {
                        this.activeCurve = (PlotShape.Curve)object;
                    } else {
                        this.activeCurve = (PlotShape.Curve)this.curvesCopy.get(0);
                        this.cbxcurves.setSelectedItem(this.activeCurve);
                    }
                    this.bcurvecolor.setBackground(this.activeCurve.color);
                    if (this.curvesCopy.size() == 1) {
                        this.cblegend.setSelected(false);
                    }
                }
                return;
            }
            if (actionEvent.getSource() == this.cbpx) {
                boolean bl = this.cbpx.isSelected();
                this.tfpxmin.setEnabled(bl);
                this.tfpxmax.setEnabled(bl);
                this.tfpxstep.setEnabled(bl);
                this.tfpxlabel.setEnabled(bl);
                this.lpxmin.setEnabled(bl);
                this.lpxmax.setEnabled(bl);
                this.lpxstep.setEnabled(bl);
                this.lpxlabel.setEnabled(bl);
                this.cbgpx.setEnabled(bl);
                return;
            }
            if (actionEvent.getSource() == this.cbpy) {
                boolean bl = this.cbpy.isSelected();
                this.tfpymin.setEnabled(bl);
                this.tfpymax.setEnabled(bl);
                this.tfpystep.setEnabled(bl);
                this.tfpylabel.setEnabled(bl);
                this.lpymin.setEnabled(bl);
                this.lpymax.setEnabled(bl);
                this.lpystep.setEnabled(bl);
                this.lpylabel.setEnabled(bl);
                this.cbgpy.setEnabled(bl);
                return;
            }
            if (actionEvent.getSource() == this.cbsx) {
                boolean bl = this.cbsx.isSelected();
                this.tfsxmin.setEnabled(bl);
                this.tfsxmax.setEnabled(bl);
                this.tfsxstep.setEnabled(bl);
                this.tfsxlabel.setEnabled(bl);
                this.lsxmin.setEnabled(bl);
                this.lsxmax.setEnabled(bl);
                this.lsxstep.setEnabled(bl);
                this.lsxlabel.setEnabled(bl);
                this.cbgsx.setEnabled(bl);
                return;
            }
            if (actionEvent.getSource() == this.cbsy) {
                boolean bl = this.cbsy.isSelected();
                this.tfsymin.setEnabled(bl);
                this.tfsymax.setEnabled(bl);
                this.tfsystep.setEnabled(bl);
                this.tfsylabel.setEnabled(bl);
                this.lsymin.setEnabled(bl);
                this.lsymax.setEnabled(bl);
                this.lsystep.setEnabled(bl);
                this.lsylabel.setEnabled(bl);
                this.cbgsy.setEnabled(bl);
                return;
            }
            if (actionEvent.getSource() == this.cblegend) {
                return;
            }
            if (actionEvent.getSource() == this.matchpx) {
                this.tfsxmin.setText(this.tfpxmin.getText());
                this.tfsxmax.setText(this.tfpxmax.getText());
                this.tfsxstep.setText(this.tfpxstep.getText());
                return;
            }
            if (actionEvent.getSource() == this.matchpy) {
                this.tfsymin.setText(this.tfpymin.getText());
                this.tfsymax.setText(this.tfpymax.getText());
                this.tfsystep.setText(this.tfpystep.getText());
                return;
            }
            if (actionEvent.getSource() == this.bcancel) {
                this.done(0);
                return;
            }
            if (actionEvent.getSource() == this.bok) {
                try {
                    if (this.cbpx.isSelected()) {
                        Plot.this.pxmin = this.tfpxmin.getDoubleValue();
                        Plot.this.pxmax = this.tfpxmax.getDoubleValue();
                        Plot.this.pxstep = this.tfpxstep.getDoubleValue();
                        Plot.this.pxlabel = this.tfpxlabel.getText();
                        Plot.this.pxvaluesOK = true;
                    }
                    if (this.cbpy.isSelected()) {
                        Plot.this.pymin = this.tfpymin.getDoubleValue();
                        Plot.this.pymax = this.tfpymax.getDoubleValue();
                        Plot.this.pystep = this.tfpystep.getDoubleValue();
                        Plot.this.pylabel = this.tfpylabel.getText();
                        Plot.this.pyvaluesOK = true;
                    }
                    if (this.cbsx.isSelected()) {
                        Plot.this.sxmin = this.tfsxmin.getDoubleValue();
                        Plot.this.sxmax = this.tfsxmax.getDoubleValue();
                        Plot.this.sxstep = this.tfsxstep.getDoubleValue();
                        Plot.this.sxlabel = this.tfsxlabel.getText();
                        Plot.this.sxvaluesOK = true;
                    } else {
                        Plot.this.sxvaluesOK = false;
                        Plot.this.setSecondaryAxis(true, false);
                    }
                    if (this.cbsy.isSelected()) {
                        Plot.this.symin = this.tfsymin.getDoubleValue();
                        Plot.this.symax = this.tfsymax.getDoubleValue();
                        Plot.this.systep = this.tfsystep.getDoubleValue();
                        Plot.this.sylabel = this.tfsylabel.getText();
                        Plot.this.syvaluesOK = true;
                    } else {
                        Plot.this.syvaluesOK = false;
                        Plot.this.setSecondaryAxis(false, false);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    return;
                }
                Plot.this.setLegendVisible(this.cblegend.isSelected());
                Plot.this.setTitle(this.tftitle.getText());
                Plot.this._curves = this.curvesCopy;
                Plot.this.primaryCurves = this.primaryCurvesCopy;
                Plot.this.secondaryCurves = this.secondaryCurvesCopy;
                if (Plot.this._asx1 != null) {
                    Plot.this._asx1.setWithGridlines(this.cbgpx.isSelected());
                }
                if (Plot.this._asy1 != null) {
                    Plot.this._asy1.setWithGridlines(this.cbgpy.isSelected());
                }
                if (Plot.this._asx2 != null) {
                    Plot.this._asx2.setWithGridlines(this.cbgsx.isSelected());
                }
                if (Plot.this._asy2 != null) {
                    Plot.this._asy2.setWithGridlines(this.cbgsy.isSelected());
                }
                this.done(1);
                return;
            }
        }
    }
}

