/*
 * Decompiled with CFR 0.152.
 */
package jsynoptic.builtin;

import jsynoptic.builtin.RandomSource;
import jsynoptic.data.DataSourceAnimator;
import simtools.data.DataSource;
import simtools.util.NumberStringComparator;

public class GaussianRandomSource
extends RandomSource {
    public static final String ID_PREFIX = "GaussianRandomSource:";

    protected void setInfo() {
        this.info.comment = resources.getString("gaussianSourceComment");
        this.info.id = ID_PREFIX + this.info.id;
    }

    public GaussianRandomSource(String string, double d, double d2) {
        super(string, d, d2);
        this.setInfo();
    }

    public GaussianRandomSource(String string, double d, double d2, long l) {
        super(string, d, d2, l);
        this.setInfo();
    }

    public GaussianRandomSource(String string, long l, double d, double d2) {
        super(string, l, d, d2);
        this.setInfo();
    }

    public GaussianRandomSource(String string, long l, double d, double d2, long l2) {
        super(string, l, d, d2, l2);
        this.setInfo();
    }

    protected double nextRandomValue() {
        return this.param1 + this.param2 * this.generator.nextGaussian();
    }

    public double getMean() {
        return this.param1;
    }

    public double getStandardDeviation() {
        return this.param2;
    }

    public static class OptionPanel
    extends RandomSource.OptionPanel {
        protected String param1Name() {
            return RandomSource.resources.getString("mean");
        }

        protected String param2Name() {
            return RandomSource.resources.getString("variance");
        }

        public DataSource createSource(String string) {
            DataSource dataSource;
            Number number = null;
            if (this.cbSeed.isSelected()) {
                number = NumberStringComparator.stringToNumber(this.tfSeed.getText());
            }
            if (this.rbDynamic.isSelected()) {
                Number number2 = NumberStringComparator.stringToNumber(this.tfPeriod.getText());
                if (number2 == null) {
                    number2 = new Long(1000L);
                }
                dataSource = number != null ? new DataSourceAnimator(new GaussianRandomSource(string, number.longValue(), this.nfParam1.getDoubleValue(), this.nfParam2.getDoubleValue()), (int)this.nfSize.getLongValue(), (long)number2.intValue()) : new DataSourceAnimator(new GaussianRandomSource(string, this.nfParam1.getDoubleValue(), this.nfParam2.getDoubleValue()), (int)this.nfSize.getLongValue(), (long)number2.intValue());
            } else {
                dataSource = number != null ? new GaussianRandomSource(string, number.longValue(), this.nfParam1.getDoubleValue(), this.nfParam2.getDoubleValue(), this.nfSize.getLongValue()) : new GaussianRandomSource(string, this.nfParam1.getDoubleValue(), this.nfParam2.getDoubleValue(), this.nfSize.getLongValue());
            }
            return dataSource;
        }
    }
}

