/* $Id: NamespaceSorter.java,v 1.1 2005/04/09 03:35:04 sgalles Exp $
 * -----------------------------------------------------------------------
 * 
 * TSP Library - core components for a generic Transport Sampling Protocol.
 * 
 * Copyright (c) 2002 Yves DUFRENNE, Stephane GALLES, Eric NOULARD and Robert PAGNOT 
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * -----------------------------------------------------------------------
 * 
 * Project    : TSP
 * SubProject : jTSP
 * Maintainer : tsp@astrium-space.com
 * Component  : Consumer
 * 
 * -----------------------------------------------------------------------
 * 
 * Purpose   : 
 * 
 * -----------------------------------------------------------------------
 */
package tsp.consumer.util.aggregator;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

import tsp.core.consumer.TspConsumerException;
import tsp.core.consumer.simple.TspSimpleSampleSymbolInfo;

class NamespaceSorter {
	
	private Map infosByNamespace;
	private Map indexByName;
	
	public NamespaceSorter(TspSimpleSampleSymbolInfo[] infos) throws TspConsumerException{
		sortInfosByNamespace(infos);
	}
	
	TspSimpleSampleSymbolInfo[] getSampleInfoByNamespace(String namespace){
		List infoList = (List)infosByNamespace.get(namespace);
		if(infoList == null) {
			return null;
		}else{
			return (TspSimpleSampleSymbolInfo[])infoList.toArray(new TspSimpleSampleSymbolInfo[0]);
		}
	}
	
	int getIndexInInitialArray(String symbolName) throws TspConsumerException{
		Integer index = (Integer)indexByName.get(symbolName);
		if(index == null) throw new TspConsumerException("Unable to find symbol '" + symbolName + "' in initial array");
		return index.intValue(); 
	}
	
	private void sortInfosByNamespace(TspSimpleSampleSymbolInfo[] sinfos) throws TspConsumerException {
		infosByNamespace = new HashMap();
		indexByName = new HashMap(); 
		for(int i = 0 ; i < sinfos.length ; i++){			
			TspSimpleSampleSymbolInfo si = sinfos[i];
			// memorize index
			indexByName.put(si.getName(), new Integer(i));
			
			String namespace = NamespaceHelper.getNamespace(si);
			if(!infosByNamespace.containsKey(namespace)){
				infosByNamespace.put(namespace, new LinkedList());
			}
			List infoList = (List)infosByNamespace.get(namespace);
			// Add the info in the list, but remove the namespace
			infoList.add(NamespaceHelper.removeNamespace(si));
		}		
	}

}
