/* $Id: NamespaceHelper.java,v 1.2 2005/04/09 05:13:12 sgalles Exp $
 * -----------------------------------------------------------------------
 * 
 * TSP Library - core components for a generic Transport Sampling Protocol.
 * 
 * Copyright (c) 2002 Yves DUFRENNE, Stephane GALLES, Eric NOULARD and Robert PAGNOT 
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * -----------------------------------------------------------------------
 * 
 * Project    : TSP
 * SubProject : jTSP
 * Maintainer : tsp@astrium-space.com
 * Component  : Consumer
 * 
 * -----------------------------------------------------------------------
 * 
 * Purpose   : 
 * 
 * -----------------------------------------------------------------------
 */
package tsp.consumer.util.aggregator;

import tsp.core.consumer.TspConsumerException;
import tsp.core.consumer.simple.TspSimpleSampleSymbolInfo;

public class NamespaceHelper {
	
	private final static String SEPARATOR="::";
	private final static int S_SIZE=SEPARATOR.length();

	public static String getNamespace(String s) throws TspConsumerException{
		int index = getNamespaceIndex(s);
		return s.substring(0, index);
	}
	
	public static String getOnlyName(String s) throws TspConsumerException{
		int index = getNamespaceIndex(s);
		return s.substring(index + S_SIZE, s.length());
	}
	
	public static String addNamespace(String namespace, String name) throws TspConsumerException{
		if(name.length() == 0){
			throw new TspConsumerException("Empty name forbiden");
		}
		if(namespace.length() == 0){
			throw new TspConsumerException("Empty namespace forbiden");
		}
		return namespace + SEPARATOR + name;
	}
	
	public static String getNamespace(TspSimpleSampleSymbolInfo info) throws TspConsumerException{
		return getNamespace(info.getName());
	}
	
	
	public static TspSimpleSampleSymbolInfo addNamespace(String namespace, TspSimpleSampleSymbolInfo info) throws TspConsumerException{
		return new TspSimpleSampleSymbolInfo(addNamespace(namespace, info.getName()), info.getPeriod(), info.getPhase(), info.getIndex());
	}
	
	public static TspSimpleSampleSymbolInfo removeNamespace(TspSimpleSampleSymbolInfo info) throws TspConsumerException{
		return new TspSimpleSampleSymbolInfo(getOnlyName(info.getName()), info.getPeriod(), info.getPhase(), info.getIndex());
	}
	
	private static int getNamespaceIndex(String s) throws TspConsumerException{
		int index = s.indexOf(SEPARATOR);
		if(index == -1){
			throw new TspConsumerException("No namespace for string : " + s);
		}
		if(index == 0){
			throw new TspConsumerException("Empty namespace forbiden. String was : " + s);
		}
		if(index + S_SIZE == s.length()){
			throw new TspConsumerException("Empty name forbiden. String was : " + s);
		}
		return index;
	}
	
	
}
