/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer;

import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import org.jfree.chart.CrosshairInfo;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.entity.XYItemEntity;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.AbstractXYItemRenderer;
import org.jfree.chart.renderer.XYItemRenderer;
import org.jfree.chart.renderer.XYItemRendererState;
import org.jfree.chart.urls.XYURLGenerator;
import org.jfree.data.XYDataset;
import org.jfree.util.PublicCloneable;

public class XYStepAreaRenderer
extends AbstractXYItemRenderer
implements XYItemRenderer,
Cloneable,
PublicCloneable,
Serializable {
    public static final int SHAPES = 1;
    public static final int AREA = 2;
    public static final int AREA_AND_SHAPES = 3;
    private boolean plotShapes;
    private boolean shapesFilled;
    private boolean plotArea;
    private boolean showOutline;
    protected transient Polygon pArea = null;
    private double rangeBase;

    public XYStepAreaRenderer() {
        this(2);
    }

    public XYStepAreaRenderer(int n) {
        this(n, null, null);
    }

    public XYStepAreaRenderer(int n, XYToolTipGenerator xYToolTipGenerator, XYURLGenerator xYURLGenerator) {
        this.setToolTipGenerator(xYToolTipGenerator);
        this.setURLGenerator(xYURLGenerator);
        if (n == 2) {
            this.plotArea = true;
        } else if (n == 1) {
            this.plotShapes = true;
        } else if (n == 3) {
            this.plotArea = true;
            this.plotShapes = true;
        }
        this.showOutline = false;
    }

    public boolean isOutline() {
        return this.showOutline;
    }

    public void setOutline(boolean bl) {
        this.showOutline = bl;
    }

    public boolean getPlotShapes() {
        return this.plotShapes;
    }

    public void setShapesFilled(boolean bl) {
        this.shapesFilled = bl;
    }

    public boolean getPlotArea() {
        return this.plotArea;
    }

    public void setRangeBase(double d) {
        this.rangeBase = d;
    }

    public double getRangeBase() {
        return this.rangeBase;
    }

    public XYItemRendererState initialise(Graphics2D graphics2D, Rectangle2D rectangle2D, XYPlot xYPlot, XYDataset xYDataset, PlotRenderingInfo plotRenderingInfo) {
        return super.initialise(graphics2D, rectangle2D, xYPlot, xYDataset, plotRenderingInfo);
    }

    public void drawItem(Graphics2D graphics2D, XYItemRendererState xYItemRendererState, Rectangle2D rectangle2D, PlotRenderingInfo plotRenderingInfo, XYPlot xYPlot, ValueAxis valueAxis, ValueAxis valueAxis2, XYDataset xYDataset, int n, int n2, CrosshairInfo crosshairInfo, int n3) {
        EntityCollection entityCollection;
        double d;
        int n4 = xYDataset.getItemCount(n);
        Paint paint = this.getItemPaint(n, n2);
        Stroke stroke = this.getItemStroke(n, n2);
        graphics2D.setPaint(paint);
        graphics2D.setStroke(stroke);
        Number number = xYDataset.getXValue(n, n2);
        Number number2 = xYDataset.getYValue(n, n2);
        double d2 = number.doubleValue();
        double d3 = number2 == null ? this.rangeBase : number2.doubleValue();
        double d4 = valueAxis.translateValueToJava2D(d2, rectangle2D, xYPlot.getDomainAxisEdge());
        double d5 = valueAxis2.translateValueToJava2D(d3, rectangle2D, xYPlot.getRangeAxisEdge());
        d5 = XYStepAreaRenderer.restrictValueToDataArea(d5, xYPlot, rectangle2D);
        if (this.pArea == null && number2 != null) {
            this.pArea = new Polygon();
            d = valueAxis2.translateValueToJava2D(this.rangeBase, rectangle2D, xYPlot.getRangeAxisEdge());
            d = XYStepAreaRenderer.restrictValueToDataArea(d, xYPlot, rectangle2D);
            if (xYPlot.getOrientation() == PlotOrientation.VERTICAL) {
                this.pArea.addPoint((int)d4, (int)d);
            } else if (xYPlot.getOrientation() == PlotOrientation.HORIZONTAL) {
                this.pArea.addPoint((int)d, (int)d4);
            }
        }
        d = 0.0;
        double d6 = XYStepAreaRenderer.restrictValueToDataArea(this.rangeBase, xYPlot, rectangle2D);
        Number number3 = null;
        Number number4 = null;
        if (n2 > 0) {
            number3 = xYDataset.getXValue(n, n2 - 1);
            number4 = number2 == null ? (Number)null : (Number)xYDataset.getYValue(n, n2 - 1);
            d2 = number3.doubleValue();
            d3 = number4 == null ? this.rangeBase : number4.doubleValue();
            d = valueAxis.translateValueToJava2D(d2, rectangle2D, xYPlot.getDomainAxisEdge());
            d6 = valueAxis2.translateValueToJava2D(d3, rectangle2D, xYPlot.getRangeAxisEdge());
            d6 = XYStepAreaRenderer.restrictValueToDataArea(d6, xYPlot, rectangle2D);
            if (number2 == null) {
                d4 = d;
                d6 = d5;
            }
            if (d6 != d5) {
                if (xYPlot.getOrientation() == PlotOrientation.VERTICAL) {
                    this.pArea.addPoint((int)d4, (int)d6);
                } else if (xYPlot.getOrientation() == PlotOrientation.HORIZONTAL) {
                    this.pArea.addPoint((int)d6, (int)d4);
                }
            }
        }
        Shape shape = null;
        if (number2 != null) {
            if (xYPlot.getOrientation() == PlotOrientation.VERTICAL) {
                this.pArea.addPoint((int)d4, (int)d5);
            } else if (xYPlot.getOrientation() == PlotOrientation.HORIZONTAL) {
                this.pArea.addPoint((int)d5, (int)d4);
            }
            if (this.plotShapes) {
                shape = this.getItemShape(n, n2);
                if (xYPlot.getOrientation() == PlotOrientation.VERTICAL) {
                    shape = this.createTransformedShape(shape, d4, d5);
                } else if (xYPlot.getOrientation() == PlotOrientation.HORIZONTAL) {
                    shape = this.createTransformedShape(shape, d5, d4);
                }
                if (this.shapesFilled) {
                    graphics2D.fill(shape);
                } else {
                    graphics2D.draw(shape);
                }
            } else if (xYPlot.getOrientation() == PlotOrientation.VERTICAL) {
                shape = new Rectangle2D.Double(d4 - 2.0, d5 - 2.0, 4.0, 4.0);
            } else if (xYPlot.getOrientation() == PlotOrientation.HORIZONTAL) {
                shape = new Rectangle2D.Double(d5 - 2.0, d4 - 2.0, 4.0, 4.0);
            }
        }
        if (this.plotArea && n2 > 0 && this.pArea != null && (n2 == n4 - 1 || number2 == null)) {
            double d7 = valueAxis2.translateValueToJava2D(this.rangeBase, rectangle2D, xYPlot.getRangeAxisEdge());
            d7 = XYStepAreaRenderer.restrictValueToDataArea(d7, xYPlot, rectangle2D);
            if (xYPlot.getOrientation() == PlotOrientation.VERTICAL) {
                this.pArea.addPoint((int)d4, (int)d7);
            } else if (xYPlot.getOrientation() == PlotOrientation.HORIZONTAL) {
                this.pArea.addPoint((int)d7, (int)d4);
            }
            graphics2D.fill(this.pArea);
            if (this.showOutline) {
                graphics2D.setStroke(xYPlot.getOutlineStroke());
                graphics2D.setPaint(xYPlot.getOutlinePaint());
                graphics2D.draw(this.pArea);
            }
            this.pArea = null;
        }
        if (number2 != null) {
            if (xYPlot.isDomainCrosshairLockedOnData()) {
                if (xYPlot.isRangeCrosshairLockedOnData()) {
                    crosshairInfo.updateCrosshairPoint(number.doubleValue(), number2.doubleValue(), d4, d5);
                } else {
                    crosshairInfo.updateCrosshairX(number.doubleValue());
                }
            } else if (xYPlot.isRangeCrosshairLockedOnData()) {
                crosshairInfo.updateCrosshairY(number2.doubleValue());
            }
        }
        if (xYItemRendererState.getInfo() != null && (entityCollection = xYItemRendererState.getInfo().getOwner().getEntityCollection()) != null && shape != null) {
            String string = null;
            if (this.getToolTipGenerator() != null) {
                string = this.getToolTipGenerator().generateToolTip(xYDataset, n, n2);
            }
            String string2 = null;
            if (this.getURLGenerator() != null) {
                string2 = this.getURLGenerator().generateURL(xYDataset, n, n2);
            }
            XYItemEntity xYItemEntity = new XYItemEntity(shape, xYDataset, n, n2, string, string2);
            entityCollection.addEntity(xYItemEntity);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    private static double restrictValueToDataArea(double d, XYPlot xYPlot, Rectangle2D rectangle2D) {
        double d2 = 0.0;
        double d3 = 0.0;
        if (xYPlot.getOrientation() == PlotOrientation.VERTICAL) {
            d2 = rectangle2D.getMinY();
            d3 = rectangle2D.getMaxY();
        } else if (xYPlot.getOrientation() == PlotOrientation.HORIZONTAL) {
            d2 = rectangle2D.getMinX();
            d3 = rectangle2D.getMaxX();
        }
        if (d < d2) {
            d = d2;
        } else if (d > d3) {
            d = d3;
        }
        return d;
    }
}

