/*
 * Decompiled with CFR 0.152.
 */
package simtools.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import javax.swing.AbstractAction;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.JViewport;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import javax.swing.undo.UndoManager;
import simtools.diagram.undo.UndoHandler;
import simtools.ui.MenuResourceBundle;
import simtools.ui.ResourceFinder;
import simtools.ui.UserProperties;

public class UserPropertiesEditor
extends JDialog
implements CaretListener,
ActionListener {
    public static MenuResourceBundle resources = ResourceFinder.getMenu(class$simtools$ui$UserPropertiesEditor == null ? (class$simtools$ui$UserPropertiesEditor = UserPropertiesEditor.class$("simtools.ui.UserPropertiesEditor")) : class$simtools$ui$UserPropertiesEditor);
    UndoHandler undoHandler;
    AbstractAction copyAction;
    AbstractAction cutAction;
    AbstractAction pasteAction;
    JMenuItem importMenuItem;
    JMenuItem exportMenuItem;
    JMenuItem closeMenuItem;
    JTextArea ui;
    PlainDocument doc;
    JFileChooser chooser = null;
    static /* synthetic */ Class class$simtools$ui$UserPropertiesEditor;

    public UserPropertiesEditor(Frame frame) {
        super(frame, true);
        this.getContentPane().setLayout(new BorderLayout());
        JScrollPane jScrollPane = new JScrollPane();
        JViewport jViewport = jScrollPane.getViewport();
        this.doc = new PlainDocument();
        this.createTextArea();
        jViewport.add(this.ui);
        this.undoHandler = new UndoHandler(new UndoManager());
        this.doc.addUndoableEditListener(this.undoHandler);
        this.ui.addCaretListener(this);
        this.setupActions();
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar.add(this.createFileMenu());
        jMenuBar.add(this.createEditMenu());
        this.setJMenuBar(jMenuBar);
        this.getContentPane().add((Component)jScrollPane, "Center");
        this.getContentPane().add((Component)this.createToolBar(), "North");
        this.pack();
        this.setSize(600, 480);
    }

    public boolean show(UserProperties userProperties) {
        if (this.chooser == null) {
            this.chooser = new JFileChooser(userProperties.getFile().getParentFile());
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            userProperties.store(byteArrayOutputStream, "");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        try {
            this.doc.insertString(0, byteArrayOutputStream.toString(), null);
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
        this.setTitle(resources.getString("titlePart1") + userProperties._productName + resources.getString("titlePart2"));
        this.show();
        return !byteArrayOutputStream.toString().equals(this.getText());
    }

    protected void createTextArea() {
        this.ui = new JTextArea(this.doc);
    }

    protected JToolBar createToolBar() {
        JToolBar jToolBar = new JToolBar();
        jToolBar.add(this.undoHandler.getUndoAction());
        jToolBar.add(this.undoHandler.getRedoAction());
        jToolBar.add(this.cutAction);
        jToolBar.add(this.copyAction);
        jToolBar.add(this.pasteAction);
        return jToolBar;
    }

    protected JMenu createFileMenu() {
        JMenu jMenu = resources.getMenu("file");
        this.importMenuItem = resources.getItem("import", this);
        jMenu.add(this.importMenuItem);
        this.exportMenuItem = resources.getItem("export", this);
        jMenu.add(this.exportMenuItem);
        this.closeMenuItem = resources.getItem("close", this);
        jMenu.add(this.closeMenuItem);
        return jMenu;
    }

    protected JMenu createEditMenu() {
        JMenu jMenu = resources.getMenu("edit");
        jMenu.add(this.undoHandler.getUndoAction());
        jMenu.add(this.undoHandler.getRedoAction());
        jMenu.addSeparator();
        jMenu.add(this.cutAction);
        jMenu.add(this.copyAction);
        jMenu.add(this.pasteAction);
        return jMenu;
    }

    public String getText() {
        try {
            return this.doc.getText(0, this.doc.getLength());
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
            return "";
        }
    }

    public void update(UserProperties userProperties) {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.getText().replaceAll("\r", "").getBytes());
        try {
            userProperties.load(byteArrayInputStream);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public boolean showAndUpdate(UserProperties userProperties, boolean bl) {
        if (this.show(userProperties) && (!bl || JOptionPane.showConfirmDialog(null, resources.getString("confirmMessage"), resources.getString("confirmTitle"), 0) == 0)) {
            this.update(userProperties);
            return true;
        }
        return false;
    }

    protected void setupActions() {
        this.copyAction = (AbstractAction)this.ui.getActionMap().get("copy-to-clipboard");
        this.copyAction.putValue("SmallIcon", resources.getIcon("copyImage"));
        this.copyAction.putValue("Name", resources.getString("copyAction"));
        this.copyAction.putValue("AcceleratorKey", resources.getKeyStroke("copyShortcut"));
        this.copyAction.putValue("LongDescription", resources.getString("copyTip"));
        this.cutAction = (AbstractAction)this.ui.getActionMap().get("cut-to-clipboard");
        this.cutAction.putValue("SmallIcon", resources.getIcon("cutImage"));
        this.cutAction.putValue("Name", resources.getString("cutAction"));
        this.cutAction.putValue("AcceleratorKey", resources.getKeyStroke("cutShortcut"));
        this.cutAction.putValue("LongDescription", resources.getString("cutTip"));
        this.pasteAction = (AbstractAction)this.ui.getActionMap().get("paste-from-clipboard");
        this.pasteAction.putValue("SmallIcon", resources.getIcon("pasteImage"));
        this.pasteAction.putValue("Name", resources.getString("pasteAction"));
        this.pasteAction.putValue("AcceleratorKey", resources.getKeyStroke("pasteShortcut"));
        this.pasteAction.putValue("LongDescription", resources.getString("pasteTip"));
        this.cutAction.setEnabled(false);
        this.copyAction.setEnabled(false);
        this.pasteAction.setEnabled(true);
        this.undoHandler.getUndoAction().putValue("AcceleratorKey", resources.getKeyStroke("undoShortcut"));
        this.undoHandler.getRedoAction().putValue("AcceleratorKey", resources.getKeyStroke("redoShortcut"));
    }

    public void caretUpdate(CaretEvent caretEvent) {
        boolean bl = caretEvent.getDot() != caretEvent.getMark();
        this.cutAction.setEnabled(bl);
        this.copyAction.setEnabled(bl);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.importMenuItem) {
            if (this.chooser.showDialog(this, resources.getString("importTitle")) == 0) {
                this.read(this.chooser.getSelectedFile());
            }
        } else if (actionEvent.getSource() == this.exportMenuItem) {
            if (this.chooser.showDialog(this, resources.getString("exportTitle")) == 0) {
                this.write(this.chooser.getSelectedFile());
            }
        } else if (actionEvent.getSource() == this.closeMenuItem) {
            this.hide();
        }
    }

    protected void write(File file) {
        try {
            FileWriter fileWriter = new FileWriter(file);
            fileWriter.write(this.getText());
            fileWriter.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    protected void read(File file) {
        String string = System.getProperty("line.separator");
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "8859_1"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        StringBuffer stringBuffer = new StringBuffer();
        while (bufferedReader != null) {
            String string2;
            try {
                string2 = bufferedReader.readLine();
            }
            catch (IOException iOException) {
                break;
            }
            if (string2 == null) break;
            stringBuffer.append(string2);
            stringBuffer.append(string);
        }
        try {
            this.doc.remove(0, this.doc.getLength() - 1);
            this.doc.insertString(0, stringBuffer.toString(), null);
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
    }

    public static void main(String[] stringArray) {
        UserPropertiesEditor userPropertiesEditor = new UserPropertiesEditor(null);
        UserProperties userProperties = new UserProperties("jsynoptic");
        userProperties.read();
        if (userPropertiesEditor.showAndUpdate(userProperties, true)) {
            userProperties.write();
        }
        System.exit(0);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

