/*
 * Decompiled with CFR 0.152.
 */
package simtools.diagram.test;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.Line2D;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Random;
import java.util.Vector;
import javax.swing.event.UndoableEditEvent;
import simtools.diagram.DiagramClipboard;
import simtools.diagram.DiagramComponent;
import simtools.diagram.DiagramConnection;
import simtools.diagram.DiagramConnector;
import simtools.diagram.DiagramParameters;
import simtools.diagram.DiagramSelectedShape;
import simtools.diagram.DiagramSelection;
import simtools.diagram.undo.TranslateEdit;
import simtools.shapes.AbstractShape;
import simtools.shapes.CompoundShape;

public class TestComponent
extends DiagramComponent {
    private Vector _boxes = null;
    private int startx;
    private int starty;
    private int movex;
    private int movey;

    public TestComponent() {
        super(new DiagramParameters());
        this.createSelection();
        this.load();
    }

    public void createSelection() {
        this._selection = new TestSelection();
        this._selection.setGrid(this.getGrid());
    }

    public void load() {
        if (this._boxes != null) {
            return;
        }
        this._boxes = new Vector();
        Random random = new Random();
        for (int i = 0; i < 100; ++i) {
            this._boxes.addElement(new TestShape(random.nextInt() & 0x3FF, random.nextInt() & 0x3FF, random.nextInt() & 0xFF, random.nextInt() & 0xFF));
        }
        TestShape testShape = (TestShape)this._boxes.elementAt(0);
        this._param.name = "Name" + testShape.x;
    }

    protected void translate(int n, int n2) {
        for (int i = 0; i < this._boxes.size(); ++i) {
            TestShape testShape = (TestShape)this._boxes.elementAt(i);
            testShape.translate(n, n2);
            Enumeration enumeration = testShape.getConnections();
            while (enumeration.hasMoreElements()) {
                TestShapeLink testShapeLink = (TestShapeLink)enumeration.nextElement();
                if (testShapeLink.input() != testShape) continue;
                testShapeLink.translate(n, n2);
            }
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.startx = mouseEvent.getX();
        this.starty = mouseEvent.getY();
        super.mousePressed(mouseEvent);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.movex = mouseEvent.getX() - this.startx;
        this.movey = mouseEvent.getY() - this.starty;
        super.mouseReleased(mouseEvent);
    }

    protected void translationEnd() {
        Vector vector = this._selection.getSelection();
        CompoundShape compoundShape = new CompoundShape();
        for (int i = 0; i < vector.size(); ++i) {
            TestShape testShape = (TestShape)vector.get(i);
            AbstractShape abstractShape = new AbstractShape(testShape){
                TestShape ts;
                private final /* synthetic */ TestShape val$tmps;
                {
                    this.ts = this.val$tmps = testShape;
                }

                public void draw(Graphics2D graphics2D) {
                    graphics2D.draw(this.ts);
                }

                public void translate(int n, int n2) {
                    this.ts.translate(n, n2);
                    TestComponent.this.repaint();
                }
            };
            compoundShape.addShape(abstractShape);
        }
        this.fireUndoableEditUpdate(new UndoableEditEvent(this, new TranslateEdit(this.movex, this.movey, compoundShape)));
    }

    protected void getMin(Point point) {
        for (int i = 0; i < this._boxes.size(); ++i) {
            TestShape testShape = (TestShape)this._boxes.elementAt(i);
            if (testShape.x < point.x) {
                point.x = testShape.x;
            }
            if (testShape.y >= point.y) continue;
            point.y = testShape.y;
        }
    }

    protected void copyAt(Vector vector, int n, int n2) {
        TestShape testShape;
        Object object;
        int n3;
        Vector<Object> vector2 = new Vector<Object>();
        Hashtable<Object, TestShape> hashtable = new Hashtable<Object, TestShape>();
        for (n3 = 0; n3 < vector.size(); ++n3) {
            object = vector.elementAt(n3);
            if (object instanceof TestShape) {
                testShape = new TestShape((TestShape)object);
                testShape.translate(n, n2);
                hashtable.put(object, testShape);
                this._boxes.addElement(testShape);
                continue;
            }
            if (!(object instanceof TestShapeLink)) continue;
            vector2.addElement(object);
        }
        for (n3 = 0; n3 < vector2.size(); ++n3) {
            object = (TestShapeLink)vector2.elementAt(n3);
            testShape = (TestShape)((TestShapeLink)object).input();
            TestShape testShape2 = (TestShape)((TestShapeLink)object).output();
            TestShape testShape3 = (TestShape)hashtable.get(testShape);
            TestShape testShape4 = (TestShape)hashtable.get(testShape2);
            TestShapeLink testShapeLink = new TestShapeLink((TestShapeLink)object, testShape3, testShape4);
            testShape3.addConnection(testShapeLink);
            testShape4.addConnection(testShapeLink);
        }
    }

    protected void drawDiagramElements(Graphics2D graphics2D, Point point) {
        for (int i = 0; i < this._boxes.size(); ++i) {
            TestShape testShape = (TestShape)this._boxes.elementAt(i);
            boolean bl = this._selection.isSelected(testShape);
            if (bl) {
                graphics2D.setColor(Color.red);
            } else {
                graphics2D.setColor(Color.blue);
            }
            graphics2D.draw(testShape);
            Enumeration enumeration = testShape.getConnections();
            while (enumeration.hasMoreElements()) {
                TestShapeLink testShapeLink = (TestShapeLink)enumeration.nextElement();
                if (testShapeLink.input() != testShape) continue;
                if (bl || this._selection.isSelected(testShapeLink)) {
                    graphics2D.setColor(Color.red);
                } else {
                    graphics2D.setColor(Color.blue);
                }
                graphics2D.draw(testShapeLink);
            }
            if (testShape.x + testShape.width > point.x) {
                point.x = testShape.x + testShape.width;
            }
            if (testShape.y + testShape.height <= point.y) continue;
            point.y = testShape.y + testShape.height;
        }
    }

    protected void printDiagramElements(Graphics2D graphics2D, Point point) {
        this.drawDiagramElements(graphics2D, point);
    }

    protected void drawClipboardElements(Graphics2D graphics2D, Point point) {
        int n = this._dragPoint.x;
        int n2 = this._dragPoint.y;
        graphics2D.translate(n, n2);
        DiagramClipboard diagramClipboard = DiagramClipboard.get();
        graphics2D.setColor(Color.green);
        for (int i = 0; i < diagramClipboard.size(); ++i) {
            int n3;
            Shape shape;
            Object e = diagramClipboard.elementAt(i);
            if (e instanceof TestShape) {
                shape = (TestShape)e;
                graphics2D.draw(shape);
                n3 = shape.x + shape.width + n;
                if (n3 > point.x) {
                    point.x = n3;
                }
                if ((n3 = shape.y + shape.height + n2) > point.y) {
                    point.y = n3;
                }
            }
            if (!(e instanceof TestShapeLink)) continue;
            shape = (TestShapeLink)e;
            graphics2D.draw(shape);
            n3 = (int)((TestShapeLink)shape).x1 + n;
            if (n3 > point.x) {
                point.x = n3;
            }
            if ((n3 = (int)((TestShapeLink)shape).x2 + n) > point.x) {
                point.x = n3;
            }
            if ((n3 = (int)((TestShapeLink)shape).y1 + n2) > point.y) {
                point.y = n3;
            }
            if ((n3 = (int)((TestShapeLink)shape).y2 + n2) <= point.y) continue;
            point.y = n3;
        }
        graphics2D.translate(-n, -n2);
    }

    protected void drawConnection(Graphics2D graphics2D, Point point) {
        graphics2D.setColor(Color.pink);
        TestShapeLink testShapeLink = (TestShapeLink)this._connection;
        graphics2D.draw(testShapeLink);
        if (testShapeLink.x2 > (double)point.x) {
            point.x = (int)testShapeLink.x2;
        }
        if (testShapeLink.y2 > (double)point.y) {
            point.y = (int)testShapeLink.y2;
        }
    }

    protected DiagramConnection createConnection(DiagramConnector diagramConnector, int n, int n2) {
        return new TestShapeLink((TestShape)diagramConnector, n, n2);
    }

    protected void translateConnection(DiagramConnection diagramConnection, int n, int n2) {
        ((TestShapeLink)diagramConnection).translateOutput(n, n2);
    }

    protected void performConnection(DiagramConnection diagramConnection, DiagramConnector diagramConnector, DiagramConnector diagramConnector2) {
        TestShape testShape = (TestShape)diagramConnector;
        TestShape testShape2 = (TestShape)diagramConnector2;
        TestShapeLink testShapeLink = (TestShapeLink)diagramConnection;
        testShapeLink.connect(testShape2);
        testShape.addConnection(diagramConnection);
        testShape2.addConnection(diagramConnection);
    }

    public class TestShapeLink
    extends Line2D.Double
    implements DiagramConnection {
        private TestShape _in;
        private TestShape _out;

        public TestShapeLink(TestShape testShape, int n, int n2) {
            super(testShape.x + testShape.width, testShape.y + testShape.height, n, n2);
            this._in = testShape;
            this._out = null;
        }

        public TestShapeLink(TestShapeLink testShapeLink, TestShape testShape, TestShape testShape2) {
            super(testShape.x + testShape.width, testShape.y + testShape.height, testShape2.x, testShape2.y);
            this._in = testShape;
            this._out = testShape2;
        }

        public void translate(int n, int n2) {
            System.out.println("TestShapeLink.translate()");
            this.x1 += (double)n;
            this.y1 += (double)n2;
            this.x2 += (double)n;
            this.y2 += (double)n2;
        }

        public void translateInput(int n, int n2) {
            this.x1 += (double)n;
            this.y1 += (double)n2;
        }

        public void translateOutput(int n, int n2) {
            this.x2 += (double)n;
            this.y2 += (double)n2;
        }

        public void connect(TestShape testShape) {
            if (this._out == this._in) {
                return;
            }
            this._out = testShape;
            this.x1 = this._in.x + this._in.width;
            this.y1 = this._in.y + this._in.height;
            this.x2 = this._out.x;
            this.y2 = this._out.y;
        }

        public DiagramConnector input() {
            return this._in;
        }

        public DiagramConnector output() {
            return this._out;
        }

        public String toString() {
            String string = "link:[" + this.x1 + "," + this.y1 + "][" + this.x2 + "," + this.y2 + "]";
            string = string + "in=" + this._in;
            string = string + "out=" + this._out;
            return string;
        }
    }

    public class TestShape
    extends Rectangle
    implements DiagramConnector {
        private Vector _links = new Vector();

        public TestShape(int n, int n2, int n3, int n4) {
            super(n, n2, n3, n4);
        }

        public TestShape(TestShape testShape) {
            super(testShape);
        }

        public Enumeration getConnections() {
            return this._links.elements();
        }

        public boolean allowsInputConnection(DiagramConnector diagramConnector) {
            return this._links.size() < 2;
        }

        public boolean allowsOutputConnection(DiagramConnector diagramConnector) {
            return this._links.size() < 3;
        }

        public DiagramConnector connectorOwner() {
            return null;
        }

        public void addConnection(DiagramConnection diagramConnection) {
            this._links.addElement(diagramConnection);
        }

        public void removeConnection(DiagramConnection diagramConnection) {
            this._links.removeElement(diagramConnection);
        }

        public void removeAllConnections() {
            this._links.clear();
        }
    }

    public class TestSelection
    extends DiagramSelection {
        private transient int _nbrLink;
        private transient int _nbrRect;

        public TestSelection() {
            this.clear();
        }

        private void removeLinks() {
            int n;
            if (this._nbrLink == 0) {
                return;
            }
            for (int i = n = this.getShapeCount() - 1; i >= 0; --i) {
                Shape shape = this.getShape(i);
                if (!(shape instanceof TestShapeLink)) continue;
                this.removeShapeAt(i);
            }
            this._nbrLink = 0;
        }

        protected void clear() {
            super.clear();
            this._nbrLink = 0;
            this._nbrRect = 0;
        }

        public Shape copyShape(Shape shape) {
            if (shape instanceof TestShape) {
                return new TestShape((TestShape)shape);
            }
            if (shape instanceof TestShapeLink) {
                return null;
            }
            return super.copyShape(shape);
        }

        public Shape copyConnectionShape(Shape shape, DiagramConnector diagramConnector, DiagramConnector diagramConnector2) {
            if (shape instanceof TestShapeLink) {
                return new TestShapeLink((TestShapeLink)shape, (TestShape)diagramConnector, (TestShape)diagramConnector2);
            }
            return super.copyShape(shape);
        }

        public void deleteShape(Shape shape) {
            if (shape instanceof TestShape) {
                TestShape testShape = (TestShape)shape;
                TestComponent.this._boxes.removeElement(testShape);
            }
        }

        public void translateShape(Shape shape, int n, int n2) {
            if (shape instanceof TestShapeLink) {
                ((TestShapeLink)shape).translate(n, n2);
            } else {
                super.translateShape(shape, n, n2);
            }
        }

        public void translateConnectionShape(Shape shape, DiagramConnector diagramConnector, int n, int n2) {
            System.out.println("TestSelection.translateConnectionShape()");
            if (shape instanceof TestShapeLink) {
                TestShapeLink testShapeLink = (TestShapeLink)shape;
                if (testShapeLink.input() == diagramConnector) {
                    testShapeLink.translateInput(n, n2);
                } else {
                    testShapeLink.translateOutput(n, n2);
                }
            } else {
                super.translateConnectionShape(shape, diagramConnector, n, n2);
            }
        }

        protected boolean addShapeAt(int n, int n2) {
            Shape shape;
            int n3;
            if (this._nbrRect == 0) {
                for (n3 = 0; n3 < TestComponent.this._boxes.size(); ++n3) {
                    shape = (TestShape)TestComponent.this._boxes.elementAt(n3);
                    Enumeration enumeration = ((TestShape)shape).getConnections();
                    while (enumeration.hasMoreElements()) {
                        TestShapeLink testShapeLink = (TestShapeLink)enumeration.nextElement();
                        if (!testShapeLink.intersects(n - 1, n2 - 1, 3.0, 3.0)) continue;
                        this.add(new DiagramSelectedShape(testShapeLink, this.getShapeOrigin(testShapeLink, null)));
                        ++this._nbrLink;
                        return true;
                    }
                }
            }
            for (n3 = 0; n3 < TestComponent.this._boxes.size(); ++n3) {
                shape = (Shape)TestComponent.this._boxes.elementAt(n3);
                if (!shape.contains(n, n2)) continue;
                this.add(new DiagramSelectedShape(shape, this.getShapeOrigin(shape, null)));
                ++this._nbrRect;
                this.removeLinks();
                return true;
            }
            return false;
        }

        protected boolean addShapesInside() {
            Shape shape;
            int n;
            boolean bl = false;
            if (this._nbrRect == 0) {
                for (n = 0; n < TestComponent.this._boxes.size(); ++n) {
                    shape = (TestShape)TestComponent.this._boxes.elementAt(n);
                    Enumeration enumeration = ((TestShape)shape).getConnections();
                    while (enumeration.hasMoreElements()) {
                        TestShapeLink testShapeLink = (TestShapeLink)enumeration.nextElement();
                        if (!testShapeLink.intersects(this)) continue;
                        this.add(new DiagramSelectedShape(testShapeLink, this.getShapeOrigin(testShapeLink, null)));
                        ++this._nbrLink;
                        bl = true;
                    }
                }
            }
            for (n = 0; n < TestComponent.this._boxes.size(); ++n) {
                shape = (Shape)TestComponent.this._boxes.elementAt(n);
                if (!this.contains(shape.getBounds())) continue;
                this.add(new DiagramSelectedShape(shape, this.getShapeOrigin(shape, null)));
                ++this._nbrRect;
                this.removeLinks();
                bl = true;
            }
            return bl;
        }
    }
}

