/*
 * Decompiled with CFR 0.152.
 */
package simtools.diagram;

import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.UndoableEdit;
import simtools.diagram.DiagramSelectedShape;
import simtools.diagram.LineShapeInterface;

public abstract class DiagramSelectedLineShape
extends DiagramSelectedShape {
    static final int HANDLE_HALF_SIZE = 5;

    protected DiagramSelectedLineShape(Shape shape, Point point) {
        super(shape, point);
    }

    protected abstract void selectPoint(int var1, boolean var2);

    protected abstract boolean isSelectedPoint(int var1);

    public int getPointIndex(int n, int n2) {
        LineShapeInterface lineShapeInterface = (LineShapeInterface)((Object)this.s);
        for (int i = 0; i < lineShapeInterface.pointsNumber(); ++i) {
            int n3 = lineShapeInterface.getX(i);
            int n4 = lineShapeInterface.getY(i);
            if (n < n3 - 5 || n > n3 + 5 || n2 < n4 - 5 || n2 > n4 + 5) continue;
            return i;
        }
        return -1;
    }

    public Point selectPointAt(int n, int n2, boolean bl) {
        Point point = new Point();
        Object var5_5 = null;
        LineShapeInterface lineShapeInterface = (LineShapeInterface)((Object)this.s);
        int n3 = this.getPointIndex(n, n2);
        if (n3 >= 0 && this.isSelectedPoint(n3) != bl) {
            this.selectPoint(n3, bl);
            return new Point(lineShapeInterface.getX(n3), lineShapeInterface.getY(n3));
        }
        return null;
    }

    public Point selectPointsInside(Rectangle2D rectangle2D) {
        Point point = new Point();
        Point point2 = null;
        LineShapeInterface lineShapeInterface = (LineShapeInterface)((Object)this.s);
        for (int i = 0; i < lineShapeInterface.pointsNumber(); ++i) {
            point.x = lineShapeInterface.getX(i);
            point.y = lineShapeInterface.getY(i);
            if (!rectangle2D.contains(point)) continue;
            this.selectPoint(i, true);
            if (point2 != null) continue;
            point2 = new Point();
            point2.x = lineShapeInterface.getX(0);
            point2.y = lineShapeInterface.getY(0);
        }
        return point2;
    }

    public Rectangle2D getInnerBounds() {
        Rectangle2D.Double double_ = null;
        LineShapeInterface lineShapeInterface = (LineShapeInterface)((Object)this.s);
        for (int i = 0; i < lineShapeInterface.pointsNumber(); ++i) {
            if (!this.isSelectedPoint(i)) continue;
            if (double_ == null) {
                double_ = new Rectangle2D.Double(lineShapeInterface.getX(i), lineShapeInterface.getY(i), 1.0, 1.0);
                continue;
            }
            double_.add(new Rectangle2D.Double(lineShapeInterface.getX(i), lineShapeInterface.getY(i), 1.0, 1.0));
        }
        return double_;
    }

    public void selectAll(boolean bl) {
        LineShapeInterface lineShapeInterface = (LineShapeInterface)((Object)this.s);
        for (int i = 0; i < lineShapeInterface.pointsNumber(); ++i) {
            this.selectPoint(i, bl);
        }
    }

    public boolean getSelectionStatus(boolean bl) {
        LineShapeInterface lineShapeInterface = (LineShapeInterface)((Object)this.s);
        for (int i = 0; i < lineShapeInterface.pointsNumber(); ++i) {
            if (this.isSelectedPoint(i) == bl) continue;
            return false;
        }
        return true;
    }

    public boolean canBeSelectedAt(int n, int n2) {
        int n3 = this.getPointIndex(n, n2);
        return n3 >= 0;
    }

    public UndoableEdit translate(int n, int n2) {
        LineShapeInterface lineShapeInterface = (LineShapeInterface)((Object)this.s);
        TranslatePointsEdit translatePointsEdit = null;
        for (int i = 0; i < lineShapeInterface.pointsNumber(); ++i) {
            if (!this.isSelectedPoint(i)) continue;
            lineShapeInterface.translatePoint(i, n, n2);
            if (translatePointsEdit == null) {
                translatePointsEdit = new TranslatePointsEdit(n, n2, lineShapeInterface);
            }
            translatePointsEdit.addPointIndex(i);
        }
        return translatePointsEdit;
    }

    public boolean canDrawBounds() {
        return !this.getSelectionStatus(false);
    }

    public void drawBounds(Graphics2D graphics2D) {
        LineShapeInterface lineShapeInterface = (LineShapeInterface)((Object)this.s);
        for (int i = 0; i < lineShapeInterface.pointsNumber(); ++i) {
            if (!this.isSelectedPoint(i)) continue;
            int n = lineShapeInterface.getX(i);
            int n2 = lineShapeInterface.getY(i);
            graphics2D.drawRect(n - 5, n2 - 5, 10, 10);
        }
    }

    public class TranslatePointsEdit
    extends AbstractUndoableEdit {
        LineShapeInterface sourceShape;
        int dx;
        int dy;
        ArrayList tab;

        public TranslatePointsEdit(int n, int n2, LineShapeInterface lineShapeInterface) {
            this.sourceShape = lineShapeInterface;
            this.dx = n;
            this.dy = n2;
            this.tab = new ArrayList();
        }

        public void undo() {
            for (int i = 0; i < this.tab.size(); ++i) {
                this.sourceShape.translatePoint((Integer)this.tab.get(i), -this.dx, -this.dy);
            }
            super.undo();
        }

        public void redo() {
            for (int i = 0; i < this.tab.size(); ++i) {
                this.sourceShape.translatePoint((Integer)this.tab.get(i), this.dx, this.dy);
            }
            super.redo();
        }

        public void addPointIndex(int n) {
            this.tab.add(new Integer(n));
        }

        public String getPresentationName() {
            return "translatePoints";
        }
    }
}

